/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.util.regexp;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TestNameExpression {
    public static final String PATTERN_RAW_TEXT = "(?'className'((\\^)?[\\d_\\w\\^]+(\\$)?))(\\.(?'testName'((\\^)?[\\d_\\w]+(\\$)?)))?";
    public static final String PATTERN_TEXT;
    public static final Pattern pattern;
    private static final Map<String, Integer> groupOffsets;
    private final Matcher matcher;
    private final CharSequence matchText;

    private TestNameExpression(Matcher pMatcher, CharSequence ch) {
        this.matcher = pMatcher;
        this.matchText = ch;
    }

    public TestNameExpression(CharSequence ch) {
        this(pattern.matcher(ch), ch);
    }

    public static TestNameExpression match(CharSequence pText) {
        return new TestNameExpression(pText);
    }

    public int end() {
        return this.matcher.end();
    }

    public int end(int group) {
        return this.matcher.end(group);
    }

    public int start() {
        return this.matcher.start();
    }

    public int start(int group) {
        return this.matcher.start(group);
    }

    public String replaceAll(String replacement) {
        return this.matcher.replaceAll(replacement);
    }

    public String replaceAll(RegExpIterator it) {
        String match = ((Object)this.matchText).toString();
        String str = "";
        int end = -1;
        while (this.hasNext()) {
            str = str + match.substring(end == -1 ? 0 : end, this.start());
            str = str + it.replaceMatch(this);
            end = this.end();
        }
        str = str + match.substring(end == -1 ? 0 : end, match.length());
        return str;
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean hasNext() {
        return this.matcher.find();
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int i) {
        return this.matcher.group(i);
    }

    public TestNameExpression resetMatch(CharSequence seq) {
        return TestNameExpression.match(seq);
    }

    public String group(String name) {
        return this.matcher.group(groupOffsets.get(name));
    }

    private static String scope(String text, String name) {
        return text.replaceAll("(\\(\\?')(\\w+')", "$1" + name + ".$2");
    }

    public boolean hasClassName() {
        return this.group("className") != null;
    }

    public String getClassName() {
        if (!this.hasClassName()) {
            throw new IllegalArgumentException("Property not defined: ClassName");
        }
        return this.group("className");
    }

    public boolean hasTestName() {
        return this.group("testName") != null;
    }

    public String getTestName() {
        if (!this.hasTestName()) {
            throw new IllegalArgumentException("Property not defined: TestName");
        }
        return this.group("testName");
    }

    public String toString() {
        return "{TestNameExpression, matchText='" + this.matchText + "'}[" + "(className)=" + (this.hasClassName() ? this.getClassName() : "null") + ", (testName)=" + (this.hasTestName() ? this.getTestName() : "null") + "]";
    }

    public static void main(String[] argv) {
        System.out.println(PATTERN_TEXT);
    }

    static {
        groupOffsets = new HashMap<String, Integer>();
        PATTERN_TEXT = PATTERN_RAW_TEXT.replaceAll("\\(\\?'[^']+'", "(");
        Pattern cpattern = Pattern.compile("(\\\\)?\\((\\?'([^']+)')?");
        Matcher matcher = cpattern.matcher(PATTERN_RAW_TEXT);
        int groupCount = 1;
        while (matcher.find()) {
            if (matcher.group(1) != null) continue;
            String groupName = matcher.group(3);
            if (groupName != null) {
                groupOffsets.put(groupName, new Integer(groupCount));
            }
            ++groupCount;
        }
        pattern = Pattern.compile(PATTERN_TEXT, 10);
    }

    public static interface RegExpIterator {
        public String replaceMatch(TestNameExpression var1);
    }
}

