/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dartsclone;

import com.hankcs.hanlp.collection.dartsclone.DoubleArray;
import com.hankcs.hanlp.collection.dartsclone.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DartMap<V>
extends DoubleArray
implements Map<String, V> {
    ArrayList<V> valueArray;

    public DartMap(List<String> keyList, List<V> valueList) {
        int[] valueArray = new int[valueList.size()];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = i;
        }
        this.valueArray = new ArrayList<V>(valueList);
        this.build(keyList, valueArray);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(key.toString());
    }

    public boolean containsKey(String key) {
        return this.exactMatchSearch(key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public V get(Object key) {
        return this.get(key.toString());
    }

    public V get(String key) {
        int id = this.exactMatchSearch(key);
        if (id == -1) {
            return null;
        }
        return this.valueArray.get(id);
    }

    public ArrayList<Pair<String, V>> commonPrefixSearch(String key, int offset, int maxResults) {
        byte[] keyBytes = key.getBytes(utf8);
        List<Pair<Integer, Integer>> pairList = this.commonPrefixSearch(keyBytes, offset, maxResults);
        ArrayList<Pair<String, V>> resultList = new ArrayList<Pair<String, V>>(pairList.size());
        for (Pair<Integer, Integer> pair : pairList) {
            resultList.add(new Pair<String, V>(new String(keyBytes, 0, (int)((Integer)pair.first)), this.valueArray.get((Integer)pair.second)));
        }
        return resultList;
    }

    public ArrayList<Pair<String, V>> commonPrefixSearch(String key) {
        return this.commonPrefixSearch(key, 0, Integer.MAX_VALUE);
    }

    @Override
    public V put(String key, V value) {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301\u589e\u91cf\u5f0f\u63d2\u5165");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301\u5220\u9664");
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301\u589e\u91cf\u5f0f\u63d2\u5165");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301");
    }

    @Override
    public Collection<V> values() {
        return this.valueArray;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301");
    }
}

