/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.corpus.dictionary.ISaveAble;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class TMDictionaryMaker
implements ISaveAble {
    Map<String, Map<String, Integer>> transferMatrix = new TreeMap<String, Map<String, Integer>>();

    public void addPair(String first, String second) {
        Integer frequency;
        Map<String, Integer> firstMatrix = this.transferMatrix.get(first);
        if (firstMatrix == null) {
            firstMatrix = new TreeMap<String, Integer>();
            this.transferMatrix.put(first, firstMatrix);
        }
        if ((frequency = firstMatrix.get(second)) == null) {
            frequency = 0;
        }
        firstMatrix.put(second, frequency + 1);
    }

    public String toString() {
        TreeSet<String> labelSet = new TreeSet<String>();
        for (Map.Entry<String, Map<String, Integer>> first : this.transferMatrix.entrySet()) {
            labelSet.add(first.getKey());
            labelSet.addAll(first.getValue().keySet());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        for (String key : labelSet) {
            sb.append(',');
            sb.append(key);
        }
        sb.append('\n');
        for (String first : labelSet) {
            Map<String, Integer> firstMatrix = this.transferMatrix.get(first);
            if (firstMatrix == null) {
                firstMatrix = new TreeMap<String, Integer>();
            }
            sb.append(first);
            for (String second : labelSet) {
                sb.append(',');
                Integer frequency = firstMatrix.get(second);
                if (frequency == null) {
                    frequency = 0;
                }
                sb.append(frequency);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean saveTxtTo(String path) {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
            bw.write(this.toString());
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5728\u4fdd\u5b58\u8f6c\u79fb\u77e9\u9635\u8bcd\u5178\u5230" + path + "\u65f6\u53d1\u751f\u5f02\u5e38" + e);
            return false;
        }
        return true;
    }
}

