/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;

public class TransformMatrixDictionary<E extends Enum<E>> {
    Class<E> enumType;
    public int ordinaryMax;
    int[][] matrix;
    int[] total;
    int totalFrequency;
    public int[] states;
    public double[] start_probability;
    public double[][] transititon_probability;

    public TransformMatrixDictionary(Class<E> enumType) {
        this.enumType = enumType;
    }

    public boolean load(String path) {
        try {
            int j;
            int i;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(path)));
            String line = br.readLine();
            String[] _param = line.split(",");
            String[] labels = new String[_param.length - 1];
            System.arraycopy(_param, 1, labels, 0, labels.length);
            int[] ordinaryArray = new int[labels.length];
            this.ordinaryMax = 0;
            for (i = 0; i < ordinaryArray.length; ++i) {
                ordinaryArray[i] = ((Enum)this.convert(labels[i])).ordinal();
                this.ordinaryMax = Math.max(this.ordinaryMax, ordinaryArray[i]);
            }
            ++this.ordinaryMax;
            this.matrix = new int[this.ordinaryMax][this.ordinaryMax];
            for (i = 0; i < this.ordinaryMax; ++i) {
                for (int j2 = 0; j2 < this.ordinaryMax; ++j2) {
                    this.matrix[i][j2] = 0;
                }
            }
            while ((line = br.readLine()) != null) {
                String[] paramArray = line.split(",");
                int currentOrdinary = ((Enum)this.convert(paramArray[0])).ordinal();
                for (int i2 = 0; i2 < ordinaryArray.length; ++i2) {
                    this.matrix[currentOrdinary][ordinaryArray[i2]] = Integer.valueOf(paramArray[1 + i2]);
                }
            }
            br.close();
            this.total = new int[this.ordinaryMax];
            for (j = 0; j < this.ordinaryMax; ++j) {
                this.total[j] = 0;
                for (int i3 = 0; i3 < this.ordinaryMax; ++i3) {
                    int n = j;
                    this.total[n] = this.total[n] + this.matrix[i3][j];
                }
            }
            for (j = 0; j < this.ordinaryMax; ++j) {
                int n = j;
                this.total[n] = this.total[n] + this.matrix[j][j];
            }
            for (j = 0; j < this.ordinaryMax; ++j) {
                this.totalFrequency += this.total[j];
            }
            this.states = ordinaryArray;
            this.start_probability = new double[this.ordinaryMax];
            for (int s : this.states) {
                double frequency = (double)this.total[s] + 1.0E-8;
                this.start_probability[s] = -Math.log(frequency / (double)this.totalFrequency);
            }
            this.transititon_probability = new double[this.ordinaryMax][this.ordinaryMax];
            for (int from : this.states) {
                for (int to : this.states) {
                    double frequency = (double)this.matrix[from][to] + 1.0E-8;
                    this.transititon_probability[from][to] = -Math.log(frequency / (double)this.totalFrequency);
                }
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
        }
        return true;
    }

    public int getFrequency(String from, String to) {
        return this.getFrequency(this.convert(from), this.convert(to));
    }

    public int getFrequency(E from, E to) {
        return this.matrix[((Enum)from).ordinal()][((Enum)to).ordinal()];
    }

    public int getTotalFrequency(E e) {
        return this.total[((Enum)e).ordinal()];
    }

    public int getTotalFrequency() {
        return this.totalFrequency;
    }

    protected E convert(String label) {
        return Enum.valueOf(this.enumType, label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransformMatrixDictionary{");
        sb.append("enumType=").append(this.enumType);
        sb.append(", ordinaryMax=").append(this.ordinaryMax);
        sb.append(", matrix=").append(Arrays.toString((Object[])this.matrix));
        sb.append(", total=").append(Arrays.toString(this.total));
        sb.append(", totalFrequency=").append(this.totalFrequency);
        sb.append('}');
        return sb.toString();
    }
}

