/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;

public class TraditionalChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    public static String convertToSimplifiedChinese(String traditionalChineseString) {
        return TraditionalChineseDictionary.segLongest(traditionalChineseString.toCharArray(), trie);
    }

    public static String convertToSimplifiedChinese(char[] traditionalChinese) {
        return TraditionalChineseDictionary.segLongest(traditionalChinese, trie);
    }

    static {
        long start = System.currentTimeMillis();
        if (!TraditionalChineseDictionary.load(HanLP.Config.TraditionalChineseDictionaryPath, trie, false)) {
            throw new IllegalArgumentException("\u7e41\u7b80\u8bcd\u5178" + HanLP.Config.TraditionalChineseDictionaryPath + "\u52a0\u8f7d\u5931\u8d25");
        }
        Predefine.logger.info("\u7e41\u7b80\u8bcd\u5178" + HanLP.Config.TraditionalChineseDictionaryPath + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }
}

