/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.trigram.frequency;

import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import java.io.DataOutputStream;
import java.util.Collection;
import java.util.Set;

public class Probability
implements ICacheAble {
    public BinTrie<Integer> d = new BinTrie();
    int total;

    public boolean exists(String key) {
        return this.d.containsKey(key);
    }

    public int getsum() {
        return this.total;
    }

    Integer get(String key) {
        return this.d.get(key);
    }

    public int get(char[] ... keyArray) {
        Integer f = this.get(Probability.convert(keyArray));
        if (f == null) {
            return 0;
        }
        return f;
    }

    public int get(char ... key) {
        Integer f = this.d.get(key);
        if (f == null) {
            return 0;
        }
        return f;
    }

    public double freq(String key) {
        Integer f = this.get(key);
        if (f == null) {
            f = 0;
        }
        return (double)f.intValue() / (double)this.total;
    }

    public double freq(char[] ... keyArray) {
        return this.freq(Probability.convert(keyArray));
    }

    public double freq(char ... keyArray) {
        Integer f = this.d.get(keyArray);
        if (f == null) {
            f = 0;
        }
        return (double)f.intValue() / (double)this.total;
    }

    public Set<String> samples() {
        return this.d.keySet();
    }

    void add(String key, int value) {
        Integer f = this.get(key);
        if (f == null) {
            f = 0;
        }
        f = f + value;
        this.d.put(key, f);
        this.total += value;
    }

    void add(int value, char ... key) {
        Integer f = this.d.get(key);
        if (f == null) {
            f = 0;
        }
        f = f + value;
        this.d.put(key, f);
        this.total += value;
    }

    public void add(int value, char[] ... keyArray) {
        this.add(Probability.convert(keyArray), value);
    }

    public void add(int value, Collection<char[]> keyArray) {
        this.add(this.convert(keyArray), value);
    }

    private String convert(Collection<char[]> keyArray) {
        StringBuilder sbKey = new StringBuilder(keyArray.size() * 2);
        for (char[] key : keyArray) {
            sbKey.append(key[0]);
            sbKey.append(key[1]);
        }
        return sbKey.toString();
    }

    private static String convert(char[] ... keyArray) {
        StringBuilder sbKey = new StringBuilder(keyArray.length * 2);
        for (char[] key : keyArray) {
            sbKey.append(key[0]);
            sbKey.append(key[1]);
        }
        return sbKey.toString();
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        out.writeInt(this.total);
        Integer[] valueArray = this.d.getValueArray((Integer[])new Integer[0]);
        out.writeInt(valueArray.length);
        for (Integer v : valueArray) {
            out.writeInt(v);
        }
        this.d.save(out);
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.total = byteArray.nextInt();
        int size = byteArray.nextInt();
        Integer[] valueArray = new Integer[size];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = byteArray.nextInt();
        }
        this.d.load(byteArray, (Integer[])valueArray);
        return true;
    }
}

