/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.algoritm.ahocorasick.trie;

import com.hankcs.hanlp.algoritm.ahocorasick.interval.IntervalTree;
import com.hankcs.hanlp.algoritm.ahocorasick.interval.Intervalable;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.Emit;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.FragmentToken;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.MatchToken;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.State;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.Token;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.TrieConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingDeque;

public class Trie {
    private TrieConfig trieConfig;
    private State rootState;
    private boolean failureStatesConstructed = false;

    public Trie(TrieConfig trieConfig) {
        this.trieConfig = trieConfig;
        this.rootState = new State();
    }

    public Trie() {
        this(new TrieConfig());
    }

    public Trie removeOverlaps() {
        this.trieConfig.setAllowOverlaps(false);
        return this;
    }

    public Trie remainLongest() {
        this.trieConfig.remainLongest = true;
        return this;
    }

    public void addKeyword(String keyword) {
        if (keyword == null || keyword.length() == 0) {
            return;
        }
        State currentState = this.rootState;
        char[] cArray = keyword.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            currentState = currentState.addState(character);
        }
        currentState.addEmit(keyword);
    }

    public void addAllKeyword(Collection<String> keywordSet) {
        for (String keyword : keywordSet) {
            this.addKeyword(keyword);
        }
    }

    public Collection<Token> tokenize(String text) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Collection<Emit> collectedEmits = this.parseText(text);
        IntervalTree intervalTree = new IntervalTree((List)collectedEmits);
        intervalTree.removeOverlaps((List)collectedEmits);
        int lastCollectedPosition = -1;
        for (Emit emit : collectedEmits) {
            if (emit.getStart() - lastCollectedPosition > 1) {
                tokens.add(this.createFragment(emit, text, lastCollectedPosition));
            }
            tokens.add(this.createMatch(emit, text));
            lastCollectedPosition = emit.getEnd();
        }
        if (text.length() - lastCollectedPosition > 1) {
            tokens.add(this.createFragment(null, text, lastCollectedPosition));
        }
        return tokens;
    }

    private Token createFragment(Emit emit, String text, int lastCollectedPosition) {
        return new FragmentToken(text.substring(lastCollectedPosition + 1, emit == null ? text.length() : emit.getStart()));
    }

    private Token createMatch(Emit emit, String text) {
        return new MatchToken(text.substring(emit.getStart(), emit.getEnd() + 1), emit);
    }

    public Collection<Emit> parseText(String text) {
        this.checkForConstructedFailureStates();
        int position = 0;
        State currentState = this.rootState;
        ArrayList<Intervalable> collectedEmits = new ArrayList<Intervalable>();
        for (int i = 0; i < text.length(); ++i) {
            currentState = Trie.getState(currentState, Character.valueOf(text.charAt(i)));
            Trie.storeEmits(position, currentState, collectedEmits);
            ++position;
        }
        if (!this.trieConfig.isAllowOverlaps()) {
            IntervalTree intervalTree = new IntervalTree(collectedEmits);
            intervalTree.removeOverlaps(collectedEmits);
        }
        if (this.trieConfig.remainLongest) {
            Trie.remainLongest(collectedEmits);
        }
        return collectedEmits;
    }

    private static void remainLongest(Collection<Emit> collectedEmits) {
        if (collectedEmits.size() < 2) {
            return;
        }
        TreeMap<Integer, Emit> emitMapStart = new TreeMap<Integer, Emit>();
        for (Emit emit : collectedEmits) {
            Emit pre = (Emit)emitMapStart.get(emit.getStart());
            if (pre != null && pre.size() >= emit.size()) continue;
            emitMapStart.put(emit.getStart(), emit);
        }
        if (emitMapStart.size() < 2) {
            collectedEmits.clear();
            collectedEmits.addAll(emitMapStart.values());
            return;
        }
        TreeMap<Integer, Emit> emitMapEnd = new TreeMap<Integer, Emit>();
        for (Emit emit : emitMapStart.values()) {
            Emit pre = (Emit)emitMapEnd.get(emit.getEnd());
            if (pre != null && pre.size() >= emit.size()) continue;
            emitMapEnd.put(emit.getEnd(), emit);
        }
        collectedEmits.clear();
        collectedEmits.addAll(emitMapEnd.values());
    }

    private static State getState(State currentState, Character character) {
        State newCurrentState = currentState.nextState(character);
        while (newCurrentState == null) {
            currentState = currentState.failure();
            newCurrentState = currentState.nextState(character);
        }
        return newCurrentState;
    }

    private void checkForConstructedFailureStates() {
        if (!this.failureStatesConstructed) {
            this.constructFailureStates();
        }
    }

    private void constructFailureStates() {
        LinkedBlockingDeque<State> queue = new LinkedBlockingDeque<State>();
        for (State depthOneState : this.rootState.getStates()) {
            depthOneState.setFailure(this.rootState);
            queue.add(depthOneState);
        }
        this.failureStatesConstructed = true;
        while (!queue.isEmpty()) {
            State currentState = (State)queue.remove();
            for (Character transition : currentState.getTransitions()) {
                State targetState = currentState.nextState(transition);
                queue.add(targetState);
                State traceFailureState = currentState.failure();
                while (traceFailureState.nextState(transition) == null) {
                    traceFailureState = traceFailureState.failure();
                }
                State newFailureState = traceFailureState.nextState(transition);
                targetState.setFailure(newFailureState);
                targetState.addEmit(newFailureState.emit());
            }
        }
    }

    public void dfs(IWalker walker) {
        this.checkForConstructedFailureStates();
        this.dfs(this.rootState, "", walker);
    }

    private void dfs(State currentState, String path, IWalker walker) {
        walker.meet(path, currentState);
        for (Character transition : currentState.getTransitions()) {
            State targetState = currentState.nextState(transition);
            this.dfs(targetState, path + transition, walker);
        }
    }

    private static void storeEmits(int position, State currentState, List<Emit> collectedEmits) {
        Collection<String> emits = currentState.emit();
        if (emits != null && !emits.isEmpty()) {
            for (String emit : emits) {
                collectedEmits.add(new Emit(position - emit.length() + 1, position, emit));
            }
        }
    }

    public static interface IWalker {
        public void meet(String var1, State var2);
    }
}

