/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ns;

import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.NS;
import com.hankcs.hanlp.dictionary.common.CommonDictionary;
import com.hankcs.hanlp.utility.ByteUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Map;

public class NSDictionary
extends CommonDictionary<EnumItem<NS>> {
    protected EnumItem<NS>[] onLoadValue(String path) {
        EnumItem<NS>[] valueArray = this.loadDat(path + ".value.dat");
        if (valueArray != null) {
            return valueArray;
        }
        LinkedList valueList = new LinkedList();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                Map.Entry<String, Map.Entry<String, Integer>[]> args = EnumItem.create(line);
                EnumItem NSEnumItem = new EnumItem();
                for (Map.Entry<String, Integer> e : args.getValue()) {
                    NSEnumItem.labelMap.put(NS.valueOf(e.getKey()), e.getValue());
                }
                valueList.add(NSEnumItem);
            }
            br.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
        }
        valueArray = valueList.toArray(new EnumItem[0]);
        return valueArray;
    }

    protected boolean onSaveValue(EnumItem<NS>[] valueArray, String path) {
        return this.saveDat(path + ".value.dat", valueArray);
    }

    private EnumItem<NS>[] loadDat(String path) {
        byte[] bytes = IOUtil.readBytes(path);
        if (bytes == null) {
            return null;
        }
        NS[] NSArray = NS.values();
        int index = 0;
        int size = ByteUtil.bytesHighFirstToInt(bytes, index);
        index += 4;
        EnumItem[] valueArray = new EnumItem[size];
        for (int i = 0; i < size; ++i) {
            int currentSize = ByteUtil.bytesHighFirstToInt(bytes, index);
            index += 4;
            EnumItem item = new EnumItem();
            for (int j = 0; j < currentSize; ++j) {
                NS NS2 = NSArray[ByteUtil.bytesHighFirstToInt(bytes, index)];
                int frequency = ByteUtil.bytesHighFirstToInt(bytes, index += 4);
                index += 4;
                item.labelMap.put(NS2, frequency);
            }
            valueArray[i] = item;
        }
        return valueArray;
    }

    private boolean saveDat(String path, EnumItem<NS>[] valueArray) {
        try {
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(path));
            out.writeInt(valueArray.length);
            for (EnumItem<NS> item : valueArray) {
                out.writeInt(item.labelMap.size());
                for (Map.Entry entry : item.labelMap.entrySet()) {
                    out.writeInt(((NS)((Object)entry.getKey())).ordinal());
                    out.writeInt(entry.getValue());
                }
            }
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5931\u8d25" + e);
            return false;
        }
        return true;
    }
}

