/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.trigram;

import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.model.trigram.frequency.Probability;
import java.io.DataOutputStream;
import java.util.LinkedList;
import java.util.List;

public class CharacterBasedGenerativeModel
implements ICacheAble {
    double l1;
    double l2;
    double l3;
    Probability tf = new Probability();
    static final char[] id2tag = new char[]{'b', 'm', 'e', 's'};
    static final char[] bos = new char[]{'\b', 'x'};
    static final double inf = -1.0E10;

    public void learn(List<Word> wordList) {
        LinkedList<char[]> sentence = new LinkedList<char[]>();
        for (IWord iWord : wordList) {
            String word = iWord.getValue();
            if (word.length() == 1) {
                sentence.add(new char[]{word.charAt(0), 's'});
                continue;
            }
            sentence.add(new char[]{word.charAt(0), 'b'});
            for (int i = 1; i < word.length() - 1; ++i) {
                sentence.add(new char[]{word.charAt(i), 'm'});
            }
            sentence.add(new char[]{word.charAt(word.length() - 1), 'e'});
        }
        char[][] now = new char[3][];
        now[1] = bos;
        now[2] = bos;
        this.tf.add(1, new char[][]{bos, bos});
        this.tf.add(2, new char[][]{bos});
        for (char[] i : sentence) {
            System.arraycopy(now, 1, now, 0, 2);
            now[2] = i;
            this.tf.add(1, new char[][]{i});
            this.tf.add(1, new char[][]{now[1], now[2]});
            this.tf.add(1, now);
        }
    }

    public void train() {
        double tl1 = 0.0;
        double tl2 = 0.0;
        double tl3 = 0.0;
        for (String key : this.tf.d.keySet()) {
            if (key.length() != 6) continue;
            char[][] now = new char[][]{{key.charAt(0), key.charAt(1)}, {key.charAt(2), key.charAt(3)}, {key.charAt(4), key.charAt(5)}};
            double c3 = CharacterBasedGenerativeModel.div(this.tf.get(now) - 1, this.tf.get(new char[][]{now[0], now[1]}) - 1);
            double c2 = CharacterBasedGenerativeModel.div(this.tf.get(new char[][]{now[1], now[2]}) - 1, this.tf.get(now[1]) - 1);
            double c1 = CharacterBasedGenerativeModel.div(this.tf.get(now[2]) - 1, this.tf.getsum() - 1);
            if (c3 >= c1 && c3 >= c2) {
                tl3 += (double)this.tf.get(now);
                continue;
            }
            if (c2 >= c1 && c2 >= c3) {
                tl2 += (double)this.tf.get(now);
                continue;
            }
            if (!(c1 >= c2) || !(c1 >= c3)) continue;
            tl1 += (double)this.tf.get(now);
        }
        this.l1 = CharacterBasedGenerativeModel.div(tl1, tl1 + tl2 + tl3);
        this.l2 = CharacterBasedGenerativeModel.div(tl2, tl1 + tl2 + tl3);
        this.l3 = CharacterBasedGenerativeModel.div(tl3, tl1 + tl2 + tl3);
    }

    double log_prob(char[] s1, char[] s2, char[] s3) {
        double uni = this.l1 * this.tf.freq(s3);
        double bi = CharacterBasedGenerativeModel.div(this.l2 * (double)this.tf.get(new char[][]{s2, s3}), (double)this.tf.get(s2));
        double tri = CharacterBasedGenerativeModel.div(this.l3 * (double)this.tf.get(new char[][]{s1, s2, s3}), (double)this.tf.get(new char[][]{s1, s2}));
        if (uni + bi + tri == 0.0) {
            return -1.0E10;
        }
        return Math.log(uni + bi + tri);
    }

    public char[] tag(char[] charArray) {
        int i;
        int t;
        int s;
        if (charArray.length == 0) {
            return new char[0];
        }
        if (charArray.length == 1) {
            return new char[]{'s'};
        }
        char[] tag = new char[charArray.length];
        double[][] now = new double[4][4];
        double[] first = new double[4];
        int[][][] link = new int[charArray.length][4][4];
        for (int s2 = 0; s2 < 4; ++s2) {
            double p;
            first[s2] = p = s2 == 1 || s2 == 2 ? -1.0E10 : this.log_prob(bos, bos, new char[]{charArray[0], id2tag[s2]});
        }
        for (int f = 0; f < 4; ++f) {
            for (int s3 = 0; s3 < 4; ++s3) {
                double p;
                now[f][s3] = p = first[f] + this.log_prob(bos, new char[]{charArray[0], id2tag[f]}, new char[]{charArray[1], id2tag[s3]});
                link[1][f][s3] = f;
            }
        }
        double[][] pre = new double[4][4];
        for (int i2 = 2; i2 < charArray.length; ++i2) {
            double[][] _ = pre;
            pre = now;
            now = _;
            for (s = 0; s < 4; ++s) {
                for (t = 0; t < 4; ++t) {
                    now[s][t] = -1.0E20;
                    for (int f = 0; f < 4; ++f) {
                        char[] cArray = new char[]{charArray[i2 - 2], id2tag[f]};
                        char[] cArray2 = new char[]{charArray[i2 - 1], id2tag[s]};
                        char[] cArray3 = new char[]{charArray[i2], id2tag[t]};
                        double p = pre[f][s] + this.log_prob(cArray, cArray2, cArray3);
                        if (!(p > now[s][t])) continue;
                        now[s][t] = p;
                        link[i2][s][t] = f;
                    }
                }
            }
        }
        double score = -1.0E10;
        s = 0;
        t = 0;
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!(now[i][j] > score)) continue;
                score = now[i][j];
                s = i;
                t = j;
            }
        }
        for (i = link.length - 1; i >= 0; --i) {
            tag[i] = id2tag[t];
            int f = link[i][s][t];
            t = s;
            s = f;
        }
        return tag;
    }

    private static double div(int v1, int v2) {
        if (v2 == 0) {
            return 0.0;
        }
        return (double)v1 / (double)v2;
    }

    private static double div(double v1, double v2) {
        if (v2 == 0.0) {
            return 0.0;
        }
        return v1 / v2;
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        out.writeDouble(this.l1);
        out.writeDouble(this.l2);
        out.writeDouble(this.l3);
        this.tf.save(out);
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.l1 = byteArray.nextDouble();
        this.l2 = byteArray.nextDouble();
        this.l3 = byteArray.nextDouble();
        this.tf.load(byteArray);
        return true;
    }
}

