/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.lucene;

import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Scanner;

public class SegmentWrapper {
    Scanner scanner;
    Segment segment;
    Term[] termArray;
    int index;
    int offset;

    public SegmentWrapper(Reader reader, Segment segment) {
        this.scanner = SegmentWrapper.createScanner(reader);
        this.segment = segment;
    }

    public void reset(Reader reader) {
        this.scanner = SegmentWrapper.createScanner(reader);
        this.termArray = null;
        this.index = 0;
        this.offset = 0;
    }

    public Term next() throws IOException {
        if (this.termArray != null && this.index < this.termArray.length) {
            return this.termArray[this.index++];
        }
        if (!this.scanner.hasNext()) {
            return null;
        }
        String line = this.scanner.next();
        while (SegmentWrapper.isBlank(line)) {
            if (line == null) {
                return null;
            }
            this.offset += line.length() + 1;
            if (this.scanner.hasNext()) {
                line = this.scanner.next();
                continue;
            }
            return null;
        }
        List termList = this.segment.seg(line);
        if (termList.size() == 0) {
            return null;
        }
        for (Term term : this.termArray = termList.toArray(new Term[0])) {
            term.offset += this.offset;
        }
        this.index = 0;
        this.offset += line.length() + 1;
        return this.termArray[this.index++];
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Scanner createScanner(Reader reader) {
        return new Scanner(reader).useDelimiter("\n");
    }
}

