/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.crypto.IfxCipher;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEncPkt;
import java.io.ByteArrayInputStream;
import java.util.Vector;

class IfxCipherElem {
    int cipherType;
    int mode;
    private static int CPHRELMLIST_COUNT_CSIZE = 2;
    private static int CPHR_CSIZE = 2;
    private static int MODE_CSIZE = 2;

    IfxCipherElem(int cipherType, int mode) {
        this.cipherType = cipherType;
        this.mode = mode;
    }

    int getCipherType() {
        return this.cipherType;
    }

    int getMode() {
        return this.mode;
    }

    IfxCipher getCipher() {
        return IfxCipher.FindCipherByID(this.cipherType);
    }

    public boolean equals(Object obj) {
        IfxCipherElem cipherElement;
        return obj != null && this.getClass() == obj.getClass() && this.mode == (cipherElement = (IfxCipherElem)obj).getMode() && this.cipherType == cipherElement.getCipherType();
    }

    boolean isStrongerThan(IfxCipherElem cipherElem) {
        return this.mode > cipherElem.getMode() || this.mode == cipherElem.getMode() && this.cipherType > cipherElem.getCipherType();
    }

    static boolean isCipherInList(IfxCipherElem cipherElem, Vector elementList) {
        return elementList.contains(cipherElem);
    }

    static int cryptoGetCiphers(IfxCsmBuffer buff, IfxCryptoCtx ctx) {
        int status = 0;
        boolean count = false;
        Vector<IfxCipherElem> cipherElemList = ctx.RegisteredCiphers;
        if (cipherElemList == null || cipherElemList.isEmpty()) {
            status = -20;
        } else {
            buff.reset();
            buff.write(IfxCryptoUtils.JavaToIfxInt(cipherElemList.size(), CPHRELMLIST_COUNT_CSIZE));
            for (int k = 0; k < cipherElemList.size(); ++k) {
                IfxCipherElem regCipher = cipherElemList.get(k);
                buff.write(IfxCryptoUtils.JavaToIfxInt(regCipher.getCipherType(), CPHR_CSIZE));
                buff.write(IfxCryptoUtils.JavaToIfxInt(regCipher.getMode(), MODE_CSIZE));
            }
        }
        if (status != 0) {
            IfxCryptoCtx.printError(null, "CryptoGetCiphers", status);
        }
        return status;
    }

    static int negotiateCipher(IfxEncPkt encPkt, byte[] cipherStringArray, IfxCryptoCtx ctx) {
        int mode;
        int cipher;
        IfxCipherElem cipherElem;
        ByteArrayInputStream cipherString = new ByteArrayInputStream(cipherStringArray);
        int status = 0;
        int count = 0;
        Object temp = null;
        Vector<IfxCipherElem> ctxCipherList = ctx.RegisteredCiphers;
        count = IfxCryptoUtils.readInt(cipherString, CPHRELMLIST_COUNT_CSIZE);
        while (!(count-- <= 0 || status != 0 || IfxCipher.isCipherElementValid(cipherElem = new IfxCipherElem(cipher = IfxCryptoUtils.readInt(cipherString, CPHR_CSIZE), mode = IfxCryptoUtils.readInt(cipherString, MODE_CSIZE))) && IfxCipherElem.isCipherInList(cipherElem, ctxCipherList) && (status = IfxCipher.insertCipher(cipherElem, encPkt.NegoaitedCipherList)) != 0)) {
        }
        if (status == 0 && encPkt.NegoaitedCipherList.isEmpty()) {
            status = -20;
        }
        if (status != 0) {
            IfxCryptoCtx.printError(encPkt, "CryptoNegotiateCiphers", status);
        }
        return status;
    }

    String getTransformString() {
        IfxCipher cipherDesc = null;
        cipherDesc = this.getCipher();
        String algorithm = cipherDesc.getAlgorithmName();
        String modename = IfxCipher.FindNameByMode(this.mode);
        String paddingScheme = IfxCipher.getPaddingScheme(this);
        String transFormString = algorithm + "/" + modename + "/" + paddingScheme;
        return transFormString;
    }
}

