/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;

public class IfxFloat
extends IfxObject {
    private static final Object logger = Trace.getLoggerForClass(IfxFloat.class);
    private double value;

    IfxFloat() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat() constructor called");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat() constructor exited");
        }
        this.setIfxType(3);
    }

    IfxFloat(double d) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat(double) constructor called");
        }
        this.setIfxType(3);
        this.value = d;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat(double) constructor exited");
        }
    }

    IfxFloat(Double D) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat(Double) constructor called");
        }
        this.setIfxType(3);
        if (D != null) {
            this.value = D;
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat(Double) constructor exited");
        }
    }

    IfxFloat(float f) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat(float) constructor called");
        }
        this.setIfxType(3);
        this.value = f;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat(float) constructor exited");
        }
    }

    IfxFloat(Float F) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat(Float) constructor called");
        }
        this.setIfxType(3);
        if (F != null) {
            this.value = F.floatValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat(Float) constructor exited");
        }
    }

    @Override
    public byte[] toIfx() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toIfx called/exited");
        }
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[8];
            Arrays.fill(b, (byte)-1);
            return b;
        }
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        boolean null_flg = true;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromIfx called");
        }
        if (!(null_flg = IfxFloat.isIfxNull(b, offset, length))) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaDouble(b, offset);
        } else {
            this.nullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromIfx exited");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        if (other instanceof IfxFloat) {
            IfxFloat floatOther = (IfxFloat)other;
            if (floatOther.isNull()) {
                return false;
            }
            return this.value == floatOther.value;
        }
        return false;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    @Override
    public byte toByte() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toByte called");
        }
        this.clearWarning();
        byte b = this.isNull() ? (byte)0 : (byte)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toByte exited");
        }
        return b;
    }

    @Override
    public void fromByte(byte b) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromByte called");
        }
        this.value = b;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromByte exited");
        }
    }

    @Override
    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = d;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double D) throws SQLException {
        if (D == null) {
            this.nullify();
        } else {
            this.value = D;
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toShort called");
        }
        this.clearWarning();
        if (this.isNull()) {
            short s = 0;
            return 0;
        }
        short s = (short)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toShort exited");
        }
        return s;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromShort called");
        }
        this.value = s;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromShort exited");
        }
    }

    @Override
    public void fromShort(Short S) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromShort called");
        }
        if (S == null) {
            this.nullify();
        } else {
            this.value = S.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromShort exited");
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toInt called");
        }
        this.clearWarning();
        int i = this.isNull() ? 0 : (int)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toInt exited");
        }
        return i;
    }

    @Override
    public void fromInt(int i) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromInt called");
        }
        this.value = i;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromInt exited");
        }
    }

    @Override
    public void fromInt(Integer I) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromInt called");
        }
        if (I == null) {
            this.nullify();
        } else {
            this.value = I.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromInt exited");
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toLong called");
        }
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toLong exited");
        }
        return l;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromLong called");
        }
        this.value = l;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromLong exited");
        }
    }

    @Override
    public void fromLong(Long L) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromLong called");
        }
        if (L == null) {
            this.nullify();
        } else {
            this.value = L.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromLong exited");
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toFloat called");
        }
        this.clearWarning();
        float f = this.isNull() ? 0.0f : (float)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toFloat exited");
        }
        return f;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromFloat called");
        }
        this.value = f;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromFloat exited");
        }
    }

    @Override
    public void fromFloat(Float F) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromFloat called");
        }
        if (F == null) {
            this.nullify();
        } else {
            this.value = F.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromFloat exited");
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toDecimal called/exited");
        }
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigdec) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromBigDecimal called");
        }
        if (bigdec == null) {
            this.nullify();
        } else {
            this.value = bigdec.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromBigDecimal exited");
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        boolean b;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toBoolean called");
        }
        if (this.isNull()) {
            b = false;
        } else {
            boolean bl = b = this.value != 0.0;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toBoolean exited");
        }
        return b;
    }

    @Override
    public void fromBoolean(boolean b) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromBoolean called");
        }
        this.value = b ? 1 : 0;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromBoolean exited");
        }
    }

    @Override
    public void fromBoolean(Boolean b) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromBoolean called");
        }
        if (b == null) {
            this.nullify();
        } else {
            this.value = b == true ? 1 : 0;
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromBoolean exited");
        }
    }

    @Override
    public String toString() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toString called");
        }
        String s = this.isNull() ? null : Double.toString(this.value);
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: toString exited");
        }
        return s;
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromString called");
        }
        if (str == null) {
            this.nullify();
        } else {
            try {
                this.value = Double.valueOf(str.trim());
                this.unnullify();
            }
            catch (Exception e) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxFloat: fromString exited");
        }
    }

    static boolean isIfxNull(double d) {
        byte[] b = JavaToIfxType.JavaToIfxDouble(d);
        return IfxFloat.isIfxNull(b);
    }

    static boolean isIfxNull(byte[] b) {
        return IfxFloat.isIfxNull(b, 0, b.length);
    }

    static boolean isIfxNull(byte[] b, int offset, int length) {
        for (int i = 0; i < 8; ++i) {
            if (b[i + offset] == -1) continue;
            return false;
        }
        return true;
    }

    static double getIfxNull() {
        byte[] b = new byte[8];
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            b[i] = -1;
            d = IfxToJavaType.IfxToJavaDouble(b);
        }
        return d;
    }
}

