/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import com.informix.jns.IfxJNSException;
import com.informix.jns.LdapSqlhosts;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import com.informix.jns.Sqlhosts;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Properties;
import java.util.StringTokenizer;

class Jnstoolimpl {
    final int LIST = 1;
    final int LOOKUP = 2;
    final int ADD = 3;
    final int DEL = 4;
    final int UPDSQLH = 5;
    final int DELSQLH = 6;
    int cmd;
    Sqlhosts mysqh;
    LdapSqlhosts ldsqh;
    String cmdSrvrName = "mumbai_tli";
    String cmdFileName = "tfile.txt";
    String pfilename = "jnsproperties.txt";

    public Jnstoolimpl(String[] args) {
        this.parseArgs(args);
        this.initSqlhosts(this.pfilename);
        if (this.cmd == 1) {
            this.list();
        } else if (this.cmd == 2) {
            this.lookup(this.cmdSrvrName);
        } else if (this.cmd == 3) {
            this.add(this.cmdSrvrName);
        } else if (this.cmd == 4) {
            this.del(this.cmdSrvrName);
        } else if (this.cmd == 6) {
            this.delsqlh(this.cmdSrvrName);
        } else if (this.cmd == 5) {
            this.updsqlh(this.cmdFileName);
        }
    }

    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.cmd = 1;
        } else if (args[0].equalsIgnoreCase("-l")) {
            this.cmd = 1;
        } else if (args[0].equalsIgnoreCase("-g")) {
            this.cmd = 2;
            if (args.length > 1) {
                this.cmdSrvrName = args[1];
            }
        } else if (args[0].equalsIgnoreCase("-s")) {
            this.cmd = 3;
            if (args.length > 1) {
                this.cmdSrvrName = args[1];
            }
        } else if (args[0].equalsIgnoreCase("-d")) {
            this.cmd = 4;
            if (args.length > 1) {
                this.cmdSrvrName = args[1];
            }
        } else if (args[0].equalsIgnoreCase("-us")) {
            this.cmd = 5;
            if (args.length > 1) {
                this.cmdFileName = args[1];
            }
        } else if (args[0].equalsIgnoreCase("-ds")) {
            this.cmd = 6;
        } else if (args[0].equalsIgnoreCase("-sc")) {
            this.showschema();
            System.exit(0);
        } else {
            System.out.println("Usage ====> \njava Jnstool [-opt [arg]]\nWhere\nopt = -l (for list)\nopt = -g sname (for get)\nopt = -d sname (for delete)\nopt = -us filename (for update SQLHOSTS node in LDAP)\nopt = -ds (for delete SQLHOSTS node in LDAP)\nopt = -sc (print SQLHOSTS LDAP object schema definition)\nNOTE----> You must have \"jnsproperties.txt\" file in CWD\n");
            System.exit(-1);
        }
    }

    public void initSqlhosts(String pfilename) {
        Properties myenv;
        try {
            myenv = this.readProperties(pfilename);
        }
        catch (Exception e) {
            myenv = new Properties();
        }
        String sqlhType = myenv.getProperty("SQLH_TYPE", "LDAP");
        try {
            if (sqlhType.equalsIgnoreCase("FILE")) {
                this.mysqh = new Sqlhosts(myenv);
            } else {
                this.mysqh = new Sqlhosts(myenv);
                this.ldsqh = new LdapSqlhosts(myenv);
            }
        }
        catch (Exception e) {
            System.err.println("JNS operation(initSqlhosts) failed.==> " + e);
            System.err.println("The Stack Trace ==>");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public Properties readProperties(String pfilename) throws Exception {
        Properties jnsProp = new Properties();
        try {
            String sline;
            FileReader frdr = new FileReader(pfilename);
            BufferedReader bfr = new BufferedReader(frdr);
            while ((sline = bfr.readLine()) != null) {
                if (sline.charAt(0) == '#') continue;
                StringTokenizer stoken = new StringTokenizer(sline, "@ ");
                String tok1 = stoken.nextToken();
                String tok2 = stoken.nextToken();
                jnsProp.put(tok1, tok2);
            }
            bfr.close();
            frdr.close();
        }
        catch (Exception e) {
            System.out.println("Error reading Prop file e--> " + e);
            e.printStackTrace();
            throw e;
        }
        return jnsProp;
    }

    public void lookup(String sname) {
        String mySrvname = sname;
        try {
            ServerInfo mysrvr = this.mysqh.getServer(mySrvname);
            System.out.println("The Srvr:--> " + mysrvr);
            if (mysrvr.isGroupEntry()) {
                System.out.println("[" + mySrvname + "] is a grp entry -- Group entries ");
                ServerGroup mygrp = this.mysqh.getServerGroup(mySrvname);
                while (mygrp.hasMoreElements()) {
                    String gsrvr;
                    String ldgsrvr = gsrvr = (String)mygrp.nextElement();
                    System.out.println(" Member:-> " + gsrvr + " ==> ");
                    System.out.println(this.mysqh.getServer(ldgsrvr));
                }
            }
        }
        catch (IfxJNSException ejns) {
            System.err.println("JNS operation(lookup)failed.==>" + ejns);
            System.err.println("The Stack Trace ==>");
            ejns.printStackTrace();
        }
    }

    public void list() {
        try {
            ServerGroup mygrp = this.mysqh.listServers();
            while (mygrp.hasMoreElements()) {
                String gsrvr;
                String ldgsrvr = gsrvr = (String)mygrp.nextElement();
                System.out.println("S Member:->" + gsrvr + ":=>" + this.mysqh.getServer(ldgsrvr));
            }
        }
        catch (IfxJNSException ejns) {
            System.err.println("JNS operation (list) failed.==>" + ejns);
            System.err.println("The Stack Trace ==>");
            ejns.printStackTrace();
        }
    }

    public void add(String sname) {
        ServerInfo mysrvr = new ServerInfo(sname, "gnettype", "ultraman", "21000", sname + "++a=b");
        try {
            this.ldsqh.addServer(mysrvr);
        }
        catch (Exception e) {
            System.err.println("The Error ==>" + e);
        }
    }

    public void del(String sname) {
        try {
            this.ldsqh.delServer(sname);
        }
        catch (Exception e) {
            System.err.println("The Error ==>" + e);
        }
    }

    public void updsqlh(String filename) {
        try {
            this.ldsqh.uploadSqlhosts(filename);
        }
        catch (Exception e) {
            System.err.println("The Error ==>" + e);
        }
    }

    public void delsqlh(String sname) {
        try {
            this.ldsqh.destroySqlhosts();
        }
        catch (Exception e) {
            System.err.println("The Error ==>" + e);
        }
    }

    public void showschema() {
        System.out.println("SQLHOST object definition in LDIF format:\n\n  dn: cn=sqlhost,cn=schema,cn=config\n  objectClass: olcSchemaConfig\n  cn: sqlhost\n  olcAttributeTypes: ( 2.25.204145568702392606184909274861457726620 NAME 'desc' DESC 'description' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  olcAttributeTypes: ( 2.25.204145568702392606184909274861457726621 NAME 'dsf1hostname' DESC 'hostname' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  olcAttributeTypes: ( 2.25.204145568702392606184909274861457726622 NAME 'dsf1nettype' DESC 'nettype' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  olcAttributeTypes: ( 2.25.204145568702392606184909274861457726623 NAME 'dsf1options' DESC 'options' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  olcAttributeTypes: ( 2.25.204145568702392606184909274861457726624 NAME 'dsf1service' DESC 'service' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  olcObjectClasses: ( 2.25.47738286970033183401410679001448301858 NAME 'sqlhosts' DESC 'sqlhosts' SUP top STRUCTURAL MUST ( desc $ cn ) )\n  olcObjectClasses: ( 2.25.47738286970033183401410679001448301859 NAME 'sqlhostentry' DESC 'sqlhost entry' SUP top STRUCTURAL MAY ( dsf1hostname $ dsf1nettype $ dsf1options $ dsf1service $ desc $ cn ) )\n\n\n");
        System.out.println("SQLHOST object definition in SCHEMA format:\n\n  attributetype ( 2.5.4.10002 NAME 'desc'\n    DESC 'description'\n    SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  attributetype ( 2.5.4.10003 NAME 'dsf1hostname'\n    DESC 'hostname'\n    SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  attributetype ( 2.5.4.10004 NAME 'dsf1nettype'\n    DESC 'nettype'\n    SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  attributetype ( 2.5.4.10005 NAME 'dsf1options'\n    DESC 'options'\n    SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  attributetype ( 2.5.4.10006 NAME 'dsf1service'\n    DESC 'service'\n    SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{32768} )\n  objectclass ( 2.5.6.10002 NAME 'sqlhosts' SUP top STRUCTURAL\n    DESC 'sqlhosts'\n    MUST ( desc $ cn )\n    )\n  objectclass ( 2.5.7.10002 NAME 'sqlhostentry' SUP top STRUCTURAL\n    DESC 'sqlhost entry'\n    MAY ( dsf1hostname $ dsf1nettype $ dsf1options $ dsf1service $ cn $ desc )\n    )\n\n\n");
    }
}

