/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ByteArrayOutputStreamToInputStream;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.Encoding;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.PLPXMLInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

final class SQLServerSQLXML
implements SQLXML {
    private final SQLServerConnection con;
    private final PLPXMLInputStream contents;
    private final InputStreamGetterArgs getterArgs;
    private final TypeInfo typeInfo;
    private boolean isUsed = false;
    private boolean isFreed = false;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerSQLXML");
    private ByteArrayOutputStreamToInputStream outputStreamValue;
    private Document docValue;
    private String strValue;
    private static int baseID = 0;
    private final String traceID;

    public final String toString() {
        return this.traceID;
    }

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    InputStream getValue() throws SQLServerException {
        this.checkClosed();
        if (!this.isUsed) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_noDataXML"), null, true);
        }
        assert (null == this.contents);
        ByteArrayInputStream byteArrayInputStream = null;
        if (null != this.outputStreamValue) {
            byteArrayInputStream = this.outputStreamValue.getInputStream();
            assert (null == this.docValue);
            assert (null == this.strValue);
        } else if (null != this.docValue) {
            assert (null == this.outputStreamValue);
            assert (null == this.strValue);
            ByteArrayOutputStreamToInputStream byteArrayOutputStreamToInputStream = new ByteArrayOutputStreamToInputStream();
            Object var4_4 = null;
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.newTransformer().transform(new DOMSource(this.docValue), new StreamResult(byteArrayOutputStreamToInputStream));
            }
            catch (TransformerException transformerException) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noParserSupport"));
                Object[] objectArray = new Object[]{transformerException.toString()};
                SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
            }
            byteArrayInputStream = byteArrayOutputStreamToInputStream.getInputStream();
        } else {
            assert (null == this.outputStreamValue);
            assert (null == this.docValue);
            assert (null != this.strValue);
            try {
                byteArrayInputStream = new ByteArrayInputStream(this.strValue.getBytes(Encoding.UNICODE.charsetName()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
            }
        }
        assert (null != byteArrayInputStream);
        this.isFreed = true;
        return byteArrayInputStream;
    }

    SQLServerSQLXML(SQLServerConnection sQLServerConnection) {
        this.contents = null;
        this.traceID = " SQLServerSQLXML:" + SQLServerSQLXML.nextInstanceID();
        this.con = sQLServerConnection;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerConnection.toString() + ")");
        }
        this.getterArgs = null;
        this.typeInfo = null;
    }

    SQLServerSQLXML(InputStream inputStream, InputStreamGetterArgs inputStreamGetterArgs, TypeInfo typeInfo) throws SQLServerException {
        this.traceID = " SQLServerSQLXML:" + SQLServerSQLXML.nextInstanceID();
        this.contents = (PLPXMLInputStream)inputStream;
        this.con = null;
        this.getterArgs = inputStreamGetterArgs;
        this.typeInfo = typeInfo;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (null connection)");
        }
    }

    InputStream getStream() {
        return this.contents;
    }

    @Override
    public void free() throws SQLException {
        if (!this.isFreed) {
            this.isFreed = true;
            if (null != this.contents) {
                try {
                    this.contents.close();
                }
                catch (IOException iOException) {
                    SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
                }
            }
        }
    }

    private void checkClosed() throws SQLServerException {
        if (this.isFreed || null != this.con && this.con.isClosed()) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_isFreed"));
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(new Object[]{"SQLXML"}), null, true);
        }
    }

    private void checkReadXML() throws SQLException {
        if (null == this.contents) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_writeOnlyXML"), null, true);
        }
        if (this.isUsed) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_dataHasBeenReadXML"), null, true);
        }
        try {
            this.contents.checkClosed();
        }
        catch (IOException iOException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_isFreed"));
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(new Object[]{"SQLXML"}), null, true);
        }
    }

    void checkWriteXML() throws SQLException {
        if (null != this.contents) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_readOnlyXML"), null, true);
        }
        if (this.isUsed) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_dataHasBeenSetXML"), null, true);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        this.checkReadXML();
        this.isUsed = true;
        return this.contents;
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        this.checkClosed();
        this.checkWriteXML();
        this.isUsed = true;
        this.outputStreamValue = new ByteArrayOutputStreamToInputStream();
        return this.outputStreamValue;
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        this.checkClosed();
        this.checkWriteXML();
        this.isUsed = true;
        this.outputStreamValue = new ByteArrayOutputStreamToInputStream();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)this.outputStreamValue, Encoding.UNICODE.charsetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
        }
        return outputStreamWriter;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        this.checkReadXML();
        this.isUsed = true;
        StreamType streamType = StreamType.CHARACTER;
        InputStreamGetterArgs inputStreamGetterArgs = new InputStreamGetterArgs(streamType, this.getterArgs.isAdaptive, this.getterArgs.isStreaming, this.getterArgs.logContext);
        assert (null != this.contents);
        try {
            this.contents.read();
            this.contents.read();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
        }
        Reader reader = (Reader)DDC.convertStreamToObject(this.contents, this.typeInfo, streamType.getJDBCType(), inputStreamGetterArgs);
        return reader;
    }

    @Override
    public String getString() throws SQLException {
        this.checkClosed();
        this.checkReadXML();
        this.isUsed = true;
        assert (null != this.contents);
        try {
            this.contents.read();
            this.contents.read();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
        }
        byte[] byArray = this.contents.getBytes();
        String string = null;
        try {
            string = new String(byArray, 0, byArray.length, Encoding.UNICODE.charsetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
        }
        return string;
    }

    @Override
    public void setString(String string) throws SQLException {
        this.checkClosed();
        this.checkWriteXML();
        this.isUsed = true;
        if (null == string) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        this.strValue = string;
    }

    @Override
    public <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        this.checkClosed();
        this.checkReadXML();
        if (null == clazz) {
            StreamSource streamSource = this.getSourceInternal(StreamSource.class);
            return (T)streamSource;
        }
        return this.getSourceInternal(clazz);
    }

    <T extends Source> T getSourceInternal(Class<T> clazz) throws SQLException {
        this.isUsed = true;
        Source source = null;
        if (DOMSource.class == clazz) {
            source = (Source)clazz.cast(this.getDOMSource());
        } else if (SAXSource.class == clazz) {
            source = (Source)clazz.cast(this.getSAXSource());
        } else if (StAXSource.class == clazz) {
            source = (Source)clazz.cast(this.getStAXSource());
        } else if (StreamSource.class == clazz) {
            source = (Source)clazz.cast(new StreamSource(this.contents));
        } else {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_notSupported"), null, true);
        }
        return (T)source;
    }

    @Override
    public <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        this.checkClosed();
        this.checkWriteXML();
        if (null == clazz) {
            StreamResult streamResult = this.setResultInternal(StreamResult.class);
            return (T)streamResult;
        }
        return this.setResultInternal(clazz);
    }

    <T extends Result> T setResultInternal(Class<T> clazz) throws SQLException {
        this.isUsed = true;
        Result result = null;
        if (DOMResult.class == clazz) {
            result = (Result)clazz.cast(this.getDOMResult());
        } else if (SAXResult.class == clazz) {
            result = (Result)clazz.cast(this.getSAXResult());
        } else if (StAXResult.class == clazz) {
            result = (Result)clazz.cast(this.getStAXResult());
        } else if (StreamResult.class == clazz) {
            this.outputStreamValue = new ByteArrayOutputStreamToInputStream();
            result = (Result)clazz.cast(new StreamResult(this.outputStreamValue));
        } else {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_notSupported"), null, true);
        }
        return (T)result;
    }

    private final DOMSource getDOMSource() throws SQLException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                document = documentBuilder.parse(this.contents);
            }
            catch (IOException iOException) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                Object[] objectArray = new Object[]{iOException.toString()};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
            }
            DOMSource dOMSource = new DOMSource(document);
            return dOMSource;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noParserSupport"));
            Object[] objectArray = new Object[]{parserConfigurationException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        catch (SAXException sAXException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_failedToParseXML"));
            Object[] objectArray = new Object[]{sAXException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        return null;
    }

    private final SAXSource getSAXSource() throws SQLException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(this.contents);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            return sAXSource;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noParserSupport"));
            Object[] objectArray = new Object[]{parserConfigurationException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        catch (SAXException sAXException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_failedToParseXML"));
            Object[] objectArray = new Object[]{sAXException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        return null;
    }

    private final StAXSource getStAXSource() throws SQLException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(this.contents);
            StAXSource stAXSource = new StAXSource(xMLStreamReader);
            return stAXSource;
        }
        catch (XMLStreamException xMLStreamException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noParserSupport"));
            Object[] objectArray = new Object[]{xMLStreamException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
            return null;
        }
    }

    private final StAXResult getStAXResult() throws SQLException {
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        this.outputStreamValue = new ByteArrayOutputStreamToInputStream();
        try {
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(this.outputStreamValue);
            StAXResult stAXResult = new StAXResult(xMLStreamWriter);
            return stAXResult;
        }
        catch (XMLStreamException xMLStreamException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noParserSupport"));
            Object[] objectArray = new Object[]{xMLStreamException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
            return null;
        }
    }

    private final SAXResult getSAXResult() throws SQLException {
        Object object;
        TransformerHandler transformerHandler = null;
        try {
            object = (SAXTransformerFactory)TransformerFactory.newInstance();
            transformerHandler = ((SAXTransformerFactory)object).newTransformerHandler();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noParserSupport"));
            Object[] objectArray = new Object[]{transformerConfigurationException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        catch (ClassCastException classCastException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noParserSupport"));
            Object[] objectArray = new Object[]{classCastException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        this.outputStreamValue = new ByteArrayOutputStreamToInputStream();
        transformerHandler.setResult(new StreamResult(this.outputStreamValue));
        object = new SAXResult(transformerHandler);
        return object;
    }

    private final DOMResult getDOMResult() throws SQLException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        assert (null == this.outputStreamValue);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.docValue = documentBuilder.newDocument();
            DOMResult dOMResult = new DOMResult(this.docValue);
            return dOMResult;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noParserSupport"));
            Object[] objectArray = new Object[]{parserConfigurationException.toString()};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
            return null;
        }
    }
}

