/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerStatement;
import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamInfo;
import com.microsoft.sqlserver.jdbc.StreamRetStatus;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLServerStatement
implements ISQLServerStatement {
    static final char LEFT_CURLY_BRACKET = '{';
    static final char RIGHT_CURLY_BRACKET = '}';
    private boolean isResponseBufferingAdaptive = false;
    private boolean wasResponseBufferingSet = false;
    static final String identityQuery = " select SCOPE_IDENTITY() AS GENERATED_KEYS";
    String procedureName;
    private int serverCursorId;
    private int serverCursorRowCount;
    boolean stmtPoolable;
    private TDSReader tdsReader;
    Parameter[] inOutParam;
    final SQLServerConnection connection;
    int queryTimeout;
    private volatile TDSCommand currentCommand = null;
    private TDSCommand lastStmtExecCmd = null;
    static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.Statement");
    private final String loggingClassName;
    private final String traceID;
    private ExecuteProperties execProps;
    boolean moreResults = false;
    SQLServerResultSet resultSet;
    static final int EXECUTE_NOT_SET = 0;
    static final int EXECUTE_QUERY = 1;
    static final int EXECUTE_UPDATE = 2;
    static final int EXECUTE = 3;
    static final int EXECUTE_BATCH = 4;
    static final int EXECUTE_QUERY_INTERNAL = 5;
    int executeMethod = 0;
    int updateCount = -1;
    boolean escapeProcessing;
    int maxRows = 0;
    int maxFieldSize = 0;
    int resultSetConcurrency;
    int appResultSetType;
    int resultSetType;
    boolean executedSqlDirectly = false;
    boolean expectCursorOutParams;
    String cursorName;
    int nFetchSize;
    int defaultFetchSize;
    int nFetchDirection;
    boolean bIsClosed;
    boolean bRequestedGeneratedKeys;
    private ResultSet autoGeneratedKeys;
    private final ArrayList<String> batchStatementBuffer = new ArrayList();
    private static final Logger stmtlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerStatement");
    private static int lastStatementID = 0;
    Vector<SQLWarning> sqlWarnings;

    final boolean getIsResponseBufferingAdaptive() {
        return this.isResponseBufferingAdaptive;
    }

    final boolean wasResponseBufferingSet() {
        return this.wasResponseBufferingSet;
    }

    final int getServerCursorId() {
        return this.serverCursorId;
    }

    final int getServerCursorRowCount() {
        return this.serverCursorRowCount;
    }

    final TDSReader resultsReader() {
        return this.tdsReader;
    }

    final boolean wasExecuted() {
        return null != this.tdsReader;
    }

    final void discardLastExecutionResults() {
        if (null != this.lastStmtExecCmd) {
            this.lastStmtExecCmd.close();
            this.lastStmtExecCmd = null;
        }
        this.clearLastResult();
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    final ExecuteProperties getExecProps() {
        return this.execProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void executeStatement(TDSCommand tDSCommand) throws SQLServerException {
        this.discardLastExecutionResults();
        this.execProps = new ExecuteProperties(this);
        try {
            this.executeCommand(tDSCommand);
        }
        finally {
            this.lastStmtExecCmd = tDSCommand;
        }
    }

    final void executeCommand(TDSCommand tDSCommand) throws SQLServerException {
        this.currentCommand = tDSCommand;
        this.connection.executeCommand(tDSCommand);
    }

    final int getSQLResultSetType() {
        return this.resultSetType;
    }

    final int getCursorType() {
        return this.getResultSetScrollOpt() & 0xFFFFEFFF;
    }

    final boolean isCursorable(int n) {
        return this.resultSetType != 2003 && (3 == n || 1 == n);
    }

    public String toString() {
        return this.traceID;
    }

    String getClassNameInternal() {
        return "SQLServerStatement";
    }

    private static synchronized int nextStatementID() {
        return ++lastStatementID;
    }

    SQLServerStatement(SQLServerConnection sQLServerConnection, int n, int n2) throws SQLServerException {
        String string;
        int n3 = SQLServerStatement.nextStatementID();
        String string2 = this.getClassNameInternal();
        this.traceID = string2 + ":" + n3;
        this.loggingClassName = "com.microsoft.sqlserver.jdbc." + string2 + ":" + n3;
        this.stmtPoolable = false;
        this.connection = sQLServerConnection;
        this.bIsClosed = false;
        if (1003 != n && 1005 != n && 1004 != n && 2003 != n && 2004 != n && 1006 != n && 1005 != n && 1004 != n) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursor"), null, true);
        }
        if (1007 != n2 && 1008 != n2 && 1009 != n2 && 1008 != n2 && 1010 != n2) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedConcurrency"), null, true);
        }
        this.resultSetConcurrency = n2;
        this.appResultSetType = n;
        this.resultSetType = 1003 == n ? (1007 == n2 ? (null == (string = sQLServerConnection.getSelectMethod()) || !string.equals("cursor") ? 2003 : 2004) : 2004) : (1004 == n ? 1004 : (1005 == n ? 1005 : n));
        this.nFetchDirection = 2003 == this.resultSetType || 2004 == this.resultSetType ? 1000 : 1002;
        this.defaultFetchSize = this.nFetchSize = 1009 == this.resultSetConcurrency ? 8 : 128;
        if (1007 != n2 && (2003 == this.resultSetType || 1004 == this.resultSetType)) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursorAndConcurrency"), null, true);
        }
        this.setResponseBuffering(this.connection.getResponseBuffering());
        if (stmtlogger.isLoggable(Level.FINER)) {
            stmtlogger.finer("Properties for " + this.toString() + ":" + " Result type:" + this.appResultSetType + " (" + this.resultSetType + ")" + " Concurrency:" + this.resultSetConcurrency + " Fetchsize:" + this.nFetchSize + " bIsClosed:" + this.bIsClosed + " useLastUpdateCount:" + this.connection.useLastUpdateCount());
        }
        if (stmtlogger.isLoggable(Level.FINE)) {
            stmtlogger.fine(this.toString() + " created by (" + this.connection.toString() + ")");
        }
    }

    final Logger getStatementLogger() {
        return stmtlogger;
    }

    final void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    void closeInternal() {
        assert (!this.bIsClosed);
        this.bIsClosed = true;
        this.discardLastExecutionResults();
        this.autoGeneratedKeys = null;
        this.sqlWarnings = null;
        this.inOutParam = null;
    }

    @Override
    public void close() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "close");
        if (!this.bIsClosed) {
            this.closeInternal();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "close");
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "executeQuery", string);
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 1, 2));
        loggerExternal.exiting(this.getClassNameLogging(), "executeQuery", this.resultSet);
        return this.resultSet;
    }

    final SQLServerResultSet executeQueryInternal(String string) throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 5, 2));
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", string);
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 2, 2));
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", new Integer(this.updateCount));
        return this.updateCount;
    }

    @Override
    public boolean execute(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "execute", string);
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, string, 3, 2));
        loggerExternal.exiting(this.getClassNameLogging(), "execute", null != this.resultSet);
        return null != this.resultSet;
    }

    private String ensureSQLSyntax(String string) {
        if (string.indexOf(123) >= 0) {
            JDBCCallSyntaxTranslator jDBCCallSyntaxTranslator = new JDBCCallSyntaxTranslator();
            String string2 = jDBCCallSyntaxTranslator.translate(string);
            this.procedureName = jDBCCallSyntaxTranslator.getProcedureName();
            return string2;
        }
        return string;
    }

    void startResults() {
        this.moreResults = true;
    }

    final void doExecuteStatement(StmtExecCmd stmtExecCmd) throws SQLServerException {
        this.resetForReexecute();
        this.executeMethod = stmtExecCmd.executeMethod;
        String string = this.ensureSQLSyntax(stmtExecCmd.sql);
        if (1 == this.executeMethod || 3 == this.executeMethod) {
            this.connection.setMaxRows(this.maxRows);
            this.connection.setMaxFieldSize(this.maxFieldSize);
        } else {
            assert (2 == this.executeMethod || 4 == this.executeMethod || 5 == this.executeMethod);
            this.connection.setMaxRows(0);
        }
        if (this.isCursorable(this.executeMethod) && this.isSelect(string)) {
            if (stmtlogger.isLoggable(Level.FINE)) {
                stmtlogger.fine(this.toString() + " Executing server side cursor " + string);
            }
            this.doExecuteCursored(stmtExecCmd, string);
        } else {
            this.executedSqlDirectly = true;
            this.expectCursorOutParams = false;
            TDSWriter tDSWriter = stmtExecCmd.startRequest((byte)1);
            tDSWriter.writeString(string);
            if (1 == stmtExecCmd.autoGeneratedKeys && (2 == this.executeMethod || 3 == this.executeMethod) && string.trim().toUpperCase().startsWith("INSERT")) {
                tDSWriter.writeString(identityQuery);
            }
            if (stmtlogger.isLoggable(Level.FINE)) {
                stmtlogger.fine(this.toString() + " Executing (not server cursor) " + string);
            }
            this.ensureExecuteResultsReader(stmtExecCmd.startResponse(this.isResponseBufferingAdaptive));
            this.startResults();
            this.getNextResult();
        }
        if (null == this.resultSet) {
            if (1 == this.executeMethod) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
            }
        } else if (2 == this.executeMethod || 4 == this.executeMethod) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    private final void doExecuteStatementBatch(StmtBatchExecCmd stmtBatchExecCmd) throws SQLServerException {
        this.resetForReexecute();
        this.connection.setMaxRows(0);
        this.executeMethod = 4;
        this.executedSqlDirectly = true;
        this.expectCursorOutParams = false;
        TDSWriter tDSWriter = stmtBatchExecCmd.startRequest((byte)1);
        ListIterator<String> listIterator = this.batchStatementBuffer.listIterator();
        tDSWriter.writeString(listIterator.next());
        while (listIterator.hasNext()) {
            tDSWriter.writeString(" ; ");
            tDSWriter.writeString(listIterator.next());
        }
        this.ensureExecuteResultsReader(stmtBatchExecCmd.startResponse(this.isResponseBufferingAdaptive));
        this.startResults();
        this.getNextResult();
        if (null != this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    final void resetForReexecute() throws SQLServerException {
        this.ensureExecuteResultsReader(null);
        this.autoGeneratedKeys = null;
        this.updateCount = -1;
        this.sqlWarnings = null;
        this.executedSqlDirectly = false;
        this.startResults();
    }

    final boolean isSelect(String string) throws SQLServerException {
        this.checkClosed();
        String string2 = string.trim();
        char c = string2.charAt(0);
        if (c != 's' && c != 'S') {
            return false;
        }
        return string2.substring(0, 6).equalsIgnoreCase("select");
    }

    static String replaceParameterWithString(String string, char c, String string2) {
        int n = 0;
        while ((n = string.indexOf("" + c)) >= 0) {
            string = string.substring(0, n) + string2 + string.substring(n + 1, string.length());
        }
        return string;
    }

    static String replaceMarkerWithNull(String string) {
        if (string.indexOf("'") < 0) {
            String string2 = SQLServerStatement.replaceParameterWithString(string, '?', "null");
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'", true);
        boolean bl = true;
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("'")) {
                string3 = string3 + "'";
                bl = !bl;
                continue;
            }
            if (bl) {
                String string5 = SQLServerStatement.replaceParameterWithString(string4, '?', "null");
                string3 = string3 + string5;
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    void checkClosed() throws SQLServerException {
        this.connection.checkClosed();
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
    }

    @Override
    public final int getMaxFieldSize() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMaxFieldSize");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getMaxFieldSize", new Integer(this.maxFieldSize));
        return this.maxFieldSize;
    }

    @Override
    public final void setMaxFieldSize(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setMaxFieldSize", new Integer(n));
        this.checkClosed();
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.maxFieldSize = n;
        loggerExternal.exiting(this.getClassNameLogging(), "setMaxFieldSize");
    }

    @Override
    public final int getMaxRows() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMaxRows");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getMaxRows", new Integer(this.maxRows));
        return this.maxRows;
    }

    @Override
    public final void setMaxRows(int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setMaxRows", new Integer(n));
        }
        this.checkClosed();
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidRowcount"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        if (1006 != this.resultSetType) {
            this.maxRows = n;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setMaxRows");
    }

    @Override
    public final void setEscapeProcessing(boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setEscapeProcessing", bl);
        }
        this.checkClosed();
        this.escapeProcessing = bl;
        loggerExternal.exiting(this.getClassNameLogging(), "setEscapeProcessing");
    }

    @Override
    public final int getQueryTimeout() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getQueryTimeout");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getQueryTimeout", new Integer(this.queryTimeout));
        return this.queryTimeout;
    }

    @Override
    public final void setQueryTimeout(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setQueryTimeout", new Integer(n));
        this.checkClosed();
        if (n < 0) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidQueryTimeOutValue"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        this.queryTimeout = n;
        loggerExternal.exiting(this.getClassNameLogging(), "setQueryTimeout");
    }

    @Override
    public final void cancel() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "cancel");
        this.checkClosed();
        if (null != this.currentCommand) {
            this.currentCommand.interrupt(SQLServerException.getErrString("R_queryCancelled"));
        }
        loggerExternal.exiting(this.getClassNameLogging(), "cancel");
    }

    @Override
    public final SQLWarning getWarnings() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getWarnings");
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        SQLWarning sQLWarning = this.sqlWarnings.elementAt(0);
        loggerExternal.exiting(this.getClassNameLogging(), "getWarnings", sQLWarning);
        return sQLWarning;
    }

    @Override
    public final void clearWarnings() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearWarnings");
        this.checkClosed();
        this.sqlWarnings = null;
        loggerExternal.exiting(this.getClassNameLogging(), "clearWarnings");
    }

    @Override
    public final void setCursorName(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setCursorName", string);
        this.checkClosed();
        this.cursorName = string;
        loggerExternal.exiting(this.getClassNameLogging(), "setCursorName");
    }

    final String getCursorName() {
        return this.cursorName;
    }

    @Override
    public final ResultSet getResultSet() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getResultSet");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getResultSet", this.resultSet);
        return this.resultSet;
    }

    @Override
    public final int getUpdateCount() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getUpdateCount");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getUpdateCount", new Integer(this.updateCount));
        return this.updateCount;
    }

    final void ensureExecuteResultsReader(TDSReader tDSReader) {
        this.tdsReader = tDSReader;
    }

    final void processExecuteResults() throws SQLServerException {
        if (this.wasExecuted()) {
            this.processBatch();
            TDSParser.parse(this.resultsReader(), "batch completion");
            this.ensureExecuteResultsReader(null);
        }
    }

    void processBatch() throws SQLServerException {
        this.processResults();
    }

    final void processResults() throws SQLServerException {
        SQLServerException sQLServerException = null;
        while (this.moreResults) {
            try {
                this.getNextResult();
            }
            catch (SQLServerException sQLServerException2) {
                if (this.moreResults) {
                    if (2 == sQLServerException2.getDriverErrorCode()) {
                        if (!stmtlogger.isLoggable(Level.FINEST)) continue;
                        stmtlogger.finest(this + " ignoring database error: " + sQLServerException2.getErrorCode() + " " + sQLServerException2.getMessage());
                        continue;
                    }
                    if (sQLServerException2.getSQLState().equals(SQLState.STATEMENT_CANCELED.getSQLStateCode())) {
                        sQLServerException = sQLServerException2;
                        continue;
                    }
                }
                this.moreResults = false;
                throw sQLServerException2;
            }
        }
        this.clearLastResult();
        if (null != sQLServerException) {
            throw sQLServerException;
        }
    }

    @Override
    public final boolean getMoreResults() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMoreResults");
        this.checkClosed();
        this.getNextResult();
        loggerExternal.exiting(this.getClassNameLogging(), "getMoreResults", null != this.resultSet);
        return null != this.resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clearLastResult() {
        this.updateCount = -1;
        if (null != this.resultSet) {
            try {
                this.resultSet.close();
            }
            catch (SQLServerException sQLServerException) {
                stmtlogger.finest(this + " clearing last result; ignored error closing ResultSet: " + sQLServerException.getErrorCode() + " " + sQLServerException.getMessage());
            }
            finally {
                this.resultSet = null;
            }
        }
    }

    final boolean getNextResult() throws SQLServerException {
        if (!this.wasExecuted()) {
            this.moreResults = false;
            return false;
        }
        this.clearLastResult();
        if (!this.moreResults) {
            return false;
        }
        final class NextResult
        extends TDSTokenHandler {
            private StreamDone stmtDoneToken;
            private boolean isResultSet;
            private StreamRetStatus procedureRetStatToken;

            final boolean isUpdateCount() {
                return null != this.stmtDoneToken;
            }

            final int getUpdateCount() {
                return this.stmtDoneToken.getUpdateCount();
            }

            final boolean isResultSet() {
                return this.isResultSet;
            }

            NextResult() {
                super("getNextResult");
                this.stmtDoneToken = null;
                this.isResultSet = false;
                this.procedureRetStatToken = null;
            }

            @Override
            boolean onColMetaData(TDSReader tDSReader) throws SQLServerException {
                if (null != this.stmtDoneToken) {
                    return false;
                }
                if (null != this.getDatabaseError()) {
                    return false;
                }
                this.isResultSet = true;
                return false;
            }

            @Override
            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                StreamDone streamDone = new StreamDone();
                streamDone.setFromTDS(tDSReader);
                if (streamDone.isAttnAck()) {
                    return false;
                }
                if (streamDone.cmdIsDMLOrDDL()) {
                    if (-1 == streamDone.getUpdateCount() && 4 != SQLServerStatement.this.executeMethod) {
                        return true;
                    }
                    this.stmtDoneToken = streamDone;
                    if (255 != streamDone.getTokenType()) {
                        return false;
                    }
                    if (4 != SQLServerStatement.this.executeMethod) {
                        if (null != SQLServerStatement.this.procedureName) {
                            return false;
                        }
                        if (3 == SQLServerStatement.this.executeMethod) {
                            return false;
                        }
                        if (!SQLServerStatement.this.connection.useLastUpdateCount()) {
                            return false;
                        }
                    }
                } else {
                    if (streamDone.isFinal()) {
                        SQLServerStatement.this.moreResults = false;
                        return false;
                    }
                    if (4 == SQLServerStatement.this.executeMethod && (255 != streamDone.getTokenType() || streamDone.wasRPCInBatch())) {
                        SQLServerStatement.this.moreResults = false;
                        return false;
                    }
                }
                return !streamDone.isError();
            }

            @Override
            boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
                if (SQLServerStatement.this.consumeExecOutParam(tDSReader)) {
                    SQLServerStatement.this.moreResults = false;
                } else {
                    this.procedureRetStatToken = new StreamRetStatus();
                    this.procedureRetStatToken.setFromTDS(tDSReader);
                }
                return true;
            }

            @Override
            boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
                if (SQLServerStatement.this.moreResults && null == this.procedureRetStatToken) {
                    Parameter parameter = new Parameter();
                    parameter.skipRetValStatus(tDSReader);
                    parameter.skipValue(tDSReader, true);
                    return true;
                }
                return false;
            }

            @Override
            boolean onInfo(TDSReader tDSReader) throws SQLServerException {
                StreamInfo streamInfo = new StreamInfo();
                streamInfo.setFromTDS(tDSReader);
                if (16954 == streamInfo.msg.getErrorNumber()) {
                    SQLServerStatement.this.executedSqlDirectly = true;
                }
                SQLWarning sQLWarning = new SQLWarning(streamInfo.msg.getMessage(), SQLServerException.generateStateCode(SQLServerStatement.this.connection, streamInfo.msg.getErrorNumber(), streamInfo.msg.getErrorState()), streamInfo.msg.getErrorNumber());
                if (SQLServerStatement.this.sqlWarnings == null) {
                    SQLServerStatement.this.sqlWarnings = new Vector();
                } else {
                    int n = SQLServerStatement.this.sqlWarnings.size();
                    SQLWarning sQLWarning2 = SQLServerStatement.this.sqlWarnings.elementAt(n - 1);
                    sQLWarning2.setNextWarning(sQLWarning);
                }
                SQLServerStatement.this.sqlWarnings.add(sQLWarning);
                return true;
            }
        }
        NextResult nextResult = new NextResult();
        TDSParser.parse(this.resultsReader(), nextResult);
        if (null != nextResult.getDatabaseError()) {
            SQLServerException.makeFromDatabaseError(this.connection, null, nextResult.getDatabaseError().getMessage(), nextResult.getDatabaseError(), false);
        } else {
            if (nextResult.isResultSet()) {
                this.resultSet = new SQLServerResultSet(this);
                return true;
            }
            if (nextResult.isUpdateCount()) {
                this.updateCount = nextResult.getUpdateCount();
                return true;
            }
        }
        this.updateCount = -1;
        if (!this.moreResults) {
            return true;
        }
        this.moreResults = false;
        return false;
    }

    boolean consumeExecOutParam(TDSReader tDSReader) throws SQLServerException {
        if (this.expectCursorOutParams) {
            TDSParser.parse(tDSReader, new StmtExecOutParamHandler());
            return true;
        }
        return false;
    }

    @Override
    public final void setFetchDirection(int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFetchDirection", new Integer(n));
        }
        this.checkClosed();
        if (1000 != n && 1001 != n && 1002 != n || 1000 != n && (2003 == this.resultSetType || 2004 == this.resultSetType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.nFetchDirection = n;
        loggerExternal.exiting(this.getClassNameLogging(), "setFetchDirection");
    }

    @Override
    public final int getFetchDirection() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFetchDirection");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getFetchDirection", new Integer(this.nFetchDirection));
        return this.nFetchDirection;
    }

    @Override
    public final void setFetchSize(int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFetchSize", new Integer(n));
        }
        this.checkClosed();
        if (n < 0) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.nFetchSize = 0 == n ? this.defaultFetchSize : n;
        loggerExternal.exiting(this.getClassNameLogging(), "setFetchSize");
    }

    @Override
    public final int getFetchSize() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFetchSize");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getFetchSize", new Integer(this.nFetchSize));
        return this.nFetchSize;
    }

    @Override
    public final int getResultSetConcurrency() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getResultSetConcurrency");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getResultSetConcurrency", new Integer(this.resultSetConcurrency));
        return this.resultSetConcurrency;
    }

    @Override
    public final int getResultSetType() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getResultSetType");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getResultSetType", new Integer(this.appResultSetType));
        return this.appResultSetType;
    }

    @Override
    public void addBatch(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "addBatch", string);
        this.checkClosed();
        string = this.ensureSQLSyntax(string);
        this.batchStatementBuffer.add(string);
        loggerExternal.exiting(this.getClassNameLogging(), "addBatch");
    }

    @Override
    public void clearBatch() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearBatch");
        this.checkClosed();
        this.batchStatementBuffer.clear();
        loggerExternal.exiting(this.getClassNameLogging(), "clearBatch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLServerException, BatchUpdateException {
        loggerExternal.entering(this.getClassNameLogging(), "executeBatch");
        this.checkClosed();
        this.discardLastExecutionResults();
        try {
            int n = this.batchStatementBuffer.size();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = -3;
            }
            Throwable throwable = null;
            for (int i = 0; i < n; ++i) {
                try {
                    if (0 == i) {
                        this.executeStatement(new StmtBatchExecCmd(this));
                    } else {
                        this.startResults();
                        if (!this.getNextResult()) break;
                    }
                    if (null != this.resultSet) {
                        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, true);
                        continue;
                    }
                    nArray[i] = -1 != this.updateCount ? this.updateCount : -2;
                    continue;
                }
                catch (SQLServerException sQLServerException) {
                    if (this.connection.isSessionUnAvailable() || this.connection.rolledBackTransaction()) {
                        throw sQLServerException;
                    }
                    throwable = sQLServerException;
                }
            }
            if (null != throwable) {
                throw new BatchUpdateException(throwable.getMessage(), ((SQLException)throwable).getSQLState(), ((SQLException)throwable).getErrorCode(), nArray);
            }
            loggerExternal.exiting(this.getClassNameLogging(), "executeBatch", nArray);
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            this.batchStatementBuffer.clear();
        }
    }

    @Override
    public final Connection getConnection() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getConnection");
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
        Connection connection = this.connection.getConnection();
        loggerExternal.exiting(this.getClassNameLogging(), "getConnection", connection);
        return connection;
    }

    final int getResultSetScrollOpt() {
        int n = null == this.inOutParam ? 0 : 4096;
        switch (this.resultSetType) {
            case 2004: {
                return n | (1007 == this.resultSetConcurrency ? 16 : 4);
            }
            case 1006: {
                return n | 2;
            }
            case 1005: {
                return n | 1;
            }
            case 1004: {
                return n | 8;
            }
        }
        return 0;
    }

    final int getResultSetCCOpt() {
        switch (this.resultSetConcurrency) {
            case 1007: {
                return 8193;
            }
            case 1008: {
                return 24580;
            }
            case 1009: {
                return 24578;
            }
            case 1010: {
                return 24584;
            }
        }
        return 0;
    }

    private final void doExecuteCursored(StmtExecCmd stmtExecCmd, String string) throws SQLServerException {
        if (stmtlogger.isLoggable(Level.FINER)) {
            stmtlogger.finer(this.toString() + " Execute for cursor open" + " SQL:" + string + " Scrollability:" + this.getResultSetScrollOpt() + " Concurrency:" + this.getResultSetCCOpt());
        }
        this.executedSqlDirectly = false;
        this.expectCursorOutParams = true;
        TDSWriter tDSWriter = stmtExecCmd.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)2);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCStringUnicode(string);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        this.ensureExecuteResultsReader(stmtExecCmd.startResponse(this.isResponseBufferingAdaptive));
        this.startResults();
        this.getNextResult();
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getResultSetHoldability");
        this.checkClosed();
        int n = this.connection.getHoldability();
        loggerExternal.exiting(this.getClassNameLogging(), "getResultSetHoldability", new Integer(n));
        return n;
    }

    @Override
    public final boolean execute(String string, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "execute", new Object[]{string, new Integer(n)});
        }
        this.checkClosed();
        if (n != 1 && n != 2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.executeStatement(new StmtExecCmd(this, string, 3, n));
        loggerExternal.exiting(this.getClassNameLogging(), "execute", null != this.resultSet);
        return null != this.resultSet;
    }

    @Override
    public final boolean execute(String string, int[] nArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "execute", new Object[]{string, nArray});
        }
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        boolean bl = this.execute(string, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "execute", bl);
        return bl;
    }

    @Override
    public final boolean execute(String string, String[] stringArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "execute", new Object[]{string, stringArray});
        }
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        boolean bl = this.execute(string, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "execute", bl);
        return bl;
    }

    @Override
    public final int executeUpdate(String string, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", new Object[]{string, new Integer(n)});
        }
        this.checkClosed();
        if (n != 1 && n != 2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        this.executeStatement(new StmtExecCmd(this, string, 2, n));
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", new Integer(this.updateCount));
        return this.updateCount;
    }

    @Override
    public final int executeUpdate(String string, int[] nArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", new Object[]{string, nArray});
        }
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        int n = this.executeUpdate(string, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", new Integer(n));
        return n;
    }

    @Override
    public final int executeUpdate(String string, String[] stringArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", new Object[]{string, stringArray});
        }
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        int n = this.executeUpdate(string, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", new Integer(n));
        return n;
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getGeneratedKeys");
        this.checkClosed();
        if (null == this.autoGeneratedKeys) {
            int n = this.updateCount;
            if (!this.getNextResult() || null == this.resultSet) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementMustBeExecuted"), null, false);
            }
            this.autoGeneratedKeys = this.resultSet;
            this.updateCount = n;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getGeneratedKeys", this.autoGeneratedKeys);
        return this.autoGeneratedKeys;
    }

    @Override
    public final boolean getMoreResults(int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getMoreResults", new Integer(n));
        }
        this.checkClosed();
        if (2 == n) {
            this.NotImplemented();
        }
        if (1 != n && 3 != n) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_modeSuppliedNotValid"), null, true);
        }
        SQLServerResultSet sQLServerResultSet = this.resultSet;
        boolean bl = this.getMoreResults();
        if (sQLServerResultSet != null) {
            try {
                sQLServerResultSet.close();
            }
            catch (SQLException sQLException) {
                throw new SQLServerException(null, sQLException.getMessage(), null, 0, false);
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getMoreResults", bl);
        return bl;
    }

    @Override
    public boolean isClosed() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "isClosed");
        boolean bl = this.bIsClosed || this.connection.isSessionUnAvailable();
        loggerExternal.exiting(this.getClassNameLogging(), "isClosed", bl);
        return bl;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "isPoolable");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "isPoolable", this.stmtPoolable);
        return this.stmtPoolable;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "setPoolable", bl);
        this.checkClosed();
        this.stmtPoolable = bl;
        loggerExternal.exiting(this.getClassNameLogging(), "setPoolable");
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isWrapperFor");
        DriverJDBCVersion.checkSupportsJDBC4();
        boolean bl = clazz.isInstance(this);
        loggerExternal.exiting(this.getClassNameLogging(), "isWrapperFor", bl);
        return bl;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t;
        loggerExternal.entering(this.getClassNameLogging(), "unwrap");
        DriverJDBCVersion.checkSupportsJDBC4();
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SQLServerException(classCastException.getMessage(), classCastException);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "unwrap", t);
        return t;
    }

    @Override
    public final void setResponseBuffering(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setResponseBuffering", string);
        this.checkClosed();
        if (string.equalsIgnoreCase("full")) {
            this.isResponseBufferingAdaptive = false;
            this.wasResponseBufferingSet = true;
        } else if (string.equalsIgnoreCase("adaptive")) {
            this.isResponseBufferingAdaptive = true;
            this.wasResponseBufferingSet = true;
        } else {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidresponseBuffering"));
            Object[] objectArray = new Object[]{new String(string)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setResponseBuffering");
    }

    @Override
    public final String getResponseBuffering() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getResponseBuffering");
        this.checkClosed();
        String string = this.wasResponseBufferingSet ? (this.isResponseBufferingAdaptive ? "adaptive" : "full") : this.connection.getResponseBuffering();
        loggerExternal.exiting(this.getClassNameLogging(), "getResponseBuffering", string);
        return string;
    }

    private final class StmtBatchExecCmd
    extends TDSCommand {
        final SQLServerStatement stmt;

        StmtBatchExecCmd(SQLServerStatement sQLServerStatement2) {
            super(sQLServerStatement2.toString() + " executeBatch", sQLServerStatement2.queryTimeout);
            this.stmt = sQLServerStatement2;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecuteStatementBatch(this);
            return false;
        }

        @Override
        final void processResponse(TDSReader tDSReader) throws SQLServerException {
            SQLServerStatement.this.ensureExecuteResultsReader(tDSReader);
            SQLServerStatement.this.processExecuteResults();
        }
    }

    private final class StmtExecCmd
    extends TDSCommand {
        final SQLServerStatement stmt;
        final String sql;
        final int executeMethod;
        final int autoGeneratedKeys;

        StmtExecCmd(SQLServerStatement sQLServerStatement2, String string, int n, int n2) {
            super(sQLServerStatement2.toString() + " executeXXX", sQLServerStatement2.queryTimeout);
            this.stmt = sQLServerStatement2;
            this.sql = string;
            this.executeMethod = n;
            this.autoGeneratedKeys = n2;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecuteStatement(this);
            return false;
        }

        @Override
        final void processResponse(TDSReader tDSReader) throws SQLServerException {
            SQLServerStatement.this.ensureExecuteResultsReader(tDSReader);
            SQLServerStatement.this.processExecuteResults();
        }
    }

    class StmtExecOutParamHandler
    extends TDSTokenHandler {
        StmtExecOutParamHandler() {
            super("StmtExecOutParamHandler");
        }

        @Override
        boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
            new StreamRetStatus().setFromTDS(tDSReader);
            return true;
        }

        @Override
        boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
            if (SQLServerStatement.this.expectCursorOutParams) {
                Parameter parameter = new Parameter();
                parameter.skipRetValStatus(tDSReader);
                SQLServerStatement.this.serverCursorId = parameter.getInt(tDSReader);
                parameter.skipValue(tDSReader, true);
                parameter = new Parameter();
                parameter.skipRetValStatus(tDSReader);
                if (-1 == (SQLServerStatement.this.serverCursorRowCount = parameter.getInt(tDSReader))) {
                    SQLServerStatement.this.serverCursorRowCount = -3;
                }
                parameter.skipValue(tDSReader, true);
                SQLServerStatement.this.expectCursorOutParams = false;
                return true;
            }
            return false;
        }

        @Override
        boolean onDone(TDSReader tDSReader) throws SQLServerException {
            return false;
        }
    }

    final class ExecuteProperties {
        private final boolean wasResponseBufferingSet;
        private final boolean isResponseBufferingAdaptive;
        private final int holdability;

        final boolean wasResponseBufferingSet() {
            return this.wasResponseBufferingSet;
        }

        final boolean isResponseBufferingAdaptive() {
            return this.isResponseBufferingAdaptive;
        }

        final int getHoldability() {
            return this.holdability;
        }

        ExecuteProperties(SQLServerStatement sQLServerStatement2) {
            this.wasResponseBufferingSet = sQLServerStatement2.wasResponseBufferingSet();
            this.isResponseBufferingAdaptive = sQLServerStatement2.getIsResponseBufferingAdaptive();
            this.holdability = sQLServerStatement2.connection.getHoldabilityInternal();
        }
    }
}

