/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Encoding;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerDriverIntProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Util {
    static final String SYSTEM_SPEC_VERSION = System.getProperty("java.specification.version");
    static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String WSIDNotAvailable = "";
    static final String SYSTEM_JRE = System.getProperty("java.vendor") + " " + System.getProperty("java.version");

    Util() {
    }

    static boolean isIBM() {
        return SYSTEM_JRE.startsWith("IBM");
    }

    static short readShort(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
    }

    static int readUnsignedShort(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static int readUnsignedShortBigEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    static void writeShort(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s >> 0 & 0xFF);
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
    }

    static void writeShortBigEndian(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s >> 8 & 0xFF);
        byArray[n + 1] = (byte)(s >> 0 & 0xFF);
    }

    static int readInt(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = (byArray[n + 1] & 0xFF) << 8;
        int n4 = (byArray[n + 2] & 0xFF) << 16;
        int n5 = (byArray[n + 3] & 0xFF) << 24;
        return n5 | n4 | n3 | n2;
    }

    static int readIntBigEndian(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 0 | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 0] & 0xFF) << 24;
    }

    static void writeInt(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >> 0 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    static void writeIntBigEndian(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 0 & 0xFF);
    }

    static void writeLongBigEndian(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >> 56 & 0xFFL);
        byArray[n + 1] = (byte)(l >> 48 & 0xFFL);
        byArray[n + 2] = (byte)(l >> 40 & 0xFFL);
        byArray[n + 3] = (byte)(l >> 32 & 0xFFL);
        byArray[n + 4] = (byte)(l >> 24 & 0xFFL);
        byArray[n + 5] = (byte)(l >> 16 & 0xFFL);
        byArray[n + 6] = (byte)(l >> 8 & 0xFFL);
        byArray[n + 7] = (byte)(l >> 0 & 0xFFL);
    }

    static long readLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 7; i > 0; --i) {
            l += (long)(byArray[n + i] & 0xFF);
            l <<= 8;
        }
        return l + (long)(byArray[n] & 0xFF);
    }

    static Properties parseUrl(String string, Logger logger) throws SQLServerException {
        Properties properties = new Properties();
        String string2 = string;
        String string3 = "jdbc:sqlserver://";
        String string4 = WSIDNotAvailable;
        String string5 = WSIDNotAvailable;
        String string6 = WSIDNotAvailable;
        if (!string2.startsWith(string3)) {
            return null;
        }
        string2 = string2.substring(string3.length());
        int n = 0;
        int n2 = 0;
        block18: for (n = 0; n < string2.length(); ++n) {
            char c = string2.charAt(n);
            switch (n2) {
                case 0: {
                    if (c == ';') {
                        n2 = 7;
                        continue block18;
                    }
                    string4 = string4 + c;
                    n2 = 1;
                    continue block18;
                }
                case 1: {
                    if (c == ';' || c == ':' || c == '\\') {
                        if ((string4 = string4.trim()).length() > 0) {
                            properties.put(SQLServerDriverStringProperty.SERVER_NAME.toString(), string4);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Property:serverName Value:" + string4);
                            }
                        }
                        string4 = WSIDNotAvailable;
                        if (c == ';') {
                            n2 = 7;
                            continue block18;
                        }
                        if (c == ':') {
                            n2 = 2;
                            continue block18;
                        }
                        n2 = 3;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 2: {
                    if (c == ';') {
                        string4 = string4.trim();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Property:portNumber Value:" + string4);
                        }
                        properties.put(SQLServerDriverIntProperty.PORT_NUMBER.toString(), string4);
                        string4 = WSIDNotAvailable;
                        n2 = 7;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 3: {
                    if (c == ';' || c == ':') {
                        string4 = string4.trim();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Property:instanceName Value:" + string4);
                        }
                        properties.put(SQLServerDriverStringProperty.INSTANCE_NAME.toString(), string4.toLowerCase(Locale.US));
                        string4 = WSIDNotAvailable;
                        if (c == ';') {
                            n2 = 7;
                            continue block18;
                        }
                        n2 = 2;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 7: {
                    if (c == '=') {
                        if ((string5 = string5.trim()).length() <= 0) {
                            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        }
                        n2 = 6;
                        continue block18;
                    }
                    if (c == ';') {
                        if ((string5 = string5.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string5 = string5 + c;
                    continue block18;
                }
                case 6: {
                    if (c == ';') {
                        string6 = string6.trim();
                        if (null != (string5 = SQLServerDriver.getNormalizedPropertyName(string5, logger))) {
                            if (logger.isLoggable(Level.FINE) && !string5.equals(SQLServerDriverStringProperty.USER.toString()) && !string5.equals(SQLServerDriverStringProperty.PASSWORD.toString())) {
                                logger.fine("Property:" + string5 + " Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = WSIDNotAvailable;
                        string6 = WSIDNotAvailable;
                        n2 = 7;
                        continue block18;
                    }
                    if (c == '{') {
                        n2 = 4;
                        if ((string6 = string6.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string6 = string6 + c;
                    continue block18;
                }
                case 4: {
                    if (c == '}') {
                        if (null != (string5 = SQLServerDriver.getNormalizedPropertyName(string5, logger))) {
                            if (logger.isLoggable(Level.FINE) && !string5.equals(SQLServerDriverStringProperty.USER.toString()) && !string5.equals(SQLServerDriverStringProperty.PASSWORD.toString())) {
                                logger.fine("Property:" + string5 + " Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = WSIDNotAvailable;
                        string6 = WSIDNotAvailable;
                        n2 = 5;
                        continue block18;
                    }
                    string6 = string6 + c;
                    continue block18;
                }
                case 5: {
                    if (c == ';') {
                        n2 = 7;
                        continue block18;
                    }
                    if (c == ' ') continue block18;
                    SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                    continue block18;
                }
                default: {
                    assert (false) : "parseURL: Invalid state " + n2;
                    continue block18;
                }
            }
        }
        switch (n2) {
            case 1: {
                string4 = string4.trim();
                if (string4.length() <= 0) break;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Property:serverName Value:" + string4);
                }
                properties.put(SQLServerDriverStringProperty.SERVER_NAME.toString(), string4);
                break;
            }
            case 2: {
                string4 = string4.trim();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Property:portNumber Value:" + string4);
                }
                properties.put(SQLServerDriverIntProperty.PORT_NUMBER.toString(), string4);
                break;
            }
            case 3: {
                string4 = string4.trim();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Property:instanceName Value:" + string4);
                }
                properties.put(SQLServerDriverStringProperty.INSTANCE_NAME.toString(), string4);
                break;
            }
            case 6: {
                string6 = string6.trim();
                string5 = SQLServerDriver.getNormalizedPropertyName(string5, logger);
                if (null == string5) break;
                if (logger.isLoggable(Level.FINE) && !string5.equals(SQLServerDriverStringProperty.USER.toString()) && !string5.equals(SQLServerDriverStringProperty.PASSWORD.toString())) {
                    logger.fine("Property:" + string5 + " Value:" + string6);
                }
                properties.put(string5, string6);
                break;
            }
            case 0: 
            case 5: {
                break;
            }
            case 7: {
                string5 = string5.trim();
                if (string5.length() <= 0) break;
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                break;
            }
            default: {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
            }
        }
        return properties;
    }

    static String escapeSQLId(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('[');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (']' == c) {
                stringBuilder.append("]]");
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static String readUnicodeString(byte[] byArray, int n, int n2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        try {
            return new String(byArray, n, n2, Encoding.UNICODE.charsetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = SQLServerException.checkAndAppendClientConnId(SQLServerException.getErrString("R_stringReadError"), sQLServerConnection);
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string = SQLServerException.checkAndAppendClientConnId(SQLServerException.getErrString("R_stringReadError"), sQLServerConnection);
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static String byteToHexDisplayString(byte[] byArray) {
        if (null == byArray) {
            return "(null)";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2 + 2);
        stringBuilder.append("0x");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuilder.append(hexChars[(n & 0xF0) >> 4]);
            stringBuilder.append(hexChars[n & 0xF]);
        }
        return stringBuilder.toString();
    }

    static String bytesToHexString(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            stringBuilder.append(hexChars[(n2 & 0xF0) >> 4]);
            stringBuilder.append(hexChars[n2 & 0xF]);
        }
        return stringBuilder.toString();
    }

    static String lookupHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (null != inetAddress) {
                String string = inetAddress.getHostName();
                if (null != string && string.length() > 0) {
                    return string;
                }
                string = inetAddress.getHostAddress();
                if (null != string && string.length() > 0) {
                    return string;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            return WSIDNotAvailable;
        }
        return WSIDNotAvailable;
    }
}

