/*
 * Decompiled with CFR 0.152.
 */
package com.miya.api;

import com.alibaba.fastjson.JSON;
import com.miya.api.DefaultPoshubParser;
import com.miya.api.OperateErrorlog;
import com.miya.api.PollingRequest;
import com.miya.api.PosHubApiException;
import com.miya.api.PoshubClient;
import com.miya.api.PoshubParser;
import com.miya.api.PoshubRequest;
import com.miya.api.inernal.PoshubHttpUtils;
import com.miya.api.inernal.PoshubMD5Util;
import com.miya.api.inernal.PoshubMockUtil;
import com.miya.api.inernal.PoshubTimeUtils;
import com.miya.api.request.BarCodeRequest;
import com.miya.api.request.PaymentRefundRequest;
import com.miya.api.request.PaymentReverseRequest;
import com.miya.api.response.BarcodeResponse;
import com.miya.api.response.BizContentVO;
import com.miya.api.response.GoodsDetailResponse;
import com.miya.api.response.PaymentConfirmResponse;
import com.miya.api.response.PaymentRefundResponse;
import com.miya.api.response.PaymentReverseResponse;
import com.miya.api.response.QueryCardInfoResponse;
import com.miya.api.response.UnFreezeResponse;
import com.miya.api.test.MockData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class DefaultPoshubClient
implements PoshubClient {
    private String url;
    private String appid;
    private String method;
    private String secret;
    private String sign_type = "MD5";
    private String format = "JSON";
    private String charset = "UTF-8";
    private String ver = "1.0";
    private int connectTimeout = 15000;
    private int readTimeout = 15000;
    private static Logger logger;

    public DefaultPoshubClient(String url, String appid, String secret) {
        this.url = url;
        this.appid = appid;
        this.secret = secret;
    }

    public DefaultPoshubClient(String url, String appid, String secret, String method) {
        this(url, appid, secret);
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public <T extends BizContentVO> T execute(PoshubRequest<T> request) throws PosHubApiException {
        return this._execute(request);
    }

    private <T extends BizContentVO> T _execute(PoshubRequest<T> request) throws PosHubApiException {
        PoshubRequest<PaymentReverseResponse> req;
        BizContentVO resp;
        Class<T> respcls = request.responseClass();
        logger.info("poshubUtils request: " + JSON.toJSONString(request));
        DefaultPoshubParser<T> parser = new DefaultPoshubParser<T>(respcls);
        String data = JSON.toJSONString(request);
        Map<String, String> qureyMap = this.buildQueryMapWithSign(data);
        if (PoshubMockUtil.isMonck()) {
            BizContentVO mockData = (BizContentVO)this.mock(request.responseClass());
            mockData.setRet_code("0000");
            mockData.setRet_msg("success");
            return (T)mockData;
        }
        BizContentVO t = null;
        try {
            t = (BizContentVO)this.doPost(qureyMap, parser, data);
        }
        catch (Exception e) {
            String method = this.url.substring(this.url.lastIndexOf("/") + 1);
            if ("tradecancel".equals(method)) {
                PaymentReverseResponse resp2 = new PaymentReverseResponse();
                resp2.setRet_code("99");
                resp2.setRet_msg("jar\u5305\u51fa\u73b0\u5f02\u5e38");
                PaymentReverseRequest req2 = (PaymentReverseRequest)request;
                new OperateErrorlog().addErrorlog(resp2, req2);
            } else {
                if ("traderefund".equals(method)) {
                    PaymentRefundResponse resp3 = (PaymentRefundResponse)(t = PollingRequest.polllingRefund(data, t, this));
                    if ("2002".equals(resp3.getStatus())) {
                        PaymentRefundRequest req3 = (PaymentRefundRequest)request;
                        new OperateErrorlog().addErrorlog(resp3, req3);
                    }
                    logger.info("poshubUtils response: " + t.toString());
                    return (T)t;
                }
                if ("barcode".equals(method)) {
                    BarcodeResponse resp4 = (BarcodeResponse)(t = PollingRequest.polllingEpay(data, t, this));
                    if ("1002".equals(resp4.getStatus())) {
                        BarCodeRequest req4 = (BarCodeRequest)request;
                        new OperateErrorlog().addErrorlog(resp4, req4);
                    }
                    logger.info("poshubUtils response: " + t.toString());
                    return (T)t;
                }
            }
            logger.info("jar\u5305\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), e);
            return null;
        }
        if (t instanceof BarcodeResponse && "barcode".equals(this.url.substring(this.url.lastIndexOf("/") + 1)) && "1002".equals(((BarcodeResponse)(resp = (BarcodeResponse)(t = PollingRequest.polllingEpay(data, t, this)))).getStatus())) {
            req = (BarCodeRequest)request;
            new OperateErrorlog().addErrorlog(resp, req);
        }
        if (t instanceof PaymentRefundResponse && "traderefund".equals(this.url.substring(this.url.lastIndexOf("/") + 1)) && "2002".equals(((PaymentRefundResponse)(resp = (PaymentRefundResponse)(t = PollingRequest.polllingRefund(data, t, this)))).getStatus())) {
            req = (PaymentRefundRequest)request;
            new OperateErrorlog().addErrorlog(resp, req);
        }
        if (t instanceof PaymentReverseResponse && !"3000".equals(((PaymentReverseResponse)(resp = (PaymentReverseResponse)t)).getStatus())) {
            req = (PaymentReverseRequest)request;
            new OperateErrorlog().addErrorlog(resp, req);
        }
        logger.info("poshubUtils response: " + t.toString());
        return (T)t;
    }

    private Object mock(Class<?> t) {
        if (t.equals(GoodsDetailResponse.class)) {
            return MockData.mockGoodsDetailResponse();
        }
        if (t.equals(BarcodeResponse.class)) {
            String bizType = null;
            int tmp = new Random().nextInt(6);
            bizType = tmp == 1 ? "00" : (tmp == 2 ? "02" : (tmp == 3 ? "03" : (tmp == 4 ? "04" : "05")));
            return MockData.mockBarcodeResponse(bizType);
        }
        if (t.equals(PaymentRefundResponse.class)) {
            return MockData.mockPaymentRefundResponse();
        }
        if (t.equals(PaymentReverseResponse.class)) {
            return MockData.mockPaymentReverseResponse();
        }
        if (t.equals(PaymentConfirmResponse.class)) {
            return MockData.mockPaymentConfirmResponse();
        }
        if (t.equals(UnFreezeResponse.class)) {
            return MockData.mockUnfreezeResponse();
        }
        if (t.equals(QueryCardInfoResponse.class)) {
            return MockData.mockQueryCardInfoResponse();
        }
        return null;
    }

    public <T extends BizContentVO> T doPost(Map<String, String> queryMap, PoshubParser<T> parser, String body) throws Exception {
        String res = PoshubHttpUtils.doPost(this.url, queryMap, body, "UTF-8", this.connectTimeout, this.readTimeout);
        if ("404".equals(res)) {
            Class<T> respcls = parser.getResponseClass();
            BizContentVO ret = (BizContentVO)respcls.newInstance();
            ret.setRet_code("404");
            ret.setRet_msg("\u65e0\u6cd5\u8fde\u63a5");
            return (T)ret;
        }
        return parser.parse(res);
    }

    public Map<String, String> buildQueryMapWithSign(String data) {
        Map<String, String> qureyMap = this.buildQueryMap();
        String sign = this.sign(qureyMap, data);
        qureyMap.put("sign", sign);
        return qureyMap;
    }

    private Map<String, String> buildQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("appid", this.appid);
        queryMap.put("charset", this.charset);
        queryMap.put("format", this.format);
        queryMap.put("method", this.method);
        queryMap.put("sign_type", this.sign_type);
        try {
            queryMap.put("timestamp", URLEncoder.encode(PoshubTimeUtils.formatter("yyyy-MM-dd HH:mm:ss.SSS"), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        queryMap.put("ver", this.ver);
        return queryMap;
    }

    private String sign(Map<String, String> queryMap, String data) {
        Object[] keys = queryMap.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder targetSign = new StringBuilder();
        for (Object key : keys) {
            if (((String)key).equals("sign") || ((String)key).equals("sign_type")) continue;
            targetSign.append((String)key);
            targetSign.append(queryMap.get(key));
        }
        targetSign.append(data);
        targetSign.append(this.secret);
        return PoshubMD5Util.MD5(targetSign.toString());
    }

    static {
        System.setProperty("sun.net.http.retryPost", "false");
        logger = Logger.getLogger(DefaultPoshubClient.class);
    }
}

