/*
 * Decompiled with CFR 0.152.
 */
package com.miya.api;

import com.alibaba.fastjson.JSONObject;
import com.miya.api.dao.ErrorlogDAO;
import com.miya.api.dao.model.ErrorlogVO;
import com.miya.api.inernal.DButils;
import com.miya.api.request.BarCodeRequest;
import com.miya.api.request.PaymentRefundRequest;
import com.miya.api.request.PaymentReverseRequest;
import com.miya.api.response.BarcodeResponse;
import com.miya.api.response.BizContentVO;
import com.miya.api.response.PaymentRefundResponse;
import com.miya.api.response.PaymentReverseResponse;

public class OperateErrorlog {
    public <T extends BizContentVO> void addErrorlog(T response, Object request) {
        if (!DButils.isTableExist(ErrorlogDAO.url, "errorlog")) {
            DButils.createTableErrorlog(ErrorlogDAO.url);
        }
        if (response instanceof PaymentReverseResponse) {
            PaymentReverseResponse resp = (PaymentReverseResponse)response;
            PaymentReverseRequest req = (PaymentReverseRequest)request;
            ErrorlogVO vo = new ErrorlogVO();
            vo.setTrade_no(req.getTrade_no());
            vo.setStore_id(req.getStore_id());
            vo.setPos_id(req.getPos_id());
            vo.setUser_id(req.getUser_id());
            vo.setMethod_name("tradecancel");
            vo.setReq(JSONObject.toJSONString(req));
            vo.setRes(JSONObject.toJSONString(resp));
            vo.setUploadFlag("0");
            new ErrorlogDAO().inserErrorlog(vo);
        } else if (response instanceof PaymentRefundResponse) {
            PaymentRefundResponse resp = (PaymentRefundResponse)response;
            PaymentRefundRequest req = (PaymentRefundRequest)request;
            ErrorlogVO vo = new ErrorlogVO();
            vo.setTrade_no(req.getTrade_no());
            vo.setStore_id(req.getStore_id());
            vo.setPos_id(req.getPos_id());
            vo.setUser_id(req.getUser_id());
            vo.setMethod_name("traderefund");
            vo.setReq(JSONObject.toJSONString(req));
            vo.setRes(JSONObject.toJSONString(resp));
            vo.setUploadFlag("0");
            new ErrorlogDAO().inserErrorlog(vo);
        } else if (response instanceof BarcodeResponse) {
            BarcodeResponse resp = (BarcodeResponse)response;
            BarCodeRequest req = (BarCodeRequest)request;
            ErrorlogVO vo = new ErrorlogVO();
            vo.setTrade_no(req.getTrade_no());
            vo.setStore_id(req.getStore_id());
            vo.setPos_id(req.getPos_id());
            vo.setUser_id(req.getUser_id());
            vo.setMethod_name("barcode");
            vo.setReq(JSONObject.toJSONString(req));
            vo.setRes(JSONObject.toJSONString(resp));
            vo.setUploadFlag("0");
            new ErrorlogDAO().inserErrorlog(vo);
        }
    }
}

