/*
 * Decompiled with CFR 0.152.
 */
package com.miya.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.miya.api.DefaultPoshubClient;
import com.miya.api.DefaultPoshubParser;
import com.miya.api.PosHubApiException;
import com.miya.api.inernal.PropUtils;
import com.miya.api.request.PaymentQueryRequest;
import com.miya.api.request.PaymentRefundQueryRequest;
import com.miya.api.response.BarcodeResponse;
import com.miya.api.response.BizContentVO;
import com.miya.api.response.PaymentRefundResponse;
import java.util.Map;

public class PollingRequest {
    private static String pollingCnt;
    private static String pollingInterval;

    public static <T extends BizContentVO> T polllingEpay(String reqstr, T t, DefaultPoshubClient client) throws PosHubApiException {
        BarcodeResponse barcodeResponse;
        boolean flag = false;
        flag = t != null ? "00".equals((barcodeResponse = (BarcodeResponse)t).getBiz_type()) && "1002".equals(barcodeResponse.getStatus()) : true;
        if (flag) {
            int cnt = 0;
            int interval = 0;
            cnt = null == pollingCnt ? Integer.parseInt(PropUtils.getValueByName("polling.cnt")) : Integer.parseInt(pollingCnt);
            interval = null == pollingInterval ? Integer.parseInt(PropUtils.getValueByName("polling.interval")) : Integer.parseInt(pollingInterval);
            if (cnt <= 0 || interval <= 0) {
                return t;
            }
            DefaultPoshubParser<BarcodeResponse> parser = new DefaultPoshubParser<BarcodeResponse>(BarcodeResponse.class);
            JSONObject jsonObj = JSONObject.parseObject(reqstr);
            PaymentQueryRequest request = JSONObject.toJavaObject(jsonObj, PaymentQueryRequest.class);
            String data = JSON.toJSONString(request);
            Map<String, String> qureyMap = client.buildQueryMapWithSign(data);
            client.setUrl(client.getUrl().replace("barcode", "tradequery"));
            client.setMethod("query");
            for (int i = cnt; i > 0; --i) {
                BarcodeResponse resp = null;
                try {
                    resp = client.doPost(qureyMap, parser, data);
                }
                catch (Exception e1) {
                    throw new PosHubApiException("\u8d85\u65f6\u5f02\u5e38!");
                }
                if (resp != null && !"1002".equals(resp.getStatus())) {
                    return (T)resp;
                }
                try {
                    Thread.sleep(interval * 1000);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    public static <T extends BizContentVO> T polllingRefund(String reqstr, T t, DefaultPoshubClient client) throws PosHubApiException {
        PaymentRefundResponse refundResponse;
        boolean flag = false;
        flag = t != null ? "00".equals((refundResponse = (PaymentRefundResponse)t).getBiz_type()) && "2002".equals(refundResponse.getStatus()) : true;
        if (flag) {
            int cnt = 0;
            int interval = 0;
            cnt = null == pollingCnt ? Integer.parseInt(PropUtils.getValueByName("polling.cnt")) : Integer.parseInt(pollingCnt);
            interval = null == pollingInterval ? Integer.parseInt(PropUtils.getValueByName("polling.interval")) : Integer.parseInt(pollingInterval);
            if (cnt <= 0 || interval <= 0) {
                return t;
            }
            DefaultPoshubParser<PaymentRefundResponse> parser = new DefaultPoshubParser<PaymentRefundResponse>(PaymentRefundResponse.class);
            JSONObject jsonObj = JSONObject.parseObject(reqstr);
            PaymentRefundQueryRequest request = JSONObject.toJavaObject(jsonObj, PaymentRefundQueryRequest.class);
            String data = JSON.toJSONString(request);
            Map<String, String> qureyMap = client.buildQueryMapWithSign(data);
            client.setUrl(client.getUrl().replace("traderefund", "traderefundQuery"));
            client.setMethod("refundquery");
            for (int i = cnt; i > 0; --i) {
                PaymentRefundResponse resp = null;
                try {
                    resp = client.doPost(qureyMap, parser, data);
                }
                catch (Exception e1) {
                    throw new PosHubApiException("\u8d85\u65f6\u5f02\u5e38!");
                }
                if (resp != null && !"2002".equals(resp.getStatus())) {
                    return (T)resp;
                }
                try {
                    Thread.sleep(interval * 1000);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }
}

