/*
 * Decompiled with CFR 0.152.
 */
package com.miya.api.inernal;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class CustomLogAppender
extends FileAppender {
    private static final String datePattern = "'.'yyyy-MM-dd";
    private int maxBackupIndex = 30;
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;

    public CustomLogAppender() {
    }

    public CustomLogAppender(Layout layout, String filename, int maxBackupIndex) throws IOException {
        super(layout, filename, true);
        this.maxBackupIndex = maxBackupIndex;
        this.activateOptions();
    }

    @Override
    public void activateOptions() {
        super.activateOptions();
        if (this.fileName != null) {
            this.sdf = new SimpleDateFormat(datePattern);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
        } else {
            LogLog.error("File is not set for appender [" + this.name + "].");
        }
        if (this.maxBackupIndex <= 0) {
            LogLog.error("maxBackupIndex reset to default value[2],orignal value is:" + this.maxBackupIndex);
            this.maxBackupIndex = 30;
        }
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            try {
                target.delete();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug(this.fileName + " -> " + this.scheduledFilename);
        } else {
            LogLog.error("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "].");
        }
        if (this.maxBackupIndex > 0) {
            File folder = new File(file.getParent());
            List<String> maxBackupIndexDates = this.getMaxBackupIndexDates();
            for (File ff : folder.listFiles()) {
                if (!ff.getName().startsWith(file.getName()) || ff.getName().equals(file.getName())) continue;
                String markedDate = ff.getName().substring(file.getName().length());
                if (!maxBackupIndexDates.contains(markedDate)) {
                    result = ff.delete();
                }
                if (result) {
                    LogLog.debug(ff.getName() + " -> deleted ");
                    continue;
                }
                LogLog.error("Failed to deleted old DayRollingFileAppender file :" + ff.getName());
            }
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = datedFilename;
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.getNextDayCheckPoint(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                LogLog.error("rollOver() failed.", ioe);
            }
        }
        super.subAppend(event);
    }

    long getNextDayCheckPoint(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    List<String> getMaxBackupIndexDates() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.maxBackupIndex > 0) {
            for (int i = 1; i <= this.maxBackupIndex; ++i) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.now);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(5, -i);
                result.add(this.sdf.format(calendar.getTime()));
            }
        }
        return result;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
    }

    public String getDatePattern() {
        return datePattern;
    }
}

