/*
 * Decompiled with CFR 0.152.
 */
package com.miya.api.inernal;

import com.miya.api.inernal.PropUtils;
import com.miya.api.inernal.SignUtils;
import com.miya.api.request.QRCodeRequest;
import com.miya.api.response.QRCodeRequestResponse;
import org.apache.log4j.Logger;

public class GenerateQRCode {
    private static String QRCodeUrl;
    private static String H5RequestUrl;
    private static Logger logger;

    public static QRCodeRequestResponse generate(QRCodeRequest request, String secret, String appid) {
        QRCodeRequestResponse resp = new QRCodeRequestResponse();
        QRCodeRequestResponse checkParamResp = GenerateQRCode.checkParam(request, resp);
        if (checkParamResp.getRet_code() != null) {
            return checkParamResp;
        }
        StringBuilder sb = new StringBuilder();
        if (null == H5RequestUrl) {
            H5RequestUrl = PropUtils.getValueByName("H5RequestUrl");
        }
        sb.append(H5RequestUrl);
        sb.append("?t=");
        sb.append(request.getPay_amt()).append(",");
        sb.append(request.getOrder_no()).append(",");
        sb.append(request.getTimestamp()).append(",");
        sb.append(appid).append(",");
        sb.append(GenerateQRCode.getSignStr(request, secret, appid));
        logger.info("\u8981\u751f\u6210\u7684\u4e8c\u7ef4\u7801\u7684\u4fe1\u606f:" + sb.toString());
        if (null == QRCodeUrl) {
            QRCodeUrl = PropUtils.getValueByName("QRCodeUrl");
        }
        try {
            resp.setRet_code("00");
            resp.setRet_msg("success");
            resp.setQRCodeFullPath(sb.toString());
        }
        catch (Exception e) {
            resp.setRet_code("99");
            resp.setRet_msg("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + e.getMessage());
            logger.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25:", e);
        }
        return resp;
    }

    private static QRCodeRequestResponse checkParam(QRCodeRequest request, QRCodeRequestResponse resp) {
        if (request.getPay_amt() == null) {
            resp.setRet_code("1001");
            resp.setRet_msg("\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getOrder_no() == null) {
            resp.setRet_code("1003");
            resp.setRet_msg("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getTimestamp() == null) {
            resp.setRet_code("1004");
            resp.setRet_msg("\u65f6\u95f4\u6233\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return resp;
    }

    private static String getSignStr(QRCodeRequest request, String secret, String appid) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getPay_amt()).append(",");
        sb.append(request.getOrder_no()).append(",");
        sb.append(request.getTimestamp()).append(",");
        sb.append(appid).append(",");
        sb.append(secret);
        try {
            return SignUtils.md5(sb.toString()).toUpperCase();
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        logger = Logger.getLogger(GenerateQRCode.class);
    }
}

