/*
 * Decompiled with CFR 0.152.
 */
package com.miya.api.inernal;

import com.miya.api.inernal.PoshubStringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class PoshubHttpUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static SSLContext ctx = null;
    private static HostnameVerifier verifier = null;
    private static SSLSocketFactory socketFactory = null;
    private static Logger logger = Logger.getLogger(PoshubHttpUtils.class);

    private PoshubHttpUtils() {
    }

    public static String doPost(String url, Map<String, String> params, String body, String charset, int connectTimeout, int readTimeout) throws Exception {
        String ctype = "application/json";
        String query = PoshubHttpUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = body.getBytes(charset);
        }
        return PoshubHttpUtils.doPost(url + query, ctype, content, connectTimeout, readTimeout);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!PoshubStringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (isFirst) {
                query.append("?");
                isFirst = false;
            } else {
                query.append("&");
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        Map<String, String> map = PoshubHttpUtils.getParamsFromUrl(url);
        try {
            try {
                conn = null;
                conn = PoshubHttpUtils.getConnection(new URL(url), METHOD_POST, ctype);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                logger.info("\u8bf7\u6c42\u62a5\u6587\uff1aurl=" + url + ",method=" + map.get("method") + ",content=" + new String(content));
            }
            catch (Exception e) {
                logger.error("url=" + url + ",method=" + map.get("method") + ",content=" + new String(content), e);
                throw e;
            }
            try {
                out = conn.getOutputStream();
                out.write(content);
                rsp = PoshubHttpUtils.getResponseAsString(conn);
                logger.info("\u5e94\u7b54\u62a5\u6587:" + rsp);
            }
            catch (Exception e) {
                block16: {
                    String string;
                    block17: {
                        String msg = e.getMessage();
                        logger.error("\u7f51\u7edc\u5f02\u5e38", e);
                        if (e instanceof ConnectException) {
                            String string2 = "404";
                            if (out != null) {
                                out.close();
                            }
                            if (conn != null) {
                                conn.disconnect();
                            }
                            return string2;
                        }
                        if (!msg.contains("connect")) break block16;
                        string = "404";
                        if (out == null) break block17;
                        out.close();
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    return string;
                }
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = null;
            connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(socketFactory);
            connHttps.setHostnameVerifier(verifier);
            conn = connHttps;
        } else {
            conn = null;
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("User-Agent", "aop-sdk-java");
        conn.addRequestProperty("Content-Type", ctype);
        conn.addRequestProperty("charset", "utf-8");
        return conn;
    }

    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = PoshubHttpUtils.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = PoshubHttpUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return PoshubHttpUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = PoshubHttpUtils.getStreamAsString(es, charset);
        if (PoshubStringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!PoshubStringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || PoshubStringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    static {
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            ctx.getClientSessionContext().setSessionTimeout(15);
            ctx.getClientSessionContext().setSessionCacheSize(1000);
            socketFactory = ctx.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return false;
            }
        };
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

