/*
 * Decompiled with CFR 0.152.
 */
package com.miya.api.inernal;

import com.miya.api.PoshubResponse;
import com.miya.api.inernal.PoshubTimeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;

public class PoshubMockUtil {
    private static Boolean isMonck;
    private ThreadLocal<Field[]> fields;
    private ThreadLocal<Method[]> declaredMethods;
    private Random random = null;
    private static List<String> dateStrList;
    private static List<String> booleanStrList;

    public static synchronized boolean isMonck() {
        if (null != isMonck) {
            return isMonck;
        }
        try {
            Properties prop = new Properties();
            InputStream resource = PoshubMockUtil.class.getResourceAsStream("/resources/config.properties");
            prop.load(resource);
            isMonck = "1".equals(prop.getProperty("isMockData")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            return isMonck;
        }
        catch (IOException e) {
            isMonck = false;
            return isMonck;
        }
    }

    public <T> T mock(T t) {
        T obj = null;
        try {
            obj = (T)t.getClass().newInstance();
            this.declaredMethods = new ThreadLocal();
            this.declaredMethods.set(t.getClass().getDeclaredMethods());
            for (Method method : this.declaredMethods.get()) {
                String methodName = method.getName();
                if (!methodName.startsWith("set")) continue;
                String field = PoshubMockUtil.toLowerCaseFirstOne(method.getName().substring(3));
                Class fieldClass = this.getFieldClass(t.getClass(), field);
                if (dateStrList.contains(field)) {
                    method.invoke(obj, this.instanceWithSpecialStr(fieldClass, 1));
                    continue;
                }
                if (booleanStrList.contains(field)) {
                    method.invoke(obj, this.instanceWithSpecialStr(fieldClass, 2));
                    continue;
                }
                method.invoke(obj, this.instanceWithClass(fieldClass));
            }
            return obj;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object instanceWithSpecialStr(Class cls, int type) {
        if (type == 1) {
            return PoshubTimeUtils.yyyyMMddHHmmss();
        }
        if (type == 2) {
            return this.ran().nextInt(10) % 2 == 0 ? "N" : "Y";
        }
        return "";
    }

    public Object instanceWithClass(Class cls) {
        if (cls.equals(String.class)) {
            return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 5);
        }
        if (cls.equals(Integer.TYPE)) {
            return this.ran().nextInt(100);
        }
        if (cls.equals(Integer.class)) {
            return this.ran().nextInt(100);
        }
        if (cls.equals(Long.class)) {
            return new Long(this.ran().nextLong());
        }
        if (cls.equals(Boolean.class)) {
            return this.ran().nextBoolean();
        }
        if (cls.equals(Boolean.TYPE)) {
            return this.ran().nextBoolean();
        }
        if (cls.equals(Date.class)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(calendar.getTimeInMillis() - Math.abs(this.ran().nextLong() % calendar.getTimeInMillis()));
            return calendar.getTime();
        }
        if (cls.equals(Long.TYPE)) {
            return this.ran().nextLong();
        }
        if (cls.equals(BigDecimal.class)) {
            return new BigDecimal(this.ran().nextInt(100));
        }
        if (cls.equals(PoshubResponse.class)) {
            return this.instanceWithClass(PoshubResponse.class);
        }
        return null;
    }

    private Random ran() {
        if (null == this.random) {
            this.random = new Random();
            return this.random;
        }
        return this.random;
    }

    private Class getFieldClass(Class clazz, String field) {
        this.fields = new ThreadLocal();
        this.fields.set(clazz.getDeclaredFields());
        for (Field f : this.fields.get()) {
            if (!f.getName().equals(field)) continue;
            return f.getType();
        }
        throw new NoClassDefFoundForFieldException(MessageFormat.format("Class fo field {0} not found or is unsupported.", field));
    }

    private static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    static {
        dateStrList = Arrays.asList("gmt_payment");
        booleanStrList = Arrays.asList("is_subscribe");
    }

    public class NoClassDefFoundForFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoClassDefFoundForFieldException(String msg) {
            super(msg);
        }
    }
}

