/*
 * Decompiled with CFR 0.152.
 */
package com.miya.api.inernal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class PoshubTimeUtils {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY_MM_DD_24HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_12HH_MM_SS = "yyyy-MM-dd hh:mm:ss";
    public static final String YYYY_MM_DD_24HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";

    public static String yyyyMMdd() {
        return new SimpleDateFormat(YYYY_MM_DD).format(new Date());
    }

    public static String yyyyMMdd(Date date) {
        return new SimpleDateFormat(YYYY_MM_DD).format(date);
    }

    public static String dateToyyyyMMddHHmmss(Date date) {
        return new SimpleDateFormat(YYYYMMDDHHMMSS).format(date);
    }

    public static String get_now_yyyyMMddHHmmss() {
        return new SimpleDateFormat(YYYYMMDDHHMMSS).format(new Date());
    }

    public static String yyyyMMddHHmmss() {
        return new SimpleDateFormat(YYYY_MM_DD_24HH_MM_SS).format(new Date());
    }

    public static String formatter(String formatter) {
        return new SimpleDateFormat(formatter).format(new Date());
    }

    public static String formatter(String formatter, Date date) {
        return new SimpleDateFormat(formatter).format(date);
    }

    public static Date zeroDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date fullDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getParseDate(int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -(days - 1));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date parseDate(String dateStr, String formatStr) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(String dateStr) {
        return PoshubTimeUtils.parseDate(dateStr, YYYY_MM_DD_24HH_MM_SS);
    }

    public static Date getTomorrowWeeHours() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addDay(int ndays) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, ndays);
        return cal.getTime();
    }
}

