/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.Header;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public final class LicenseCheckMojo
extends AbstractLicenseMojo {
    public final Collection<File> missingHeaders = new ConcurrentLinkedQueue<File>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.getLog().info((CharSequence)"Checking licenses...");
        }
        this.missingHeaders.clear();
        AbstractLicenseMojo.AbstractCallback callback = new AbstractLicenseMojo.AbstractCallback(this){

            @Override
            public void onHeaderNotFound(Document document, Header header) {
                if (LicenseCheckMojo.this.skipExistingHeaders) {
                    document.parseHeader();
                    if (document.headerDetected()) {
                        LicenseCheckMojo.this.debug("Existing header in: %s", document.getFilePath());
                        return;
                    }
                }
                LicenseCheckMojo.this.warn("Missing header in: %s", document.getFilePath());
                LicenseCheckMojo.this.missingHeaders.add(document.getFile());
            }

            @Override
            public void onExistingHeader(Document document, Header header) {
                LicenseCheckMojo.this.debug("Header OK in: %s", document.getFilePath());
            }
        };
        this.execute(callback);
        if (!this.missingHeaders.isEmpty()) {
            if (this.failIfMissing) {
                throw new MojoExecutionException("Some files do not have the expected license header");
            }
            this.getLog().warn((CharSequence)"Some files do not have the expected license header");
        }
        if (!this.skip) {
            callback.checkUnknown();
        }
    }
}

