/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.Report;
import com.mycila.maven.plugin.license.dependencies.AggregateLicensePolicyEnforcer;
import com.mycila.maven.plugin.license.dependencies.LicensePolicy;
import com.mycila.maven.plugin.license.dependencies.LicensePolicyEnforcerResult;
import com.mycila.maven.plugin.license.dependencies.MavenProjectLicenses;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.Header;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public final class LicenseCheckMojo
extends AbstractLicenseMojo {
    @Parameter(property="license.errorMessage", defaultValue="Some files do not have the expected license header")
    public String errorMessage = "Some files do not have the expected license header";
    public final Collection<File> missingHeaders = new ConcurrentLinkedQueue<File>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProjectLicenses licenseMap;
        AggregateLicensePolicyEnforcer enforcer;
        Map<Artifact, LicensePolicyEnforcerResult> licenseResult;
        Set deniedLicenseResult;
        this.report = new Report(this.reportFormat, Report.Action.CHECK, this.project, this.clock, this.reportSkipped);
        if (!this.skip) {
            this.getLog().info((CharSequence)"Checking licenses...");
        }
        this.missingHeaders.clear();
        AbstractLicenseMojo.AbstractCallback callback = new AbstractLicenseMojo.AbstractCallback(){

            @Override
            public void onHeaderNotFound(Document document, Header header) {
                if (LicenseCheckMojo.this.skipExistingHeaders) {
                    document.parseHeader();
                    if (document.headerDetected()) {
                        LicenseCheckMojo.this.debug("Existing header in: %s", document.getFilePath());
                        LicenseCheckMojo.this.report.add(document.getFile(), Report.Result.PRESENT);
                        return;
                    }
                }
                LicenseCheckMojo.this.warn("Missing header in: %s", document.getFilePath());
                LicenseCheckMojo.this.missingHeaders.add(document.getFile());
                LicenseCheckMojo.this.report.add(document.getFile(), Report.Result.MISSING);
            }

            @Override
            public void onExistingHeader(Document document, Header header) {
                LicenseCheckMojo.this.debug("Header OK in: %s", document.getFilePath());
                LicenseCheckMojo.this.report.add(document.getFile(), Report.Result.PRESENT);
            }
        };
        if (this.dependencyEnforce && (deniedLicenseResult = (licenseResult = (enforcer = new AggregateLicensePolicyEnforcer(this.dependencyPolicies)).apply(licenseMap = new MavenProjectLicenses(this.session, this.project, this.dependencyGraphBuilder, this.projectBuilder, this.dependencyScopes, this.getLog()))).values().stream().filter(result -> result.getRuling().equals((Object)LicensePolicy.Rule.DENY)).collect(Collectors.toSet())).size() != 0) {
            StringBuilder licenseExceptionMsg = new StringBuilder(this.dependencyExceptionMessage);
            deniedLicenseResult.stream().forEach(result -> {
                licenseExceptionMsg.append(System.lineSeparator());
                licenseExceptionMsg.append(result);
            });
            throw new MojoExecutionException(licenseExceptionMsg.toString());
        }
        this.execute(callback);
        if (!this.missingHeaders.isEmpty()) {
            if (this.failIfMissing) {
                throw new MojoExecutionException(this.errorMessage);
            }
            this.getLog().warn((CharSequence)this.errorMessage);
        }
        callback.checkUnknown();
    }
}

