/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.dependencies;

import java.util.Optional;
import org.apache.maven.plugins.annotations.Parameter;

public class LicensePolicy {
    @Parameter
    private Type type;
    @Parameter
    private Rule rule;
    @Parameter
    private String value;

    public LicensePolicy() {
    }

    public LicensePolicy(Rule rule, Type type, String value) {
        this.setRule(rule);
        this.setType(type);
        this.setValue(value);
    }

    public int hashCode() {
        return 11 * (this.rule.hashCode() + this.type.hashCode() + this.value.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other.hashCode() == this.hashCode();
    }

    public String getValue() {
        return this.value;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        this.type = type;
    }

    private void setRule(Rule rule) {
        this.rule = Optional.ofNullable(rule).orElse(Rule.DENY);
    }

    private void setValue(String value) {
        this.value = Optional.ofNullable(value).orElse("");
    }

    public String toString() {
        return String.format("%s:%s:%s", new Object[]{this.getType(), this.getRule(), this.getValue()});
    }

    public static enum Rule {
        APPROVE(true),
        DENY(false);

        boolean allowed;

        private Rule(boolean allowed) {
            this.allowed = allowed;
        }

        public boolean getPredicate() {
            return this.allowed;
        }

        public boolean isAllowed(boolean matched) {
            if (matched && this.allowed) {
                return true;
            }
            return !matched && !this.allowed;
        }

        public static Rule valueOf(boolean allowed) {
            if (allowed) {
                return APPROVE;
            }
            return DENY;
        }
    }

    public static enum Type {
        LICENSE_NAME,
        LICENSE_URL,
        ARTIFACT_PATTERN;

    }
}

