/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import com.google.common.base.Strings;
import com.netflix.client.VipAddressResolver;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientConfigImpl
implements IClientConfig {
    public static final Boolean DEFAULT_PRIORITIZE_VIP_ADDRESS_BASED_SERVERS = Boolean.TRUE;
    public static final String DEFAULT_NFLOADBALANCER_PING_CLASSNAME = "com.netflix.loadbalancer.DummyPing";
    public static final String DEFAULT_NFLOADBALANCER_RULE_CLASSNAME = "com.netflix.loadbalancer.AvailabilityFilteringRule";
    public static final String DEFAULT_NFLOADBALANCER_CLASSNAME = "com.netflix.loadbalancer.ZoneAwareLoadBalancer";
    public static final boolean DEFAULT_USEIPADDRESS_FOR_SERVER = Boolean.FALSE;
    public static final String DEFAULT_CLIENT_CLASSNAME = "com.netflix.niws.client.http.RestClient";
    public static final String DEFAULT_VIPADDRESS_RESOLVER_CLASSNAME = "com.netflix.client.SimpleVipAddressResolver";
    public static final String DEFAULT_PRIME_CONNECTIONS_URI = "/";
    public static final int DEFAULT_MAX_TOTAL_TIME_TO_PRIME_CONNECTIONS = 30000;
    public static final int DEFAULT_MAX_RETRIES_PER_SERVER_PRIME_CONNECTION = 9;
    public static final Boolean DEFAULT_ENABLE_PRIME_CONNECTIONS = Boolean.FALSE;
    public static final int DEFAULT_MAX_REQUESTS_ALLOWED_PER_WINDOW = Integer.MAX_VALUE;
    public static final int DEFAULT_REQUEST_THROTTLING_WINDOW_IN_MILLIS = 60000;
    public static final Boolean DEFAULT_ENABLE_REQUEST_THROTTLING = Boolean.FALSE;
    public static final Boolean DEFAULT_ENABLE_GZIP_CONTENT_ENCODING_FILTER = Boolean.FALSE;
    public static final Boolean DEFAULT_CONNECTION_POOL_CLEANER_TASK_ENABLED = Boolean.TRUE;
    public static final Boolean DEFAULT_FOLLOW_REDIRECTS = Boolean.FALSE;
    public static final float DEFAULT_PERCENTAGE_NIWS_EVENT_LOGGED = 0.0f;
    public static final int DEFAULT_MAX_AUTO_RETRIES_NEXT_SERVER = 1;
    public static final int DEFAULT_MAX_AUTO_RETRIES = 0;
    public static final int DEFAULT_BACKOFF_INTERVAL = 0;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    public static final int DEFAULT_CONNECTION_MANAGER_TIMEOUT = 2000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    public static final Boolean DEFAULT_ENABLE_CONNECTION_POOL = Boolean.TRUE;
    @Deprecated
    public static final int DEFAULT_MAX_HTTP_CONNECTIONS_PER_HOST = 50;
    @Deprecated
    public static final int DEFAULT_MAX_TOTAL_HTTP_CONNECTIONS = 200;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_HOST = 50;
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 200;
    public static final float DEFAULT_MIN_PRIME_CONNECTIONS_RATIO = 1.0f;
    public static final String DEFAULT_PRIME_CONNECTIONS_CLASS = "com.netflix.niws.client.http.HttpPrimeConnection";
    public static final String DEFAULT_SEVER_LIST_CLASS = "com.netflix.loadbalancer.ConfigurationBasedServerList";
    public static final int DEFAULT_CONNECTION_IDLE_TIMERTASK_REPEAT_IN_MSECS = 30000;
    public static final int DEFAULT_CONNECTIONIDLE_TIME_IN_MSECS = 30000;
    protected volatile Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    protected Map<IClientConfigKey<?>, Object> typedProperties = new ConcurrentHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientConfigImpl.class);
    private String clientName = null;
    private VipAddressResolver resolver = null;
    private boolean enableDynamicProperties = true;
    public static final int DEFAULT_POOL_MAX_THREADS = 200;
    public static final int DEFAULT_POOL_MIN_THREADS = 1;
    public static final long DEFAULT_POOL_KEEP_ALIVE_TIME = 900L;
    public static final TimeUnit DEFAULT_POOL_KEEP_ALIVE_TIME_UNITS = TimeUnit.SECONDS;
    public static final Boolean DEFAULT_ENABLE_ZONE_AFFINITY = Boolean.FALSE;
    public static final Boolean DEFAULT_ENABLE_ZONE_EXCLUSIVITY = Boolean.FALSE;
    public static final int DEFAULT_PORT = 7001;
    public static final Boolean DEFAULT_ENABLE_LOADBALANCER = Boolean.TRUE;
    public static final String DEFAULT_PROPERTY_NAME_SPACE = "ribbon";
    private String propertyNameSpace = "ribbon";
    public static final Boolean DEFAULT_OK_TO_RETRY_ON_ALL_OPERATIONS = Boolean.FALSE;
    public static final Boolean DEFAULT_ENABLE_NIWS_EVENT_LOGGING = Boolean.TRUE;
    public static final Boolean DEFAULT_IS_CLIENT_AUTH_REQUIRED = Boolean.FALSE;
    private final Map<String, DynamicStringProperty> dynamicProperties = new ConcurrentHashMap<String, DynamicStringProperty>();

    public Boolean getDefaultPrioritizeVipAddressBasedServers() {
        return DEFAULT_PRIORITIZE_VIP_ADDRESS_BASED_SERVERS;
    }

    public String getDefaultNfloadbalancerPingClassname() {
        return DEFAULT_NFLOADBALANCER_PING_CLASSNAME;
    }

    public String getDefaultNfloadbalancerRuleClassname() {
        return DEFAULT_NFLOADBALANCER_RULE_CLASSNAME;
    }

    public String getDefaultNfloadbalancerClassname() {
        return DEFAULT_NFLOADBALANCER_CLASSNAME;
    }

    public boolean getDefaultUseIpAddressForServer() {
        return DEFAULT_USEIPADDRESS_FOR_SERVER;
    }

    public String getDefaultClientClassname() {
        return DEFAULT_CLIENT_CLASSNAME;
    }

    public String getDefaultVipaddressResolverClassname() {
        return DEFAULT_VIPADDRESS_RESOLVER_CLASSNAME;
    }

    public String getDefaultPrimeConnectionsUri() {
        return DEFAULT_PRIME_CONNECTIONS_URI;
    }

    public int getDefaultMaxTotalTimeToPrimeConnections() {
        return 30000;
    }

    public int getDefaultMaxRetriesPerServerPrimeConnection() {
        return 9;
    }

    public Boolean getDefaultEnablePrimeConnections() {
        return DEFAULT_ENABLE_PRIME_CONNECTIONS;
    }

    public int getDefaultMaxRequestsAllowedPerWindow() {
        return Integer.MAX_VALUE;
    }

    public int getDefaultRequestThrottlingWindowInMillis() {
        return 60000;
    }

    public Boolean getDefaultEnableRequestThrottling() {
        return DEFAULT_ENABLE_REQUEST_THROTTLING;
    }

    public Boolean getDefaultEnableGzipContentEncodingFilter() {
        return DEFAULT_ENABLE_GZIP_CONTENT_ENCODING_FILTER;
    }

    public Boolean getDefaultConnectionPoolCleanerTaskEnabled() {
        return DEFAULT_CONNECTION_POOL_CLEANER_TASK_ENABLED;
    }

    public Boolean getDefaultFollowRedirects() {
        return DEFAULT_FOLLOW_REDIRECTS;
    }

    public float getDefaultPercentageNiwsEventLogged() {
        return 0.0f;
    }

    public int getDefaultMaxAutoRetriesNextServer() {
        return 1;
    }

    public int getDefaultMaxAutoRetries() {
        return 0;
    }

    public int getDefaultReadTimeout() {
        return 5000;
    }

    public int getDefaultConnectionManagerTimeout() {
        return 2000;
    }

    public int getDefaultConnectTimeout() {
        return 2000;
    }

    @Deprecated
    public int getDefaultMaxHttpConnectionsPerHost() {
        return 50;
    }

    @Deprecated
    public int getDefaultMaxTotalHttpConnections() {
        return 200;
    }

    public int getDefaultMaxConnectionsPerHost() {
        return 50;
    }

    public int getDefaultMaxTotalConnections() {
        return 200;
    }

    public float getDefaultMinPrimeConnectionsRatio() {
        return 1.0f;
    }

    public String getDefaultPrimeConnectionsClass() {
        return DEFAULT_PRIME_CONNECTIONS_CLASS;
    }

    public String getDefaultSeverListClass() {
        return DEFAULT_SEVER_LIST_CLASS;
    }

    public int getDefaultConnectionIdleTimertaskRepeatInMsecs() {
        return 30000;
    }

    public int getDefaultConnectionidleTimeInMsecs() {
        return 30000;
    }

    public VipAddressResolver getResolver() {
        return this.resolver;
    }

    public boolean isEnableDynamicProperties() {
        return this.enableDynamicProperties;
    }

    public int getDefaultPoolMaxThreads() {
        return 200;
    }

    public int getDefaultPoolMinThreads() {
        return 1;
    }

    public long getDefaultPoolKeepAliveTime() {
        return 900L;
    }

    public TimeUnit getDefaultPoolKeepAliveTimeUnits() {
        return DEFAULT_POOL_KEEP_ALIVE_TIME_UNITS;
    }

    public Boolean getDefaultEnableZoneAffinity() {
        return DEFAULT_ENABLE_ZONE_AFFINITY;
    }

    public Boolean getDefaultEnableZoneExclusivity() {
        return DEFAULT_ENABLE_ZONE_EXCLUSIVITY;
    }

    public int getDefaultPort() {
        return 7001;
    }

    public Boolean getDefaultEnableLoadbalancer() {
        return DEFAULT_ENABLE_LOADBALANCER;
    }

    public Boolean getDefaultOkToRetryOnAllOperations() {
        return DEFAULT_OK_TO_RETRY_ON_ALL_OPERATIONS;
    }

    public Boolean getDefaultIsClientAuthRequired() {
        return DEFAULT_IS_CLIENT_AUTH_REQUIRED;
    }

    public DefaultClientConfigImpl() {
        this.dynamicProperties.clear();
        this.enableDynamicProperties = false;
    }

    public DefaultClientConfigImpl(String nameSpace) {
        this();
        this.propertyNameSpace = nameSpace;
    }

    @Override
    public void loadDefaultValues() {
        Integer proxyPort;
        this.putDefaultIntegerProperty(CommonClientConfigKey.MaxHttpConnectionsPerHost, this.getDefaultMaxHttpConnectionsPerHost());
        this.putDefaultIntegerProperty(CommonClientConfigKey.MaxTotalHttpConnections, this.getDefaultMaxTotalHttpConnections());
        this.putDefaultBooleanProperty(CommonClientConfigKey.EnableConnectionPool, this.getDefaultEnableConnectionPool());
        this.putDefaultIntegerProperty(CommonClientConfigKey.MaxConnectionsPerHost, this.getDefaultMaxConnectionsPerHost());
        this.putDefaultIntegerProperty(CommonClientConfigKey.MaxTotalConnections, this.getDefaultMaxTotalConnections());
        this.putDefaultIntegerProperty(CommonClientConfigKey.ConnectTimeout, this.getDefaultConnectTimeout());
        this.putDefaultIntegerProperty(CommonClientConfigKey.ConnectionManagerTimeout, this.getDefaultConnectionManagerTimeout());
        this.putDefaultIntegerProperty(CommonClientConfigKey.ReadTimeout, this.getDefaultReadTimeout());
        this.putDefaultIntegerProperty(CommonClientConfigKey.MaxAutoRetries, this.getDefaultMaxAutoRetries());
        this.putDefaultIntegerProperty(CommonClientConfigKey.MaxAutoRetriesNextServer, this.getDefaultMaxAutoRetriesNextServer());
        this.putDefaultBooleanProperty(CommonClientConfigKey.OkToRetryOnAllOperations, this.getDefaultOkToRetryOnAllOperations());
        this.putDefaultBooleanProperty(CommonClientConfigKey.FollowRedirects, this.getDefaultFollowRedirects());
        this.putDefaultBooleanProperty(CommonClientConfigKey.ConnectionPoolCleanerTaskEnabled, this.getDefaultConnectionPoolCleanerTaskEnabled());
        this.putDefaultIntegerProperty(CommonClientConfigKey.ConnIdleEvictTimeMilliSeconds, this.getDefaultConnectionidleTimeInMsecs());
        this.putDefaultIntegerProperty(CommonClientConfigKey.ConnectionCleanerRepeatInterval, this.getDefaultConnectionIdleTimertaskRepeatInMsecs());
        this.putDefaultBooleanProperty(CommonClientConfigKey.EnableGZIPContentEncodingFilter, this.getDefaultEnableGzipContentEncodingFilter());
        String proxyHost = ConfigurationManager.getConfigInstance().getString(this.getDefaultPropName(CommonClientConfigKey.ProxyHost.key()));
        if (proxyHost != null && proxyHost.length() > 0) {
            this.setProperty(CommonClientConfigKey.ProxyHost, proxyHost);
        }
        if ((proxyPort = ConfigurationManager.getConfigInstance().getInteger(this.getDefaultPropName(CommonClientConfigKey.ProxyPort), Integer.valueOf(-2147483647))) != -2147483647) {
            this.setProperty(CommonClientConfigKey.ProxyPort, proxyPort);
        }
        this.putDefaultIntegerProperty(CommonClientConfigKey.Port, this.getDefaultPort());
        this.putDefaultBooleanProperty(CommonClientConfigKey.EnablePrimeConnections, this.getDefaultEnablePrimeConnections());
        this.putDefaultIntegerProperty(CommonClientConfigKey.MaxRetriesPerServerPrimeConnection, this.getDefaultMaxRetriesPerServerPrimeConnection());
        this.putDefaultIntegerProperty(CommonClientConfigKey.MaxTotalTimeToPrimeConnections, this.getDefaultMaxTotalTimeToPrimeConnections());
        this.putDefaultStringProperty(CommonClientConfigKey.PrimeConnectionsURI, this.getDefaultPrimeConnectionsUri());
        this.putDefaultIntegerProperty(CommonClientConfigKey.PoolMinThreads, this.getDefaultPoolMinThreads());
        this.putDefaultIntegerProperty(CommonClientConfigKey.PoolMaxThreads, this.getDefaultPoolMaxThreads());
        this.putDefaultLongProperty(CommonClientConfigKey.PoolKeepAliveTime, this.getDefaultPoolKeepAliveTime());
        this.putDefaultTimeUnitProperty(CommonClientConfigKey.PoolKeepAliveTimeUnits, this.getDefaultPoolKeepAliveTimeUnits());
        this.putDefaultBooleanProperty(CommonClientConfigKey.EnableZoneAffinity, this.getDefaultEnableZoneAffinity());
        this.putDefaultBooleanProperty(CommonClientConfigKey.EnableZoneExclusivity, this.getDefaultEnableZoneExclusivity());
        this.putDefaultStringProperty(CommonClientConfigKey.ClientClassName, this.getDefaultClientClassname());
        this.putDefaultStringProperty(CommonClientConfigKey.NFLoadBalancerClassName, this.getDefaultNfloadbalancerClassname());
        this.putDefaultStringProperty(CommonClientConfigKey.NFLoadBalancerRuleClassName, this.getDefaultNfloadbalancerRuleClassname());
        this.putDefaultStringProperty(CommonClientConfigKey.NFLoadBalancerPingClassName, this.getDefaultNfloadbalancerPingClassname());
        this.putDefaultBooleanProperty(CommonClientConfigKey.PrioritizeVipAddressBasedServers, this.getDefaultPrioritizeVipAddressBasedServers());
        this.putDefaultFloatProperty(CommonClientConfigKey.MinPrimeConnectionsRatio, Float.valueOf(this.getDefaultMinPrimeConnectionsRatio()));
        this.putDefaultStringProperty(CommonClientConfigKey.PrimeConnectionsClassName, this.getDefaultPrimeConnectionsClass());
        this.putDefaultStringProperty(CommonClientConfigKey.NIWSServerListClassName, this.getDefaultSeverListClass());
        this.putDefaultStringProperty(CommonClientConfigKey.VipAddressResolverClassName, this.getDefaultVipaddressResolverClassname());
        this.putDefaultBooleanProperty(CommonClientConfigKey.IsClientAuthRequired, this.getDefaultIsClientAuthRequired());
        this.putDefaultBooleanProperty(CommonClientConfigKey.UseIPAddrForServer, this.getDefaultUseIpAddressForServer());
        this.putDefaultStringProperty(CommonClientConfigKey.ListOfServers, "");
    }

    public Boolean getDefaultEnableConnectionPool() {
        return DEFAULT_ENABLE_CONNECTION_POOL;
    }

    protected void setPropertyInternal(IClientConfigKey propName, Object value) {
        this.setPropertyInternal(propName.key(), value);
    }

    private String getConfigKey(String propName) {
        return this.clientName == null ? this.getDefaultPropName(propName) : this.getInstancePropName(this.clientName, propName);
    }

    protected void setPropertyInternal(final String propName, Object value) {
        String stringValue = value == null ? "" : String.valueOf(value);
        this.properties.put(propName, stringValue);
        if (!this.enableDynamicProperties) {
            return;
        }
        String configKey = this.getConfigKey(propName);
        final DynamicStringProperty prop = DynamicPropertyFactory.getInstance().getStringProperty(configKey, null);
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                String value = prop.get();
                if (value != null) {
                    DefaultClientConfigImpl.this.properties.put(propName, value);
                } else {
                    DefaultClientConfigImpl.this.properties.remove(propName);
                }
            }

            public boolean equals(Object other) {
                if (other == null) {
                    return false;
                }
                if (this.getClass() == other.getClass()) {
                    return this.toString().equals(other.toString());
                }
                return false;
            }

            public String toString() {
                return propName;
            }

            public int hashCode() {
                return propName.hashCode();
            }
        };
        prop.addCallback(callback);
        this.dynamicProperties.put(propName, prop);
    }

    protected void putDefaultIntegerProperty(IClientConfigKey propName, Integer defaultValue) {
        Integer value = ConfigurationManager.getConfigInstance().getInteger(this.getDefaultPropName(propName), defaultValue);
        this.setPropertyInternal(propName, (Object)value);
    }

    protected void putDefaultLongProperty(IClientConfigKey propName, Long defaultValue) {
        Long value = ConfigurationManager.getConfigInstance().getLong(this.getDefaultPropName(propName), defaultValue);
        this.setPropertyInternal(propName, (Object)value);
    }

    protected void putDefaultFloatProperty(IClientConfigKey propName, Float defaultValue) {
        Float value = ConfigurationManager.getConfigInstance().getFloat(this.getDefaultPropName(propName), defaultValue);
        this.setPropertyInternal(propName, (Object)value);
    }

    protected void putDefaultTimeUnitProperty(IClientConfigKey propName, TimeUnit defaultValue) {
        TimeUnit value = defaultValue;
        String propValue = ConfigurationManager.getConfigInstance().getString(this.getDefaultPropName(propName));
        if (propValue != null && propValue.length() > 0) {
            value = TimeUnit.valueOf(propValue);
        }
        this.setPropertyInternal(propName, (Object)value);
    }

    String getDefaultPropName(String propName) {
        return this.getNameSpace() + "." + propName;
    }

    public String getDefaultPropName(IClientConfigKey propName) {
        return this.getDefaultPropName(propName.key());
    }

    protected void putDefaultStringProperty(IClientConfigKey propName, String defaultValue) {
        String value = ConfigurationManager.getConfigInstance().getString(this.getDefaultPropName(propName), defaultValue);
        this.setPropertyInternal(propName, (Object)value);
    }

    protected void putDefaultBooleanProperty(IClientConfigKey propName, Boolean defaultValue) {
        Boolean value = ConfigurationManager.getConfigInstance().getBoolean(this.getDefaultPropName(propName), defaultValue);
        this.setPropertyInternal(propName, (Object)value);
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public void loadProperties(String restClientName) {
        this.enableDynamicProperties = true;
        this.setClientName(restClientName);
        this.loadDefaultValues();
        Configuration props = ConfigurationManager.getConfigInstance().subset(restClientName);
        Iterator keys = props.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String prop = key;
            if (prop.startsWith(this.getNameSpace())) {
                prop = prop.substring(this.getNameSpace().length() + 1);
            }
            this.setPropertyInternal(prop, (Object)DefaultClientConfigImpl.getStringValue(props, key));
        }
    }

    protected static String getStringValue(Configuration config, String key) {
        try {
            String[] values = config.getStringArray(key);
            if (values == null) {
                return null;
            }
            if (values.length == 0) {
                return config.getString(key);
            }
            if (values.length == 1) {
                return values[0];
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                if (i == values.length - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        catch (Exception e) {
            Object v = config.getProperty(key);
            if (v != null) {
                return String.valueOf(v);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DC_DOUBLECHECK"})
    private VipAddressResolver getVipAddressResolver() {
        if (this.resolver == null) {
            DefaultClientConfigImpl defaultClientConfigImpl = this;
            synchronized (defaultClientConfigImpl) {
                if (this.resolver == null) {
                    try {
                        this.resolver = (VipAddressResolver)Class.forName((String)this.getProperty(CommonClientConfigKey.VipAddressResolverClassName)).newInstance();
                    }
                    catch (Throwable e) {
                        LOG.error("Cannot instantiate VipAddressResolver", e);
                    }
                }
            }
        }
        return this.resolver;
    }

    @Override
    public String resolveDeploymentContextbasedVipAddresses() {
        String deploymentContextBasedVipAddressesMacro = (String)this.getProperty(CommonClientConfigKey.DeploymentContextBasedVipAddresses);
        if (deploymentContextBasedVipAddressesMacro == null) {
            return null;
        }
        return this.getVipAddressResolver().resolve(deploymentContextBasedVipAddressesMacro, this);
    }

    public String getAppName() {
        String appName = null;
        Object an = this.getProperty(CommonClientConfigKey.AppName);
        if (an != null) {
            appName = "" + an;
        }
        return appName;
    }

    public String getVersion() {
        String version = null;
        Object an = this.getProperty(CommonClientConfigKey.Version);
        if (an != null) {
            version = "" + an;
        }
        return version;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperty(IClientConfigKey key, Object value) {
        this.setPropertyInternal(key.key(), value);
    }

    public DefaultClientConfigImpl withProperty(IClientConfigKey key, Object value) {
        this.setProperty(key, value);
        return this;
    }

    public IClientConfig applyOverride(IClientConfig override) {
        if (override == null) {
            return this;
        }
        Map<String, Object> props = override.getProperties();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            this.setPropertyInternal(key, value);
        }
        return this;
    }

    protected Object getProperty(String key) {
        if (this.enableDynamicProperties) {
            String dynamicValue = null;
            DynamicStringProperty dynamicProperty = this.dynamicProperties.get(key);
            if (dynamicProperty != null) {
                dynamicValue = dynamicProperty.get();
            }
            if (dynamicValue == null && (dynamicValue = DynamicProperty.getInstance((String)this.getConfigKey(key)).getString()) == null) {
                dynamicValue = DynamicProperty.getInstance((String)this.getDefaultPropName(key)).getString();
            }
            if (dynamicValue != null) {
                return dynamicValue;
            }
        }
        return this.properties.get(key);
    }

    @Override
    public Object getProperty(IClientConfigKey key) {
        String propName = key.key();
        Object value = this.getProperty(propName);
        return value;
    }

    @Override
    public Object getProperty(IClientConfigKey key, Object defaultVal) {
        Object val = this.getProperty(key);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static Object getProperty(Map<String, Object> config, IClientConfigKey key, Object defaultVal) {
        Object val = config.get(key.key());
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static Object getProperty(Map<String, Object> config, IClientConfigKey key) {
        return DefaultClientConfigImpl.getProperty(config, key, null);
    }

    public boolean isSecure() {
        Object oo = this.getProperty(CommonClientConfigKey.IsSecure);
        if (oo != null) {
            return Boolean.parseBoolean(oo.toString());
        }
        return false;
    }

    @Override
    public boolean containsProperty(IClientConfigKey key) {
        Object oo = this.getProperty(key);
        return oo != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        sb.append("ClientConfig:");
        for (IClientConfigKey key : CommonClientConfigKey.values()) {
            Object value = this.getProperty(key);
            sb.append(separator);
            separator = ", ";
            sb.append(key).append(":");
            if (key.key().endsWith("Password") && value instanceof String) {
                sb.append(Strings.repeat((String)"*", (int)((String)value).length()));
                continue;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public void setProperty(Properties props, String restClientName, String key, String value) {
        props.setProperty(this.getInstancePropName(restClientName, key), value);
    }

    public String getInstancePropName(String restClientName, IClientConfigKey configKey) {
        return this.getInstancePropName(restClientName, configKey.key());
    }

    public String getInstancePropName(String restClientName, String key) {
        return restClientName + "." + this.getNameSpace() + "." + key;
    }

    @Override
    public String getNameSpace() {
        return this.propertyNameSpace;
    }

    public static DefaultClientConfigImpl getEmptyConfig() {
        return new DefaultClientConfigImpl();
    }

    public static DefaultClientConfigImpl getClientConfigWithDefaultValues(String clientName) {
        return DefaultClientConfigImpl.getClientConfigWithDefaultValues(clientName, DEFAULT_PROPERTY_NAME_SPACE);
    }

    public static DefaultClientConfigImpl getClientConfigWithDefaultValues() {
        return DefaultClientConfigImpl.getClientConfigWithDefaultValues("default", DEFAULT_PROPERTY_NAME_SPACE);
    }

    public static DefaultClientConfigImpl getClientConfigWithDefaultValues(String clientName, String nameSpace) {
        DefaultClientConfigImpl config = new DefaultClientConfigImpl(nameSpace);
        config.loadProperties(clientName);
        return config;
    }

    @Override
    public int getPropertyAsInteger(IClientConfigKey key, int defaultValue) {
        Object rawValue = this.getProperty(key);
        if (rawValue != null) {
            try {
                return Integer.parseInt(String.valueOf(rawValue));
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    @Override
    public String getPropertyAsString(IClientConfigKey key, String defaultValue) {
        Object rawValue = this.getProperty(key);
        if (rawValue != null) {
            return String.valueOf(rawValue);
        }
        return defaultValue;
    }

    @Override
    public boolean getPropertyAsBoolean(IClientConfigKey key, boolean defaultValue) {
        Object rawValue = this.getProperty(key);
        if (rawValue != null) {
            try {
                return Boolean.valueOf(String.valueOf(rawValue));
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    @Override
    public <T> T get(IClientConfigKey<T> key) {
        Object obj = this.getProperty(key.key());
        if (obj == null) {
            return null;
        }
        Class<T> type = key.type();
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            if (obj instanceof String) {
                String stringValue = (String)obj;
                if (Integer.class.equals(type)) {
                    return (T)Integer.valueOf(stringValue);
                }
                if (Boolean.class.equals(type)) {
                    return (T)Boolean.valueOf(stringValue);
                }
                if (Float.class.equals(type)) {
                    return (T)Float.valueOf(stringValue);
                }
                if (Long.class.equals(type)) {
                    return (T)Long.valueOf(stringValue);
                }
                if (Double.class.equals(type)) {
                    return (T)Double.valueOf(stringValue);
                }
                if (TimeUnit.class.equals(type)) {
                    return (T)((Object)TimeUnit.valueOf(stringValue));
                }
                throw new IllegalArgumentException("Unable to convert string value to desired type " + type);
            }
            throw e;
        }
    }

    @Override
    public <T> DefaultClientConfigImpl set(IClientConfigKey<T> key, T value) {
        this.properties.put(key.key(), value);
        return this;
    }

    @Override
    public <T> T get(IClientConfigKey<T> key, T defaultValue) {
        T value = this.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

