/**
 * Copyright 2014 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.netflix.servo.util;

/**
 * A wrapper around the system clock to allow custom implementations to be used in unit tests
 * where we want to fake or control the clock behavior.
 */
public interface Clock {
    /**
     * A Clock instance that returns the current time in milliseconds since
     * the epoch using the system clock.
     */
    Clock WALL = new Clock() {
        public long now() {
            return System.currentTimeMillis();
        }
    };

    /**
     * Returns the number of milliseconds since the epoch.
     */
    long now();
}
