/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.common.util;

import io.netty.channel.Channel;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;

public class NetworkUtil {
    private static String IP;

    public static String getLocalIp() {
        return IP;
    }

    public static String parseRemoteAddress(Channel channel) {
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        return NetworkUtil.doParse(remote != null ? remote.toString().trim() : "");
    }

    private static String doParse(String addr) {
        if (StringUtils.isBlank((CharSequence)addr)) {
            return "";
        }
        if (addr.charAt(0) == '/') {
            return addr.substring(1);
        }
        int len = addr.length();
        for (int i = 1; i < len; ++i) {
            if (addr.charAt(i) != '/') continue;
            return addr.substring(i + 1);
        }
        return addr;
    }

    static {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            block2: while (e.hasMoreElements()) {
                NetworkInterface item = e.nextElement();
                for (InterfaceAddress address : item.getInterfaceAddresses()) {
                    if (item.isLoopback() || !item.isUp() || !(address.getAddress() instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address.getAddress();
                    IP = inet4Address.getHostAddress();
                    continue block2;
                }
            }
            if (IP.isEmpty()) {
                IP = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (SocketException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

