/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.oms.logmessage;

import com.oceanbase.oms.common.enums.DbTypeEnum;
import com.oceanbase.oms.logmessage.ByteString;
import com.oceanbase.oms.logmessage.DataMessage;
import com.oceanbase.oms.logmessage.FieldParseListener;
import com.oceanbase.oms.logmessage.LogMessageException;
import com.oceanbase.oms.logmessage.typehelper.LogTypeHelper;
import com.oceanbase.oms.logmessage.typehelper.LogTypeHelperFactory;
import com.oceanbase.oms.logmessage.utils.BinaryMessageUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMessage
extends DataMessage.Record {
    private static final Logger log = LoggerFactory.getLogger(LogMessage.class);
    public static final String DEFAULT_ENCODING = "ASCII";
    public static final String UTF8_ENCODING = "UTF-8";
    private static final String SEP = System.getProperty("line.separator");
    private static final int OLD_VERSION_2_HEADER_LEN = 88;
    private static final int NEW_VERSION_2_HEADER_LEN = 96;
    private static final int VERSION_3_HEADER_LEN = 104;
    private static final int VERSION_3_1_HEADER_LEN = 120;
    private static final int PREFIX_LENGTH = 12;
    private int brVersion = -1;
    private int srcType = -1;
    private int op = -1;
    private int lastInLogEvent = -1;
    private long srcCategory = -1L;
    private long id = -1L;
    private long timestamp = -1L;
    private long encoding = -1L;
    private long instanceOffset = -1L;
    private long timeMarkOffset = -1L;
    private long dbNameOffset = -1L;
    private long tbNameOffset = -1L;
    private long colNamesOffset = -1L;
    private long colTypesOffset = -1L;
    private long fileNameOffset = -1L;
    private long fileOffset = -1L;
    private long oldColsOffset = -1L;
    private long newColsOffset = -1L;
    private long pkValOffset = -1L;
    private long pkKeysOffset = -1L;
    private long ukColsOffset = -1L;
    private long colsEncodingOffset = -1L;
    private long filterRuleValOffset = -1L;
    private long tailOffset = -1L;
    private long metaVersion = -1L;
    private long colFlagOffset = -1L;
    private long colNotNullOffset = -1L;
    private String dbName;
    private String tableName;
    private String serverId;
    private List<Integer> primaryKeyIndexList;
    private String uniqueKeyList;
    private ByteBuf byteBuf;
    private Set<String> keysValue;
    private List<String> pkValues;
    private List<Long> timeMarks = null;
    private boolean keyChange = false;
    private static final int[] ELEMENT_ARRAY = new int[]{0, 1, 1, 2, 2, 4, 4, 8, 8};
    private static final int BYTE_SIZE = 1;
    private static final int INT_SIZE = 4;
    private final CRC32 crc32 = new CRC32();
    private boolean isCheckCRC = false;

    public LogMessage(boolean isCheckCRC) {
        this.isCheckCRC = isCheckCRC;
    }

    private void setKeyChange(boolean isChange) {
        this.keyChange = isChange;
    }

    @Override
    public boolean isKeyChange() {
        return this.keyChange;
    }

    public int getVersion() {
        return this.brVersion;
    }

    @Override
    public DbTypeEnum getDbType() {
        return DataMessage.parseDBTypeCode(this.srcType);
    }

    @Override
    public boolean isQueryBack() {
        switch ((int)this.srcCategory) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFirstInLogEvent() {
        return this.lastInLogEvent == 1;
    }

    @Override
    public DataMessage.Record.Type getOpt() {
        return DataMessage.Record.Type.valueOf(this.op);
    }

    @Override
    public String getId() {
        return Long.toString(this.id);
    }

    @Override
    public String getDbName() {
        if (this.dbName == null) {
            if ((int)this.dbNameOffset < 0) {
                this.dbName = "";
            } else {
                try {
                    this.dbName = BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.dbNameOffset, UTF8_ENCODING);
                }
                catch (Exception e) {
                    throw new LogMessageException(e.getMessage(), e.getCause());
                }
            }
        }
        return "".endsWith(this.dbName) ? null : this.dbName;
    }

    @Override
    public String getTableName() {
        if (this.tableName == null) {
            if ((int)this.tbNameOffset < 0) {
                this.tableName = "";
            } else {
                try {
                    this.tableName = BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.tbNameOffset, UTF8_ENCODING);
                }
                catch (Exception e) {
                    throw new LogMessageException(e.getMessage(), e.getCause());
                }
            }
        }
        return "".endsWith(this.tableName) ? null : this.tableName;
    }

    @Override
    public String getCheckpoint() {
        return this.fileOffset + "@" + this.fileNameOffset;
    }

    @Override
    public String getTimestamp() {
        return Long.toString(this.timestamp);
    }

    @Override
    public String getServerId() {
        if (this.serverId == null) {
            if ((int)this.instanceOffset < 0) {
                this.serverId = "";
            } else {
                try {
                    this.serverId = BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.instanceOffset, DEFAULT_ENCODING);
                }
                catch (Exception e) {
                    throw new LogMessageException(e.getMessage(), e.getCause());
                }
            }
        }
        return "".endsWith(this.serverId) ? null : this.serverId;
    }

    @Override
    public void fieldListParse(FieldParseListener fieldParseListener) throws Exception {
        if (this.colNamesOffset < 0L || this.colTypesOffset < 0L || this.oldColsOffset < 0L || this.newColsOffset < 0L) {
            return;
        }
        String encodingStr = null;
        encodingStr = this.getOpt() == DataMessage.Record.Type.DDL ? UTF8_ENCODING : BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.encoding, DEFAULT_ENCODING);
        ByteBuf wrapByteBuf = Unpooled.wrappedBuffer((byte[])this.byteBuf.array()).order(ByteOrder.LITTLE_ENDIAN);
        wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L));
        int count = wrapByteBuf.readInt();
        wrapByteBuf.readerIndex(12 + (int)this.colTypesOffset);
        byte t = wrapByteBuf.readByte();
        int elementSize = ELEMENT_ARRAY[t & 0xF];
        int colEncodingsCount = 0;
        int currentEncodingOffset = 0;
        if (this.colsEncodingOffset > 0L) {
            wrapByteBuf.readerIndex((int)(12L + this.colsEncodingOffset + 1L));
            colEncodingsCount = wrapByteBuf.readInt();
            currentEncodingOffset = (int)wrapByteBuf.readUnsignedInt();
        }
        wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L + 4L));
        int currentColNameOffset = (int)wrapByteBuf.readUnsignedInt();
        wrapByteBuf.readerIndex((int)(12L + this.oldColsOffset + 1L));
        int oldColCount = wrapByteBuf.readInt();
        int currentOldColOffset = -1;
        if (0 != oldColCount) {
            currentOldColOffset = (int)wrapByteBuf.readUnsignedInt();
        }
        wrapByteBuf.readerIndex((int)(12L + this.newColsOffset + 1L));
        int newColCount = wrapByteBuf.readInt();
        int currentNewColOffset = -1;
        if (0 != newColCount) {
            currentNewColOffset = (int)wrapByteBuf.readUnsignedInt();
        }
        LogTypeHelper logTypeHelper = LogTypeHelperFactory.getInstance(this.getDbType());
        for (int i = 0; i < count; ++i) {
            ByteString value;
            int type = 0;
            wrapByteBuf.readerIndex(12 + (int)this.colTypesOffset + 1 + 4 + i * elementSize);
            switch (elementSize) {
                case 1: {
                    type = wrapByteBuf.readUnsignedByte();
                    break;
                }
                case 2: {
                    type = wrapByteBuf.readUnsignedShort();
                    break;
                }
                case 4: {
                    type = (int)wrapByteBuf.readUnsignedInt();
                    break;
                }
                case 8: {
                    type = (int)wrapByteBuf.readLong();
                }
            }
            boolean notNull = false;
            if (fieldParseListener.needSchemaInfo() && this.colNotNullOffset > 0L) {
                wrapByteBuf.readerIndex(12 + (int)this.colNotNullOffset + 1 + 4 + i * elementSize);
                notNull = wrapByteBuf.readBoolean();
            }
            String realEncoding = encodingStr;
            if (colEncodingsCount > 0) {
                wrapByteBuf.readerIndex((int)(12L + this.colsEncodingOffset + 1L + 4L + (long)((i + 1) * 4)));
                int nextEncodingOffset = (int)wrapByteBuf.readUnsignedInt();
                ByteString encodingByteString = new ByteString(wrapByteBuf.array(), 12 + currentEncodingOffset + 1 + 4 + (count + 1) * 4 + (int)this.colsEncodingOffset, nextEncodingOffset - currentEncodingOffset - 1);
                realEncoding = encodingByteString.toString();
                currentEncodingOffset = nextEncodingOffset;
            }
            realEncoding = logTypeHelper.correctEncoding(type, realEncoding);
            String columnName = null;
            if (fieldParseListener.needSchemaInfo()) {
                type = logTypeHelper.correctCode(type, realEncoding);
                wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L + 4L + (long)((i + 1) * 4)));
                int nextColNameOffset = (int)wrapByteBuf.readUnsignedInt();
                ByteString colNameByteString = new ByteString(wrapByteBuf.array(), 12 + currentColNameOffset + 1 + 4 + (count + 1) * 4 + (int)this.colNamesOffset, nextColNameOffset - currentColNameOffset - 1);
                columnName = colNameByteString.toString();
                currentColNameOffset = nextColNameOffset;
            }
            if (oldColCount != 0) {
                wrapByteBuf.readerIndex((int)(12L + this.oldColsOffset + 1L + 4L + (long)((i + 1) * 4)));
                int nextOldColOffset = (int)wrapByteBuf.readUnsignedInt();
                value = null;
                if (nextOldColOffset != currentOldColOffset) {
                    value = new ByteString(wrapByteBuf.array(), 12 + currentOldColOffset + 1 + 4 + (count + 1) * 4 + (int)this.oldColsOffset, nextOldColOffset - currentOldColOffset - 1);
                }
                if (fieldParseListener.needSchemaInfo()) {
                    fieldParseListener.parseNotify(columnName, type, realEncoding, value, notNull, true);
                } else {
                    fieldParseListener.parseNotify(type, value, realEncoding, true);
                }
                currentOldColOffset = nextOldColOffset;
            }
            if (newColCount == 0) continue;
            wrapByteBuf.readerIndex((int)(12L + this.newColsOffset + 1L + 4L + (long)((i + 1) * 4)));
            int nextNewColOffset = (int)wrapByteBuf.readUnsignedInt();
            value = null;
            if (currentNewColOffset != nextNewColOffset) {
                value = new ByteString(wrapByteBuf.array(), 12 + currentNewColOffset + 1 + 4 + (count + 1) * 4 + (int)this.newColsOffset, nextNewColOffset - currentNewColOffset - 1);
            }
            if (fieldParseListener.needSchemaInfo()) {
                fieldParseListener.parseNotify(columnName, type, realEncoding, value, notNull, false);
            } else {
                fieldParseListener.parseNotify(type, value, realEncoding, false);
            }
            currentNewColOffset = nextNewColOffset;
        }
    }

    @Override
    public synchronized List<DataMessage.Record.Field> getFieldList() {
        try {
            if (this.fields == null) {
                if (this.colNamesOffset < 0L || this.colTypesOffset < 0L || this.oldColsOffset < 0L || this.newColsOffset < 0L) {
                    return this.fields;
                }
                LogTypeHelper logTypeHelper = LogTypeHelperFactory.getInstance(this.getDbType());
                String encodingStr = null;
                encodingStr = this.getOpt() == DataMessage.Record.Type.DDL ? UTF8_ENCODING : BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.encoding, DEFAULT_ENCODING);
                List pks = null;
                if ((int)this.pkKeysOffset > 0) {
                    pks = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.pkKeysOffset);
                }
                ByteBuf wrapByteBuf = Unpooled.wrappedBuffer((byte[])this.byteBuf.array()).order(ByteOrder.LITTLE_ENDIAN);
                wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L));
                int count = wrapByteBuf.readInt();
                this.fields = new ArrayList(count);
                wrapByteBuf.readerIndex(12 + (int)this.colTypesOffset);
                byte t = wrapByteBuf.readByte();
                int elementSize = ELEMENT_ARRAY[t & 0xF];
                int colEncodingsCount = 0;
                int currentEncodingOffset = 0;
                if (this.colsEncodingOffset > 0L) {
                    wrapByteBuf.readerIndex((int)(12L + this.colsEncodingOffset + 1L));
                    colEncodingsCount = wrapByteBuf.readInt();
                    currentEncodingOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L + 4L));
                int currentColNameOffset = (int)wrapByteBuf.readUnsignedInt();
                wrapByteBuf.readerIndex((int)(12L + this.oldColsOffset + 1L));
                int oldColCount = wrapByteBuf.readInt();
                int currentOldColOffset = -1;
                if (0 != oldColCount) {
                    currentOldColOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                wrapByteBuf.readerIndex((int)(12L + this.newColsOffset + 1L));
                int newColCount = wrapByteBuf.readInt();
                int currentNewColOffset = -1;
                if (0 != newColCount) {
                    currentNewColOffset = (int)wrapByteBuf.readUnsignedInt();
                }
                for (int i = 0; i < count; ++i) {
                    DataMessage.Record.Field field;
                    ByteString value;
                    boolean isPk = false;
                    if (pks != null && pks.contains(i)) {
                        isPk = true;
                    }
                    int type = 0;
                    wrapByteBuf.readerIndex(12 + (int)this.colTypesOffset + 1 + 4 + i * elementSize);
                    switch (elementSize) {
                        case 1: {
                            type = wrapByteBuf.readUnsignedByte();
                            break;
                        }
                        case 2: {
                            type = wrapByteBuf.readUnsignedShort();
                            break;
                        }
                        case 4: {
                            type = (int)wrapByteBuf.readUnsignedInt();
                            break;
                        }
                        case 8: {
                            type = (int)wrapByteBuf.readLong();
                        }
                    }
                    short flag = 0;
                    if (this.colFlagOffset > 0L) {
                        wrapByteBuf.readerIndex(12 + (int)this.colFlagOffset + 1 + 4 + i * elementSize);
                        flag = wrapByteBuf.readUnsignedByte();
                    }
                    boolean notNull = false;
                    if (this.colNotNullOffset > 0L) {
                        wrapByteBuf.readerIndex(12 + (int)this.colNotNullOffset + 1 + 4 + i * elementSize);
                        notNull = wrapByteBuf.readBoolean();
                    }
                    String realEncoding = encodingStr;
                    if (colEncodingsCount > 0) {
                        wrapByteBuf.readerIndex((int)(12L + this.colsEncodingOffset + 1L + 4L + (long)((i + 1) * 4)));
                        int nextEncodingOffset = (int)wrapByteBuf.readUnsignedInt();
                        ByteString encodingByteString = new ByteString(wrapByteBuf.array(), 12 + currentEncodingOffset + 1 + 4 + (count + 1) * 4 + (int)this.colsEncodingOffset, nextEncodingOffset - currentEncodingOffset - 1);
                        realEncoding = encodingByteString.toString();
                        currentEncodingOffset = nextEncodingOffset;
                    }
                    realEncoding = logTypeHelper.correctEncoding(type, realEncoding);
                    type = logTypeHelper.correctCode(type, realEncoding);
                    wrapByteBuf.readerIndex((int)(12L + this.colNamesOffset + 1L + 4L + (long)((i + 1) * 4)));
                    int nextColNameOffset = (int)wrapByteBuf.readUnsignedInt();
                    ByteString colNameByteString = new ByteString(wrapByteBuf.array(), 12 + currentColNameOffset + 1 + 4 + (count + 1) * 4 + (int)this.colNamesOffset, nextColNameOffset - currentColNameOffset - 1);
                    String columnName = colNameByteString.toString();
                    currentColNameOffset = nextColNameOffset;
                    if (oldColCount != 0) {
                        wrapByteBuf.readerIndex((int)(12L + this.oldColsOffset + 1L + 4L + (long)((i + 1) * 4)));
                        int nextOldColOffset = (int)wrapByteBuf.readUnsignedInt();
                        value = null;
                        if (nextOldColOffset != currentOldColOffset) {
                            value = new ByteString(wrapByteBuf.array(), 12 + currentOldColOffset + 1 + 4 + (count + 1) * 4 + (int)this.oldColsOffset, nextOldColOffset - currentOldColOffset - 1);
                        }
                        field = new DataMessage.Record.Field(columnName, type, realEncoding, value, isPk);
                        field.setFlag(flag);
                        field.setNotNull(notNull);
                        this.fields.add(field);
                        field.setPrev(true);
                        currentOldColOffset = nextOldColOffset;
                    }
                    if (newColCount == 0) continue;
                    wrapByteBuf.readerIndex((int)(12L + this.newColsOffset + 1L + 4L + (long)((i + 1) * 4)));
                    int nextNewColOffset = (int)wrapByteBuf.readUnsignedInt();
                    value = null;
                    if (currentNewColOffset != nextNewColOffset) {
                        value = new ByteString(wrapByteBuf.array(), 12 + currentNewColOffset + 1 + 4 + (count + 1) * 4 + (int)this.newColsOffset, nextNewColOffset - currentNewColOffset - 1);
                    }
                    field = new DataMessage.Record.Field(columnName, type, realEncoding, value, isPk);
                    field.setFlag(flag);
                    field.setNotNull(notNull);
                    this.fields.add(field);
                    field.setPrev(false);
                    currentNewColOffset = nextNewColOffset;
                }
            }
        }
        catch (Exception e) {
            this.fields = null;
            throw new LogMessageException(e.getMessage(), e);
        }
        return this.fields;
    }

    @Override
    public int getFieldCount() {
        List<DataMessage.Record.Field> fields = this.getFieldList();
        if (fields == null) {
            return 0;
        }
        return fields.size();
    }

    public List<Integer> getPrimaryKeyIndex() {
        try {
            if (this.primaryKeyIndexList == null) {
                this.primaryKeyIndexList = (int)this.pkKeysOffset < 0 ? new ArrayList<Integer>() : BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.pkKeysOffset);
            }
        }
        catch (Exception e) {
            throw new LogMessageException(e.getMessage(), e.getCause());
        }
        return this.primaryKeyIndexList;
    }

    @Override
    public void parse(byte[] data) throws Exception {
        ByteBuf inner = Unpooled.wrappedBuffer((byte[])data, (int)0, (int)data.length).order(ByteOrder.LITTLE_ENDIAN);
        this.setByteBuf(inner);
    }

    @Override
    public byte[] getRawData() {
        if (this.byteBuf == null) {
            return null;
        }
        return this.byteBuf.array();
    }

    public void setByteBuf(ByteBuf byteBuf) throws Exception {
        this.byteBuf = byteBuf;
        byteBuf.readerIndex(12);
        if ((byteBuf.readByte() & 0xF) != 2) {
            throw new Exception("parse error");
        }
        long count = byteBuf.readInt();
        boolean old = false;
        switch ((int)count) {
            case 88: {
                old = true;
                break;
            }
            case 96: 
            case 104: 
            case 120: {
                break;
            }
            default: {
                throw new Exception("");
            }
        }
        this.brVersion = byteBuf.readUnsignedByte();
        this.srcType = byteBuf.readUnsignedByte();
        this.op = byteBuf.readUnsignedByte();
        this.lastInLogEvent = byteBuf.readByte();
        this.srcCategory = byteBuf.readInt();
        this.id = byteBuf.readLong();
        this.timestamp = byteBuf.readLong();
        this.encoding = byteBuf.readInt();
        this.instanceOffset = byteBuf.readInt();
        this.timeMarkOffset = byteBuf.readInt();
        this.dbNameOffset = byteBuf.readInt();
        this.tbNameOffset = byteBuf.readInt();
        this.colNamesOffset = byteBuf.readInt();
        this.colTypesOffset = byteBuf.readInt();
        if (!old) {
            this.pkValOffset = byteBuf.readInt();
            this.fileNameOffset = byteBuf.readLong();
            this.fileOffset = byteBuf.readLong();
            if (this.fileNameOffset < -1L || this.fileOffset < -1L) {
                throw new IOException("f: " + this.fileNameOffset + " and o: " + this.fileOffset + " should both be signed integer");
            }
            this.oldColsOffset = byteBuf.readInt();
            this.newColsOffset = byteBuf.readInt();
        } else {
            this.fileNameOffset = byteBuf.readInt();
            this.fileOffset = byteBuf.readInt();
            this.oldColsOffset = byteBuf.readInt();
            this.newColsOffset = byteBuf.readInt();
            this.pkValOffset = byteBuf.readInt();
        }
        this.pkKeysOffset = byteBuf.readInt();
        this.ukColsOffset = byteBuf.readInt();
        if (this.brVersion > 1) {
            this.colsEncodingOffset = byteBuf.readLong();
        }
        if (this.brVersion == 3) {
            this.filterRuleValOffset = byteBuf.readInt();
            this.tailOffset = byteBuf.readInt();
            long version = this.id >> 56;
            if (version >= 1L) {
                this.metaVersion = byteBuf.readInt();
                this.colFlagOffset = byteBuf.readInt();
            }
            if (version >= 2L) {
                this.colNotNullOffset = byteBuf.readInt();
            }
        }
        DataMessage.Record.Type type = DataMessage.Record.Type.valueOf(this.op);
        String ts = Long.toString(this.timestamp);
        DbTypeEnum dbTypeEnum = this.getDbType();
        if (dbTypeEnum == DbTypeEnum.OB_MYSQL || dbTypeEnum == DbTypeEnum.OB_ORACLE) {
            globalSafeTimestamp.set(String.valueOf(this.fileNameOffset));
        } else {
            if (type == DataMessage.Record.Type.BEGIN) {
                globalSafeTimestamp.set(ts);
                txEnd.set(false);
            }
            if (((Boolean)txEnd.get()).booleanValue()) {
                globalSafeTimestamp.set(ts);
            }
            if (type == DataMessage.Record.Type.COMMIT || type == DataMessage.Record.Type.ROLLBACK) {
                txEnd.set(true);
            }
        }
        this.safeTimestamp = (String)globalSafeTimestamp.get();
        if (this.isCheckCRC) {
            this.checkCRC();
        }
    }

    private void checkCRC() throws IOException {
        long value = this.getCRCValue();
        if (value == 0L) {
            return;
        }
        this.crc32.update(this.byteBuf.array(), 0, this.byteBuf.array().length - 4);
        long actual = this.crc32.getValue();
        this.crc32.reset();
        if (value != actual) {
            throw new IOException("crc 32 check failed,expect:" + value + ",actual:" + actual);
        }
    }

    @Override
    public String getTraceId() {
        List<ByteString> list = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.filterRuleValOffset);
        if (list == null || list.size() == 0 || list.size() < 3) {
            return null;
        }
        ByteString traceId = list.get(2);
        return traceId == null ? null : traceId.toString();
    }

    @Override
    public String getOB10UniqueId() {
        List<ByteString> list = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.filterRuleValOffset);
        if (list == null || list.size() == 0 || list.size() < 3) {
            return null;
        }
        ByteString ob10UniqueId = list.get(1);
        return ob10UniqueId == null ? null : ob10UniqueId.toString();
    }

    @Override
    public String getThreadId() throws Exception {
        long threadId = 0L;
        if (this.tailOffset == -1L) {
            return null;
        }
        List list = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.tailOffset);
        if (list == null || list.size() == 0) {
            return null;
        }
        threadId += (long)((Integer)list.get(0)).intValue();
        threadId += (long)((Integer)list.get(1)).intValue() << 8;
        threadId += (long)((Integer)list.get(2)).intValue() << 16;
        return String.valueOf(threadId += (long)((Integer)list.get(3)).intValue() << 24);
    }

    private List<List<String>> getKeys(int valueOffset, List<ByteString> keys) {
        if (valueOffset == -1) {
            return null;
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ByteBuf wrapByteBuf = Unpooled.wrappedBuffer((byte[])this.byteBuf.array()).order(ByteOrder.LITTLE_ENDIAN);
        wrapByteBuf.readerIndex(12 + valueOffset + 1);
        int fieldCount = wrapByteBuf.readInt();
        for (ByteString key : keys) {
            int i;
            String keyStr = key.toString();
            int m = 0;
            while ((i = keyStr.indexOf(40, m)) != -1) {
                int j = keyStr.indexOf(41, i);
                if (j == -1) {
                    log.error("Parse key error");
                    return null;
                }
                m = j;
                String[] parts = keyStr.substring(i + 1, j).split(",");
                StringBuilder sb = new StringBuilder();
                ArrayList<String> item = new ArrayList<String>();
                result.add(item);
                for (String indexStr : parts) {
                    int index = Integer.parseInt(indexStr);
                    wrapByteBuf.readerIndex(12 + valueOffset + 5 + index * 4);
                    int start = (int)wrapByteBuf.readUnsignedInt();
                    int end = (int)wrapByteBuf.readUnsignedInt();
                    if (end - start == 0) {
                        item.add(null);
                        continue;
                    }
                    String k = new ByteString(wrapByteBuf.array(), 12 + valueOffset + 5 + (fieldCount + 1) * 4 + start, end - start - 1).toString();
                    sb.append(k);
                    item.add(k);
                }
                if (sb.length() > 0) {
                    this.keysValue.add(sb.toString());
                    continue;
                }
                this.keysValue.add(null);
            }
        }
        return result;
    }

    @Override
    public Set<String> getKeysValue() {
        block15: {
            List<Object> prev = new ArrayList();
            List<Object> next = new ArrayList();
            try {
                if (this.keysValue != null) {
                    return this.keysValue;
                }
                if (this.colNamesOffset < 0L || this.colTypesOffset < 0L || this.oldColsOffset < 0L || this.newColsOffset < 0L) {
                    return null;
                }
                this.keysValue = new HashSet<String>();
                List<ByteString> keys = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), (int)this.pkValOffset);
                if (keys == null || keys.size() == 0) {
                    return null;
                }
                block1 : switch (this.getOpt()) {
                    case INSERT: 
                    case REPLACE: 
                    case INDEX_INSERT: 
                    case INDEX_REPLACE: {
                        next = this.getKeys((int)this.newColsOffset, keys);
                        break;
                    }
                    case DELETE: 
                    case INDEX_DELETE: {
                        prev = this.getKeys((int)this.oldColsOffset, keys);
                        break;
                    }
                    case UPDATE: 
                    case INDEX_UPDATE: {
                        switch (this.getDbType()) {
                            case OB_MYSQL: 
                            case OB_ORACLE: {
                                prev.addAll(this.getKeys((int)this.oldColsOffset, keys));
                                next.addAll(this.getKeys((int)this.newColsOffset, keys));
                                if (!prev.equals(next)) {
                                    this.setKeyChange(true);
                                    break block1;
                                }
                                break block15;
                            }
                            case UNKNOWN: {
                                next.addAll(this.getKeys((int)this.newColsOffset, keys));
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return this.keysValue;
    }

    @Override
    public List<String> getPrimaryValues() {
        try {
            List<DataMessage.Record.Field> filedList = this.getFieldList();
            List<String> primaryKeys = this.getPrimaryKeyValue();
            if (primaryKeys == null) {
                primaryKeys = new ArrayList<String>();
            }
            HashMap<String, String> keyValue = new HashMap<String, String>();
            if (filedList != null) {
                for (DataMessage.Record.Field field : filedList) {
                    if ("binary".equalsIgnoreCase(field.getEncoding())) {
                        keyValue.put(field.getFieldname().toLowerCase(), field.getValue() == null ? null : new String(field.getValue().getBytes()));
                        continue;
                    }
                    keyValue.put(field.getFieldname().toLowerCase(), field.getValue() == null ? null : field.getValue().toString(field.getEncoding()));
                }
            }
            ArrayList<String> primaryValues = new ArrayList<String>(primaryKeys.size());
            for (String primaryKey : primaryKeys) {
                primaryValues.add((String)keyValue.get(primaryKey.toLowerCase()));
            }
            return primaryValues;
        }
        catch (Exception e) {
            throw new LogMessageException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public List<String> getPrimaryKeyValue() {
        try {
            if (this.pkValues != null) {
                return this.pkValues;
            }
            if (this.colNamesOffset < 0L || this.pkKeysOffset < 0L) {
                return null;
            }
            this.pkValues = new ArrayList<String>();
            List pks = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.pkKeysOffset);
            List<ByteString> names = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.colNamesOffset);
            if (pks != null) {
                Iterator iterator = pks.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    this.pkValues.add(names.get(idx).toString(DEFAULT_ENCODING));
                }
            }
            return this.pkValues;
        }
        catch (Exception e) {
            throw new LogMessageException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public List<int[]> getPrimaryAndUniqueConstraintColumnIndexTuples() {
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        try {
            List<ByteString> rawConstraintByteString;
            if ((int)this.pkValOffset > 0 && (rawConstraintByteString = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.pkValOffset)) != null && !rawConstraintByteString.isEmpty()) {
                for (int i = 0; i < rawConstraintByteString.size(); ++i) {
                    String rawConstraintStringArray = rawConstraintByteString.get(i).toString();
                    for (String rawConstraintString : rawConstraintStringArray.split("\\),")) {
                        int leftIndex;
                        if (!StringUtils.isNotEmpty((CharSequence)rawConstraintString)) continue;
                        int m = 0;
                        while (m < rawConstraintString.length() && (leftIndex = rawConstraintString.indexOf(40, m)) != -1) {
                            int rightIndex = rawConstraintString.indexOf(41, leftIndex);
                            if (rightIndex == -1) {
                                if (rawConstraintString.length() == 1) {
                                    throw new IOException("Missing index and ) for constraints: " + rawConstraintByteString);
                                }
                                rightIndex = rawConstraintString.length();
                            }
                            m = rightIndex;
                            String[] parts = rawConstraintString.substring(leftIndex + 1, rightIndex).split(",");
                            if (parts == null || parts.length <= 0) continue;
                            int[] tuple = new int[parts.length];
                            for (int j = 0; j < parts.length; ++j) {
                                tuple[j] = Integer.valueOf(parts[j]);
                            }
                            tuples.add(tuple);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new LogMessageException(e);
        }
        return tuples;
    }

    @Override
    public List<ByteString> getFirstPKValue() {
        try {
            if ((int)this.pkValOffset < 0) {
                return null;
            }
            return BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.pkValOffset);
        }
        catch (Exception e) {
            throw new LogMessageException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public List<String> getPrimaryKeysList() {
        List<String> primaryKeyStringList = this.getPrimaryKeyValue();
        ArrayList<String> pkKeyName = new ArrayList<String>();
        if (primaryKeyStringList != null) {
            for (String idx : primaryKeyStringList) {
                pkKeyName.add(idx);
            }
            return pkKeyName;
        }
        return null;
    }

    @Override
    public String getPrimaryKeys() {
        List<String> primaryKeyStringList = this.getPrimaryKeyValue();
        if (primaryKeyStringList != null) {
            StringBuilder pkKeyName = new StringBuilder();
            for (String idx : primaryKeyStringList) {
                if (pkKeyName.length() != 0) {
                    pkKeyName.append(",");
                }
                pkKeyName.append(idx);
            }
            return pkKeyName.toString();
        }
        return "";
    }

    public long getMetaVersion() {
        return this.metaVersion;
    }

    @Override
    public String getUniqueColNames() {
        try {
            if (this.uniqueKeyList == null) {
                if ((int)this.ukColsOffset < 0) {
                    this.uniqueKeyList = "";
                    return this.uniqueKeyList;
                }
                List uks = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.ukColsOffset);
                List<ByteString> names = BinaryMessageUtils.getByteStringList(this.byteBuf.array(), this.colNamesOffset);
                StringBuilder ukKeyName = new StringBuilder();
                if (uks != null && names != null) {
                    Iterator iterator = uks.iterator();
                    while (iterator.hasNext()) {
                        int idx = (Integer)iterator.next();
                        if (ukKeyName.length() != 0) {
                            ukKeyName.append(",");
                        }
                        ukKeyName.append(names.get(idx).toString(DEFAULT_ENCODING));
                    }
                }
                this.uniqueKeyList = ukKeyName.toString();
                return this.uniqueKeyList;
            }
        }
        catch (Exception e) {
            throw new LogMessageException(e.getMessage(), e.getCause());
        }
        return this.uniqueKeyList;
    }

    public List<Long> getTimeMarks() throws IOException {
        if (this.timeMarkOffset == -1L) {
            return null;
        }
        if (this.timeMarks == null) {
            this.timeMarks = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.timeMarkOffset);
        }
        return this.timeMarks;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type:" + (Object)((Object)this.getOpt())).append(SEP);
        builder.append("record_id:" + this.getId()).append(SEP);
        builder.append("db:" + this.getDbName()).append(SEP);
        builder.append("tb:" + this.getTableName()).append(SEP);
        builder.append("serverId:" + this.getServerId()).append(SEP);
        builder.append("checkpoint:" + this.getCheckpoint()).append(SEP);
        builder.append("primary_value:" + this.getPrimaryKeys()).append(SEP);
        builder.append("unique_keys:" + this.getUniqueColNames()).append(SEP);
        builder.append(SEP);
        this.getFieldList();
        if (this.fields != null) {
            for (DataMessage.Record.Field field : this.fields) {
                builder.append(field.toString());
            }
        }
        builder.append(SEP);
        return builder.toString();
    }

    private long getCRCValue() throws IOException {
        long crcValue = 0L;
        if (this.tailOffset == -1L) {
            return 0L;
        }
        List list = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.tailOffset);
        if (list == null || list.size() != 12) {
            return 0L;
        }
        crcValue += (long)((Integer)list.get(8)).intValue();
        crcValue += (long)((Integer)list.get(9)).intValue() << 8;
        crcValue += (long)((Integer)list.get(10)).intValue() << 16;
        return crcValue += (long)((Integer)list.get(11)).intValue() << 24;
    }

    @Override
    public String getTimestampUsec() throws IOException {
        long usecs = 0L;
        if (this.tailOffset == -1L) {
            return "0";
        }
        List list = BinaryMessageUtils.getArray(this.byteBuf.array(), (int)this.tailOffset);
        if (list == null || list.size() != 12) {
            return "0";
        }
        usecs += (long)((Integer)list.get(4)).intValue();
        usecs += (long)((Integer)list.get(5)).intValue() << 8;
        usecs += (long)((Integer)list.get(6)).intValue() << 16;
        return Long.toString(usecs += (long)((Integer)list.get(7)).intValue() << 24);
    }

    public String getEncodingStr() {
        try {
            return BinaryMessageUtils.getString(this.byteBuf.array(), (int)this.encoding, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new LogMessageException(e.getMessage(), e.getCause());
        }
    }

    public long getFileNameOffset() {
        return this.fileNameOffset;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public ByteBuf getByteBuff() {
        return this.byteBuf;
    }

    public void releaseContents() {
        this.fields = null;
        this.pkValues = null;
        this.keysValue = null;
        this.primaryKeyIndexList = null;
    }
}

