/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.connection;

import com.oceanbase.clogproxy.client.config.ClientConf;
import com.oceanbase.clogproxy.client.connection.ClientStream;
import com.oceanbase.clogproxy.client.connection.ConnectionParams;
import com.oceanbase.clogproxy.common.packet.HeaderType;
import com.oceanbase.clogproxy.common.packet.protocol.LogProxyProto;
import com.oceanbase.oms.logmessage.LogMessage;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class StreamContext {
    private final BlockingQueue<TransferPacket> recordQueue = new LinkedBlockingQueue<TransferPacket>(ClientConf.TRANSFER_QUEUE_SIZE);
    private final ClientStream stream;
    ConnectionParams params;
    private final SslContext sslContext;

    public StreamContext(ClientStream stream, ConnectionParams params, SslContext sslContext) {
        this.stream = stream;
        this.params = params;
        this.sslContext = sslContext;
    }

    public ConnectionParams getParams() {
        return this.params;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public ClientStream stream() {
        return this.stream;
    }

    public BlockingQueue<TransferPacket> recordQueue() {
        return this.recordQueue;
    }

    public static class TransferPacket {
        private final HeaderType type;
        private LogMessage record;
        private LogProxyProto.RuntimeStatus status;

        public TransferPacket(LogMessage record) {
            this.type = HeaderType.DATA_CLIENT;
            this.record = record;
        }

        public TransferPacket(LogProxyProto.RuntimeStatus status) {
            this.type = HeaderType.STATUS;
            this.status = status;
        }

        public HeaderType getType() {
            return this.type;
        }

        public LogMessage getRecord() {
            return this.record;
        }

        public LogProxyProto.RuntimeStatus getStatus() {
            return this.status;
        }
    }
}

