/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase;

import com.alipay.oceanbase.hbase.constants.OHConstants;
import com.alipay.oceanbase.hbase.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.hbase.exception.OperationTimeoutException;
import com.alipay.oceanbase.hbase.execute.ServerCallable;
import com.alipay.oceanbase.hbase.filter.HBaseFilterUtils;
import com.alipay.oceanbase.hbase.result.ClientStreamScanner;
import com.alipay.oceanbase.hbase.util.BatchError;
import com.alipay.oceanbase.hbase.util.OHBaseFuncUtils;
import com.alipay.oceanbase.hbase.util.OHConnectionConfiguration;
import com.alipay.oceanbase.hbase.util.ObTableBuilderBase;
import com.alipay.oceanbase.hbase.util.ObTableClientManager;
import com.alipay.oceanbase.hbase.util.Preconditions;
import com.alipay.oceanbase.hbase.util.TableHBaseLoggerFactory;
import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.location.model.partition.Partition;
import com.alipay.oceanbase.rpc.mutation.BatchOperation;
import com.alipay.oceanbase.rpc.mutation.ColumnValue;
import com.alipay.oceanbase.rpc.mutation.Mutation;
import com.alipay.oceanbase.rpc.mutation.MutationFactory;
import com.alipay.oceanbase.rpc.mutation.result.BatchOperationResult;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableAbstractOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutate;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutateRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutateResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.AbstractQueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObHTableFilter;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObScanOrder;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncRequest;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryAsyncStreamResult;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import com.alipay.oceanbase.rpc.table.ObHBaseParams;
import com.alipay.oceanbase.rpc.table.ObKVParams;
import com.alipay.oceanbase.rpc.table.ObKVParamsBase;
import com.alipay.oceanbase.rpc.table.ObTableClientQueryImpl;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import com.alipay.sofa.common.thread.SofaThreadPoolExecutor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.slf4j.Logger;

public class OHTable
implements Table {
    private static final Logger logger = TableHBaseLoggerFactory.getLogger(OHTable.class);
    private final ObTableClient obTableClient;
    private final byte[] tableName;
    private final String tableNameString;
    private int operationTimeout;
    private int rpcTimeout;
    private int readRpcTimeout;
    private int writeRpcTimeout;
    private boolean cleanupPoolOnClose = true;
    private boolean closeClientOnClose = true;
    private ExecutorService executePool;
    private boolean operationExecuteInPool = false;
    private final ArrayList<Put> writeBuffer = new ArrayList();
    private long writeBufferSize;
    private int putWriteBufferCheck;
    private boolean clearBufferOnFail = true;
    private boolean autoFlush = true;
    private long currentWriteBufferSize;
    private int maxKeyValueSize;
    private final Configuration configuration;
    private int scannerTimeout;

    public OHTable(Configuration configuration, String tableName) throws IOException {
        Preconditions.checkArgument(configuration != null, "configuration is null.");
        Preconditions.checkArgument(StringUtils.isNotBlank((String)tableName), "tableNameString is blank.");
        this.configuration = configuration;
        this.tableName = tableName.getBytes();
        this.tableNameString = tableName;
        int maxThreads = configuration.getInt("hbase.htable.privatethreads.max", Integer.MAX_VALUE);
        long keepAliveTime = configuration.getLong("hbase.htable.threads.keepalivetime", 60L);
        this.executePool = OHTable.createDefaultThreadPoolExecutor(1, maxThreads, keepAliveTime);
        OHConnectionConfiguration ohConnectionConf = new OHConnectionConfiguration(configuration);
        int numRetries = configuration.getInt("hbase.client.retries.number", 15);
        this.obTableClient = ObTableClientManager.getOrCreateObTableClient(this.setUserDefinedNamespace(this.tableNameString, ohConnectionConf));
        this.obTableClient.setRpcExecuteTimeout(ohConnectionConf.getRpcTimeout());
        this.obTableClient.setRuntimeRetryTimes(numRetries);
        this.setOperationTimeout(ohConnectionConf.getOperationTimeout());
        this.finishSetUp();
    }

    public OHTable(Configuration configuration, byte[] tableName) throws IOException {
        this(configuration, Arrays.toString(tableName));
    }

    public OHTable(Configuration configuration, byte[] tableName, ExecutorService executePool) throws IOException {
        Preconditions.checkArgument(configuration != null, "configuration is null.");
        Preconditions.checkArgument(tableName != null, "tableNameString is blank.");
        Preconditions.checkArgument(executePool != null && !executePool.isShutdown(), "executePool is null or executePool is shutdown");
        this.configuration = configuration;
        this.tableName = tableName;
        this.tableNameString = Bytes.toString((byte[])tableName);
        this.executePool = executePool;
        this.cleanupPoolOnClose = false;
        OHConnectionConfiguration ohConnectionConf = new OHConnectionConfiguration(configuration);
        int numRetries = configuration.getInt("hbase.client.retries.number", 15);
        this.obTableClient = ObTableClientManager.getOrCreateObTableClient(this.setUserDefinedNamespace(this.tableNameString, ohConnectionConf));
        this.obTableClient.setRpcExecuteTimeout(ohConnectionConf.getRpcTimeout());
        this.obTableClient.setRuntimeRetryTimes(numRetries);
        this.setOperationTimeout(ohConnectionConf.getOperationTimeout());
        this.finishSetUp();
    }

    @InterfaceAudience.Private
    public OHTable(byte[] tableName, ObTableClient obTableClient, ExecutorService executePool) {
        Preconditions.checkArgument(tableName != null, "tableNameString is blank.");
        Preconditions.checkArgument(executePool != null && !executePool.isShutdown(), "executePool is null or executePool is shutdown");
        this.tableName = tableName;
        this.tableNameString = Bytes.toString((byte[])tableName);
        this.cleanupPoolOnClose = false;
        this.closeClientOnClose = false;
        this.executePool = executePool;
        this.obTableClient = obTableClient;
        this.configuration = new Configuration();
        this.finishSetUp();
    }

    public OHTable(TableName tableName, Connection connection, OHConnectionConfiguration connectionConfig, ExecutorService executePool) throws IOException {
        Preconditions.checkArgument(connection != null, "connection is null.");
        Preconditions.checkArgument(tableName != null, "tableName is null.");
        Preconditions.checkArgument(connection.getConfiguration() != null, "configuration is null.");
        Preconditions.checkArgument(tableName.getName() != null, "tableNameString is null.");
        Preconditions.checkArgument(connectionConfig != null, "connectionConfig is null.");
        this.tableNameString = Bytes.toString((byte[])tableName.getName());
        this.configuration = connection.getConfiguration();
        this.executePool = executePool;
        if (executePool == null) {
            int maxThreads = this.configuration.getInt("hbase.htable.privatethreads.max", Integer.MAX_VALUE);
            long keepAliveTime = this.configuration.getLong("hbase.htable.threads.keepalivetime", 60L);
            this.executePool = OHTable.createDefaultThreadPoolExecutor(1, maxThreads, keepAliveTime);
            this.cleanupPoolOnClose = true;
        } else {
            this.cleanupPoolOnClose = false;
        }
        this.rpcTimeout = connectionConfig.getRpcTimeout();
        this.readRpcTimeout = connectionConfig.getReadRpcTimeout();
        this.writeRpcTimeout = connectionConfig.getWriteRpcTimeout();
        this.operationTimeout = connectionConfig.getOperationTimeout();
        this.operationExecuteInPool = this.configuration.getBoolean("hbase.client.operation.executeinpool", this.operationTimeout != 1200000);
        this.maxKeyValueSize = connectionConfig.getMaxKeyValueSize();
        this.putWriteBufferCheck = this.configuration.getInt("hbase.htable.put.write.buffer.check", 10);
        this.writeBufferSize = connectionConfig.getWriteBufferSize();
        this.tableName = tableName.getName();
        int numRetries = this.configuration.getInt("hbase.client.retries.number", 15);
        this.obTableClient = ObTableClientManager.getOrCreateObTableClient(this.setUserDefinedNamespace(this.tableNameString, connectionConfig));
        this.obTableClient.setRpcExecuteTimeout(this.rpcTimeout);
        this.obTableClient.setRuntimeRetryTimes(numRetries);
        this.setOperationTimeout(this.operationTimeout);
        this.finishSetUp();
    }

    public OHTable(Connection connection, ObTableBuilderBase builder, OHConnectionConfiguration connectionConfig, ExecutorService executePool) throws IOException {
        Preconditions.checkArgument(connection != null, "connection is null.");
        Preconditions.checkArgument(connection.getConfiguration() != null, "configuration is null.");
        Preconditions.checkArgument(builder != null, "builder is null");
        Preconditions.checkArgument(connectionConfig != null, "connectionConfig is null.");
        TableName builderTableName = builder.getTableName();
        this.tableName = builderTableName.getName();
        this.tableNameString = builderTableName.getNameAsString();
        this.configuration = connection.getConfiguration();
        this.executePool = executePool;
        if (executePool == null) {
            int maxThreads = this.configuration.getInt("hbase.htable.privatethreads.max", Integer.MAX_VALUE);
            long keepAliveTime = this.configuration.getLong("hbase.htable.threads.keepalivetime", 60L);
            this.executePool = OHTable.createDefaultThreadPoolExecutor(1, maxThreads, keepAliveTime);
            this.cleanupPoolOnClose = true;
        } else {
            this.cleanupPoolOnClose = false;
        }
        this.rpcTimeout = builder.getRpcTimeout();
        this.readRpcTimeout = builder.getReadRpcTimeout();
        this.writeRpcTimeout = builder.getWriteRpcTimeout();
        this.operationTimeout = builder.getOperationTimeout();
        this.operationExecuteInPool = this.configuration.getBoolean("hbase.client.operation.executeinpool", this.operationTimeout != 1200000);
        this.maxKeyValueSize = connectionConfig.getMaxKeyValueSize();
        this.putWriteBufferCheck = this.configuration.getInt("hbase.htable.put.write.buffer.check", 10);
        this.writeBufferSize = connectionConfig.getWriteBufferSize();
        int numRetries = this.configuration.getInt("hbase.client.retries.number", 15);
        this.obTableClient = ObTableClientManager.getOrCreateObTableClient(this.setUserDefinedNamespace(this.tableNameString, connectionConfig));
        this.obTableClient.setRpcExecuteTimeout(this.rpcTimeout);
        this.obTableClient.setRuntimeRetryTimes(numRetries);
        this.setOperationTimeout(this.operationTimeout);
        this.finishSetUp();
    }

    @InterfaceAudience.Private
    public static ThreadPoolExecutor createDefaultThreadPoolExecutor(int coreSize, int maxThreads, long keepAliveTime) {
        if (System.getProperty("sofa_thread_pool_logging_capability") == null) {
            System.setProperty("sofa_thread_pool_logging_capability", "false");
        }
        SofaThreadPoolExecutor executor = new SofaThreadPoolExecutor(coreSize, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue(), "OHTableDefaultExecutePool", "oceanbase-table-hbase");
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private void finishSetUp() {
        Preconditions.checkArgument(this.configuration != null, "configuration is null.");
        Preconditions.checkArgument(this.tableName != null, "tableNameString is null.");
        Preconditions.checkArgument(this.tableNameString != null, "tableNameString is null.");
        this.scannerTimeout = HBaseConfiguration.getInt((Configuration)this.configuration, (String)"hbase.client.scanner.timeout.period", (String)"hbase.regionserver.lease.period", (int)60000);
        this.rpcTimeout = this.rpcTimeout <= 0 ? this.configuration.getInt("hbase.rpc.timeout", 60000) : this.rpcTimeout;
        this.readRpcTimeout = this.readRpcTimeout <= 0 ? this.configuration.getInt("hbase.rpc.read.timeout", 60000) : this.readRpcTimeout;
        this.writeRpcTimeout = this.writeRpcTimeout <= 0 ? this.configuration.getInt("hbase.rpc.write.timeout", 60000) : this.writeRpcTimeout;
        this.operationTimeout = this.operationTimeout <= 0 ? this.configuration.getInt("hbase.client.operation.timeout", 1200000) : this.operationTimeout;
        this.operationExecuteInPool = this.configuration.getBoolean("hbase.client.operation.executeinpool", this.operationTimeout != 1200000);
        this.maxKeyValueSize = this.configuration.getInt("hbase.client.keyvalue.maxsize", 0xA00000);
        this.putWriteBufferCheck = this.configuration.getInt("hbase.htable.put.write.buffer.check", 10);
        this.writeBufferSize = this.configuration.getLong("hbase.client.write.buffer", 0x200000L);
    }

    private OHConnectionConfiguration setUserDefinedNamespace(String tableNameString, OHConnectionConfiguration ohConnectionConf) throws IllegalArgumentException {
        if (tableNameString.indexOf(58) != -1) {
            String[] params = tableNameString.split(":");
            if (params.length != 2) {
                throw new IllegalArgumentException("Please check the format of self-defined namespace and qualifier: { " + tableNameString + " }");
            }
            String database = params[0];
            Preconditions.checkArgument(StringUtils.isNotBlank((String)database), "self-defined namespace cannot be blank or null { " + tableNameString + " }");
            if (ohConnectionConf.isOdpMode()) {
                ohConnectionConf.setDatabase(database);
            } else {
                String databaseSuffix = "database=" + database;
                String paramUrl = ohConnectionConf.getParamUrl();
                int databasePos = paramUrl.indexOf("database");
                paramUrl = databasePos == -1 ? paramUrl + "&" + databaseSuffix : paramUrl.substring(0, databasePos) + databaseSuffix;
                ohConnectionConf.setParamUrl(paramUrl);
            }
        }
        return ohConnectionConf;
    }

    public TableName getName() {
        return TableName.valueOf((String)this.tableNameString);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HTableDescriptor getTableDescriptor() {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public TableDescriptor getDescriptor() throws IOException {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public boolean exists(Get get) throws IOException {
        Get newGet = new Get(get);
        newGet.setCheckExistenceOnly(true);
        return this.get(newGet).getExists();
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        boolean[] ret = new boolean[gets.size()];
        ArrayList<Get> newGets = new ArrayList<Get>();
        for (Get get : gets) {
            Get newGet = new Get(get);
            newGet.setCheckExistenceOnly(false);
            newGets.add(newGet);
        }
        Result[] results = this.get(newGets);
        for (int i = 0; i < results.length; ++i) {
            ret[i] = !results[i].isEmpty();
        }
        return ret;
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        boolean[] results = this.existsAll(gets);
        boolean[] objectResults = new boolean[results.length];
        for (int i = 0; i < results.length; ++i) {
            objectResults[i] = results[i];
        }
        return objectResults;
    }

    private BatchOperation compatOldServerPut(List<? extends Row> actions, Object[] results, BatchError batchError, int i, List<Row> puts) throws Exception {
        LinkedList<Integer> resultMapSingleOp = new LinkedList<Integer>();
        if (((Put)actions.get(i)).getFamilyCellMap().size() == 1) {
            puts.clear();
            Put put = (Put)actions.get(i++);
            String family = Bytes.toString((byte[])((byte[])put.getFamilyCellMap().firstKey()));
            puts.add((Row)put);
            while (i < actions.size() && actions.get(i) instanceof Put && ((Put)actions.get(i)).getFamilyCellMap().size() == 1 && Objects.equals(Bytes.toString((byte[])((byte[])((Put)actions.get(i)).getFamilyCellMap().firstKey())), family)) {
                puts.add(actions.get(i++));
            }
            String realTableName = OHTable.getTargetTableName(this.tableNameString, family, this.configuration);
            BatchOperation batch = this.buildBatchOperation(realTableName, puts, false, resultMapSingleOp);
            BatchOperationResult tmpResults = batch.execute();
            int index = 0;
            for (int k = 0; k < resultMapSingleOp.size(); ++k) {
                if (tmpResults.getResults().get(index) instanceof ObTableException) {
                    if (results != null) {
                        results[i - puts.size() + k] = tmpResults.getResults().get(index);
                    }
                    batchError.add((Throwable)((ObTableException)tmpResults.getResults().get(index)), actions.get(i - puts.size() + k), null);
                } else if (results != null) {
                    results[i - puts.size() + k] = new Result();
                }
                index += ((Integer)resultMapSingleOp.get(k)).intValue();
            }
            return null;
        }
        Put put = (Put)actions.get(i);
        String realTableName = this.getTargetTableName(this.tableNameString);
        return this.buildBatchOperation(realTableName, Collections.singletonList(put), true, resultMapSingleOp);
    }

    private BatchOperation compatOldServerDel(List<? extends Row> actions, Object[] results, BatchError batchError, int i) throws Exception {
        Delete delete = (Delete)actions.get(i);
        LinkedList<Integer> resultMapSingleOp = new LinkedList<Integer>();
        if (delete.isEmpty()) {
            return this.buildBatchOperation(this.tableNameString, Collections.singletonList(delete), true, resultMapSingleOp);
        }
        if (delete.getFamilyCellMap().size() > 1) {
            boolean has_delete_family = delete.getFamilyCellMap().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).anyMatch(kv -> kv.getType().getCode() == KeyValue.Type.DeleteFamily.getCode() || kv.getType().getCode() == KeyValue.Type.DeleteFamilyVersion.getCode());
            if (!has_delete_family) {
                return this.buildBatchOperation(this.tableNameString, Collections.singletonList(delete), true, resultMapSingleOp);
            }
            for (Map.Entry entry2 : delete.getFamilyCellMap().entrySet()) {
                byte[] family = (byte[])entry2.getKey();
                String realTableName = OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family), this.configuration);
                List cells = (List)entry2.getValue();
                Delete del = new Delete(delete.getRow());
                del.getFamilyCellMap().put(family, cells);
                BatchOperation batch = this.buildBatchOperation(realTableName, Collections.singletonList(del), false, resultMapSingleOp);
                BatchOperationResult tmpResults = batch.execute();
                if (!(tmpResults.getResults().get(0) instanceof ObTableException)) continue;
                if (results != null) {
                    results[i] = tmpResults.getResults().get(0);
                }
                batchError.add((Throwable)((ObTableException)tmpResults.getResults().get(0)), actions.get(i), null);
            }
            if (results != null && results[i] == null) {
                results[i] = new Result();
            }
            return null;
        }
        byte[] family = (byte[])delete.getFamilyCellMap().firstKey();
        String realTableName = OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family), this.configuration);
        return this.buildBatchOperation(realTableName, Collections.singletonList(delete), false, resultMapSingleOp);
    }

    /*
     * WARNING - void declaration
     */
    private void compatOldServerBatch(List<? extends Row> actions, Object[] results, BatchError batchError) throws Exception {
        for (Row row : actions) {
            if (row instanceof Put || row instanceof Delete) continue;
            throw new FeatureNotSupportedException("not supported other type in batch yet,only support put and delete");
        }
        LinkedList<Row> puts = new LinkedList<Row>();
        for (int i = 0; i < actions.size(); ++i) {
            void var5_9;
            if (actions.get(i) instanceof Put) {
                BatchOperation batchOperation = this.compatOldServerPut(actions, results, batchError, i, puts);
                if (!puts.isEmpty()) {
                    i = i + puts.size() - 1;
                }
                puts.clear();
            } else {
                BatchOperation batchOperation = this.compatOldServerDel(actions, results, batchError, i);
            }
            if (var5_9 == null) continue;
            BatchOperationResult tmpResults = var5_9.execute();
            if (tmpResults.getResults().get(0) instanceof ObTableException) {
                if (results != null) {
                    results[i] = tmpResults.getResults().get(0);
                }
                batchError.add((Throwable)((ObTableException)tmpResults.getResults().get(0)), actions.get(i), null);
                continue;
            }
            if (results == null) continue;
            results[i] = new Result();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        BatchOperationResult tmpResults;
        if (actions == null) {
            return;
        }
        if (results != null && results.length != actions.size()) {
            throw new AssertionError((Object)"results.length");
        }
        BatchError batchError = new BatchError();
        this.obTableClient.setRuntimeBatchExecutor(this.executePool);
        LinkedList<Integer> resultMapSingleOp = new LinkedList<Integer>();
        if (!ObGlobal.isHBaseBatchSupport()) {
            try {
                this.compatOldServerBatch(actions, results, batchError);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        String realTableName = this.getTargetTableName(actions);
        BatchOperation batch = this.buildBatchOperation(realTableName, actions, this.tableNameString.equals(realTableName), resultMapSingleOp);
        try {
            tmpResults = batch.execute();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        int index = 0;
        for (int i = 0; i != actions.size(); ++i) {
            if (tmpResults.getResults().get(index) instanceof ObTableException) {
                if (results != null) {
                    results[i] = tmpResults.getResults().get(index);
                }
                batchError.add((Throwable)((ObTableException)tmpResults.getResults().get(index)), actions.get(i), null);
            } else if (actions.get(i) instanceof Get) {
                if (results != null) {
                    if (!(tmpResults.getResults().get(index) instanceof MutationResult)) throw new ObTableUnexpectedException("Unexpected type of result in batch");
                    MutationResult mutationResult = (MutationResult)tmpResults.getResults().get(index);
                    ObPayload innerResult = mutationResult.getResult();
                    if (!(innerResult instanceof ObTableSingleOpResult)) throw new ObTableUnexpectedException("Unexpected type of result in MutationResult");
                    ObTableSingleOpResult singleOpResult = (ObTableSingleOpResult)innerResult;
                    List<Cell> cells = this.generateGetResult(singleOpResult);
                    results[i] = Result.create(cells);
                }
            } else if (results != null) {
                results[i] = new Result();
            }
            index += ((Integer)resultMapSingleOp.get(i)).intValue();
        }
        if (!batchError.hasErrors()) return;
        throw batchError.makeException();
    }

    private List<Cell> generateGetResult(ObTableSingleOpResult getResult) throws IOException {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        ObTableSingleOpEntity singleOpEntity = getResult.getEntity();
        List propertiesValues = singleOpEntity.getPropertiesValues();
        for (int valueIdx = 0; valueIdx < propertiesValues.size(); valueIdx += 4) {
            Object familyAndQualifier = new byte[2][];
            try {
                familyAndQualifier = OHBaseFuncUtils.extractFamilyFromQualifier((byte[])((ObObj)propertiesValues.get(valueIdx + 1)).getValue());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            KeyValue kv = new KeyValue((byte[])((ObObj)propertiesValues.get(valueIdx)).getValue(), familyAndQualifier[0], familyAndQualifier[1], ((Long)((ObObj)propertiesValues.get(valueIdx + 2)).getValue()).longValue(), (byte[])((ObObj)propertiesValues.get(valueIdx + 3)).getValue());
            cells.add((Cell)kv);
        }
        return cells;
    }

    private String getTargetTableName(List<? extends Row> actions) {
        byte[] family = null;
        for (Row row : actions) {
            if (row instanceof RowMutations || row instanceof RegionCoprocessorServiceExec) {
                throw new FeatureNotSupportedException("not supported yet'");
            }
            Set familySet = null;
            if (row instanceof Get) {
                Get get = (Get)row;
                familySet = get.familySet();
            } else {
                org.apache.hadoop.hbase.client.Mutation mutation = (org.apache.hadoop.hbase.client.Mutation)row;
                familySet = mutation.getFamilyCellMap().keySet();
            }
            if (familySet == null) {
                throw new ObTableUnexpectedException("Fail to get family set in action");
            }
            if (familySet.size() != 1) {
                return this.getTargetTableName(this.tableNameString);
            }
            byte[] nextFamily = (byte[])familySet.iterator().next();
            if (family != null && !Arrays.equals(family, nextFamily)) {
                return this.getTargetTableName(this.tableNameString);
            }
            if (family != null) continue;
            family = nextFamily;
        }
        return OHTable.getTargetTableName(this.tableNameString, Bytes.toString(family), this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        try {
            this.batch(actions, results);
        }
        finally {
            if (results != null) {
                for (int i = 0; i < results.length; ++i) {
                    if (results[i] instanceof ObTableException) continue;
                    callback.update(new byte[0], actions.get(i).getRow(), results[i]);
                }
            }
        }
    }

    public static int compareByteArray(byte[] bt1, byte[] bt2) {
        int minLength = Math.min(bt1.length, bt2.length);
        for (int i = 0; i < minLength; ++i) {
            if (bt1[i] == bt2[i]) continue;
            return bt1[i] - bt2[i];
        }
        return bt1.length - bt2.length;
    }

    private void getMaxRowFromResult(AbstractQueryStreamResult clientQueryStreamResult, List<Cell> keyValueList, boolean isTableGroup, byte[] family) throws Exception {
        Object familyAndQualifier = new byte[2][];
        KeyValue kv = null;
        while (clientQueryStreamResult.next()) {
            List row = clientQueryStreamResult.getRow();
            if (row.isEmpty()) {
                keyValueList.add((Cell)new KeyValue());
                return;
            }
            if (kv != null && OHTable.compareByteArray(CellUtil.cloneRow(kv), (byte[])((ObObj)row.get(0)).getValue()) > 0) continue;
            if (kv != null && OHTable.compareByteArray(CellUtil.cloneRow(kv), (byte[])((ObObj)row.get(0)).getValue()) != 0) {
                keyValueList.clear();
            }
            if (isTableGroup) {
                familyAndQualifier = OHBaseFuncUtils.extractFamilyFromQualifier((byte[])((ObObj)row.get(1)).getValue());
            } else {
                familyAndQualifier[0] = family;
                familyAndQualifier[1] = (byte[])((ObObj)row.get(1)).getValue();
            }
            kv = new KeyValue((byte[])((ObObj)row.get(0)).getValue(), familyAndQualifier[0], familyAndQualifier[1], ((Long)((ObObj)row.get(2)).getValue()).longValue(), (byte[])((ObObj)row.get(3)).getValue());
            keyValueList.add((Cell)kv);
        }
    }

    private String getTargetTableName(String tableNameString) {
        if (this.configuration.getBoolean("hbase.htable.test.load.enable", false)) {
            return tableNameString + this.configuration.get("hbase.htable.test.load.suffix", "_t");
        }
        return tableNameString;
    }

    private void processColumnFilters(NavigableSet<byte[]> columnFilters, Map<byte[], NavigableSet<byte[]>> familyMap) {
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : familyMap.entrySet()) {
            if (entry.getValue() != null) {
                for (byte[] columnName : entry.getValue()) {
                    String columnNameStr = Bytes.toString((byte[])columnName);
                    columnNameStr = Bytes.toString((byte[])entry.getKey()) + "." + columnNameStr;
                    columnFilters.add(columnNameStr.getBytes());
                }
                continue;
            }
            String columnNameStr = Bytes.toString((byte[])entry.getKey()) + ".";
            columnFilters.add(columnNameStr.getBytes());
        }
    }

    public Result get(final Get get) throws IOException {
        if (get.getFamilyMap().keySet() != null && !get.getFamilyMap().keySet().isEmpty()) {
            OHTable.checkFamilyViolation(get.getFamilyMap().keySet(), false);
        }
        ServerCallable<Result> serverCallable = new ServerCallable<Result>(this.configuration, this.obTableClient, this.tableNameString, get.getRow(), get.getRow(), this.operationTimeout){

            @Override
            public Result call() throws IOException {
                ArrayList keyValueList = new ArrayList();
                byte[] family = new byte[]{};
                try {
                    if (get.getFamilyMap().keySet() == null || get.getFamilyMap().keySet().isEmpty() || get.getFamilyMap().size() > 1) {
                        if (!get.getColumnFamilyTimeRange().isEmpty()) {
                            throw new FeatureNotSupportedException("setColumnFamilyTimeRange is only supported in single column family for now");
                        }
                        TreeSet columnFilters = new TreeSet(Bytes.BYTES_COMPARATOR);
                        OHTable.this.processColumnFilters(columnFilters, get.getFamilyMap());
                        ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(get, columnFilters);
                        ObTableQueryAsyncRequest request = OHTable.this.buildObTableQueryAsyncRequest(obTableQuery, OHTable.this.getTargetTableName(this.tableNameString));
                        ObTableClientQueryAsyncStreamResult clientQueryStreamResult = (ObTableClientQueryAsyncStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                        OHTable.this.getMaxRowFromResult((AbstractQueryStreamResult)clientQueryStreamResult, keyValueList, true, family);
                    } else {
                        for (Map.Entry entry : get.getFamilyMap().entrySet()) {
                            family = (byte[])entry.getKey();
                            if (!get.getColumnFamilyTimeRange().isEmpty()) {
                                Map colFamTimeRangeMap = get.getColumnFamilyTimeRange();
                                if (colFamTimeRangeMap.size() > 1) {
                                    throw new FeatureNotSupportedException("setColumnFamilyTimeRange is only supported in single column family for now");
                                }
                                if (colFamTimeRangeMap.get(family) == null) {
                                    throw new IllegalArgumentException("Get family is not matched in ColumnFamilyTimeRange");
                                }
                                TimeRange tr = (TimeRange)colFamTimeRangeMap.get(family);
                                get.setTimeRange(tr.getMin(), tr.getMax());
                            }
                            ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(get, (Collection)entry.getValue());
                            ObTableQueryRequest request = OHTable.this.buildObTableQueryRequest(obTableQuery, OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family), OHTable.this.configuration));
                            ObTableClientQueryStreamResult clientQueryStreamResult = (ObTableClientQueryStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                            OHTable.this.getMaxRowFromResult((AbstractQueryStreamResult)clientQueryStreamResult, keyValueList, false, family);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(TableHBaseLoggerFactory.LCD.convert("01-00002"), new Object[]{this.tableNameString, Bytes.toString((byte[])family), e});
                    throw new IOException("query table:" + this.tableNameString + " family " + Bytes.toString((byte[])family) + " error.", e);
                }
                if (get.isCheckExistenceOnly()) {
                    return Result.create(null, (Boolean)(!keyValueList.isEmpty() ? 1 : 0));
                }
                return Result.create(keyValueList);
            }
        };
        return this.executeServerCallable(serverCallable);
    }

    public Result[] get(List<Get> gets) throws IOException {
        Object[] results = new Result[gets.size()];
        if (ObGlobal.isHBaseBatchGetSupport()) {
            this.batch(gets, results);
        } else {
            for (int i = 0; i < gets.size(); ++i) {
                results[i] = this.get(gets.get(i));
            }
        }
        return results;
    }

    public ResultScanner getScanner(final Scan scan) throws IOException {
        if (!scan.getFamilyMap().keySet().isEmpty()) {
            OHTable.checkFamilyViolation(scan.getFamilyMap().keySet(), false);
        }
        ServerCallable<ResultScanner> serverCallable = new ServerCallable<ResultScanner>(this.configuration, this.obTableClient, this.tableNameString, scan.getStartRow(), scan.getStopRow(), this.operationTimeout){

            @Override
            public ResultScanner call() throws IOException {
                byte[] family = new byte[]{};
                try {
                    if (scan.getFamilyMap().keySet() == null || scan.getFamilyMap().keySet().isEmpty() || scan.getFamilyMap().size() > 1) {
                        if (!scan.getColumnFamilyTimeRange().isEmpty()) {
                            throw new FeatureNotSupportedException("setColumnFamilyTimeRange is only supported in single column family for now");
                        }
                        TreeSet columnFilters = new TreeSet(Bytes.BYTES_COMPARATOR);
                        OHTable.this.processColumnFilters(columnFilters, scan.getFamilyMap());
                        ObHTableFilter filter = OHTable.this.buildObHTableFilter(scan.getFilter(), scan.getTimeRange(), scan.getMaxVersions(), columnFilters);
                        ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(filter, scan);
                        ObTableQueryAsyncRequest request = OHTable.this.buildObTableQueryAsyncRequest(obTableQuery, OHTable.this.getTargetTableName(this.tableNameString));
                        ObTableClientQueryAsyncStreamResult clientQueryAsyncStreamResult = (ObTableClientQueryAsyncStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                        return new ClientStreamScanner(clientQueryAsyncStreamResult, this.tableNameString, scan, true);
                    }
                    Iterator columnFilters = scan.getFamilyMap().entrySet().iterator();
                    if (columnFilters.hasNext()) {
                        Map.Entry entry = columnFilters.next();
                        family = (byte[])entry.getKey();
                        if (!scan.getColumnFamilyTimeRange().isEmpty()) {
                            Map colFamTimeRangeMap = scan.getColumnFamilyTimeRange();
                            if (colFamTimeRangeMap.size() > 1) {
                                throw new FeatureNotSupportedException("setColumnFamilyTimeRange is only supported in single column family for now");
                            }
                            if (colFamTimeRangeMap.get(family) == null) {
                                throw new IllegalArgumentException("Scan family is not matched in ColumnFamilyTimeRange");
                            }
                            TimeRange tr = (TimeRange)colFamTimeRangeMap.get(family);
                            scan.setTimeRange(tr.getMin(), tr.getMax());
                        }
                        ObHTableFilter filter = OHTable.this.buildObHTableFilter(scan.getFilter(), scan.getTimeRange(), scan.getMaxVersions(), (Collection)entry.getValue());
                        ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(filter, scan);
                        ObTableQueryAsyncRequest request = OHTable.this.buildObTableQueryAsyncRequest(obTableQuery, OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family), OHTable.this.configuration));
                        ObTableClientQueryAsyncStreamResult clientQueryAsyncStreamResult = (ObTableClientQueryAsyncStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                        return new ClientStreamScanner(clientQueryAsyncStreamResult, this.tableNameString, scan, false);
                    }
                }
                catch (Exception e) {
                    logger.error(TableHBaseLoggerFactory.LCD.convert("01-00003"), new Object[]{this.tableNameString, Bytes.toString((byte[])family), e});
                    throw new IOException("scan table:" + this.tableNameString + " family " + Bytes.toString((byte[])family) + " error.", e);
                }
                throw new IOException("scan table:" + this.tableNameString + "has no family");
            }
        };
        return this.executeServerCallable(serverCallable);
    }

    public List<ResultScanner> getScanners(final Scan scan) throws IOException {
        if (!scan.getFamilyMap().keySet().isEmpty()) {
            OHTable.checkFamilyViolation(scan.getFamilyMap().keySet(), false);
        }
        ServerCallable<List<ResultScanner>> serverCallable = new ServerCallable<List<ResultScanner>>(this.configuration, this.obTableClient, this.tableNameString, scan.getStartRow(), scan.getStopRow(), this.operationTimeout){

            @Override
            public List<ResultScanner> call() throws IOException {
                byte[] family = new byte[]{};
                ArrayList<ResultScanner> resultScanners = new ArrayList<ResultScanner>();
                try {
                    if (scan.getFamilyMap().keySet() == null || scan.getFamilyMap().keySet().isEmpty() || scan.getFamilyMap().size() > 1) {
                        if (!scan.getColumnFamilyTimeRange().isEmpty()) {
                            throw new FeatureNotSupportedException("setColumnFamilyTimeRange is only supported in single column family for now");
                        }
                        TreeSet columnFilters = new TreeSet(Bytes.BYTES_COMPARATOR);
                        OHTable.this.processColumnFilters(columnFilters, scan.getFamilyMap());
                        ObHTableFilter filter = OHTable.this.buildObHTableFilter(scan.getFilter(), scan.getTimeRange(), scan.getMaxVersions(), columnFilters);
                        ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(filter, scan);
                        ObTableQueryAsyncRequest request = OHTable.this.buildObTableQueryAsyncRequest(obTableQuery, OHTable.this.getTargetTableName(this.tableNameString));
                        String phyTableName = this.obTableClient.getPhyTableNameFromTableGroup(request.getObTableQueryRequest(), this.tableNameString);
                        List partitions = this.obTableClient.getPartition(phyTableName, false);
                        for (Partition partition : partitions) {
                            request.getObTableQueryRequest().setTableQueryPartId(partition.getPartId());
                            ObTableClientQueryAsyncStreamResult clientQueryAsyncStreamResult = (ObTableClientQueryAsyncStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                            ClientStreamScanner clientScanner = new ClientStreamScanner(clientQueryAsyncStreamResult, this.tableNameString, scan, true);
                            resultScanners.add((ResultScanner)clientScanner);
                        }
                        return resultScanners;
                    }
                    Iterator columnFilters = scan.getFamilyMap().entrySet().iterator();
                    if (columnFilters.hasNext()) {
                        Map.Entry entry = columnFilters.next();
                        family = (byte[])entry.getKey();
                        if (!scan.getColumnFamilyTimeRange().isEmpty()) {
                            Map colFamTimeRangeMap = scan.getColumnFamilyTimeRange();
                            if (colFamTimeRangeMap.size() > 1) {
                                throw new FeatureNotSupportedException("setColumnFamilyTimeRange is only supported in single column family for now");
                            }
                            if (colFamTimeRangeMap.get(family) == null) {
                                throw new IllegalArgumentException("Scan family is not matched in ColumnFamilyTimeRange");
                            }
                            TimeRange tr = (TimeRange)colFamTimeRangeMap.get(family);
                            scan.setTimeRange(tr.getMin(), tr.getMax());
                        }
                        ObHTableFilter filter = OHTable.this.buildObHTableFilter(scan.getFilter(), scan.getTimeRange(), scan.getMaxVersions(), (Collection)entry.getValue());
                        ObTableQuery obTableQuery = OHTable.this.buildObTableQuery(filter, scan);
                        String targetTableName = OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family), OHTable.this.configuration);
                        ObTableQueryAsyncRequest request = OHTable.this.buildObTableQueryAsyncRequest(obTableQuery, targetTableName);
                        List partitions = this.obTableClient.getPartition(targetTableName, false);
                        for (Partition partition : partitions) {
                            request.getObTableQueryRequest().setTableQueryPartId(partition.getPartId());
                            ObTableClientQueryAsyncStreamResult clientQueryAsyncStreamResult = (ObTableClientQueryAsyncStreamResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
                            ClientStreamScanner clientScanner = new ClientStreamScanner(clientQueryAsyncStreamResult, this.tableNameString, scan, false);
                            resultScanners.add((ResultScanner)clientScanner);
                        }
                        return resultScanners;
                    }
                }
                catch (Exception e) {
                    logger.error(TableHBaseLoggerFactory.LCD.convert("01-00003"), new Object[]{this.tableNameString, Bytes.toString((byte[])family), e});
                    throw new IOException("scan table:" + this.tableNameString + " family " + Bytes.toString((byte[])family) + " error.", e);
                }
                throw new IOException("scan table:" + this.tableNameString + "has no family");
            }
        };
        return this.executeServerCallable(serverCallable);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put) throws IOException {
        this.doPut(Collections.singletonList(put));
    }

    public void put(List<Put> puts) throws IOException {
        this.doPut(puts);
    }

    private void doPut(List<Put> puts) throws IOException {
        int n = 0;
        for (Put put : puts) {
            this.validatePut(put);
            OHTable.checkFamilyViolation(put.getFamilyCellMap().keySet(), true);
            this.writeBuffer.add(put);
            this.currentWriteBufferSize += put.heapSize();
            if (++n % this.putWriteBufferCheck != 0 || this.currentWriteBufferSize <= this.writeBufferSize) continue;
            this.flushCommits();
        }
        if (this.autoFlush || this.currentWriteBufferSize > this.writeBufferSize) {
            this.flushCommits();
        }
    }

    private void validatePut(Put put) {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (this.maxKeyValueSize > 0) {
            for (Map.Entry entry : put.getFamilyCellMap().entrySet()) {
                if (entry.getKey() == null || ((byte[])entry.getKey()).length == 0) {
                    throw new IllegalArgumentException("family is empty");
                }
                for (Cell kv : (List)entry.getValue()) {
                    if (kv.getRowLength() + kv.getValueLength() + kv.getQualifierLength() + Bytes.toBytes((long)kv.getTimestamp()).length + kv.getFamilyLength() <= this.maxKeyValueSize) continue;
                    throw new IllegalArgumentException("KeyValue size too large");
                }
            }
        }
    }

    private ObKVParams buildOBKVParams(Scan scan) {
        ObKVParams obKVParams = new ObKVParams();
        ObHBaseParams obHBaseParams = new ObHBaseParams();
        if (scan != null) {
            obHBaseParams.setCaching(scan.getCaching());
            obHBaseParams.setCallTimeout(this.scannerTimeout);
            obHBaseParams.setCacheBlock(scan.isGetScan());
            obHBaseParams.setAllowPartialResults(scan.getAllowPartialResults());
            obHBaseParams.setHbaseVersion(VersionInfo.getVersion());
        }
        obKVParams.setObParamsBase((ObKVParamsBase)obHBaseParams);
        return obKVParams;
    }

    private ObKVParams buildOBKVParams(Get get) {
        ObKVParams obKVParams = new ObKVParams();
        ObHBaseParams obHBaseParams = new ObHBaseParams();
        obHBaseParams.setCheckExistenceOnly(get.isCheckExistenceOnly());
        obHBaseParams.setCacheBlock(get.getCacheBlocks());
        obHBaseParams.setHbaseVersion(VersionInfo.getVersion());
        obKVParams.setObParamsBase((ObKVParamsBase)obHBaseParams);
        return obKVParams;
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.checkAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, put);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        RowMutations rowMutations = new RowMutations(row);
        rowMutations.add(put);
        try {
            return this.checkAndMutation(row, family, qualifier, compareOp, value, null, rowMutations);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00005"), new Object[]{put, this.tableNameString, e});
            throw new IOException("checkAndPut type table:" + this.tableNameString + " e.msg:" + e.getMessage() + " error.", e);
        }
    }

    private void innerDelete(Delete delete) throws IOException {
        Preconditions.checkArgument(delete.getRow() != null, "row is null");
        try {
            List<Delete> actions = Collections.singletonList(delete);
            Object[] results = new Object[actions.size()];
            this.batch(actions, results);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00004"), (Object)this.tableNameString, (Object)e);
            throw new IOException("delete table " + this.tableNameString + " error.", e);
        }
    }

    public void delete(Delete delete) throws IOException {
        OHTable.checkFamilyViolation(delete.getFamilyCellMap().keySet(), false);
        this.innerDelete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        for (Delete delete : deletes) {
            this.innerDelete(delete);
        }
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, delete);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        RowMutations rowMutations = new RowMutations(row);
        rowMutations.add(delete);
        try {
            return this.checkAndMutation(row, family, qualifier, compareOp, value, null, rowMutations);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00005"), new Object[]{delete, this.tableNameString, e});
            throw new IOException("checkAndDelete type table:" + this.tableNameString + " e.msg:" + e.getMessage() + " error.", e);
        }
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rowMutations) throws IOException {
        try {
            return this.checkAndMutation(row, family, qualifier, compareOp, value, null, rowMutations);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00005"), new Object[]{rowMutations, this.tableNameString, e});
            throw new IOException("checkAndMutate type table:" + this.tableNameString + " e.msg:" + e.getMessage() + " error.", e);
        }
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new ObCheckAndMutateBuilderImpl(row, family);
    }

    private boolean checkAndMutation(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, TimeRange timeRange, RowMutations rowMutations) throws Exception {
        ObTableBatchOperation batch;
        Preconditions.checkArgument(row != null, "row is null");
        Preconditions.checkArgument(StringUtils.isNotBlank((String)Bytes.toString((byte[])family)), "family is blank");
        Preconditions.checkArgument(Bytes.equals((byte[])row, (byte[])rowMutations.getRow()), "mutation row is not equal check row");
        Preconditions.checkArgument(!rowMutations.getMutations().isEmpty(), "mutation is empty");
        byte[] filterString = this.buildCheckAndMutateFilterString(family, qualifier, compareOp, value);
        ObHTableFilter filter = this.buildObHTableFilter(filterString, timeRange, 1, new byte[][]{qualifier});
        List mutations = rowMutations.getMutations();
        LinkedList<Cell> keyValueList = new LinkedList<Cell>();
        for (org.apache.hadoop.hbase.client.Mutation mutation : mutations) {
            OHTable.checkFamilyViolationForOneFamily(mutation.getFamilyCellMap().keySet());
            Preconditions.checkArgument(Arrays.equals(family, (byte[])mutation.getFamilyCellMap().firstEntry().getKey()), "mutation family is not equal check family");
            for (Map.Entry entry : mutation.getFamilyCellMap().entrySet()) {
                keyValueList.addAll((Collection)entry.getValue());
            }
        }
        ObTableQuery obTableQuery = this.buildObTableQuery(filter, row, true, row, true, false);
        ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(obTableQuery, batch = OHTable.buildObTableBatchOperation(keyValueList, false, null), OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family), this.configuration));
        ObTableQueryAndMutateResult result = (ObTableQueryAndMutateResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
        return result.getAffectedRows() > 0L;
    }

    public void mutateRow(RowMutations rm) {
        throw new FeatureNotSupportedException("not supported yet.");
    }

    public Result append(Append append) throws IOException {
        OHTable.checkFamilyViolationForOneFamily(append.getFamilyCellMap().keySet());
        Preconditions.checkArgument(!append.isEmpty(), "append is empty.");
        try {
            byte[] r = append.getRow();
            Map.Entry entry = append.getFamilyCellMap().entrySet().iterator().next();
            byte[] f = (byte[])entry.getKey();
            ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
            ObTableBatchOperation batchOperation = OHTable.buildObTableBatchOperation((List)entry.getValue(), true, qualifiers);
            ObHTableFilter filter = this.buildObHTableFilter(null, null, 1, qualifiers);
            ObTableQuery obTableQuery = this.buildObTableQuery(filter, r, true, r, true, false);
            ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
            queryAndMutate.setTableQuery(obTableQuery);
            queryAndMutate.setMutations(batchOperation);
            ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(obTableQuery, batchOperation, OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])f), this.configuration));
            request.setReturningAffectedEntity(true);
            ObTableQueryAndMutateResult result = (ObTableQueryAndMutateResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
            ObTableQueryResult queryResult = result.getAffectedEntity();
            ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
            for (List row : queryResult.getPropertiesRows()) {
                byte[] k = (byte[])((ObObj)row.get(0)).getValue();
                byte[] q = (byte[])((ObObj)row.get(1)).getValue();
                long t = (Long)((ObObj)row.get(2)).getValue();
                byte[] v = (byte[])((ObObj)row.get(3)).getValue();
                KeyValue kv = new KeyValue(k, f, q, t, v);
                keyValues.add(kv);
            }
            return Result.create(keyValues);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00006"), (Object)this.tableNameString, (Object)e);
            throw new IOException("append table " + this.tableNameString + " error.", e);
        }
    }

    public Result increment(Increment increment) throws IOException {
        OHTable.checkFamilyViolationForOneFamily(increment.getFamilyCellMap().keySet());
        try {
            ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
            byte[] rowKey = increment.getRow();
            Map.Entry entry = increment.getFamilyCellMap().entrySet().iterator().next();
            byte[] f = (byte[])entry.getKey();
            ObTableBatchOperation batch = new ObTableBatchOperation();
            for (Cell cell : (List)entry.getValue()) {
                byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
                qualifiers.add(qualifier);
                batch.addTableOperation(ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.INCREMENT, (Object[])new Object[]{rowKey, qualifier, Long.MAX_VALUE}, (String[])OHConstants.V_COLUMNS, (Object[])new Object[]{CellUtil.cloneValue((Cell)cell)}));
            }
            ObHTableFilter filter = this.buildObHTableFilter(null, increment.getTimeRange(), 1, qualifiers);
            ObTableQuery obTableQuery = this.buildObTableQuery(filter, rowKey, true, rowKey, true, false);
            ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
            queryAndMutate.setMutations(batch);
            queryAndMutate.setTableQuery(obTableQuery);
            ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(obTableQuery, batch, OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])f), this.configuration));
            request.setReturningAffectedEntity(true);
            ObTableQueryAndMutateResult result = (ObTableQueryAndMutateResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
            ObTableQueryResult queryResult = result.getAffectedEntity();
            ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
            for (List row : queryResult.getPropertiesRows()) {
                byte[] k = (byte[])((ObObj)row.get(0)).getValue();
                byte[] q = (byte[])((ObObj)row.get(1)).getValue();
                long t = (Long)((ObObj)row.get(2)).getValue();
                byte[] v = (byte[])((ObObj)row.get(3)).getValue();
                KeyValue kv = new KeyValue(k, f, q, t, v);
                keyValues.add(kv);
            }
            return Result.create(keyValues);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00007"), (Object)this.tableNameString, (Object)e);
            throw new IOException("increment table " + this.tableNameString + " error.", e);
        }
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        try {
            ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
            qualifiers.add(qualifier);
            ObTableBatchOperation batch = new ObTableBatchOperation();
            batch.addTableOperation(ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.INCREMENT, (Object[])new Object[]{row, qualifier, Long.MAX_VALUE}, (String[])OHConstants.V_COLUMNS, (Object[])new Object[]{Bytes.toBytes((long)amount)}));
            ObHTableFilter filter = this.buildObHTableFilter(null, null, 1, qualifiers);
            ObTableQuery obTableQuery = this.buildObTableQuery(filter, row, true, row, true, false);
            ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
            queryAndMutate.setMutations(batch);
            queryAndMutate.setTableQuery(obTableQuery);
            ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(obTableQuery, batch, OHTable.getTargetTableName(this.tableNameString, Bytes.toString((byte[])family), this.configuration));
            request.setReturningAffectedEntity(true);
            ObTableQueryAndMutateResult result = (ObTableQueryAndMutateResult)this.obTableClient.execute((ObTableAbstractOperationRequest)request);
            ObTableQueryResult queryResult = result.getAffectedEntity();
            if (queryResult.getPropertiesRows().size() != 1) {
                throw new IllegalStateException("the increment result size illegal " + queryResult.getPropertiesRows().size());
            }
            return Bytes.toLong((byte[])((byte[])((ObObj)((List)queryResult.getPropertiesRows().get(0)).get(3)).getValue()));
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00007"), (Object)this.tableNameString, (Object)e);
            throw new IOException("increment table " + this.tableNameString + " error.", e);
        }
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCommits() throws IOException {
        try {
            if (this.writeBuffer.isEmpty()) {
                return;
            }
            LinkedHashMap<ObTableException, Put> exceptionRowMap = new LinkedHashMap<ObTableException, Put>();
            boolean[] resultSuccess = new boolean[this.writeBuffer.size()];
            try {
                Object[] results = new Object[this.writeBuffer.size()];
                this.batch(this.writeBuffer, results);
                for (int i = 0; i != resultSuccess.length; ++i) {
                    if (results[i] instanceof ObTableException) {
                        resultSuccess[i] = false;
                        exceptionRowMap.put((ObTableException)results[i], this.writeBuffer.get(i));
                        continue;
                    }
                    resultSuccess[i] = true;
                }
            }
            catch (Exception e) {
                try {
                    logger.error(TableHBaseLoggerFactory.LCD.convert("01-00008"), new Object[]{this.tableNameString, null, this.autoFlush, this.writeBuffer.size(), e});
                    throw new IOException("put table " + this.tableNameString + " error codes " + null + "auto flush " + this.autoFlush + " current buffer size " + this.writeBuffer.size(), e);
                }
                catch (Throwable throwable) {
                    for (int i = resultSuccess.length - 1; i >= 0; --i) {
                        if (!resultSuccess[i]) continue;
                        this.writeBuffer.remove(i);
                    }
                    if (!exceptionRowMap.isEmpty()) {
                        for (Map.Entry entry : exceptionRowMap.entrySet()) {
                            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00008"), new Object[]{entry.getValue(), this.tableNameString, this.autoFlush, this.writeBuffer.size(), entry.getKey()});
                        }
                    }
                    throw throwable;
                }
            }
            for (int i = resultSuccess.length - 1; i >= 0; --i) {
                if (!resultSuccess[i]) continue;
                this.writeBuffer.remove(i);
            }
            if (!exceptionRowMap.isEmpty()) {
                for (Map.Entry entry : exceptionRowMap.entrySet()) {
                    logger.error(TableHBaseLoggerFactory.LCD.convert("01-00008"), new Object[]{entry.getValue(), this.tableNameString, this.autoFlush, this.writeBuffer.size(), entry.getKey()});
                }
            }
        }
        finally {
            if (this.clearBufferOnFail) {
                this.writeBuffer.clear();
                this.currentWriteBufferSize = 0L;
            } else {
                this.currentWriteBufferSize = 0L;
                for (Put aPut : this.writeBuffer) {
                    this.currentWriteBufferSize += aPut.heapSize();
                }
            }
        }
    }

    public void close() throws IOException {
        if (this.cleanupPoolOnClose) {
            this.executePool.shutdown();
        }
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new FeatureNotSupportedException("not supported yet'");
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        throw new FeatureNotSupportedException("not supported yet'");
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new FeatureNotSupportedException("not supported yet'");
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new FeatureNotSupportedException("not supported yet'");
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new FeatureNotSupportedException("not supported yet'");
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
        this.obTableClient.setRuntimeMaxWait((long)operationTimeout);
        this.obTableClient.setRuntimeBatchMaxWait((long)operationTimeout);
        this.operationExecuteInPool = this.configuration.getBoolean("hbase.client.operation.executeinpool", this.operationTimeout != 1200000);
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
        this.obTableClient.setRpcExecuteTimeout(rpcTimeout);
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public int getReadRpcTimeout() {
        return this.readRpcTimeout;
    }

    public int getWriteRpcTimeout() {
        return this.writeRpcTimeout;
    }

    public void setRuntimeBatchExecutor(ExecutorService runtimeBatchExecutor) {
        this.obTableClient.setRuntimeBatchExecutor(runtimeBatchExecutor);
    }

    <T> T executeServerCallable(ServerCallable<T> serverCallable) throws IOException {
        if (!this.operationExecuteInPool) {
            return serverCallable.withRetries();
        }
        long startTime = System.currentTimeMillis();
        Future<T> future = this.executePool.submit(serverCallable);
        try {
            return future.get(this.operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw new IOException("Interrupted");
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                IOException ie;
                Throwable rootCause = ie = (IOException)e.getCause();
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                throw ie;
            }
            throw new IOException(e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            String hostPort = "unknown";
            String regionEncodedName = "unknown";
            throw new OperationTimeoutException("Failed executing operation for table '" + Bytes.toString((byte[])this.tableName) + "' on server " + hostPort + ",region=" + regionEncodedName + ",operationTimeout=" + this.operationTimeout + ",waitTime=" + (System.currentTimeMillis() - startTime));
        }
    }

    public static String getTargetTableName(String tableNameString, String familyString, Configuration conf) {
        Preconditions.checkArgument(tableNameString != null, "tableNameString is null");
        Preconditions.checkArgument(familyString != null, "familyString is null");
        if (conf.getBoolean("hbase.htable.test.load.enable", false)) {
            return OHTable.getTestLoadTargetTableName(tableNameString, familyString, conf);
        }
        return OHTable.getNormalTargetTableName(tableNameString, familyString);
    }

    private static String getNormalTargetTableName(String tableNameString, String familyString) {
        return tableNameString + "$" + familyString;
    }

    private static String getTestLoadTargetTableName(String tableNameString, String familyString, Configuration conf) {
        String suffix = conf.get("hbase.htable.test.load.suffix", "_t");
        return tableNameString + suffix + "$" + familyString;
    }

    private ObHTableFilter buildObHTableFilter(Filter filter, TimeRange timeRange, int maxVersion, Collection<byte[]> columnQualifiers) throws IOException {
        ObHTableFilter obHTableFilter = new ObHTableFilter();
        if (filter != null) {
            obHTableFilter.setFilterString(HBaseFilterUtils.toParseableByteArray(filter));
        }
        if (timeRange != null) {
            obHTableFilter.setMaxStamp(timeRange.getMax());
            obHTableFilter.setMinStamp(timeRange.getMin());
        }
        obHTableFilter.setMaxVersions(maxVersion);
        if (columnQualifiers != null) {
            for (byte[] columnQualifier : columnQualifiers) {
                if (columnQualifier == null) {
                    obHTableFilter.addSelectColumnQualifier(new byte[0]);
                    continue;
                }
                obHTableFilter.addSelectColumnQualifier(columnQualifier);
            }
        }
        return obHTableFilter;
    }

    private byte[] buildCheckAndMutateFilterString(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byteStream.write("CheckAndMutateFilter(".getBytes());
        byteStream.write(HBaseFilterUtils.toParseableByteArray(compareOp));
        byteStream.write(", 'binary:".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, value);
        byteStream.write("', '".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, family);
        byteStream.write("', '".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, qualifier);
        if (value != null) {
            byteStream.write("', false)".getBytes());
        } else {
            byteStream.write("', true)".getBytes());
        }
        return byteStream.toByteArray();
    }

    private ObHTableFilter buildObHTableFilter(byte[] filterString, TimeRange timeRange, int maxVersion, byte[] ... columnQualifiers) {
        ObHTableFilter obHTableFilter = new ObHTableFilter();
        if (filterString != null) {
            obHTableFilter.setFilterString(filterString);
        }
        if (timeRange != null) {
            obHTableFilter.setMaxStamp(timeRange.getMax());
            obHTableFilter.setMinStamp(timeRange.getMin());
        }
        obHTableFilter.setMaxVersions(maxVersion);
        if (columnQualifiers != null) {
            for (byte[] columnQualifier : columnQualifiers) {
                if (columnQualifier == null) {
                    obHTableFilter.addSelectColumnQualifier(new byte[0]);
                    continue;
                }
                obHTableFilter.addSelectColumnQualifier(columnQualifier);
            }
        }
        return obHTableFilter;
    }

    private ObTableQuery buildObTableQuery(ObHTableFilter filter, byte[] start, boolean includeStart, byte[] stop, boolean includeStop, boolean isReversed) {
        ObNewRange obNewRange = new ObNewRange();
        if (Arrays.equals(start, HConstants.EMPTY_BYTE_ARRAY)) {
            obNewRange.setStartKey(ObRowKey.getInstance((ObObj[])new ObObj[]{ObObj.getMin(), ObObj.getMin(), ObObj.getMin()}));
        } else if (includeStart) {
            obNewRange.setStartKey(ObRowKey.getInstance((Object[])new Object[]{start, ObObj.getMin(), ObObj.getMin()}));
        } else {
            obNewRange.setStartKey(ObRowKey.getInstance((Object[])new Object[]{start, ObObj.getMax(), ObObj.getMax()}));
        }
        if (Arrays.equals(stop, HConstants.EMPTY_BYTE_ARRAY)) {
            obNewRange.setEndKey(ObRowKey.getInstance((ObObj[])new ObObj[]{ObObj.getMax(), ObObj.getMax(), ObObj.getMax()}));
        } else if (includeStop) {
            obNewRange.setEndKey(ObRowKey.getInstance((Object[])new Object[]{stop, ObObj.getMax(), ObObj.getMax()}));
        } else {
            obNewRange.setEndKey(ObRowKey.getInstance((Object[])new Object[]{stop, ObObj.getMin(), ObObj.getMin()}));
        }
        ObTableQuery obTableQuery = new ObTableQuery();
        if (isReversed) {
            obTableQuery.setScanOrder(ObScanOrder.Reverse);
        }
        obTableQuery.setIndexName("PRIMARY");
        obTableQuery.sethTableFilter(filter);
        for (String column : OHConstants.ALL_COLUMNS) {
            obTableQuery.addSelectColumn(column);
        }
        obTableQuery.addKeyRange(obNewRange);
        return obTableQuery;
    }

    private ObTableQuery buildObTableQuery(ObHTableFilter filter, Scan scan) {
        if (scan.getMaxResultsPerColumnFamily() > 0) {
            filter.setLimitPerRowPerCf(scan.getMaxResultsPerColumnFamily());
        }
        if (scan.getRowOffsetPerColumnFamily() > 0) {
            filter.setOffsetPerRowPerCf(scan.getRowOffsetPerColumnFamily());
        }
        ObTableQuery obTableQuery = scan.isReversed() ? this.buildObTableQuery(filter, scan.getStopRow(), scan.includeStopRow(), scan.getStartRow(), scan.includeStartRow(), true) : this.buildObTableQuery(filter, scan.getStartRow(), scan.includeStartRow(), scan.getStopRow(), scan.includeStopRow(), false);
        obTableQuery.setBatchSize(scan.getBatch());
        obTableQuery.setLimit(scan.getLimit());
        obTableQuery.setMaxResultSize(scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : this.configuration.getLong("hbase.client.scanner.max.result.size", 0x200000L));
        obTableQuery.setObKVParams(this.buildOBKVParams(scan));
        return obTableQuery;
    }

    private ObTableQuery buildObTableQuery(Get get, Collection<byte[]> columnQualifiers) throws IOException {
        ObTableQuery obTableQuery;
        ObHTableFilter filter = this.buildObHTableFilter(get.getFilter(), get.getTimeRange(), get.getMaxVersions(), columnQualifiers);
        if (get.isClosestRowBefore()) {
            obTableQuery = this.buildObTableQuery(filter, HConstants.EMPTY_BYTE_ARRAY, true, get.getRow(), true, true);
            obTableQuery.setLimit(1);
        } else {
            obTableQuery = this.buildObTableQuery(filter, get.getRow(), true, get.getRow(), true, false);
        }
        obTableQuery.setObKVParams(this.buildOBKVParams(get));
        return obTableQuery;
    }

    public static ObTableBatchOperation buildObTableBatchOperation(List<Cell> keyValueList, boolean putToAppend, List<byte[]> qualifiers) {
        ObTableBatchOperation batch = new ObTableBatchOperation();
        for (Cell kv : keyValueList) {
            if (qualifiers != null) {
                qualifiers.add(CellUtil.cloneQualifier((Cell)kv));
            }
            batch.addTableOperation(OHTable.buildObTableOperation(kv, putToAppend));
        }
        batch.setSameType(true);
        batch.setSamePropertiesNames(true);
        return batch;
    }

    private Mutation buildMutation(Cell kv, OHOpType operationType, boolean isTableGroup, byte[] family) {
        Cell new_cell = kv;
        if (isTableGroup && family != null) {
            new_cell = this.modifyQualifier(kv, (Bytes.toString((byte[])family) + "." + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv))).getBytes());
        }
        switch (operationType) {
            case INSERT_OR_UPDATE: {
                return Mutation.getInstance((ObTableOperationType)ObTableOperationType.INSERT_OR_UPDATE, (String[])OHConstants.ROW_KEY_COLUMNS, (Object[])new Object[]{CellUtil.cloneRow((Cell)new_cell), CellUtil.cloneQualifier((Cell)new_cell), new_cell.getTimestamp()}, (String[])OHConstants.V_COLUMNS, (Object[])new Object[]{CellUtil.cloneValue((Cell)new_cell)});
            }
            case APPEND: {
                return Mutation.getInstance((ObTableOperationType)ObTableOperationType.APPEND, (String[])OHConstants.ROW_KEY_COLUMNS, (Object[])new Object[]{CellUtil.cloneRow((Cell)new_cell), CellUtil.cloneQualifier((Cell)new_cell), new_cell.getTimestamp()}, (String[])OHConstants.V_COLUMNS, (Object[])new Object[]{CellUtil.cloneValue((Cell)new_cell)});
            }
            case Delete: {
                return Mutation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (String[])OHConstants.ROW_KEY_COLUMNS, (Object[])new Object[]{CellUtil.cloneRow((Cell)new_cell), CellUtil.cloneQualifier((Cell)new_cell), new_cell.getTimestamp()}, null, null);
            }
            case DeleteAll: {
                return Mutation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (String[])OHConstants.ROW_KEY_COLUMNS, (Object[])new Object[]{CellUtil.cloneRow((Cell)new_cell), null, -new_cell.getTimestamp()}, null, null);
            }
            case DeleteColumn: {
                return Mutation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (String[])OHConstants.ROW_KEY_COLUMNS, (Object[])new Object[]{CellUtil.cloneRow((Cell)new_cell), CellUtil.cloneQualifier((Cell)new_cell), -new_cell.getTimestamp()}, null, null);
            }
            case DeleteFamily: {
                return Mutation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (String[])OHConstants.ROW_KEY_COLUMNS, (Object[])new Object[]{CellUtil.cloneRow((Cell)new_cell), isTableGroup ? CellUtil.cloneQualifier((Cell)new_cell) : null, -new_cell.getTimestamp()}, null, null);
            }
            case DeleteFamilyVersion: {
                return Mutation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (String[])OHConstants.ROW_KEY_COLUMNS, (Object[])new Object[]{CellUtil.cloneRow((Cell)new_cell), isTableGroup ? CellUtil.cloneQualifier((Cell)new_cell) : null, new_cell.getTimestamp()}, null, null);
            }
        }
        throw new IllegalArgumentException("illegal mutation type " + (Object)((Object)operationType));
    }

    private KeyValue modifyQualifier(Cell original, byte[] newQualifier) {
        byte[] row = CellUtil.cloneRow((Cell)original);
        byte[] family = CellUtil.cloneFamily((Cell)original);
        byte[] value = CellUtil.cloneValue((Cell)original);
        long timestamp = original.getTimestamp();
        KeyValue.Type type = KeyValue.Type.codeToType((byte)original.getType().getCode());
        return new KeyValue(row, family, newQualifier, timestamp, type, value);
    }

    private BatchOperation buildBatchOperation(String tableName, List<? extends Row> actions, boolean isTableGroup, List<Integer> resultMapSingleOp) throws FeatureNotSupportedException, IllegalArgumentException, IOException {
        BatchOperation batch = this.obTableClient.batchOperation(tableName);
        int posInList = -1;
        for (Row row : actions) {
            List keyValueList;
            byte[] family;
            int singleOpResultNum = 0;
            ++posInList;
            if (row instanceof Get) {
                if (!ObGlobal.isHBaseBatchGetSupport()) {
                    throw new FeatureNotSupportedException("server does not support batch get");
                }
                ++singleOpResultNum;
                Get get = (Get)row;
                if ((get.getFamilyMap().keySet().isEmpty() || get.getFamilyMap().size() > 1) && !get.getColumnFamilyTimeRange().isEmpty()) {
                    throw new FeatureNotSupportedException("setColumnFamilyTimeRange is only supported in single column family for now");
                }
                if (get.getFamilyMap().size() == 1 && !get.getColumnFamilyTimeRange().isEmpty()) {
                    byte[] family2 = (byte[])get.getFamilyMap().keySet().iterator().next();
                    Map colFamTimeRangeMap = get.getColumnFamilyTimeRange();
                    if (colFamTimeRangeMap.size() > 1) {
                        throw new FeatureNotSupportedException("setColumnFamilyTimeRange is only supported in single column family for now");
                    }
                    if (colFamTimeRangeMap.get(family2) == null) {
                        throw new IllegalArgumentException("Get family is not matched in ColumnFamilyTimeRange");
                    }
                    TimeRange tr = (TimeRange)colFamTimeRangeMap.get(family2);
                    get.setTimeRange(tr.getMin(), tr.getMax());
                }
                TreeSet<byte[]> columnFilters = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                this.processColumnFilters(columnFilters, get.getFamilyMap());
                ObTableQuery obTableQuery = this.buildObTableQuery(get, columnFilters);
                ObTableClientQueryImpl query = new ObTableClientQueryImpl(tableName, obTableQuery, this.obTableClient);
                try {
                    query.setRowKey(MutationFactory.row((ColumnValue[])new ColumnValue[]{MutationFactory.colVal((String)"K", (Object)Bytes.toString((byte[])get.getRow())), MutationFactory.colVal((String)"Q", null), MutationFactory.colVal((String)"T", null)}));
                }
                catch (Exception e) {
                    logger.error("unexpected error occurs when set row key", (Throwable)e);
                    throw new IOException(e);
                }
                batch.addOperation(new TableQuery[]{query});
            } else if (row instanceof Put) {
                Put put = (Put)row;
                if (put.isEmpty()) {
                    throw new IllegalArgumentException("No columns to insert for #" + (posInList + 1) + " item");
                }
                for (Map.Entry entry : put.getFamilyCellMap().entrySet()) {
                    family = (byte[])entry.getKey();
                    keyValueList = (List)entry.getValue();
                    for (Cell kv : keyValueList) {
                        ++singleOpResultNum;
                        batch.addOperation(new Mutation[]{this.buildMutation(kv, OHOpType.INSERT_OR_UPDATE, isTableGroup, family)});
                    }
                }
            } else if (row instanceof Delete) {
                Delete delete = (Delete)row;
                if (delete.isEmpty()) {
                    ++singleOpResultNum;
                    KeyValue kv = new KeyValue(delete.getRow(), delete.getTimeStamp());
                    batch.addOperation(new Mutation[]{this.buildMutation((Cell)kv, OHOpType.DeleteAll, isTableGroup, null)});
                } else {
                    for (Map.Entry entry : delete.getFamilyCellMap().entrySet()) {
                        family = (byte[])entry.getKey();
                        keyValueList = (List)entry.getValue();
                        for (Cell kv : keyValueList) {
                            ++singleOpResultNum;
                            batch.addOperation(new Mutation[]{this.buildMutation(kv, OHTable.getDeleteType(kv.getType()), isTableGroup, family)});
                        }
                    }
                }
            } else {
                throw new FeatureNotSupportedException("not supported other type in batch yet,only support get, put and delete");
            }
            resultMapSingleOp.add(singleOpResultNum);
        }
        batch.setEntityType(ObTableEntityType.HKV);
        return batch;
    }

    public static ObTableOperation buildObTableOperation(Cell kv, boolean putToAppend) {
        Cell.Type kvType = kv.getType();
        switch (kvType) {
            case Put: {
                ObTableOperationType operationType = putToAppend ? ObTableOperationType.APPEND : ObTableOperationType.INSERT_OR_UPDATE;
                return ObTableOperation.getInstance((ObTableOperationType)operationType, (Object[])new Object[]{CellUtil.cloneRow((Cell)kv), CellUtil.cloneQualifier((Cell)kv), kv.getTimestamp()}, (String[])OHConstants.V_COLUMNS, (Object[])new Object[]{CellUtil.cloneValue((Cell)kv)});
            }
            case Delete: {
                return ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (Object[])new Object[]{CellUtil.cloneRow((Cell)kv), CellUtil.cloneQualifier((Cell)kv), kv.getTimestamp()}, null, null);
            }
            case DeleteColumn: {
                return ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (Object[])new Object[]{CellUtil.cloneRow((Cell)kv), CellUtil.cloneQualifier((Cell)kv), -kv.getTimestamp()}, null, null);
            }
            case DeleteFamily: {
                return ObTableOperation.getInstance((ObTableOperationType)ObTableOperationType.DEL, (Object[])new Object[]{CellUtil.cloneRow((Cell)kv), null, -kv.getTimestamp()}, null, null);
            }
        }
        throw new IllegalArgumentException("illegal mutation type " + kvType);
    }

    private ObTableQueryRequest buildObTableQueryRequest(ObTableQuery obTableQuery, String targetTableName) {
        ObTableQueryRequest request = new ObTableQueryRequest();
        request.setEntityType(ObTableEntityType.HKV);
        request.setTableQuery(obTableQuery);
        request.setTableName(targetTableName);
        return request;
    }

    private ObTableQueryAsyncRequest buildObTableQueryAsyncRequest(ObTableQuery obTableQuery, String targetTableName) {
        ObTableQueryRequest request = new ObTableQueryRequest();
        request.setEntityType(ObTableEntityType.HKV);
        request.setTableQuery(obTableQuery);
        request.setTableName(targetTableName);
        ObTableQueryAsyncRequest asyncRequest = new ObTableQueryAsyncRequest();
        asyncRequest.setEntityType(ObTableEntityType.HKV);
        asyncRequest.setTableName(targetTableName);
        asyncRequest.setObTableQueryRequest(request);
        return asyncRequest;
    }

    public static ObTableBatchOperationRequest buildObTableBatchOperationRequest(ObTableBatchOperation obTableBatchOperation, String targetTableName) {
        ObTableBatchOperationRequest request = new ObTableBatchOperationRequest();
        request.setTableName(targetTableName);
        request.setReturningAffectedRows(true);
        request.setEntityType(ObTableEntityType.HKV);
        request.setBatchOperation(obTableBatchOperation);
        return request;
    }

    private ObTableQueryAndMutateRequest buildObTableQueryAndMutateRequest(ObTableQuery obTableQuery, ObTableBatchOperation obTableBatchOperation, String targetTableName) {
        ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
        queryAndMutate.setTableQuery(obTableQuery);
        queryAndMutate.setMutations(obTableBatchOperation);
        ObTableQueryAndMutateRequest request = new ObTableQueryAndMutateRequest();
        request.setTableName(targetTableName);
        request.setTableQueryAndMutate(queryAndMutate);
        request.setEntityType(ObTableEntityType.HKV);
        request.setReturningAffectedEntity(true);
        return request;
    }

    public static void checkFamilyViolation(Collection<byte[]> families, boolean check_empty_family) {
        if (check_empty_family && (families == null || families.isEmpty())) {
            throw new FeatureNotSupportedException("family is empty");
        }
        for (byte[] family : families) {
            if (family == null || family.length == 0) {
                throw new IllegalArgumentException("family is empty");
            }
            if (!StringUtils.isBlank((String)Bytes.toString((byte[])family))) continue;
            throw new IllegalArgumentException("family is blank");
        }
    }

    public static void checkFamilyViolationForOneFamily(Collection<byte[]> families) {
        if (families == null || families.size() == 0) {
            throw new FeatureNotSupportedException("family is empty.");
        }
        if (families.size() > 1) {
            throw new FeatureNotSupportedException("multi family is not supported yet.");
        }
        for (byte[] family : families) {
            if (family == null || family.length == 0) {
                throw new IllegalArgumentException("family is empty");
            }
            if (!StringUtils.isBlank((String)Bytes.toString((byte[])family))) continue;
            throw new IllegalArgumentException("family is blank");
        }
    }

    public void refreshTableEntry(String familyString, boolean hasTestLoad) throws Exception {
        if (this.obTableClient.isOdpMode()) {
            return;
        }
        this.obTableClient.getOrRefreshTableEntry(OHTable.getNormalTargetTableName(this.tableNameString, familyString), true, true);
        if (hasTestLoad) {
            this.obTableClient.getOrRefreshTableEntry(OHTable.getTestLoadTargetTableName(this.tableNameString, familyString, this.configuration), true, true);
        }
    }

    public byte[][] getStartKeys() throws IOException {
        Object startKeys = new byte[][]{};
        try {
            startKeys = this.obTableClient.getHBaseTableStartKeys(this.tableNameString);
        }
        catch (Exception e) {
            throw new IOException("Fail to get start keys of HBase Table: " + this.tableNameString, e);
        }
        return startKeys;
    }

    public byte[][] getEndKeys() throws IOException {
        Object endKeys = new byte[][]{};
        try {
            endKeys = this.obTableClient.getHBaseTableEndKeys(this.tableNameString);
        }
        catch (Exception e) {
            throw new IOException("Fail to get start keys of HBase Table: " + this.tableNameString, e);
        }
        return endKeys;
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return new Pair((Object)this.getStartKeys(), (Object)this.getEndKeys());
    }

    public static OHOpType getDeleteType(Cell.Type type) {
        switch (type) {
            case Delete: {
                return OHOpType.Delete;
            }
            case DeleteColumn: {
                return OHOpType.DeleteColumn;
            }
            case DeleteFamily: {
                return OHOpType.DeleteFamily;
            }
            case DeleteFamilyVersion: {
                return OHOpType.DeleteFamilyVersion;
            }
        }
        throw new IllegalArgumentException("illegal mutation type " + type);
    }

    private class ObCheckAndMutateBuilderImpl
    implements Table.CheckAndMutateBuilder {
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private byte[] value;
        private TimeRange timeRange;
        private CompareOperator cmpOp;

        ObCheckAndMutateBuilderImpl(byte[] row, byte[] family) {
            this.row = Preconditions.checkNotNull(row, "The provided row is null.");
            this.family = Preconditions.checkNotNull(family, "The provided family is null.");
        }

        public Table.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.qualifier = Preconditions.checkNotNull(qualifier, "The provided qualifier is null. You could use an empty byte array, or do not call this method if you want a null qualifier.");
            return this;
        }

        public Table.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public Table.CheckAndMutateBuilder ifNotExists() {
            this.cmpOp = CompareOperator.EQUAL;
            this.value = null;
            return this;
        }

        public Table.CheckAndMutateBuilder ifMatches(CompareOperator cmpOp, byte[] value) {
            this.cmpOp = Preconditions.checkNotNull(cmpOp, "The provided cmpOp is null.");
            this.value = Preconditions.checkNotNull(value, "The provided value is null.");
            return this;
        }

        public boolean thenPut(Put put) throws IOException {
            this.checkCmpOp();
            RowMutations rowMutations = new RowMutations(this.row);
            rowMutations.add(put);
            try {
                return OHTable.this.checkAndMutation(this.row, this.family, this.qualifier, this.getCompareOp(this.cmpOp), this.value, this.timeRange, rowMutations);
            }
            catch (Exception e) {
                logger.error(TableHBaseLoggerFactory.LCD.convert("01-00005"), new Object[]{rowMutations, OHTable.this.tableNameString, e});
                throw new IOException("checkAndMutate type table: " + OHTable.this.tableNameString + " e.msg: " + e.getMessage() + " error.", e);
            }
        }

        public boolean thenDelete(Delete delete) throws IOException {
            this.checkCmpOp();
            RowMutations rowMutations = new RowMutations(this.row);
            rowMutations.add(delete);
            try {
                return OHTable.this.checkAndMutation(this.row, this.family, this.qualifier, this.getCompareOp(this.cmpOp), this.value, this.timeRange, rowMutations);
            }
            catch (Exception e) {
                logger.error(TableHBaseLoggerFactory.LCD.convert("01-00005"), new Object[]{rowMutations, OHTable.this.tableNameString, e});
                throw new IOException("checkAndMutate type table: " + OHTable.this.tableNameString + " e.msg: " + e.getMessage() + " error.", e);
            }
        }

        public boolean thenMutate(RowMutations mutation) throws IOException {
            this.checkCmpOp();
            try {
                return OHTable.this.checkAndMutation(this.row, this.family, this.qualifier, this.getCompareOp(this.cmpOp), this.value, this.timeRange, mutation);
            }
            catch (Exception e) {
                logger.error(TableHBaseLoggerFactory.LCD.convert("01-00005"), new Object[]{mutation, OHTable.this.tableNameString, e});
                throw new IOException("checkAndMutate type table: " + OHTable.this.tableNameString + " e.msg: " + e.getMessage() + " error.", e);
            }
        }

        private void checkCmpOp() {
            Preconditions.checkNotNull(this.cmpOp, "The compare condition is null. Please use ifNotExists/ifEquals/ifMatches before executing the request");
        }

        private CompareFilter.CompareOp getCompareOp(CompareOperator cmpOp) {
            switch (cmpOp) {
                case LESS: {
                    return CompareFilter.CompareOp.LESS;
                }
                case LESS_OR_EQUAL: {
                    return CompareFilter.CompareOp.LESS_OR_EQUAL;
                }
                case EQUAL: {
                    return CompareFilter.CompareOp.EQUAL;
                }
                case NOT_EQUAL: {
                    return CompareFilter.CompareOp.NOT_EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return CompareFilter.CompareOp.GREATER_OR_EQUAL;
                }
                case GREATER: {
                    return CompareFilter.CompareOp.GREATER;
                }
            }
            return CompareFilter.CompareOp.NO_OP;
        }
    }

    public static enum OHOpType {
        INSERT_OR_UPDATE,
        APPEND,
        Delete,
        DeleteAll,
        DeleteColumn,
        DeleteFamily,
        DeleteFamilyVersion;

    }
}

