/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.ColumnValueFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.ParseConstants;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class HBaseFilterUtils {
    public static byte[] toParseableByteArray(Filter filter) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        HBaseFilterUtils.toParseableByteArray(byteStream, filter);
        return byteStream.toByteArray();
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, Filter filter) throws IOException {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is null");
        }
        if (filter instanceof DependentColumnFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (DependentColumnFilter)filter);
        } else if (filter instanceof CompareFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (CompareFilter)filter);
        } else if (filter instanceof SingleColumnValueExcludeFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (SingleColumnValueExcludeFilter)filter);
        } else if (filter instanceof SingleColumnValueFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (SingleColumnValueFilter)filter);
        } else if (filter instanceof PageFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (PageFilter)filter);
        } else if (filter instanceof ColumnCountGetFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (ColumnCountGetFilter)filter);
        } else if (filter instanceof FirstKeyValueMatchingQualifiersFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (FirstKeyValueMatchingQualifiersFilter)filter);
        } else if (filter instanceof PrefixFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (PrefixFilter)filter);
        } else if (filter instanceof FilterList) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (FilterList)filter);
        } else if (filter instanceof RandomRowFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (RandomRowFilter)filter);
        } else if (filter instanceof ColumnPaginationFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (ColumnPaginationFilter)filter);
        } else if (filter instanceof ColumnPrefixFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (ColumnPrefixFilter)filter);
        } else if (filter instanceof FirstKeyOnlyFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (FirstKeyOnlyFilter)filter);
        } else if (filter instanceof KeyOnlyFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (KeyOnlyFilter)filter);
        } else if (filter instanceof FuzzyRowFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (FuzzyRowFilter)filter);
        } else if (filter instanceof TimestampsFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (TimestampsFilter)filter);
        } else if (filter instanceof ColumnValueFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (ColumnValueFilter)filter);
        } else if (filter instanceof MultiRowRangeFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (MultiRowRangeFilter)filter);
        } else if (filter instanceof InclusiveStopFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (InclusiveStopFilter)filter);
        } else if (filter instanceof ColumnRangeFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (ColumnRangeFilter)filter);
        } else if (filter instanceof MultipleColumnPrefixFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (MultipleColumnPrefixFilter)filter);
        } else if (filter instanceof SkipFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (SkipFilter)filter);
        } else if (filter instanceof WhileMatchFilter) {
            HBaseFilterUtils.toParseableByteArray(byteStream, (WhileMatchFilter)filter);
        } else {
            throw new IllegalArgumentException("Invalid filter: " + filter);
        }
    }

    public static byte[] toParseableByteArray(CompareFilter.CompareOp op) {
        if (op == null) {
            throw new IllegalArgumentException("Compare operator is null");
        }
        switch (op) {
            case LESS: {
                return ParseConstants.LESS_THAN_ARRAY;
            }
            case LESS_OR_EQUAL: {
                return ParseConstants.LESS_THAN_OR_EQUAL_TO_ARRAY;
            }
            case EQUAL: {
                return ParseConstants.EQUAL_TO_ARRAY;
            }
            case NOT_EQUAL: {
                return ParseConstants.NOT_EQUAL_TO_ARRAY;
            }
            case GREATER_OR_EQUAL: {
                return ParseConstants.GREATER_THAN_OR_EQUAL_TO_ARRAY;
            }
            case GREATER: {
                return ParseConstants.GREATER_THAN_ARRAY;
            }
        }
        throw new IllegalArgumentException("Invalid compare operator: " + op);
    }

    public static byte[] toParseableByteArray(CompareOperator op) {
        if (op == null) {
            throw new IllegalArgumentException("Compare operator is null");
        }
        switch (op) {
            case LESS: {
                return ParseConstants.LESS_THAN_ARRAY;
            }
            case LESS_OR_EQUAL: {
                return ParseConstants.LESS_THAN_OR_EQUAL_TO_ARRAY;
            }
            case EQUAL: {
                return ParseConstants.EQUAL_TO_ARRAY;
            }
            case NOT_EQUAL: {
                return ParseConstants.NOT_EQUAL_TO_ARRAY;
            }
            case GREATER_OR_EQUAL: {
                return ParseConstants.GREATER_THAN_OR_EQUAL_TO_ARRAY;
            }
            case GREATER: {
                return ParseConstants.GREATER_THAN_ARRAY;
            }
        }
        throw new IllegalArgumentException("Invalid compare operator: " + op);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, ByteArrayComparable comparator) throws IOException {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator is null");
        }
        byteStream.write(39);
        if (comparator instanceof BinaryComparator) {
            byteStream.write(ParseConstants.binaryType);
        } else if (comparator instanceof BinaryPrefixComparator) {
            byteStream.write(ParseConstants.binaryPrefixType);
        } else if (comparator instanceof RegexStringComparator) {
            byteStream.write(ParseConstants.regexStringType);
        } else if (comparator instanceof SubstringComparator) {
            byteStream.write(ParseConstants.substringType);
        } else {
            throw new IllegalArgumentException("This comparator has not been implemented " + comparator);
        }
        byteStream.write(58);
        HBaseFilterUtils.writeBytesWithEscape(byteStream, comparator.getValue());
        byteStream.write(39);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, CompareFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write(HBaseFilterUtils.toParseableByteArray(filter.getOperator()));
        byteStream.write(44);
        HBaseFilterUtils.toParseableByteArray(byteStream, filter.getComparator());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, SingleColumnValueFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write("('".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getFamily());
        byteStream.write("','".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getQualifier());
        byteStream.write("',".getBytes());
        byteStream.write(HBaseFilterUtils.toParseableByteArray(filter.getOperator()));
        byteStream.write(44);
        HBaseFilterUtils.toParseableByteArray(byteStream, filter.getComparator());
        byteStream.write(44);
        byteStream.write(Boolean.toString(filter.getFilterIfMissing()).getBytes());
        byteStream.write(44);
        byteStream.write(Boolean.toString(filter.getLatestVersionOnly()).getBytes());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, SingleColumnValueExcludeFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write("('".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getFamily());
        byteStream.write("','".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getQualifier());
        byteStream.write("',".getBytes());
        byteStream.write(HBaseFilterUtils.toParseableByteArray(filter.getOperator()));
        byteStream.write(44);
        HBaseFilterUtils.toParseableByteArray(byteStream, filter.getComparator());
        byteStream.write(44);
        byteStream.write(Boolean.toString(filter.getFilterIfMissing()).getBytes());
        byteStream.write(44);
        byteStream.write(Boolean.toString(filter.getLatestVersionOnly()).getBytes());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, PageFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write(Long.toString(filter.getPageSize()).getBytes());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, RandomRowFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write(Integer.toString(Bytes.toInt((byte[])Bytes.toBytes((float)filter.getChance()))).getBytes());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, DependentColumnFilter filter) throws IOException {
        if (filter.getComparator() == null) {
            byteStream.write(filter.getClass().getSimpleName().getBytes());
            byteStream.write("('".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getFamily());
            byteStream.write("','".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getQualifier());
            byteStream.write("',".getBytes());
            byteStream.write(Boolean.toString(filter.getDropDependentColumn()).getBytes());
            byteStream.write(41);
        } else {
            byteStream.write(filter.getClass().getSimpleName().getBytes());
            byteStream.write("('".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getFamily());
            byteStream.write("','".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getQualifier());
            byteStream.write("',".getBytes());
            byteStream.write(Boolean.toString(filter.getDropDependentColumn()).getBytes());
            byteStream.write(44);
            byteStream.write(HBaseFilterUtils.toParseableByteArray(filter.getOperator()));
            byteStream.write(44);
            HBaseFilterUtils.toParseableByteArray(byteStream, filter.getComparator());
            byteStream.write(41);
        }
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, ColumnPaginationFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write(Long.toString(filter.getLimit()).getBytes());
        byteStream.write(44);
        if (filter.getColumnOffset() != null) {
            byteStream.write(39);
            HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getColumnOffset());
            byteStream.write(39);
        } else {
            byteStream.write(Long.toString(filter.getOffset()).getBytes());
        }
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, ColumnPrefixFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write("('".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getPrefix());
        byteStream.write("')".getBytes());
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, FirstKeyOnlyFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, KeyOnlyFilter filter) throws IOException {
        boolean lenAsVal;
        try {
            Field field = filter.getClass().getDeclaredField("lenAsVal");
            field.setAccessible(true);
            lenAsVal = (Boolean)field.get(filter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write(Boolean.toString(lenAsVal).getBytes());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, FuzzyRowFilter filter) throws IOException {
        List fuzzyKeysData;
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        try {
            Field field = filter.getClass().getDeclaredField("fuzzyKeysData");
            field.setAccessible(true);
            fuzzyKeysData = (List)field.get(filter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < fuzzyKeysData.size(); ++i) {
            Pair data = (Pair)fuzzyKeysData.get(i);
            byteStream.write("'".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, (byte[])data.getFirst());
            byteStream.write("'".getBytes());
            byteStream.write(44);
            byteStream.write("'".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, (byte[])data.getSecond());
            byteStream.write("'".getBytes());
            if (i >= fuzzyKeysData.size() - 1) continue;
            byteStream.write(44);
        }
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, TimestampsFilter filter) throws IOException {
        boolean canHint;
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        List timestamps = filter.getTimestamps();
        try {
            Field field = filter.getClass().getDeclaredField("canHint");
            field.setAccessible(true);
            canHint = (Boolean)field.get(filter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < timestamps.size(); ++i) {
            Long timestamp = (Long)timestamps.get(i);
            byteStream.write(Long.toString(timestamp).getBytes());
            byteStream.write(44);
        }
        byteStream.write(Boolean.toString(canHint).getBytes());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, ColumnValueFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write("'".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getFamily());
        byteStream.write("','".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getQualifier());
        byteStream.write("',".getBytes());
        byteStream.write(HBaseFilterUtils.toParseableByteArray(filter.getCompareOperator()));
        byteStream.write(44);
        HBaseFilterUtils.toParseableByteArray(byteStream, filter.getComparator());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, MultiRowRangeFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        List ranges = filter.getRowRanges();
        for (int i = 0; i < ranges.size(); ++i) {
            MultiRowRangeFilter.RowRange range = (MultiRowRangeFilter.RowRange)ranges.get(i);
            byteStream.write("'".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, range.getStartRow());
            byteStream.write("',".getBytes());
            byteStream.write(Boolean.toString(range.isStartRowInclusive()).getBytes());
            byteStream.write(44);
            byteStream.write("'".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, range.getStopRow());
            byteStream.write("',".getBytes());
            byteStream.write(Boolean.toString(range.isStopRowInclusive()).getBytes());
            if (i >= ranges.size() - 1) continue;
            byteStream.write(44);
        }
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, InclusiveStopFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write(39);
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getStopRowKey());
        byteStream.write(39);
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, ColumnRangeFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write("'".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getMinColumn());
        byteStream.write("',".getBytes());
        byteStream.write(Boolean.toString(filter.getMinColumnInclusive()).getBytes());
        byteStream.write(44);
        byteStream.write("'".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getMaxColumn());
        byteStream.write("',".getBytes());
        byteStream.write(Boolean.toString(filter.getMaxColumnInclusive()).getBytes());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, MultipleColumnPrefixFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byte[][] ranges = filter.getPrefix();
        for (int i = 0; i < ranges.length; ++i) {
            byte[] range = ranges[i];
            byteStream.write("'".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, range);
            byteStream.write("'".getBytes());
            if (i >= ranges.length - 1) continue;
            byteStream.write(44);
        }
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, ColumnCountGetFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        byteStream.write(Long.toString(filter.getLimit()).getBytes());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, FirstKeyValueMatchingQualifiersFilter filter) throws IOException {
        Set qualifiers;
        try {
            Field field = filter.getClass().getDeclaredField("qualifiers");
            field.setAccessible(true);
            qualifiers = (Set)field.get(filter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write(40);
        int i = 0;
        for (byte[] qualifier : qualifiers) {
            byteStream.write("'".getBytes());
            HBaseFilterUtils.writeBytesWithEscape(byteStream, qualifier);
            byteStream.write("'".getBytes());
            if (i < qualifiers.size() - 1) {
                byteStream.write(44);
            }
            ++i;
        }
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, PrefixFilter filter) throws IOException {
        byteStream.write(filter.getClass().getSimpleName().getBytes());
        byteStream.write("('".getBytes());
        HBaseFilterUtils.writeBytesWithEscape(byteStream, filter.getPrefix());
        byteStream.write("')".getBytes());
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, SkipFilter filter) throws IOException {
        byteStream.write(40);
        byteStream.write(ParseConstants.SKIP_ARRAY);
        byteStream.write(32);
        HBaseFilterUtils.toParseableByteArray(byteStream, filter.getFilter());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, WhileMatchFilter filter) throws IOException {
        byteStream.write(40);
        byteStream.write(ParseConstants.WHILE_ARRAY);
        byteStream.write(32);
        HBaseFilterUtils.toParseableByteArray(byteStream, filter.getFilter());
        byteStream.write(41);
    }

    private static void toParseableByteArray(ByteArrayOutputStream byteStream, FilterList filterList) throws IOException {
        List filters = filterList.getFilters();
        boolean isEmpty = true;
        ByteArrayOutputStream oneFilterBytes = new ByteArrayOutputStream();
        for (int i = 0; i < filters.size(); ++i) {
            HBaseFilterUtils.toParseableByteArray(oneFilterBytes, (Filter)filters.get(i));
            if (oneFilterBytes.size() == 0) continue;
            if (isEmpty) {
                byteStream.write(40);
                isEmpty = false;
            } else {
                byteStream.write(32);
                if (filterList.getOperator().equals((Object)FilterList.Operator.MUST_PASS_ALL)) {
                    byteStream.write(ParseConstants.AND);
                } else if (filterList.getOperator().equals((Object)FilterList.Operator.MUST_PASS_ONE)) {
                    byteStream.write(ParseConstants.OR);
                } else {
                    throw new IllegalArgumentException("Invalid FilterList: " + filterList);
                }
                byteStream.write(32);
            }
            oneFilterBytes.writeTo(byteStream);
            oneFilterBytes.reset();
        }
        if (!isEmpty) {
            byteStream.write(41);
        }
    }

    public static void writeBytesWithEscape(ByteArrayOutputStream byteStream, byte[] bytes) throws IOException {
        if (bytes == null) {
            return;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 39) {
                byteStream.write(39);
            }
            byteStream.write(bytes[i]);
        }
    }
}

