/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.util;

import com.alipay.oceanbase.rpc.property.Property;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class OHConnectionConfiguration {
    private String paramUrl;
    private String database;
    private final Properties properties;
    private final String fullUsername;
    private final String password;
    private final String sysUsername;
    private final String sysPassword;
    private final String odpAddr;
    private final int odpPort;
    private final boolean odpMode;
    private final long writeBufferSize;
    private final int operationTimeout;
    private final int metaOperationTimeout;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final int maxKeyValueSize;
    private final int rpcTimeout;
    private final int readRpcTimeout;
    private final int writeRpcTimeout;
    private final int rpcConnectTimeout;
    private final long writeBufferPeriodicFlushTimeoutMs;
    private final long writeBufferPeriodicFlushTimerTickMs;

    public OHConnectionConfiguration(Configuration conf) {
        this.paramUrl = conf.get("hbase.oceanbase.paramURL");
        this.fullUsername = conf.get("hbase.oceanbase.fullUserName");
        this.password = conf.get("hbase.oceanbase.password");
        this.sysUsername = conf.get("hbase.oceanbase.sysUserName");
        this.sysPassword = conf.get("hbase.oceanbase.sysPassword");
        this.odpAddr = conf.get("hbase.oceanbase.odpAddr");
        this.odpPort = conf.getInt("hbase.oceanbase.odpPort", -1);
        this.odpMode = conf.getBoolean("hbase.oceanbase.odpMode", false);
        String database = conf.get("hbase.oceanbase.database");
        if (StringUtils.isBlank((String)database)) {
            database = "default";
        }
        this.database = database;
        this.writeBufferSize = conf.getLong("hbase.client.write.buffer", 0x200000L);
        this.metaOperationTimeout = conf.getInt("hbase.client.meta.operation.timeout", 1200000);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
        this.readRpcTimeout = conf.getInt("hbase.rpc.read.timeout", 60000);
        this.writeRpcTimeout = conf.getInt("hbase.rpc.write.timeout", 60000);
        this.writeBufferPeriodicFlushTimeoutMs = conf.getLong("hbase.client.write.buffer.periodicflush.timeout.ms", 0L);
        this.writeBufferPeriodicFlushTimerTickMs = conf.getLong("hbase.client.write.buffer.periodicflush.timertick.ms", 1000L);
        int rpcConnectTimeout = -1;
        rpcConnectTimeout = conf.get("hbase.ipc.client.socket.timeout.connect") != null ? conf.getInt("hbase.ipc.client.socket.timeout.connect", 10000) : (conf.get("ipc.socket.timeout") != null ? conf.getInt("ipc.socket.timeout", 20000) : conf.getInt("hbase.ipc.client.socket.timeout.connect", 10000));
        this.rpcConnectTimeout = rpcConnectTimeout;
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.maxKeyValueSize = conf.getInt("hbase.client.keyvalue.maxsize", 0xA00000);
        this.properties = new Properties();
        for (Property property : Property.values()) {
            String value = conf.get(property.getKey());
            if (value == null) continue;
            this.properties.put(property.getKey(), value);
        }
    }

    public void setParamUrl(String paramUrl) {
        this.paramUrl = paramUrl;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public int getMetaOperationTimeout() {
        return this.metaOperationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public int getReadRpcTimeout() {
        return this.readRpcTimeout;
    }

    public int getWriteRpcTimeout() {
        return this.writeRpcTimeout;
    }

    public int getRpcConnectTimeout() {
        return this.rpcConnectTimeout;
    }

    public long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getOdpPort() {
        return this.odpPort;
    }

    public String getSysPassword() {
        return this.sysPassword;
    }

    public String getSysUsername() {
        return this.sysUsername;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFullUsername() {
        return this.fullUsername;
    }

    public String getParamUrl() {
        return this.paramUrl;
    }

    public String getOdpAddr() {
        return this.odpAddr;
    }

    public boolean isOdpMode() {
        return this.odpMode;
    }

    public String getDatabase() {
        return this.database;
    }

    public long getWriteBufferPeriodicFlushTimeoutMs() {
        return this.writeBufferPeriodicFlushTimeoutMs;
    }

    public long getWriteBufferPeriodicFlushTimerTickMs() {
        return this.writeBufferPeriodicFlushTimerTickMs;
    }
}

