/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc;

import com.alibaba.fastjson.JSON;
import com.alipay.oceanbase.rpc.Lifecycle;
import com.alipay.oceanbase.rpc.ObClusterTableBatchOps;
import com.alipay.oceanbase.rpc.ObClusterTableQuery;
import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.checkandmutate.CheckAndInsUp;
import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.exception.ObTableAuthException;
import com.alipay.oceanbase.rpc.exception.ObTableCloseException;
import com.alipay.oceanbase.rpc.exception.ObTableEntryRefreshException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableGetException;
import com.alipay.oceanbase.rpc.exception.ObTableNeedFetchAllException;
import com.alipay.oceanbase.rpc.exception.ObTableNotExistException;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionNoMasterException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableRetryExhaustedException;
import com.alipay.oceanbase.rpc.exception.ObTableRoutingWrongException;
import com.alipay.oceanbase.rpc.exception.ObTableServerCacheExpiredException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.get.Get;
import com.alipay.oceanbase.rpc.location.LocationUtil;
import com.alipay.oceanbase.rpc.location.model.ObIndexInfo;
import com.alipay.oceanbase.rpc.location.model.ObReadConsistency;
import com.alipay.oceanbase.rpc.location.model.ObRoutePolicy;
import com.alipay.oceanbase.rpc.location.model.ObServerAddr;
import com.alipay.oceanbase.rpc.location.model.ObServerInfo;
import com.alipay.oceanbase.rpc.location.model.ObServerLdcItem;
import com.alipay.oceanbase.rpc.location.model.ObServerLdcLocation;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.ObUserAuth;
import com.alipay.oceanbase.rpc.location.model.OcpModel;
import com.alipay.oceanbase.rpc.location.model.ReplicaLocation;
import com.alipay.oceanbase.rpc.location.model.RouteTableRefresher;
import com.alipay.oceanbase.rpc.location.model.ServerRoster;
import com.alipay.oceanbase.rpc.location.model.TableEntry;
import com.alipay.oceanbase.rpc.location.model.TableEntryKey;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartIdCalculator;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionInfo;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionLevel;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionLocationInfo;
import com.alipay.oceanbase.rpc.location.model.partition.ObRangePartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.Partition;
import com.alipay.oceanbase.rpc.mutation.Append;
import com.alipay.oceanbase.rpc.mutation.BatchOperation;
import com.alipay.oceanbase.rpc.mutation.Delete;
import com.alipay.oceanbase.rpc.mutation.Increment;
import com.alipay.oceanbase.rpc.mutation.Insert;
import com.alipay.oceanbase.rpc.mutation.InsertOrUpdate;
import com.alipay.oceanbase.rpc.mutation.Put;
import com.alipay.oceanbase.rpc.mutation.Replace;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.mutation.Update;
import com.alipay.oceanbase.rpc.property.Property;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObFetchPartitionMetaRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObFetchPartitionMetaResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObFetchPartitionMetaType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableAbstractOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableApiMove;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOptionFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation.ObTableAggregation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutate;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutateRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutateResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObBorderFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncRequest;
import com.alipay.oceanbase.rpc.table.AbstractObTableClient;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableClientBatchOpsImpl;
import com.alipay.oceanbase.rpc.table.ObTableClientQueryImpl;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableBatchOps;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import com.alipay.oceanbase.rpc.threadlocal.ThreadLocalMap;
import com.alipay.oceanbase.rpc.util.MonitorUtil;
import com.alipay.oceanbase.rpc.util.StringUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import com.alipay.oceanbase.rpc.util.ZoneUtil;
import com.alipay.remoting.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class ObTableClient
extends AbstractObTableClient
implements Lifecycle {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableClient.class);
    private static final String usernameSeparators = ":;-;.";
    private AtomicInteger tableEntryRefreshContinuousFailureCount = new AtomicInteger(0);
    private String dataSourceName;
    private String paramURL;
    private String fullUserName;
    private String userName;
    private String tenantName;
    private String clusterName;
    private String password;
    private String database;
    private ObUserAuth sysUA = new ObUserAuth("proxyro@sys", "");
    private volatile OcpModel ocpModel = new OcpModel();
    private volatile ConcurrentHashMap<ObServerAddr, ObTable> tableRoster = null;
    private final ServerRoster serverRoster = new ServerRoster();
    private volatile RunningMode runningMode = RunningMode.NORMAL;
    private Map<String, TableEntry> tableLocations = new ConcurrentHashMap<String, TableEntry>();
    private Map<String, TableEntry> ODPTableLocations = new ConcurrentHashMap<String, TableEntry>();
    private Map<String, ObIndexInfo> indexinfos = new ConcurrentHashMap<String, ObIndexInfo>();
    private ConcurrentHashMap<String, Lock> refreshIndexInfoLocks = new ConcurrentHashMap();
    private Map<String, Map<String, Integer>> tableRowKeyElement = new ConcurrentHashMap<String, Map<String, Integer>>();
    private boolean retryOnChangeMasterTimes = true;
    private ConcurrentHashMap<String, AtomicLong> tableContinuousFailures = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Lock> refreshTableLocks = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Lock> fetchODPPartitionLocks = new ConcurrentHashMap();
    private Lock refreshMetadataLock = new ReentrantLock();
    private volatile long lastRefreshMetadataTimestamp;
    private volatile boolean initialized = false;
    private volatile boolean closed = false;
    private ReentrantLock statusLock = new ReentrantLock();
    private String currentIDC;
    private ObReadConsistency readConsistency = ObReadConsistency.STRONG;
    private ObRoutePolicy obRoutePolicy = ObRoutePolicy.IDC_ORDER;
    private boolean odpMode = false;
    private String odpAddr = "127.0.0.1";
    private int odpPort = 2883;
    private ObTable odpTable = null;
    private ConcurrentHashMap<String, Lock> TableGroupCacheLocks = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> TableGroupCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> TableGroupInverted = new ConcurrentHashMap();
    private RouteTableRefresher routeTableRefresher;
    private Long clientId;
    private Map<String, Object> TableConfigs = new HashMap<String, Object>();

    @Override
    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.statusLock.lock();
        try {
            if (this.initialized) {
                return;
            }
            this.clientId = Math.abs(UUID.randomUUID().getLeastSignificantBits());
            this.initTableConfigs();
            this.initProperties();
            this.initMetadata();
            this.routeTableRefresher = new RouteTableRefresher(this);
            this.routeTableRefresher.start();
            this.initialized = true;
        }
        catch (Throwable t) {
            TableClientLoggerFactory.BOOT.warn("failed to init ObTableClient", t);
            TableClientLoggerFactory.RUNTIME.warn("failed to init ObTableClient", t);
            throw new RuntimeException(t);
        }
        finally {
            TableClientLoggerFactory.BOOT.info("init ObTableClient successfully");
            this.statusLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.statusLock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.routeTableRefresher != null) {
                this.routeTableRefresher.finish();
            }
            if (this.tableRoster != null) {
                Exception throwException = null;
                ArrayList<ObServerAddr> exceptionObServers = new ArrayList<ObServerAddr>();
                for (Map.Entry<ObServerAddr, ObTable> entry : this.tableRoster.entrySet()) {
                    try {
                        entry.getValue().close();
                    }
                    catch (Exception e) {
                        TableClientLoggerFactory.BOOT.error(TableClientLoggerFactory.LCD.convert("01-00004"), (Object)entry.getKey(), (Object)e);
                        TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00004"), (Object)entry.getKey(), (Object)e);
                        throwException = e;
                        exceptionObServers.add(entry.getKey());
                    }
                }
                if (exceptionObServers.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("following ob servers [");
                    for (int i = 0; i < exceptionObServers.size(); ++i) {
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append(exceptionObServers.get(i));
                    }
                    sb.append("] close error.");
                    throw new ObTableCloseException(sb.toString(), throwException);
                }
            }
            if (this.odpTable != null) {
                this.odpTable.close();
            }
        }
        finally {
            TableClientLoggerFactory.BOOT.info("ObTableClient is closed");
            this.statusLock.unlock();
        }
    }

    public RouteTableRefresher getRouteTableRefresher() {
        return this.routeTableRefresher;
    }

    public Map<String, TableEntry> getTableLocations() {
        return this.tableLocations;
    }

    public void checkStatus() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("param url " + this.paramURL + "fullUserName " + this.fullUserName + " is not initialized");
        }
        if (this.closed) {
            throw new IllegalStateException("param url " + this.paramURL + " fullUserName " + this.fullUserName + " is closed");
        }
    }

    public Long getClientId() {
        return this.clientId;
    }

    public Map<String, Object> getTableConfigs() {
        return this.TableConfigs;
    }

    private void initTableConfigs() {
        this.TableConfigs.put("client_id", this.clientId);
        this.TableConfigs.put("runtime", new HashMap());
        this.TableConfigs.put("log", new HashMap());
        this.TableConfigs.put("route", new HashMap());
        this.TableConfigs.put("thread_pool", new HashMap());
    }

    private void initProperties() {
        this.rpcConnectTimeout = this.parseToInt(Property.RPC_CONNECT_TIMEOUT.getKey(), this.rpcConnectTimeout);
        this.metadataRefreshInterval = this.parseToLong(Property.METADATA_REFRESH_INTERVAL.getKey(), this.metadataRefreshInterval);
        this.metadataRefreshInterval = this.parseToLong(Property.METADATA_REFRESH_INTERNAL.getKey(), this.metadataRefreshInterval);
        this.metadataRefreshLockTimeout = this.parseToLong(Property.METADATA_REFRESH_LOCK_TIMEOUT.getKey(), this.metadataRefreshLockTimeout);
        this.rsListAcquireConnectTimeout = this.parseToInt(Property.RS_LIST_ACQUIRE_CONNECT_TIMEOUT.getKey(), this.rsListAcquireConnectTimeout);
        this.rsListAcquireReadTimeout = this.parseToInt(Property.RS_LIST_ACQUIRE_READ_TIMEOUT.getKey(), this.rsListAcquireReadTimeout);
        this.rsListAcquireTryTimes = this.parseToInt(Property.RS_LIST_ACQUIRE_TRY_TIMES.getKey(), this.rsListAcquireTryTimes);
        this.rsListAcquireRetryInterval = this.parseToLong(Property.RS_LIST_ACQUIRE_RETRY_INTERVAL.getKey(), this.rsListAcquireRetryInterval);
        this.rsListAcquireRetryInterval = this.parseToLong(Property.RS_LIST_ACQUIRE_RETRY_INTERNAL.getKey(), this.rsListAcquireRetryInterval);
        this.tableEntryAcquireConnectTimeout = this.parseToLong(Property.TABLE_ENTRY_ACQUIRE_CONNECT_TIMEOUT.getKey(), this.tableEntryAcquireConnectTimeout);
        this.tableEntryAcquireSocketTimeout = this.parseToLong(Property.TABLE_ENTRY_ACQUIRE_SOCKET_TIMEOUT.getKey(), this.tableEntryAcquireSocketTimeout);
        this.tableEntryRefreshIntervalBase = this.parseToLong(Property.TABLE_ENTRY_REFRESH_INTERVAL_BASE.getKey(), this.tableEntryRefreshIntervalBase);
        this.tableEntryRefreshIntervalBase = this.parseToLong(Property.TABLE_ENTRY_REFRESH_INTERNAL_BASE.getKey(), this.tableEntryRefreshIntervalBase);
        this.tableEntryRefreshIntervalCeiling = this.parseToLong(Property.TABLE_ENTRY_REFRESH_INTERVAL_CEILING.getKey(), this.tableEntryRefreshIntervalCeiling);
        this.tableEntryRefreshIntervalCeiling = this.parseToLong(Property.TABLE_ENTRY_REFRESH_INTERNAL_CEILING.getKey(), this.tableEntryRefreshIntervalCeiling);
        this.tableEntryRefreshIntervalWait = this.parseToBoolean(Property.TABLE_ENTRY_REFRESH_INTERVAL_WAIT.getKey(), this.tableEntryRefreshIntervalWait);
        this.tableEntryRefreshLockTimeout = this.parseToLong(Property.TABLE_ENTRY_REFRESH_LOCK_TIMEOUT.getKey(), this.tableEntryRefreshLockTimeout);
        this.ODPTableEntryRefreshLockTimeout = this.parseToLong(Property.ODP_TABLE_ENTRY_REFRESH_LOCK_TIMEOUT.getKey(), this.ODPTableEntryRefreshLockTimeout);
        this.tableEntryRefreshTryTimes = this.parseToInt(Property.TABLE_ENTRY_REFRESH_TRY_TIMES.getKey(), this.tableEntryRefreshTryTimes);
        this.tableEntryRefreshContinuousFailureCeiling = this.parseToInt(Property.TABLE_ENTRY_REFRESH_CONTINUOUS_FAILURE_CEILING.getKey(), this.tableEntryRefreshContinuousFailureCeiling);
        this.serverAddressPriorityTimeout = this.parseToLong(Property.SERVER_ADDRESS_PRIORITY_TIMEOUT.getKey(), this.serverAddressPriorityTimeout);
        this.serverAddressCachingTimeout = this.parseToLong(Property.SERVER_ADDRESS_CACHING_TIMEOUT.getKey(), this.serverAddressCachingTimeout);
        this.runtimeContinuousFailureCeiling = this.parseToInt(Property.RUNTIME_CONTINUOUS_FAILURE_CEILING.getKey(), this.runtimeContinuousFailureCeiling);
        this.runtimeRetryTimes = this.parseToInt(Property.RUNTIME_RETRY_TIMES.getKey(), this.runtimeRetryTimes);
        this.runtimeRetryInterval = this.parseToInt(Property.RUNTIME_RETRY_INTERVAL.getKey(), this.runtimeRetryInterval);
        this.runtimeMaxWait = this.parseToLong(Property.RUNTIME_MAX_WAIT.getKey(), this.runtimeMaxWait);
        this.runtimeBatchMaxWait = this.parseToLong(Property.RUNTIME_BATCH_MAX_WAIT.getKey(), this.runtimeBatchMaxWait);
        this.rpcExecuteTimeout = this.parseToInt(Property.RPC_EXECUTE_TIMEOUT.getKey(), this.rpcExecuteTimeout);
        this.rpcLoginTimeout = this.parseToInt(Property.RPC_LOGIN_TIMEOUT.getKey(), this.rpcLoginTimeout);
        this.slowQueryMonitorThreshold = this.parseToLong(Property.SLOW_QUERY_MONITOR_THRESHOLD.getKey(), this.slowQueryMonitorThreshold);
        this.maxConnExpiredTime = this.parseToLong(Property.MAX_CONN_EXPIRED_TIME.getKey(), this.maxConnExpiredTime);
        Object value = this.TableConfigs.get("runtime");
        if (value instanceof Map) {
            Map runtimeMap = (Map)value;
            runtimeMap.put(Property.RUNTIME_RETRY_TIMES.getKey(), String.valueOf(this.runtimeRetryTimes));
            runtimeMap.put(Property.RPC_EXECUTE_TIMEOUT.getKey(), String.valueOf(this.rpcExecuteTimeout));
            runtimeMap.put(Property.RUNTIME_MAX_WAIT.getKey(), String.valueOf(this.runtimeMaxWait));
            runtimeMap.put(Property.RUNTIME_RETRY_INTERVAL.getKey(), String.valueOf(this.runtimeRetryInterval));
            runtimeMap.put(Property.RUNTIME_RETRY_TIMES.getKey(), String.valueOf(this.runtimeRetryTimes));
            runtimeMap.put(Property.MAX_CONN_EXPIRED_TIME.getKey(), String.valueOf(this.maxConnExpiredTime));
        }
        if ((value = this.TableConfigs.get("log")) instanceof Map) {
            Map logMap = (Map)value;
            logMap.put(Property.SLOW_QUERY_MONITOR_THRESHOLD.getKey(), String.valueOf(this.slowQueryMonitorThreshold));
        }
        if ((value = this.TableConfigs.get("route")) instanceof Map) {
            Map routeMap = (Map)value;
            routeMap.put(Property.METADATA_REFRESH_INTERVAL.getKey(), String.valueOf(this.metadataRefreshInterval));
            routeMap.put(Property.RUNTIME_CONTINUOUS_FAILURE_CEILING.getKey(), String.valueOf(this.runtimeContinuousFailureCeiling));
            routeMap.put(Property.SERVER_ADDRESS_CACHING_TIMEOUT.getKey(), String.valueOf(this.serverAddressCachingTimeout));
            routeMap.put(Property.SERVER_ADDRESS_PRIORITY_TIMEOUT.getKey(), String.valueOf(this.serverAddressPriorityTimeout));
            routeMap.put(Property.TABLE_ENTRY_ACQUIRE_CONNECT_TIMEOUT.getKey(), String.valueOf(this.tableEntryAcquireConnectTimeout));
            routeMap.put(Property.TABLE_ENTRY_ACQUIRE_SOCKET_TIMEOUT.getKey(), String.valueOf(this.tableEntryAcquireSocketTimeout));
            routeMap.put(Property.TABLE_ENTRY_REFRESH_INTERVAL_BASE.getKey(), String.valueOf(this.tableEntryRefreshIntervalBase));
            routeMap.put(Property.TABLE_ENTRY_REFRESH_INTERVAL_CEILING.getKey(), String.valueOf(this.tableEntryRefreshIntervalCeiling));
            routeMap.put(Property.TABLE_ENTRY_REFRESH_TRY_TIMES.getKey(), String.valueOf(this.tableEntryRefreshTryTimes));
        }
        Boolean useExecutor = false;
        if (this.runtimeBatchExecutor != null) {
            useExecutor = true;
        }
        if ((value = this.TableConfigs.get("thread_pool")) instanceof Map) {
            Map threadPoolMap = (Map)value;
            threadPoolMap.put(Property.RUNTIME_BATCH_EXECUTOR.getKey(), useExecutor);
        }
    }

    private void initMetadata() throws Exception {
        TableClientLoggerFactory.BOOT.info("begin initMetadata for all tables in database: {}", (Object)this.database);
        if (this.odpMode) {
            try {
                this.odpTable = new ObTable.Builder(this.odpAddr, this.odpPort).setLoginInfo(this.tenantName, this.fullUserName, this.password, this.database).setProperties(this.getProperties()).setConfigs(this.TableConfigs).build();
            }
            catch (Exception e) {
                logger.warn("The addr{}:{} failed to put into table roster, the node status may be wrong, Ignore", (Object)this.odpAddr, (Object)this.odpPort);
                throw e;
            }
            return;
        }
        this.ocpModel = LocationUtil.loadOcpModel(this.paramURL, this.dataSourceName, this.rsListAcquireConnectTimeout, this.rsListAcquireReadTimeout, this.rsListAcquireTryTimes, this.rsListAcquireRetryInterval);
        ArrayList<ObServerAddr> servers = new ArrayList<ObServerAddr>();
        ConcurrentHashMap<ObServerAddr, ObTable> tableRoster = new ConcurrentHashMap<ObServerAddr, ObTable>();
        TableEntryKey rootServerKey = new TableEntryKey(this.clusterName, this.tenantName, "oceanbase", "__all_dummy");
        List<ObServerAddr> rsList = this.ocpModel.getObServerAddrs();
        TableClientLoggerFactory.BOOT.info("{} success to get rsList, paramURL: {}, rsList: {}\uff0cidc2Region: {}", new Object[]{this.database, this.paramURL, JSON.toJSON(rsList), JSON.toJSON(this.ocpModel.getIdc2Region())});
        TableEntry tableEntry = LocationUtil.loadTableEntryRandomly(rsList, rootServerKey, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.sysUA, this.initialized);
        TableClientLoggerFactory.BOOT.info("{} success to get tableEntry with rootServerKey all_dummy_tables {}", (Object)this.database, JSON.toJSON((Object)tableEntry));
        List<ReplicaLocation> replicaLocations = tableEntry.getTableLocation().getReplicaLocations();
        TableClientLoggerFactory.BOOT.info("{} success to get replicaLocation {}", (Object)this.database, JSON.toJSON(replicaLocations));
        for (ReplicaLocation replicaLocation : replicaLocations) {
            ObServerInfo info = replicaLocation.getInfo();
            ObServerAddr addr = replicaLocation.getAddr();
            if (!info.isActive()) {
                TableClientLoggerFactory.BOOT.warn("will not init location {} because status is {}", (Object)addr.toString(), (Object)info.getStatus());
                continue;
            }
            try {
                ObTable obTable = new ObTable.Builder(addr.getIp(), addr.getSvrPort()).setLoginInfo(this.tenantName, this.userName, this.password, this.database).setProperties(this.getProperties()).setConfigs(this.TableConfigs).build();
                tableRoster.put(addr, obTable);
                servers.add(addr);
            }
            catch (Exception e) {
                TableClientLoggerFactory.BOOT.warn("The addr{}:{} failed to put into table roster, the node status may be wrong, Ignore", (Object)addr.getIp(), (Object)addr.getSvrPort());
                TableClientLoggerFactory.RUNTIME.warn("initMetadata meet exception", (Throwable)e);
                e.printStackTrace();
            }
        }
        if (servers.isEmpty()) {
            TableClientLoggerFactory.BOOT.error("{} failed to connect any replicaLocation server: {}", (Object)this.database, JSON.toJSON(replicaLocations));
            throw new Exception("failed to connect any replicaLocation server");
        }
        TableClientLoggerFactory.BOOT.info("{} success to build server connection {}", (Object)this.database, JSON.toJSON(servers));
        this.tableRoster = tableRoster;
        this.serverRoster.reset(servers);
        if (StringUtil.isEmpty(this.currentIDC)) {
            this.currentIDC = ZoneUtil.getCurrentIDC();
        }
        String regionFromOcp = this.ocpModel.getIdc2Region(this.currentIDC);
        TableClientLoggerFactory.BOOT.info("{} success get currentIDC {}, regionFromOcp {}", new Object[]{this.database, this.currentIDC, regionFromOcp});
        List<ObServerLdcItem> ldcServers = LocationUtil.getServerLdc(this.serverRoster, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.serverAddressPriorityTimeout, this.serverAddressCachingTimeout, this.sysUA);
        this.serverRoster.resetServerLdc(ObServerLdcLocation.buildLdcLocation(ldcServers, this.currentIDC, regionFromOcp));
        if (TableClientLoggerFactory.BOOT.isInfoEnabled()) {
            TableClientLoggerFactory.BOOT.info("{} finish refresh serverRoster: {}", (Object)this.database, JSON.toJSON((Object)this.serverRoster));
            TableClientLoggerFactory.BOOT.info("finish initMetadata for all tables for database {}", (Object)this.database);
        }
        this.lastRefreshMetadataTimestamp = System.currentTimeMillis();
    }

    public boolean isOdpMode() {
        return this.odpMode;
    }

    public void setOdpMode(boolean odpMode) {
        this.odpMode = odpMode;
    }

    public ObTable getOdpTable() {
        return this.odpTable;
    }

    private <T> T execute(String tableName, TableExecuteCallback<T> callback) throws Exception {
        return this.execute(tableName, callback, this.getRoute(false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(String tableName, TableExecuteCallback<T> callback, ObServerRoute route) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        boolean needRefreshTableEntry = false;
        boolean needFetchAllRouteInfo = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        while (true) {
            this.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > this.runtimeMaxWait) {
                throw new ObTableTimeoutExcetion("it has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + this.runtimeMaxWait + "/ms");
            }
            ++tryTimes;
            ObPair<Long, ObTableParam> obPair = null;
            try {
                obPair = this.odpMode ? new ObPair<Long, ObTableParam>(0L, new ObTableParam(this.odpTable)) : this.getTable(tableName, callback.getRowKey(), needRefreshTableEntry, this.tableEntryRefreshIntervalWait, needFetchAllRouteInfo, route);
                T t = callback.execute(obPair);
                this.resetExecuteContinuousFailureCount(tableName);
                return t;
            }
            catch (Exception ex) {
                block14: {
                    block17: {
                        block16: {
                            block15: {
                                if (!this.odpMode) break block15;
                                if (tryTimes - 1 >= this.runtimeRetryTimes) {
                                    TableClientLoggerFactory.RUNTIME.error("retry failed with exception", (Throwable)ex);
                                    throw ex;
                                }
                                if (ex instanceof ObTableException) {
                                    logger.warn("execute while meet Exception, errorCode: {} , errorMsg: {}, try times {}", new Object[]{((ObTableException)ex).getErrorCode(), ex.getMessage(), tryTimes});
                                    break block14;
                                } else {
                                    logger.warn("execute while meet Exception, errorMsg: {}, try times {}", (Object)ex.getMessage(), (Object)tryTimes);
                                }
                                break block14;
                            }
                            if (!(ex instanceof ObTableReplicaNotReadableException)) break block16;
                            if (obPair != null && tryTimes - 1 < this.runtimeRetryTimes) {
                                logger.warn("retry when replica not readable: {}", (Object)ex.getMessage());
                                if (!this.odpMode) {
                                    route.addToBlackList(obPair.getRight().getObTable().getIp());
                                }
                                break block14;
                            } else {
                                logger.warn("exhaust retry when replica not readable: {}", (Object)ex.getMessage());
                                TableClientLoggerFactory.RUNTIME.error("replica not readable", (Throwable)ex);
                                throw ex;
                            }
                        }
                        if (!(ex instanceof ObTableException) || !((ObTableException)ex).isNeedRefreshTableEntry()) break block17;
                        needRefreshTableEntry = true;
                        if (this.retryOnChangeMasterTimes && tryTimes - 1 < this.runtimeRetryTimes) {
                            if (ex instanceof ObTableNeedFetchAllException) {
                                needFetchAllRouteInfo = true;
                                this.getOrRefreshTableEntry(tableName, true, true, true);
                                this.resetExecuteContinuousFailureCount(tableName);
                            }
                            break block14;
                        } else {
                            this.calculateContinuousFailure(tableName, ex.getMessage());
                            throw ex;
                        }
                    }
                    String logMessage = String.format("exhaust retry while meet NeedRefresh Exception, table name: %s, batch ops refresh table, errorCode: %d", tableName, ((ObTableException)ex).getErrorCode());
                    logger.warn(logMessage, (Throwable)ex);
                    this.calculateContinuousFailure(tableName, ex.getMessage());
                    throw new ObTableRetryExhaustedException(logMessage, ex);
                }
                Thread.sleep(this.runtimeRetryInterval);
                continue;
            }
            break;
        }
    }

    private <T> T execute(String tableName, OperationExecuteCallback<T> callback) throws Exception {
        return this.execute(tableName, callback, this.getRoute(false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(String tableName, OperationExecuteCallback<T> callback, ObServerRoute route) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        boolean needRefreshTableEntry = false;
        boolean needFetchAllRouteInfo = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        while (true) {
            this.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > this.runtimeMaxWait) {
                throw new ObTableTimeoutExcetion("it has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + this.runtimeMaxWait + "/ms");
            }
            ++tryTimes;
            ObPair<Long, ObTableParam> obPair = null;
            try {
                if (this.odpMode) {
                    obPair = new ObPair<Long, ObTableParam>(0L, new ObTableParam(this.odpTable));
                } else if (null != callback.getRowKey()) {
                    if (tryTimes > 1) {
                        TableEntry entry = this.getOrRefreshTableEntry(tableName, false, false, false);
                        Long partId = this.getPartition(entry, callback.getRowKey());
                        if (ObGlobal.obVsnMajor() >= 4) {
                            this.refreshTableLocationByTabletId(entry, tableName, this.getTabletIdByPartId(entry, partId));
                        }
                    }
                    obPair = this.getTable(tableName, callback.getRowKey(), needRefreshTableEntry, this.tableEntryRefreshIntervalWait, false, route);
                } else {
                    if (null == callback.getKeyRanges()) {
                        throw new ObTableException("RowKey or scan range is null");
                    }
                    obPair = this.getTable(tableName, new ObTableQuery(), callback.getKeyRanges());
                }
                T t = callback.execute(obPair);
                this.resetExecuteContinuousFailureCount(tableName);
                return t;
            }
            catch (Exception ex) {
                block22: {
                    block25: {
                        block24: {
                            block23: {
                                TableClientLoggerFactory.RUNTIME.error("execute while meet exception", (Throwable)ex);
                                if (!this.odpMode) break block23;
                                if (tryTimes - 1 >= this.runtimeRetryTimes) {
                                    TableClientLoggerFactory.RUNTIME.error("retry failed with exception", (Throwable)ex);
                                    throw ex;
                                }
                                if (ex instanceof ObTableException) {
                                    logger.warn("execute while meet Exception, errorCode: {} , errorMsg: {}, try times {}", new Object[]{((ObTableException)ex).getErrorCode(), ex.getMessage(), tryTimes});
                                    break block22;
                                } else {
                                    logger.warn("execute while meet Exception, exception: {}, try times {}", (Object)ex, (Object)tryTimes);
                                }
                                break block22;
                            }
                            if (!(ex instanceof ObTableReplicaNotReadableException)) break block24;
                            if (obPair != null && tryTimes - 1 < this.runtimeRetryTimes) {
                                logger.warn("retry when replica not readable: {}", (Object)ex.getMessage());
                                if (!this.odpMode) {
                                    route.addToBlackList(obPair.getRight().getObTable().getIp());
                                }
                                break block22;
                            } else {
                                logger.warn("exhaust retry when replica not readable: {}", (Object)ex.getMessage());
                                TableClientLoggerFactory.RUNTIME.error("replica not readable", (Throwable)ex);
                                throw ex;
                            }
                        }
                        if (!(ex instanceof ObTableException) || !((ObTableException)ex).isNeedRefreshTableEntry()) break block25;
                        if (this.tableRowKeyElement.get(tableName) == null) {
                            logger.warn("tableRowKeyElement not found table name: {}", (Object)ex.getMessage());
                            TableClientLoggerFactory.RUNTIME.error("tableRowKeyElement not found table name", (Throwable)ex);
                            throw ex;
                        }
                        needRefreshTableEntry = true;
                        if (this.retryOnChangeMasterTimes && tryTimes - 1 < this.runtimeRetryTimes) {
                            if (ex instanceof ObTableNeedFetchAllException) {
                                this.getOrRefreshTableEntry(tableName, true, true, true);
                                this.resetExecuteContinuousFailureCount(tableName);
                            }
                            break block22;
                        } else {
                            String logMessage = String.format("exhaust retry while meet NeedRefresh Exception, table name: %s, retry times: %d, errorCode: %d", tableName, this.runtimeRetryTimes, ((ObTableException)ex).getErrorCode());
                            logger.warn(logMessage, (Throwable)ex);
                            this.calculateContinuousFailure(tableName, ex.getMessage());
                            throw new ObTableRetryExhaustedException(logMessage, ex);
                        }
                    }
                    this.calculateContinuousFailure(tableName, ex.getMessage());
                    TableClientLoggerFactory.RUNTIME.error("execute while meet exception", (Throwable)ex);
                    throw ex;
                }
                Thread.sleep(this.runtimeRetryInterval);
                continue;
            }
            break;
        }
    }

    public void calculateContinuousFailure(String tableName, String errorMsg) throws Exception {
        AtomicLong tempFailures = new AtomicLong();
        AtomicLong failures = this.tableContinuousFailures.putIfAbsent(tableName, tempFailures);
        AtomicLong atomicLong = failures = failures == null ? tempFailures : failures;
        if (failures.incrementAndGet() > (long)this.runtimeContinuousFailureCeiling) {
            logger.warn("refresh table entry {} while execute failed times exceeded {}, msg: {}", new Object[]{tableName, this.runtimeContinuousFailureCeiling, errorMsg});
            this.getOrRefreshTableEntry(tableName, true, this.isTableEntryRefreshIntervalWait(), true);
            failures.set(0L);
        } else {
            logger.warn("error msg: {}, current continues failure count: {}", (Object)errorMsg, (Object)failures);
        }
    }

    public void resetExecuteContinuousFailureCount(String tableName) {
        AtomicLong failures = this.tableContinuousFailures.get(tableName);
        if (failures != null) {
            failures.set(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRefreshMetadata() throws Exception {
        block10: {
            if (System.currentTimeMillis() - this.lastRefreshMetadataTimestamp < this.metadataRefreshInterval) {
                logger.warn("try to lock metadata refreshing, it has refresh  at: {}, dataSourceName: {}, url: {}", new Object[]{this.lastRefreshMetadataTimestamp, this.dataSourceName, this.paramURL});
                return;
            }
            boolean acquired = this.refreshMetadataLock.tryLock(this.metadataRefreshLockTimeout, TimeUnit.MILLISECONDS);
            if (!acquired) {
                String errMsg = "try to lock metadata refreshing timeout dataSource:" + this.dataSourceName + " + refresh timeout:" + this.tableEntryRefreshLockTimeout + ".";
                TableClientLoggerFactory.RUNTIME.error(errMsg);
                throw new ObTableGetException(errMsg);
            }
            if (System.currentTimeMillis() - this.lastRefreshMetadataTimestamp >= this.metadataRefreshInterval) break block10;
            logger.warn("it has refresh metadata at: {}, dataSourceName: {}, url: {}", new Object[]{this.lastRefreshMetadataTimestamp, this.dataSourceName, this.paramURL});
            this.refreshMetadataLock.unlock();
            logger.warn("finish refresh all ob servers, ts: {}, dataSourceName: {}, url: {}", new Object[]{this.lastRefreshMetadataTimestamp, this.dataSourceName, this.paramURL});
            return;
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info("start refresh metadata, ts: {}, dataSourceName: {}, url: {}", new Object[]{this.lastRefreshMetadataTimestamp, this.dataSourceName, this.paramURL});
            }
            this.ocpModel = LocationUtil.loadOcpModel(this.paramURL, this.dataSourceName, this.rsListAcquireConnectTimeout, this.rsListAcquireReadTimeout, this.rsListAcquireTryTimes, this.rsListAcquireRetryInterval);
            TableEntryKey allDummyKey = new TableEntryKey(this.clusterName, this.tenantName, "oceanbase", "__all_dummy");
            List<ObServerAddr> rsList = this.ocpModel.getObServerAddrs();
            TableEntry tableEntry = LocationUtil.loadTableEntryRandomly(rsList, allDummyKey, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.sysUA, this.initialized);
            List<ReplicaLocation> replicaLocations = tableEntry.getTableLocation().getReplicaLocations();
            ArrayList<ObServerAddr> servers = new ArrayList<ObServerAddr>();
            for (ReplicaLocation replicaLocation : replicaLocations) {
                ObServerAddr addr = replicaLocation.getAddr();
                ObServerInfo info = replicaLocation.getInfo();
                if (!info.isActive()) {
                    logger.warn("will not refresh location {} because status is {} stop time {}", new Object[]{addr.toString(), info.getStatus(), info.getStopTime()});
                    continue;
                }
                servers.add(addr);
                if (this.tableRoster.containsKey(addr)) continue;
                ObTable obTable = new ObTable.Builder(addr.getIp(), addr.getSvrPort()).setLoginInfo(this.tenantName, this.userName, this.password, this.database).setProperties(this.getProperties()).setConfigs(this.getTableConfigs()).build();
                ObTable oldObTable = this.tableRoster.putIfAbsent(addr, obTable);
                logger.warn("add new table addr, {}", (Object)addr.toString());
                if (oldObTable == null) continue;
                obTable.close();
            }
            for (ObServerAddr addr : this.tableRoster.keySet()) {
                if (servers.contains(addr)) continue;
                ObTable table = this.tableRoster.remove(addr);
                logger.warn("remove useless table addr, {}", (Object)addr.toString());
                if (table == null) continue;
                table.close();
            }
            this.serverRoster.reset(servers);
            List<ObServerLdcItem> ldcServers = LocationUtil.getServerLdc(this.serverRoster, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.serverAddressPriorityTimeout, this.serverAddressCachingTimeout, this.sysUA);
            String regionFromOcp = this.ocpModel.getIdc2Region(this.currentIDC);
            this.serverRoster.resetServerLdc(ObServerLdcLocation.buildLdcLocation(ldcServers, this.currentIDC, regionFromOcp));
            if (logger.isInfoEnabled()) {
                logger.info("finish refresh serverRoster: {}", JSON.toJSON((Object)this.serverRoster));
            }
            this.lastRefreshMetadataTimestamp = System.currentTimeMillis();
            this.refreshMetadataLock.unlock();
        }
        catch (Throwable throwable) {
            this.refreshMetadataLock.unlock();
            logger.warn("finish refresh all ob servers, ts: {}, dataSourceName: {}, url: {}", new Object[]{this.lastRefreshMetadataTimestamp, this.dataSourceName, this.paramURL});
            throw throwable;
        }
        logger.warn("finish refresh all ob servers, ts: {}, dataSourceName: {}, url: {}", new Object[]{this.lastRefreshMetadataTimestamp, this.dataSourceName, this.paramURL});
    }

    public String getIndexTableName(String dataTableName, String indexName, List<String> scanRangeColumns, boolean forceRefreshIndexInfo) throws Exception {
        String indexTableName = dataTableName;
        if (indexName != null && !indexName.isEmpty() && !indexName.equalsIgnoreCase("PRIMARY")) {
            String tmpTableName = this.constructIndexTableName(dataTableName, indexName);
            if (tmpTableName == null) {
                throw new ObTableException("index table name is null");
            }
            ObIndexInfo indexInfo = this.getOrRefreshIndexInfo(tmpTableName, forceRefreshIndexInfo);
            if (indexInfo == null) {
                throw new ObTableException("index info is null, indexTableName:" + tmpTableName);
            }
            if (indexInfo.getIndexType().isGlobalIndex()) {
                indexTableName = tmpTableName;
                if (scanRangeColumns.isEmpty()) {
                    throw new ObTableException("query by global index need add all index keys in order, indexTableName:" + indexTableName);
                }
                this.addRowKeyElement(indexTableName, scanRangeColumns.toArray(new String[scanRangeColumns.size()]));
            }
        }
        return indexTableName;
    }

    @Override
    public void setRpcExecuteTimeout(int rpcExecuteTimeout) {
        this.properties.put(Property.RPC_EXECUTE_TIMEOUT.getKey(), String.valueOf(rpcExecuteTimeout));
        this.rpcExecuteTimeout = rpcExecuteTimeout;
        if (null != this.tableRoster) {
            for (ObTable obTable : this.tableRoster.values()) {
                if (obTable == null) continue;
                obTable.setObTableExecuteTimeout(rpcExecuteTimeout);
            }
        }
        if (null != this.odpTable) {
            this.odpTable.setObTableExecuteTimeout(rpcExecuteTimeout);
        }
    }

    public String constructIndexTableName(String dataTableName, String indexName) throws Exception {
        TableEntry entry = this.tableLocations.get(dataTableName);
        Long dataTableId = null;
        try {
            if (entry == null) {
                ObServerAddr addr = this.serverRoster.getServer(this.serverAddressPriorityTimeout, this.serverAddressCachingTimeout);
                dataTableId = LocationUtil.getTableIdFromRemote(addr, this.sysUA, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.tenantName, this.database, dataTableName);
            } else {
                dataTableId = entry.getTableId();
            }
        }
        catch (Exception e) {
            TableClientLoggerFactory.RUNTIME.error("get index table name exception", (Throwable)e);
            throw e;
        }
        return "__idx_" + dataTableId + "_" + indexName;
    }

    public ObIndexInfo getOrRefreshIndexInfo(String indexTableName, boolean forceRefresh) throws Exception {
        ObIndexInfo indexInfo = this.indexinfos.get(indexTableName);
        if (!forceRefresh && indexInfo != null) {
            return indexInfo;
        }
        ReentrantLock tempLock = new ReentrantLock();
        Lock lock = this.refreshIndexInfoLocks.putIfAbsent(indexTableName, tempLock);
        lock = lock == null ? tempLock : lock;
        boolean acquired = lock.tryLock(this.tableEntryRefreshLockTimeout, TimeUnit.MILLISECONDS);
        if (!acquired) {
            String errMsg = "try to lock index infos refreshing timeout dataSource:" + this.dataSourceName + " ,indexTableName:" + indexTableName + " , timeout:" + this.tableEntryRefreshLockTimeout + ".";
            TableClientLoggerFactory.RUNTIME.error(errMsg);
            throw new ObTableEntryRefreshException(errMsg);
        }
        try {
            indexInfo = this.indexinfos.get(indexTableName);
            if (!forceRefresh && indexInfo != null) {
                ObIndexInfo errMsg = indexInfo;
                return errMsg;
            }
            logger.info("index info is not exist, create new index info, indexTableName: {}", (Object)indexTableName);
            int serverSize = this.serverRoster.getMembers().size();
            int refreshTryTimes = this.tableEntryRefreshTryTimes > serverSize ? serverSize : this.tableEntryRefreshTryTimes;
            for (int i = 0; i < refreshTryTimes; ++i) {
                ObServerAddr serverAddr = this.serverRoster.getServer(this.serverAddressPriorityTimeout, this.serverAddressCachingTimeout);
                indexInfo = LocationUtil.getIndexInfoFromRemote(serverAddr, this.sysUA, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, indexTableName);
                if (indexInfo != null) {
                    this.indexinfos.put(indexTableName, indexInfo);
                    continue;
                }
                TableClientLoggerFactory.RUNTIME.error("get index info from remote is null, indexTableName: {}", (Object)indexTableName);
            }
            ObIndexInfo obIndexInfo = indexInfo;
            return obIndexInfo;
        }
        catch (Exception e) {
            TableClientLoggerFactory.RUNTIME.error("getOrRefresh index info meet exception", (Throwable)e);
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public TableEntry getOrRefreshTableEntry(String tableName, boolean refresh, boolean waitForRefresh) throws Exception {
        return this.getOrRefreshTableEntry(tableName, refresh, waitForRefresh, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableEntry getOrRefreshTableEntry(String tableName, boolean refresh, boolean waitForRefresh, boolean fetchAll) throws Exception {
        TableEntry tableEntry;
        block29: {
            int refreshTryTimes;
            block28: {
                ReentrantLock tempLock;
                Lock lock;
                boolean acquired;
                if (tableName == null) throw new IllegalArgumentException("table name is null");
                if (tableName.isEmpty()) {
                    throw new IllegalArgumentException("table name is null");
                }
                tableEntry = this.tableLocations.get(tableName);
                if (tableEntry != null) {
                    if (!refresh) {
                        return tableEntry;
                    }
                    long punishInterval = (long)((double)this.tableEntryRefreshIntervalBase * Math.pow(2.0, -this.serverRoster.getMaxPriority()));
                    punishInterval = Math.min(punishInterval, this.tableEntryRefreshIntervalCeiling);
                    long current = System.currentTimeMillis();
                    long interval = current - tableEntry.getRefreshTimeMills();
                    long fetchAllInterval = current - tableEntry.getRefreshAllTimeMills();
                    if (fetchAll && fetchAllInterval < punishInterval || !fetchAll && interval < punishInterval) {
                        if (!waitForRefresh) return tableEntry;
                        long toHoldTime = fetchAll ? punishInterval - fetchAllInterval : punishInterval - interval;
                        logger.info("punish table entry {} : table entry refresh time {} punish interval {} current time {}. wait for refresh times {}ms", new Object[]{tableName, tableEntry.getRefreshTimeMills(), punishInterval, current, toHoldTime});
                        try {
                            Thread.sleep(toHoldTime);
                        }
                        catch (InterruptedException e) {
                            TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00018"), new Object[]{tableName, punishInterval, e});
                            throw new ObTableUnexpectedException("waiting for table entry " + tableName + " punish interval " + punishInterval + " is interrupted.");
                        }
                    }
                }
                if (!(acquired = (lock = (lock = this.refreshTableLocks.putIfAbsent(tableName, tempLock = new ReentrantLock())) == null ? tempLock : lock).tryLock(this.tableEntryRefreshLockTimeout, TimeUnit.MILLISECONDS))) {
                    String errMsg = "try to lock table-entry refreshing timeout dataSource:" + this.dataSourceName + " ,tableName:" + tableName + ", refresh:" + refresh + " , timeout:" + this.tableEntryRefreshLockTimeout + ".";
                    TableClientLoggerFactory.RUNTIME.error(errMsg);
                    throw new ObTableEntryRefreshException(errMsg);
                }
                tableEntry = this.tableLocations.get(tableName);
                if (tableEntry != null) {
                    long punishInterval = (long)((double)this.tableEntryRefreshIntervalBase * Math.pow(2.0, -this.serverRoster.getMaxPriority()));
                    punishInterval = Math.min(punishInterval, this.tableEntryRefreshIntervalCeiling);
                    long interval = System.currentTimeMillis() - tableEntry.getRefreshTimeMills();
                    long fetchAllInterval = System.currentTimeMillis() - tableEntry.getRefreshAllTimeMills();
                    if (fetchAll && fetchAllInterval < punishInterval || !fetchAll && interval < punishInterval) {
                        TableEntry tableEntry2 = tableEntry;
                        return tableEntry2;
                    }
                }
                if (tableEntry == null || refresh) {
                    if (logger.isInfoEnabled()) {
                        if (tableEntry == null) {
                            logger.info("tableEntry not exist, create new table entry, tablename: {}", (Object)tableName);
                        } else {
                            logger.info("tableEntry need refresh, create new table entry, tablename: {}", (Object)tableName);
                        }
                    }
                    int serverSize = this.serverRoster.getMembers().size();
                    refreshTryTimes = Math.min(this.tableEntryRefreshTryTimes, serverSize);
                    break block28;
                } else {
                    TableEntry tableEntry3 = tableEntry;
                    return tableEntry3;
                }
                finally {
                    lock.unlock();
                }
            }
            for (int i = 0; i < refreshTryTimes; ++i) {
                try {
                    TableEntry fetchAllInterval = this.refreshTableEntry(tableEntry, tableName, fetchAll);
                    return fetchAllInterval;
                }
                catch (ObTableNotExistException e) {
                    TableClientLoggerFactory.RUNTIME.error("getOrRefreshTableEntry meet exception", (Throwable)e);
                    throw e;
                }
                catch (ObTableServerCacheExpiredException e) {
                    TableClientLoggerFactory.RUNTIME.error("getOrRefreshTableEntry meet exception", (Throwable)e);
                    if (logger.isInfoEnabled()) {
                        logger.info("server addr is expired and it will refresh metadata.");
                    }
                    this.syncRefreshMetadata();
                    this.tableEntryRefreshContinuousFailureCount.set(0);
                    continue;
                }
                catch (ObTableEntryRefreshException e) {
                    TableClientLoggerFactory.RUNTIME.error("getOrRefreshTableEntry meet exception", (Throwable)e);
                    if (this.tableRowKeyElement.get(tableName) == null) {
                        throw e;
                    }
                    if (this.tableEntryRefreshContinuousFailureCount.incrementAndGet() <= this.tableEntryRefreshContinuousFailureCeiling) continue;
                    logger.error(TableClientLoggerFactory.LCD.convert("01-00019"), (Object)this.tableEntryRefreshContinuousFailureCeiling);
                    this.syncRefreshMetadata();
                    this.tableEntryRefreshContinuousFailureCount.set(0);
                    continue;
                }
                catch (Throwable t) {
                    TableClientLoggerFactory.RUNTIME.error("getOrRefreshTableEntry meet exception", t);
                    throw t;
                }
            }
            if (!logger.isInfoEnabled()) break block29;
            logger.info("refresh table entry has tried {}-times failure and will sync refresh metadata", (Object)refreshTryTimes);
        }
        this.syncRefreshMetadata();
        return this.refreshTableEntry(tableEntry, tableName);
    }

    private TableEntry refreshTableEntry(TableEntry tableEntry, String tableName) throws ObTableEntryRefreshException {
        return this.refreshTableEntry(tableEntry, tableName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableEntry refreshTableLocationByTabletId(TableEntry tableEntry, String tableName, Long tabletId) throws ObTableAuthException {
        TableEntryKey tableEntryKey = new TableEntryKey(this.clusterName, this.tenantName, this.database, tableName);
        try {
            if (tableEntry == null) {
                throw new ObTableEntryRefreshException("Table entry is null, tableName=" + tableName);
            }
            ObPartitionLocationInfo info = tableEntry.getPartitionEntry().getPartitionInfo(tabletId);
            if (info == null) {
                throw new ObTableEntryRefreshException("Partition info is null for tabletId=" + tabletId);
            }
            long lastRefreshTime = info.getLastUpdateTime();
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastRefreshTime < this.tableEntryRefreshIntervalCeiling) {
                return tableEntry;
            }
            ReentrantLock lock = info.refreshLock;
            boolean acquired = false;
            try {
                acquired = lock.tryLock(this.tableEntryRefreshLockTimeout, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    String errMsg = String.format("Try to lock table location refreshing timeout. DataSource: %s, TableName: %s, Timeout: %dms.", this.dataSourceName, tableName, this.tableEntryRefreshLockTimeout);
                    TableClientLoggerFactory.RUNTIME.error(errMsg);
                    throw new ObTableEntryRefreshException(errMsg);
                }
                lastRefreshTime = info.getLastUpdateTime();
                currentTime = System.currentTimeMillis();
                if (currentTime - lastRefreshTime < this.tableEntryRefreshIntervalCeiling) {
                    TableEntry tableEntry2 = tableEntry;
                    return tableEntry2;
                }
                tableEntry = LocationUtil.loadTableEntryLocationWithPriority(this.serverRoster, tableEntryKey, tableEntry, tabletId, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.serverAddressPriorityTimeout, this.serverAddressCachingTimeout, this.sysUA);
                tableEntry.prepareForWeakRead(this.serverRoster.getServerLdcLocation());
            }
            finally {
                if (acquired) {
                    lock.unlock();
                }
            }
        }
        catch (ObTableNotExistException | ObTableServerCacheExpiredException e) {
            TableClientLoggerFactory.RUNTIME.error("RefreshTableEntry encountered an exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String errorMsg = String.format("Failed to get table entry. Key=%s, TabletId=%d, message=%s", tableEntryKey, tabletId, e.getMessage());
            TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00020"), new Object[]{tableEntryKey, tableEntry, e});
            throw new ObTableEntryRefreshException(errorMsg, e);
        }
        this.tableLocations.put(tableName, tableEntry);
        this.tableEntryRefreshContinuousFailureCount.set(0);
        return tableEntry;
    }

    private TableEntry refreshTableEntry(TableEntry tableEntry, String tableName, boolean fetchAll) throws ObTableEntryRefreshException {
        TableEntryKey tableEntryKey = new TableEntryKey(this.clusterName, this.tenantName, this.database, tableName);
        try {
            if (tableEntry != null && !fetchAll) {
                if (ObGlobal.obVsnMajor() < 4) {
                    tableEntry = LocationUtil.loadTableEntryLocationWithPriority(this.serverRoster, tableEntryKey, tableEntry, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.serverAddressPriorityTimeout, this.serverAddressCachingTimeout, this.sysUA);
                }
            } else {
                tableEntry = LocationUtil.loadTableEntryWithPriority(this.serverRoster, tableEntryKey, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.serverAddressPriorityTimeout, this.serverAddressCachingTimeout, this.sysUA);
                if (tableEntry.isPartitionTable()) {
                    switch (this.runningMode) {
                        case HBASE: {
                            this.tableRowKeyElement.put(tableName, TableEntry.HBASE_ROW_KEY_ELEMENT);
                            tableEntry.setRowKeyElement(TableEntry.HBASE_ROW_KEY_ELEMENT);
                            break;
                        }
                        case NORMAL: {
                            Map<String, Integer> rowKeyElement = this.tableRowKeyElement.get(tableName);
                            if (rowKeyElement != null) {
                                tableEntry.setRowKeyElement(rowKeyElement);
                                break;
                            }
                            TableClientLoggerFactory.RUNTIME.error("partition table must add row key element name for table: " + tableName + " with table entry key: " + tableEntryKey);
                            throw new ObTableEntryRefreshException("partition table must add row key element name for table: " + tableName + " with table entry key: " + tableEntryKey);
                        }
                    }
                    tableEntry.prepare();
                }
            }
            tableEntry.prepareForWeakRead(this.serverRoster.getServerLdcLocation());
        }
        catch (ObTableNotExistException e) {
            TableClientLoggerFactory.RUNTIME.error("refreshTableEntry meet exception", (Throwable)e);
            throw e;
        }
        catch (ObTableServerCacheExpiredException e) {
            TableClientLoggerFactory.RUNTIME.error("refreshTableEntry meet exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00020"), new Object[]{tableEntryKey, tableEntry, e});
            throw new ObTableEntryRefreshException(String.format("failed to get table entry key=%s original tableEntry=%s ", tableEntryKey, tableEntry), e);
        }
        this.tableLocations.put(tableName, tableEntry);
        if (fetchAll) {
            tableEntry.setRefreshAllTimeMills(System.currentTimeMillis());
        }
        this.tableEntryRefreshContinuousFailureCount.set(0);
        if (logger.isDebugEnabled()) {
            logger.debug("refresh table entry, dataSource: {}, tableName: {}, refresh: {} key:{} entry:{} ", new Object[]{this.dataSourceName, tableName, true, tableEntryKey, JSON.toJSON((Object)tableEntry)});
        }
        return tableEntry;
    }

    private String refreshTableNameByTableGroup(String physicalTableName, String tableGroupName) throws Exception {
        TableEntryKey tableEntryKey = new TableEntryKey(this.clusterName, this.tenantName, this.database, tableGroupName);
        String oldTableName = physicalTableName;
        try {
            physicalTableName = LocationUtil.loadTableNameWithGroupName(this.serverRoster, tableEntryKey, this.tableEntryAcquireConnectTimeout, this.tableEntryAcquireSocketTimeout, this.serverAddressPriorityTimeout, this.serverAddressCachingTimeout, this.sysUA);
        }
        catch (ObTableNotExistException e) {
            TableClientLoggerFactory.RUNTIME.error("refreshTableNameByTableGroup from tableGroup meet exception", (Throwable)e);
            throw e;
        }
        catch (ObTableServerCacheExpiredException e) {
            TableClientLoggerFactory.RUNTIME.error("refreshTableEntry from tableGroup meet exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            TableClientLoggerFactory.RUNTIME.error("refreshTableEntry from tableGroup meet exception", new Object[]{tableEntryKey, physicalTableName, e});
            throw new ObTableNotExistException(String.format("failed to get table name key=%s original tableName=%s ", tableEntryKey, physicalTableName), e);
        }
        if (!this.TableGroupInverted.isEmpty() && oldTableName != null && this.TableGroupInverted.containsKey(oldTableName)) {
            this.TableGroupInverted.remove(oldTableName, tableGroupName);
        }
        this.TableGroupCache.put(tableGroupName, physicalTableName);
        this.TableGroupInverted.put(physicalTableName, tableGroupName);
        if (logger.isInfoEnabled()) {
            logger.info("get table name from tableGroup, dataSource: {}, tableName: {}, refresh: {} key:{} realTableName:{} ", new Object[]{this.dataSourceName, tableGroupName, true, tableEntryKey, physicalTableName});
        }
        return physicalTableName;
    }

    private long getPartition(TableEntry tableEntry, Row row) {
        if (!tableEntry.isPartitionTable() || tableEntry.getPartitionInfo().getLevel() == ObPartitionLevel.LEVEL_ZERO) {
            return 0L;
        }
        if (tableEntry.getPartitionInfo().getLevel() == ObPartitionLevel.LEVEL_ONE) {
            return tableEntry.getPartitionInfo().getFirstPartDesc().getPartId(row);
        }
        Long partId1 = tableEntry.getPartitionInfo().getFirstPartDesc().getPartId(row);
        Long partId2 = tableEntry.getPartitionInfo().getSubPartDesc().getPartId(row);
        return ObPartIdCalculator.generatePartId(partId1, partId2);
    }

    private List<Long> getPartitionsForLevelTwo(TableEntry tableEntry, Row startRow, boolean startIncluded, Row endRow, boolean endIncluded) throws Exception {
        ArrayList<Long> partIds;
        block7: {
            if (tableEntry.getPartitionInfo().getLevel() != ObPartitionLevel.LEVEL_TWO) {
                TableClientLoggerFactory.RUNTIME.error("getPartitionsForLevelTwo need ObPartitionLevel LEVEL_TWO");
                throw new Exception("getPartitionsForLevelTwo need ObPartitionLevel LEVEL_TWO");
            }
            List<Long> partIds1 = tableEntry.getPartitionInfo().getFirstPartDesc().getPartIds(startRow, startIncluded, endRow, endIncluded);
            List<Long> partIds2 = tableEntry.getPartitionInfo().getSubPartDesc().getPartIds(startRow, startIncluded, endRow, endIncluded);
            partIds = new ArrayList<Long>();
            if (partIds1.isEmpty()) break block7;
            if (partIds1.size() == 1) {
                long firstPartId = partIds1.get(0);
                for (Long partId2 : partIds2) {
                    partIds.add(ObPartIdCalculator.generatePartId(firstPartId, partId2));
                }
            } else {
                long subPartNum = tableEntry.getPartitionInfo().getSubPartDesc().getPartNum();
                ArrayList<Long> subPartIds = new ArrayList<Long>();
                for (long i = 0L; i < subPartNum; ++i) {
                    subPartIds.add(i);
                }
                partIds2 = Collections.unmodifiableList(subPartIds);
                for (Long partId1 : partIds1) {
                    for (Long partId2 : partIds2) {
                        partIds.add(ObPartIdCalculator.generatePartId(partId1, partId2));
                    }
                }
            }
        }
        return partIds;
    }

    private ObPair<Long, ReplicaLocation> getPartitionReplica(TableEntry tableEntry, long partId, ObServerRoute route) {
        return new ObPair<Long, ReplicaLocation>(partId, this.getPartitionLocation(tableEntry, partId, route));
    }

    private ReplicaLocation getPartitionLocation(TableEntry tableEntry, long partId, ObServerRoute route) {
        partId = this.getTabletIdByPartId(tableEntry, partId);
        return tableEntry.getPartitionEntry().getPartitionLocationWithTabletId(partId).getReplica(route);
    }

    private ReplicaLocation getPartitionLocation(ObPartitionLocationInfo obPartitionLocationInfo, ObServerRoute route) {
        return obPartitionLocationInfo.getPartitionLocation().getReplica(route);
    }

    public ObPair<Long, ObTableParam> getTable(String tableName, Object[] rowKey, boolean refresh, boolean waitForRefresh) throws Exception {
        ObServerRoute route = this.getRoute(false);
        return this.getTable(tableName, rowKey, refresh, waitForRefresh, route);
    }

    public ObPair<Long, ObTableParam> getTable(String tableName, Object[] rowKey, boolean refresh, boolean waitForRefresh, ObServerRoute route) throws Exception {
        return this.getTable(tableName, rowKey, refresh, waitForRefresh, false, route);
    }

    private ObPair<Long, ObTableParam> getTable(String tableName, Object[] rowKey, boolean refresh, boolean waitForRefresh, boolean needFetchAll, ObServerRoute route) throws Exception {
        TableEntry tableEntry = this.getOrRefreshTableEntry(tableName, refresh, waitForRefresh, needFetchAll);
        Row row = new Row();
        if (tableEntry.isPartitionTable()) {
            ArrayList<Object> curTableRowKeyNames = new ArrayList();
            Map<String, Integer> tableRowKeyEle = this.getRowKeyElement(tableName);
            if (tableRowKeyEle != null) {
                curTableRowKeyNames = new ArrayList<String>(tableRowKeyEle.keySet());
            }
            if (curTableRowKeyNames.isEmpty()) {
                throw new IllegalArgumentException("Please make sure add row key elements");
            }
            for (int i = 0; i < rowKey.length && i < curTableRowKeyNames.size(); ++i) {
                row.add((String)curTableRowKeyNames.get(i), rowKey[i]);
            }
        }
        long partId = this.getPartition(tableEntry, row);
        if (refresh && ObGlobal.obVsnMajor() >= 4) {
            this.refreshTableLocationByTabletId(tableEntry, tableName, this.getTabletIdByPartId(tableEntry, partId));
        }
        return this.getTableInternal(tableName, tableEntry, partId, waitForRefresh, route);
    }

    public ObPair<Long, ObTableParam> getODPTableWithRowKeyValue(String tableName, Object[] rowKey, boolean needRenew) throws Exception {
        TableEntry odpTableEntry = this.getOrFetchODPPartitionMeta(tableName, needRenew);
        Row row = new Row();
        if (odpTableEntry.isPartitionTable() && odpTableEntry.getPartitionInfo().getLevel() != ObPartitionLevel.LEVEL_ZERO) {
            ArrayList<Object> curTableRowKeyNames = new ArrayList();
            Map<String, Integer> tableRowKeyEle = this.getRowKeyElement(tableName);
            if (tableRowKeyEle != null) {
                curTableRowKeyNames = new ArrayList<String>(tableRowKeyEle.keySet());
            }
            if (curTableRowKeyNames.isEmpty()) {
                throw new IllegalArgumentException("Please make sure add row key elements");
            }
            for (int i = 0; i < rowKey.length && i < curTableRowKeyNames.size(); ++i) {
                row.add((String)curTableRowKeyNames.get(i), rowKey[i]);
            }
        }
        long partId = this.getPartition(odpTableEntry, row);
        return this.getODPTableInternal(odpTableEntry, partId);
    }

    public ObPair<Long, ObTableParam> getTable(String tableName, ObTableQuery query, List<ObNewRange> keyRanges) throws Exception {
        HashMap<Long, ObTableParam> partIdMapObTable = new HashMap<Long, ObTableParam>();
        for (ObNewRange rang : keyRanges) {
            int i;
            ObRowKey startKey = rang.getStartKey();
            int startKeySize = startKey.getObjs().size();
            ObRowKey endKey = rang.getEndKey();
            int endKeySize = endKey.getObjs().size();
            Object[] start = new Object[startKeySize];
            Object[] end = new Object[endKeySize];
            for (i = 0; i < startKeySize; ++i) {
                ObObj curStart = startKey.getObj(i);
                start[i] = curStart.isMinObj() ? curStart : curStart.getValue();
            }
            for (i = 0; i < endKeySize; ++i) {
                ObObj curEnd = endKey.getObj(i);
                end[i] = curEnd.isMaxObj() ? curEnd : curEnd.getValue();
            }
            ObBorderFlag borderFlag = rang.getBorderFlag();
            List<ObPair<Long, ObTableParam>> pairList = this.getTables(tableName, query, start, borderFlag.isInclusiveStart(), end, borderFlag.isInclusiveEnd(), false, false);
            for (ObPair<Long, ObTableParam> pair : pairList) {
                partIdMapObTable.put(pair.getLeft(), pair.getRight());
            }
        }
        if (partIdMapObTable.size() > 1) {
            throw new ObTablePartitionConsistentException("query and mutate must be a atomic operation");
        }
        if (partIdMapObTable.size() < 1) {
            throw new ObTableException("could not find part id of range");
        }
        ObPair ans = null;
        for (Long partId : partIdMapObTable.keySet()) {
            ans = new ObPair(partId, partIdMapObTable.get(partId));
        }
        return ans;
    }

    public ObPair<Long, ObTableParam> getTable(String tableName, Row rowKey, boolean refresh, boolean waitForRefresh) throws Exception {
        return this.getTable(tableName, rowKey, refresh, waitForRefresh, false, this.getRoute(false));
    }

    private ObPair<Long, ObTableParam> getTable(String tableName, Row rowKey, boolean refresh, boolean waitForRefresh, boolean needFetchAll, ObServerRoute route) throws Exception {
        TableEntry tableEntry = this.getOrRefreshTableEntry(tableName, refresh, waitForRefresh, needFetchAll);
        long partId = this.getPartition(tableEntry, rowKey);
        return this.getTableInternal(tableName, tableEntry, partId, waitForRefresh, route);
    }

    private ObPair<Long, ObTableParam> getODPTableWithRowKey(String tableName, Row rowKey, boolean needRenew) throws Exception {
        TableEntry odpTableEntry = this.getOrFetchODPPartitionMeta(tableName, needRenew);
        long partId = this.getPartition(odpTableEntry, rowKey);
        return this.getODPTableInternal(odpTableEntry, partId);
    }

    public ObPair<Long, ObTableParam> getTableWithPartId(String tableName, long partId, boolean refresh, boolean waitForRefresh, boolean needFetchAll, ObServerRoute route) throws Exception {
        TableEntry tableEntry = this.getOrRefreshTableEntry(tableName, refresh, waitForRefresh, needFetchAll);
        return this.getTableInternal(tableName, tableEntry, partId, waitForRefresh, route);
    }

    public ObTable getTable(ObTableApiMove moveResponse) throws Exception {
        ObServerAddr addr = new ObServerAddr();
        addr.setIp(moveResponse.getReplica().getServer().ipToString());
        addr.setSvrPort(moveResponse.getReplica().getServer().getPort());
        logger.info("get new server ip {}, port {} from move response ", (Object)addr.getIp(), (Object)addr.getSvrPort());
        for (Map.Entry<ObServerAddr, ObTable> entry : this.tableRoster.entrySet()) {
            if (!Objects.equals(entry.getKey().getIp(), addr.getIp()) || !Objects.equals(entry.getKey().getSvrPort(), addr.getSvrPort())) continue;
            return entry.getValue();
        }
        return this.addTable(addr);
    }

    public ObTable addTable(ObServerAddr addr) {
        try {
            logger.info("server from response not exist in route cache, server ip {}, port {} , execute add Table.", (Object)addr.getIp(), (Object)addr.getSvrPort());
            ObTable obTable = new ObTable.Builder(addr.getIp(), addr.getSvrPort()).setLoginInfo(this.tenantName, this.userName, this.password, this.database).setProperties(this.getProperties()).build();
            this.tableRoster.put(addr, obTable);
            return obTable;
        }
        catch (Exception e) {
            TableClientLoggerFactory.BOOT.warn("The addr{}:{} failed to put into table roster, the node status may be wrong, Ignore", (Object)addr.getIp(), (Object)addr.getSvrPort());
            TableClientLoggerFactory.RUNTIME.warn("Get table from API_MOVE response ip and port meet exception", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public ObPair<Long, ObTableParam> getODPTableWithPartId(String tableName, long partId, boolean needRenew) throws Exception {
        TableEntry odpTableEntry = this.getOrFetchODPPartitionMeta(tableName, needRenew);
        return this.getODPTableInternal(odpTableEntry, partId);
    }

    public ObPair<Long, ObTableParam> getTableInternal(String tableName, TableEntry tableEntry, long partId, boolean waitForRefresh, ObServerRoute route) throws Exception {
        ReplicaLocation replica = null;
        long tabletId = this.getTabletIdByPartId(tableEntry, partId);
        long partitionId = partId;
        ObPartitionLocationInfo obPartitionLocationInfo = null;
        if (ObGlobal.obVsnMajor() >= 4) {
            obPartitionLocationInfo = this.getOrRefreshPartitionInfo(tableEntry, tableName, tabletId);
            replica = this.getPartitionLocation(obPartitionLocationInfo, route);
            if (replica == null && obPartitionLocationInfo.getPartitionLocation().getLeader() == null) {
                TableClientLoggerFactory.RUNTIME.error(TableClientLoggerFactory.LCD.convert("01-00028"), new Object[]{partitionId, tableEntry.getPartitionEntry(), tableEntry});
                TableClientLoggerFactory.RUNTIME.error(String.format("partition=%d has no leader partitionEntry=%s original tableEntry=%s", partitionId, tableEntry.getPartitionEntry(), tableEntry));
                throw new ObTablePartitionNoMasterException(String.format("partition=%d has no leader partitionEntry=%s original tableEntry=%s", partitionId, tableEntry.getPartitionEntry(), tableEntry));
            }
        } else {
            if (tableEntry.isPartitionTable() && null != tableEntry.getPartitionInfo().getSubPartDesc()) {
                partitionId = ObPartIdCalculator.getPartIdx(partId, tableEntry.getPartitionInfo().getSubPartDesc().getPartNum());
            }
            ObPair<Long, ReplicaLocation> partitionReplica = this.getPartitionReplica(tableEntry, partitionId, route);
            replica = partitionReplica.getRight();
        }
        if (replica == null) {
            TableClientLoggerFactory.RUNTIME.error("Cannot get replica by partId: " + partId);
            throw new ObTableGetException("Cannot get replica by partId: " + partId);
        }
        ObServerAddr addr = replica.getAddr();
        ObTable obTable = this.tableRoster.get(addr);
        boolean addrExpired = addr.isExpired(this.serverAddressCachingTimeout);
        if (obTable == null || addrExpired) {
            if (obTable == null) {
                logger.warn("Cannot get ObTable by addr {}, refreshing metadata.", (Object)addr);
                this.syncRefreshMetadata();
            }
            if (addr.isExpired(this.serverAddressCachingTimeout)) {
                logger.info("Server addr {} is expired, refreshing tableEntry.", (Object)addr);
                if (ObGlobal.obVsnMajor() >= 4) {
                    this.refreshTableLocationByTabletId(tableEntry, tableName, tabletId);
                } else {
                    tableEntry = this.getOrRefreshTableEntry(tableName, true, waitForRefresh, false);
                }
            }
            if (ObGlobal.obVsnMajor() >= 4) {
                obPartitionLocationInfo = this.getOrRefreshPartitionInfo(tableEntry, tableName, tabletId);
                replica = this.getPartitionLocation(obPartitionLocationInfo, route);
            } else {
                replica = this.getPartitionReplica(tableEntry, partitionId, route).getRight();
            }
            addr = replica.getAddr();
            obTable = this.tableRoster.get(addr);
            if (obTable == null) {
                TableClientLoggerFactory.RUNTIME.error("Cannot get table by addr: " + addr);
                throw new ObTableGetException("Cannot get table by addr: " + addr);
            }
        }
        ObTableParam param = this.createTableParam(obTable, tableEntry, obPartitionLocationInfo, partId, tabletId);
        if (ObGlobal.obVsnMajor() < 4) {
            param.setPartitionId(partId);
        }
        addr.recordAccess();
        return new ObPair<Long, ObTableParam>(partId, param);
    }

    private ObPartitionLocationInfo getOrRefreshPartitionInfo(TableEntry tableEntry, String tableName, long tabletId) throws Exception {
        ObPartitionLocationInfo obPartitionLocationInfo = tableEntry.getPartitionEntry().getPartitionInfo(tabletId);
        if (!obPartitionLocationInfo.initialized.get()) {
            tableEntry = this.refreshTableLocationByTabletId(tableEntry, tableName, tabletId);
            obPartitionLocationInfo = tableEntry.getPartitionEntry().getPartitionInfo(tabletId);
            obPartitionLocationInfo.initializationLatch.await();
        }
        return obPartitionLocationInfo;
    }

    private ObTableParam createTableParam(ObTable obTable, TableEntry tableEntry, ObPartitionLocationInfo obPartitionLocationInfo, long partId, long tabletId) {
        ObTableParam param = new ObTableParam(obTable);
        param.setPartId(partId);
        if (ObGlobal.obVsnMajor() >= 4 && tableEntry != null) {
            param.setLsId(obPartitionLocationInfo.getTabletLsId());
        }
        param.setTableId(tableEntry.getTableId());
        param.setPartitionId(tabletId);
        return param;
    }

    private ObPair<Long, ObTableParam> getODPTableInternal(TableEntry odpTableEntry, long partId) {
        ObTable obTable = this.odpTable;
        ObTableParam param = new ObTableParam(obTable);
        param.setPartId(partId);
        long tabletId = partId;
        if (ObGlobal.obVsnMajor() >= 4) {
            long partIdx = odpTableEntry.getPartIdx(partId);
            tabletId = odpTableEntry.isPartitionTable() ? odpTableEntry.getPartitionInfo().getPartTabletIdMap().get(partIdx) : partId;
            param.setLsId(odpTableEntry.getPartitionEntry().getLsId(tabletId));
        }
        param.setTableId(odpTableEntry.getTableId());
        param.setPartitionId(tabletId);
        return new ObPair<Long, ObTableParam>(partId, param);
    }

    private List<ObPair<Long, ReplicaLocation>> getPartitionReplica(TableEntry tableEntry, String tableName, Row startRow, boolean startIncluded, Row endRow, boolean endIncluded, ObServerRoute route) throws Exception {
        ArrayList<ObPair<Long, ReplicaLocation>> replicas = new ArrayList<ObPair<Long, ReplicaLocation>>();
        if (!tableEntry.isPartitionTable() || tableEntry.getPartitionInfo().getLevel() == ObPartitionLevel.LEVEL_ZERO) {
            if (ObGlobal.obVsnMajor() >= 4) {
                long tabletId = this.getTabletIdByPartId(tableEntry, 0L);
                ObPartitionLocationInfo locationInfo = this.getOrRefreshPartitionInfo(tableEntry, tableName, tabletId);
                replicas.add(new ObPair<Long, ReplicaLocation>(0L, this.getPartitionLocation(locationInfo, route)));
            } else {
                replicas.add(new ObPair<Long, ReplicaLocation>(0L, this.getPartitionLocation(tableEntry, 0L, route)));
            }
            return replicas;
        }
        ObPartitionLevel partitionLevel = tableEntry.getPartitionInfo().getLevel();
        List<Long> partIds = this.getPartitionTablePartitionIds(tableEntry, startRow, startIncluded, endRow, endIncluded, partitionLevel);
        if (ObGlobal.obVsnMajor() >= 4) {
            for (Long partId : partIds) {
                long tabletId = this.getTabletIdByPartId(tableEntry, partId);
                ObPartitionLocationInfo locationInfo = this.getOrRefreshPartitionInfo(tableEntry, tableName, tabletId);
                replicas.add(new ObPair<Long, ReplicaLocation>(partId, this.getPartitionLocation(locationInfo, route)));
            }
        } else {
            for (Long partId : partIds) {
                long partitionId = partId;
                if (tableEntry.getPartitionInfo().getLevel() == ObPartitionLevel.LEVEL_TWO) {
                    partitionId = ObPartIdCalculator.getPartIdx(partId, tableEntry.getPartitionInfo().getSubPartDesc().getPartNum());
                }
                replicas.add(new ObPair<Long, ReplicaLocation>(partId, this.getPartitionLocation(tableEntry, partitionId, route)));
            }
        }
        return replicas;
    }

    private List<Long> getPartitionTablePartitionIds(TableEntry tableEntry, Row startRow, boolean startIncluded, Row endRow, boolean endIncluded, ObPartitionLevel level) throws Exception {
        if (level == ObPartitionLevel.LEVEL_ONE) {
            return tableEntry.getPartitionInfo().getFirstPartDesc().getPartIds(startRow, startIncluded, endRow, endIncluded);
        }
        if (level == ObPartitionLevel.LEVEL_TWO) {
            return this.getPartitionsForLevelTwo(tableEntry, startRow, startIncluded, endRow, endIncluded);
        }
        TableClientLoggerFactory.RUNTIME.error("not allowed bigger than level two");
        throw new ObTableGetException("not allowed bigger than level two");
    }

    public long getTabletIdByPartId(TableEntry tableEntry, Long partId) {
        if (ObGlobal.obVsnMajor() >= 4 && tableEntry.isPartitionTable()) {
            ObPartitionInfo partInfo = tableEntry.getPartitionInfo();
            Map<Long, Long> tabletIdMap = partInfo.getPartTabletIdMap();
            long partIdx = tableEntry.getPartIdx(partId);
            return tabletIdMap.getOrDefault(partIdx, partId);
        }
        return partId;
    }

    private List<Long> getOdpPartIds(TableEntry odpTableEntry, Row startRow, boolean startIncluded, Row endRow, boolean endIncluded) throws Exception {
        if (!odpTableEntry.isPartitionTable() || odpTableEntry.getPartitionInfo().getLevel() == ObPartitionLevel.LEVEL_ZERO) {
            ArrayList<Long> partIds = new ArrayList<Long>();
            partIds.add(0L);
            return partIds;
        }
        if (odpTableEntry.getPartitionInfo().getLevel() == ObPartitionLevel.LEVEL_ONE) {
            return odpTableEntry.getPartitionInfo().getFirstPartDesc().getPartIds(startRow, startIncluded, endRow, endIncluded);
        }
        if (odpTableEntry.getPartitionInfo().getLevel() == ObPartitionLevel.LEVEL_TWO) {
            return this.getPartitionsForLevelTwo(odpTableEntry, startRow, startIncluded, endRow, endIncluded);
        }
        TableClientLoggerFactory.RUNTIME.error("not allowed bigger than level two");
        throw new ObTableGetException("not allowed bigger than level two");
    }

    public List<ObPair<Long, ObTableParam>> getTables(String tableName, ObTableQuery query, Object[] start, boolean startInclusive, Object[] end, boolean endInclusive, boolean refresh, boolean waitForRefresh) throws Exception {
        return this.getTables(tableName, query, start, startInclusive, end, endInclusive, refresh, waitForRefresh, false, this.getRoute(false));
    }

    public List<ObPair<Long, ObTableParam>> getTables(String tableName, ObTableQuery query, Object[] start, boolean startInclusive, Object[] end, boolean endInclusive, boolean refresh, boolean waitForRefresh, ObServerRoute route) throws Exception {
        return this.getTables(tableName, query, start, startInclusive, end, endInclusive, refresh, waitForRefresh, false, route);
    }

    private List<ObPair<Long, ObTableParam>> getTables(String tableName, ObTableQuery query, Object[] start, boolean startInclusive, Object[] end, boolean endInclusive, boolean refresh, boolean waitForRefresh, boolean needFetchAll, ObServerRoute route) throws Exception {
        Map<String, Integer> tableEntryRowKeyElement;
        TableEntry tableEntry = this.getOrRefreshTableEntry(tableName, refresh, waitForRefresh, needFetchAll);
        List<String> scanRangeColumns = query.getScanRangeColumns();
        if ((scanRangeColumns == null || scanRangeColumns.isEmpty()) && (tableEntryRowKeyElement = this.getRowKeyElement(tableName)) != null) {
            scanRangeColumns = new ArrayList<String>(tableEntryRowKeyElement.keySet());
        }
        if (start.length != end.length) {
            throw new IllegalArgumentException("length of start key and end key is not equal");
        }
        Row startRow = new Row();
        Row endRow = new Row();
        if (tableEntry.isPartitionTable()) {
            if ((scanRangeColumns == null || scanRangeColumns.isEmpty()) && start.length == 1 && start[0] instanceof ObObj && ((ObObj)start[0]).isMinObj() && end.length == 1 && end[0] instanceof ObObj && ((ObObj)end[0]).isMaxObj()) {
                scanRangeColumns = new ArrayList<String>(Collections.nCopies(start.length, "partition"));
            }
            if (scanRangeColumns == null || scanRangeColumns.size() < start.length) {
                throw new IllegalArgumentException("length of key and scan range columns do not match, please use addRowKeyElement or set scan range columns");
            }
            for (int i = 0; i < start.length; ++i) {
                startRow.add(scanRangeColumns.get(i), start[i]);
                endRow.add(scanRangeColumns.get(i), end[i]);
            }
        }
        List<ObPair<Long, ReplicaLocation>> partIdWithReplicaList = this.getPartitionReplica(tableEntry, tableName, startRow, startInclusive, endRow, endInclusive, route);
        ArrayList<ObPair<Long, ObTableParam>> obTableParams = new ArrayList<ObPair<Long, ObTableParam>>();
        for (ObPair<Long, ReplicaLocation> partIdWithReplica : partIdWithReplicaList) {
            Long partId = partIdWithReplica.getLeft();
            long tabletId = this.getTabletIdByPartId(tableEntry, partId);
            ReplicaLocation replica = partIdWithReplica.getRight();
            ObServerAddr addr = replica.getAddr();
            ObTable obTable = this.tableRoster.get(addr);
            boolean addrExpired = addr.isExpired(this.serverAddressCachingTimeout);
            if (addrExpired || obTable == null) {
                if (obTable == null) {
                    logger.warn("Cannot get ObTable by addr {}, refreshing metadata.", (Object)addr);
                    this.syncRefreshMetadata();
                }
                if (addrExpired) {
                    logger.info("Server addr {} is expired, refreshing tableEntry.", (Object)addr);
                    if (ObGlobal.obVsnMajor() >= 4) {
                        this.refreshTableLocationByTabletId(tableEntry, tableName, tabletId);
                    } else {
                        tableEntry = this.getOrRefreshTableEntry(tableName, true, waitForRefresh, false);
                    }
                }
                if (ObGlobal.obVsnMajor() >= 4) {
                    ObPartitionLocationInfo locationInfo = this.getOrRefreshPartitionInfo(tableEntry, tableName, tabletId);
                    replica = this.getPartitionLocation(locationInfo, route);
                } else {
                    replica = this.getPartitionLocation(tableEntry, partId, route);
                }
                addr = replica.getAddr();
                obTable = this.tableRoster.get(addr);
            }
            if (obTable == null) {
                TableClientLoggerFactory.RUNTIME.error("cannot get table by addr: " + addr);
                throw new ObTableGetException("cannot get table by addr: " + addr);
            }
            ObTableParam param = new ObTableParam(obTable);
            param.setPartId(partId);
            partId = this.getTabletIdByPartId(tableEntry, partId);
            if (ObGlobal.obVsnMajor() >= 4 && tableEntry != null) {
                param.setLsId(tableEntry.getPartitionEntry().getPartitionInfo(partId).getTabletLsId());
            }
            param.setTableId(tableEntry.getTableId());
            param.setPartitionId(partId);
            addr.recordAccess();
            obTableParams.add(new ObPair<Long, ObTableParam>(partIdWithReplica.getLeft(), param));
        }
        return obTableParams;
    }

    public List<ObPair<Long, ObTableParam>> getOdpTables(String tableName, ObTableQuery query, Object[] start, boolean startInclusive, Object[] end, boolean endInclusive, boolean needRenew) throws Exception {
        Map<String, Integer> tableEntryRowKeyElement;
        ArrayList<ObPair<Long, ObTableParam>> obTableParams = new ArrayList<ObPair<Long, ObTableParam>>();
        TableEntry odpTableEntry = this.getOrFetchODPPartitionMeta(tableName, needRenew);
        List<String> scanRangeColumns = query.getScanRangeColumns();
        if ((scanRangeColumns == null || scanRangeColumns.isEmpty()) && (tableEntryRowKeyElement = this.getRowKeyElement(tableName)) != null) {
            scanRangeColumns = new ArrayList<String>(tableEntryRowKeyElement.keySet());
        }
        if (start.length != end.length) {
            throw new IllegalArgumentException("length of start key and end key is not equal");
        }
        Row startRow = new Row();
        Row endRow = new Row();
        if (odpTableEntry.isPartitionTable() && odpTableEntry.getPartitionInfo().getLevel() != ObPartitionLevel.LEVEL_ZERO) {
            if ((scanRangeColumns == null || scanRangeColumns.isEmpty()) && start.length == 1 && start[0] instanceof ObObj && ((ObObj)start[0]).isMinObj() && end.length == 1 && end[0] instanceof ObObj && ((ObObj)end[0]).isMaxObj()) {
                scanRangeColumns = new ArrayList<String>(Collections.nCopies(start.length, "partition"));
            }
            if (scanRangeColumns == null || scanRangeColumns.size() < start.length) {
                throw new IllegalArgumentException("length of key and scan range columns do not match, please use addRowKeyElement or set scan range columns");
            }
            for (int i = 0; i < start.length; ++i) {
                startRow.add(scanRangeColumns.get(i), start[i]);
                endRow.add(scanRangeColumns.get(i), end[i]);
            }
        }
        List<Long> partIds = this.getOdpPartIds(odpTableEntry, startRow, startInclusive, endRow, endInclusive);
        for (Long partId : partIds) {
            ObTable obTable = this.odpTable;
            ObTableParam param = new ObTableParam(obTable);
            param.setPartId(partId);
            Long tabletId = partId;
            if (ObGlobal.obVsnMajor() >= 4) {
                long partIdx = odpTableEntry.getPartIdx(partId);
                tabletId = odpTableEntry.isPartitionTable() ? odpTableEntry.getPartitionInfo().getPartTabletIdMap().get(partIdx) : partId;
                param.setLsId(odpTableEntry.getPartitionEntry().getLsId(tabletId));
            }
            param.setTableId(odpTableEntry.getTableId());
            param.setPartitionId(tabletId);
            obTableParams.add(new ObPair<Long, ObTableParam>(partId, param));
        }
        return obTableParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryGetTableNameFromTableGroupCache(String tableGroupName, boolean refresh) throws Exception {
        String newPhyTableName;
        Lock lock;
        block14: {
            String physicalTableName = this.TableGroupCache.get(tableGroupName);
            if (physicalTableName != null && !refresh) {
                return physicalTableName;
            }
            ReentrantLock tempLock = new ReentrantLock();
            lock = this.TableGroupCacheLocks.putIfAbsent(tableGroupName, tempLock);
            lock = lock == null ? tempLock : lock;
            boolean acquired = lock.tryLock(this.metadataRefreshLockTimeout, TimeUnit.MILLISECONDS);
            if (!acquired) {
                String errMsg = "try to lock tableGroup inflect timeout dataSource:" + this.dataSourceName + " ,tableName:" + tableGroupName + " , timeout:" + this.metadataRefreshLockTimeout + ".";
                TableClientLoggerFactory.RUNTIME.error(errMsg);
                throw new ObTableEntryRefreshException(errMsg);
            }
            newPhyTableName = this.TableGroupCache.get(tableGroupName);
            if ((physicalTableName != null || newPhyTableName != null) && (!refresh || !newPhyTableName.equalsIgnoreCase(physicalTableName))) break block14;
            if (logger.isInfoEnabled()) {
                if (physicalTableName != null) {
                    logger.info("realTableName need refresh, create new table entry, tablename: {}", (Object)tableGroupName);
                } else {
                    logger.info("realTableName not exist, create new table entry, tablename: {}", (Object)tableGroupName);
                }
            }
            try {
                String string = this.refreshTableNameByTableGroup(physicalTableName, tableGroupName);
                return string;
            }
            catch (ObTableNotExistException e) {
                TableClientLoggerFactory.RUNTIME.error("getOrRefreshTableName from TableGroup meet exception", (Throwable)e);
                throw e;
            }
            catch (ObTableServerCacheExpiredException e) {
                TableClientLoggerFactory.RUNTIME.error("getOrRefreshTableName from TableGroup meet exception", (Throwable)e);
                if (logger.isInfoEnabled()) {
                    logger.info("server addr is expired and it will refresh metadata.");
                }
                this.syncRefreshMetadata();
            }
            catch (Throwable t) {
                TableClientLoggerFactory.RUNTIME.error("getOrRefreshTableName from TableGroup meet exception", t);
                throw t;
            }
            if (!logger.isInfoEnabled()) break block14;
            logger.info("refresh table Name from TableGroup failure");
        }
        String string = newPhyTableName;
        return string;
        finally {
            lock.unlock();
        }
    }

    public ObTableAggregation aggregate(String tableName) {
        ObTableClientQueryImpl tableQuery = new ObTableClientQueryImpl(tableName, this);
        ObClusterTableQuery clusterTableQuery = new ObClusterTableQuery(tableQuery);
        return new ObTableAggregation(clusterTableQuery);
    }

    @Override
    public TableQuery query(String tableName) {
        ObTableClientQueryImpl tableQuery = new ObTableClientQueryImpl(tableName, this);
        return new ObClusterTableQuery(tableQuery);
    }

    @Override
    public TableBatchOps batch(String tableName) {
        ObTableClientBatchOpsImpl batchOps = new ObTableClientBatchOpsImpl(tableName, this);
        return new ObClusterTableBatchOps(this.runtimeBatchExecutor, batchOps);
    }

    @Override
    public Map<String, Object> get(final String tableName, final Object[] rowKey, final String[] columns) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        final long startTime = System.currentTimeMillis();
        final ObReadConsistency obReadConsistency = this.getReadConsistency();
        return this.execute(tableName, new TableExecuteCallback<Map<String, Object>>(rowKey){

            @Override
            public Map<String, Object> execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long getTableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.GET, rowKey, columns, null, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                request.setConsistencyLevel(obReadConsistency.toObTableConsistencyLevel());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                this.checkObTableOperationResult(obTable.getIp(), obTable.getPort(), request, result);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "GET", endpoint, rowKey, (ObTableOperationResult)result, getTableTime - startTime, System.currentTimeMillis() - getTableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                return ((ObTableOperationResult)result).getEntity().getSimpleProperties();
            }
        }, this.getReadRoute());
    }

    @Override
    public Update update(String tableName) {
        return new Update(this, tableName);
    }

    @Override
    public long update(final String tableName, final Object[] rowKey, final String[] columns, final Object[] values) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new TableExecuteCallback<Long>(rowKey){

            @Override
            public Long execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long getTableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.UPDATE, rowKey, columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "UPDATE", endpoint, rowKey, (ObTableOperationResult)result, getTableTime - start, System.currentTimeMillis() - getTableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkObTableOperationResult(obTable.getIp(), obTable.getPort(), request, result);
                return ((ObTableOperationResult)result).getAffectedRows();
            }
        });
    }

    public ObPayload updateWithResult(final String tableName, final Row rowKey, List<ObNewRange> keyRanges, final String[] columns, final Object[] values) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.UPDATE, rowKey.getValues(), columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "UPDATE", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    @Override
    public Delete delete(String tableName) {
        return new Delete(this, tableName);
    }

    @Override
    public long delete(final String tableName, final Object[] rowKey) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new TableExecuteCallback<Long>(rowKey){

            @Override
            public Long execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long getTableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.DEL, rowKey, null, null, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "DELETE", endpoint, rowKey, (ObTableOperationResult)result, getTableTime - start, System.currentTimeMillis() - getTableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkObTableOperationResult(obTable.getIp(), obTable.getPort(), request, result);
                return ((ObTableOperationResult)result).getAffectedRows();
            }
        });
    }

    public ObPayload deleteWithResult(final String tableName, final Row rowKey, List<ObNewRange> keyRanges) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.DEL, rowKey.getValues(), null, null, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "DELETE", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    @Override
    public Insert insert(String tableName) {
        return new Insert(this, tableName);
    }

    @Override
    public long insert(final String tableName, final Object[] rowKey, final String[] columns, final Object[] values) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new TableExecuteCallback<Long>(rowKey){

            @Override
            public Long execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long getTableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.INSERT, rowKey, columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "INSERT", endpoint, rowKey, (ObTableOperationResult)result, getTableTime - start, System.currentTimeMillis() - getTableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkObTableOperationResult(obTable.getIp(), obTable.getPort(), request, result);
                return ((ObTableOperationResult)result).getAffectedRows();
            }
        });
    }

    public ObPayload insertWithResult(final String tableName, final Row rowKey, List<ObNewRange> keyRanges, final String[] columns, final Object[] values) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.INSERT, rowKey.getValues(), columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "INSERT", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    public Get get(String tableName) {
        return new Get(this, tableName);
    }

    public Map<String, Object> get(final String tableName, final Row rowKey, final String[] selectColumns) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<Map<String, Object>>(rowKey, null){

            @Override
            public Map<String, Object> execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.GET, rowKey.getValues(), selectColumns, null, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "GET", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return ((ObTableOperationResult)result).getEntity().getSimpleProperties();
            }
        });
    }

    public ObPayload putWithResult(final String tableName, final Row rowKey, List<ObNewRange> keyRanges, final String[] columns, final Object[] values) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.PUT, rowKey.getValues(), columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "PUT", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    @Override
    public Replace replace(String tableName) {
        return new Replace(this, tableName);
    }

    @Override
    public long replace(final String tableName, final Object[] rowKey, final String[] columns, final Object[] values) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new TableExecuteCallback<Long>(rowKey){

            @Override
            public Long execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long getTableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.REPLACE, rowKey, columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "REPLACE", endpoint, rowKey, (ObTableOperationResult)result, getTableTime - start, System.currentTimeMillis() - getTableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkObTableOperationResult(obTable.getIp(), obTable.getPort(), request, result);
                return ((ObTableOperationResult)result).getAffectedRows();
            }
        });
    }

    public ObPayload replaceWithResult(final String tableName, final Row rowKey, List<ObNewRange> keyRanges, final String[] columns, final Object[] values) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.REPLACE, rowKey.getValues(), columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "REPLACE", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    @Override
    public InsertOrUpdate insertOrUpdate(String tableName) {
        return new InsertOrUpdate(this, tableName);
    }

    @Override
    public long insertOrUpdate(final String tableName, final Object[] rowKey, final String[] columns, final Object[] values) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new TableExecuteCallback<Long>(rowKey){

            @Override
            public Long execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long getTableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.INSERT_OR_UPDATE, rowKey, columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "INERT_OR_UPDATE", endpoint, rowKey, (ObTableOperationResult)result, getTableTime - start, System.currentTimeMillis() - getTableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkObTableOperationResult(obTable.getIp(), obTable.getPort(), request, result);
                return ((ObTableOperationResult)result).getAffectedRows();
            }
        });
    }

    public ObPayload insertOrUpdateWithResult(final String tableName, final Row rowKey, List<ObNewRange> keyRanges, final String[] columns, final Object[] values, final boolean usePut) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.INSERT_OR_UPDATE, rowKey.getValues(), columns, values, obTable.getObTableOperationTimeout());
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                if (usePut) {
                    request.setOptionFlag(ObTableOptionFlag.USE_PUT);
                }
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "INERT_OR_UPDATE", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    @Override
    public Put put(String tableName) {
        return new Put(this, tableName);
    }

    @Override
    public Increment increment(String tableName) {
        return new Increment(this, tableName);
    }

    @Override
    public Map<String, Object> increment(final String tableName, final Object[] rowKey, final String[] columns, final Object[] values, final boolean withResult) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new TableExecuteCallback<Map<String, Object>>(rowKey){

            @Override
            public Map<String, Object> execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long getTableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.INCREMENT, rowKey, columns, values, obTable.getObTableOperationTimeout());
                request.setReturningAffectedEntity(withResult);
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "INCREMENT", endpoint, rowKey, (ObTableOperationResult)result, getTableTime - start, System.currentTimeMillis() - getTableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkObTableOperationResult(obTable.getIp(), obTable.getPort(), request, result);
                return ((ObTableOperationResult)result).getEntity().getSimpleProperties();
            }
        });
    }

    public ObPayload incrementWithResult(final String tableName, final Row rowKey, List<ObNewRange> keyRanges, final String[] columns, final Object[] values, final boolean withResult) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.INCREMENT, rowKey.getValues(), columns, values, obTable.getObTableOperationTimeout());
                request.setReturningAffectedEntity(withResult);
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "INCREMENT", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    @Override
    public Append append(String tableName) {
        return new Append(this, tableName);
    }

    @Override
    public Map<String, Object> append(final String tableName, final Object[] rowKey, final String[] columns, final Object[] values, final boolean withResult) throws Exception {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new TableExecuteCallback<Map<String, Object>>(rowKey){

            @Override
            public Map<String, Object> execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long getTableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.APPEND, rowKey, columns, values, obTable.getObTableOperationTimeout());
                request.setReturningAffectedEntity(withResult);
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "INCREMENT", endpoint, rowKey, (ObTableOperationResult)result, getTableTime - start, System.currentTimeMillis() - getTableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkObTableOperationResult(obTable.getIp(), obTable.getPort(), request, result);
                return ((ObTableOperationResult)result).getEntity().getSimpleProperties();
            }
        });
    }

    public ObPayload appendWithResult(final String tableName, final Row rowKey, List<ObNewRange> keyRanges, final String[] columns, final Object[] values, final boolean withResult) throws Exception {
        final long start = System.currentTimeMillis();
        return this.execute(tableName, new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, ObTableOperationType.APPEND, rowKey.getValues(), columns, values, obTable.getObTableOperationTimeout());
                request.setReturningAffectedEntity(withResult);
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableName);
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info((ObPayload)request, ObTableClient.this.database, tableName, "INCREMENT", endpoint, rowKey.getValues(), (ObTableOperationResult)result, TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    @Override
    public BatchOperation batchOperation(String tableName) {
        return new BatchOperation(this, tableName);
    }

    public Partition getPartition(String tableName, Row rowKey, boolean refresh) throws Exception {
        return this.getSinglePartitionInternal(tableName, rowKey, refresh);
    }

    private Partition getSinglePartitionInternal(String tableName, Row rowKey, boolean refresh) throws Exception {
        if (this.tableRowKeyElement.get(tableName) == null) {
            this.addRowKeyElement(tableName, rowKey.getColumns());
        }
        ObPair<Long, ObTableParam> obPair = null;
        obPair = this.odpMode ? this.getODPTableWithRowKey(tableName, rowKey, refresh) : (refresh ? this.getTable(tableName, rowKey, true, true, true, this.getRoute(false)) : this.getTable(tableName, rowKey, false, false, false, this.getRoute(false)));
        ObTableParam tableParam = obPair.getRight();
        return new Partition(tableParam.getPartitionId(), tableParam.getPartId(), tableParam.getTableId(), tableParam.getObTable().getIp(), tableParam.getObTable().getPort(), tableParam.getLsId());
    }

    public List<Partition> getPartition(String tableName, boolean refresh) throws Exception {
        return this.getAllPartitionInternal(tableName, refresh);
    }

    private List<Partition> getAllPartitionInternal(String tableName, boolean refresh) throws Exception {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (this.odpMode) {
            List<ObPair<Long, ObTableParam>> allTables = this.getOdpTables(tableName, new ObTableQuery(), new Object[]{ObObj.getMin()}, true, new Object[]{ObObj.getMax()}, true, refresh);
            for (ObPair<Long, ObTableParam> table : allTables) {
                ObTableParam tableParam = table.getRight();
                Partition partition = new Partition(tableParam.getPartitionId(), table.getLeft(), tableParam.getTableId(), tableParam.getObTable().getIp(), tableParam.getObTable().getPort(), tableParam.getLsId());
                partitions.add(partition);
            }
        } else {
            List<ObPair<Long, ObTableParam>> allTables = refresh ? this.getTables(tableName, new ObTableQuery(), new Object[]{ObObj.getMin()}, true, new Object[]{ObObj.getMax()}, true, true, true, true, this.getRoute(false)) : this.getTables(tableName, new ObTableQuery(), new Object[]{ObObj.getMin()}, true, new Object[]{ObObj.getMax()}, true, false, false, false, this.getRoute(false));
            for (ObPair<Long, ObTableParam> table : allTables) {
                ObTableParam tableParam = table.getRight();
                Partition partition = new Partition(tableParam.getPartitionId(), tableParam.getPartId(), tableParam.getTableId(), tableParam.getObTable().getIp(), tableParam.getObTable().getPort(), tableParam.getLsId());
                partitions.add(partition);
            }
        }
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableEntry getOrFetchODPPartitionMeta(String tableName, boolean needRenew) throws Exception {
        ReentrantLock tmpLock;
        Lock lock;
        boolean acquired;
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        TableEntry odpTableEntry = this.ODPTableLocations.get(tableName);
        Long lastOdpRefreshTimeMills = null;
        Long reFetchInterval = 500L;
        if (odpTableEntry != null) {
            lastOdpRefreshTimeMills = odpTableEntry.getOdpRefreshTimeMills();
            if (!needRenew) {
                return odpTableEntry;
            }
        }
        if (!(acquired = (lock = (lock = this.fetchODPPartitionLocks.putIfAbsent(tableName, tmpLock = new ReentrantLock())) == null ? tmpLock : lock).tryLock(this.ODPTableEntryRefreshLockTimeout, TimeUnit.MILLISECONDS))) {
            String errMsg = "try to lock odpTable-entry refreshing timeout dataSource:" + this.dataSourceName + " ,tableName:" + tableName + " , timeout:" + this.ODPTableEntryRefreshLockTimeout + ".";
            TableClientLoggerFactory.RUNTIME.error(errMsg);
            throw new ObTableEntryRefreshException(errMsg);
        }
        if (this.ODPTableLocations.get(tableName) != null) {
            odpTableEntry = this.ODPTableLocations.get(tableName);
            long interval = System.currentTimeMillis() - odpTableEntry.getRefreshTimeMills();
            if (interval < reFetchInterval) {
                if (!needRenew) {
                    lock.unlock();
                    return odpTableEntry;
                }
                Thread.sleep(reFetchInterval - interval);
            }
        }
        boolean forceRenew = needRenew;
        boolean done = false;
        int retryTime = 0;
        try {
            do {
                try {
                    ObFetchPartitionMetaRequest request = ObFetchPartitionMetaRequest.getInstance(ObFetchPartitionMetaType.GET_PARTITION_META.getIndex(), tableName, this.clusterName, this.tenantName, this.database, forceRenew, this.odpTable.getObTableOperationTimeout());
                    ObPayload result = this.odpTable.execute(request);
                    this.checkObFetchPartitionMetaResult(lastOdpRefreshTimeMills, request, result);
                    ObFetchPartitionMetaResult obFetchPartitionMetaResult = (ObFetchPartitionMetaResult)result;
                    odpTableEntry = obFetchPartitionMetaResult.getTableEntry();
                    TableEntryKey key = new TableEntryKey(this.clusterName, this.tenantName, this.database, tableName);
                    odpTableEntry.setTableEntryKey(key);
                    if (odpTableEntry.isPartitionTable()) {
                        switch (this.runningMode) {
                            case HBASE: {
                                this.tableRowKeyElement.put(tableName, TableEntry.HBASE_ROW_KEY_ELEMENT);
                                odpTableEntry.setRowKeyElement(TableEntry.HBASE_ROW_KEY_ELEMENT);
                                break;
                            }
                            case NORMAL: {
                                Map<String, Integer> rowKeyElement = this.tableRowKeyElement.get(tableName);
                                if (rowKeyElement != null) {
                                    odpTableEntry.setRowKeyElement(rowKeyElement);
                                    break;
                                }
                                TableClientLoggerFactory.RUNTIME.error("partition table must has row key element key =" + key);
                                throw new ObTableEntryRefreshException("partition table must has row key element key =" + key);
                            }
                        }
                    }
                    this.ODPTableLocations.put(tableName, odpTableEntry);
                    done = true;
                }
                catch (Exception ex) {
                    TableClientLoggerFactory.RUNTIME.error("Fetching ODP partition meta meet exception", (Throwable)ex);
                    if (this.tableRowKeyElement.get(tableName) == null) {
                        throw ex;
                    }
                    if (ex instanceof ObTableException) {
                        forceRenew = true;
                        ++retryTime;
                        continue;
                    }
                    throw ex;
                }
            } while (!done && retryTime < 3);
            TableEntry tableEntry = odpTableEntry;
            return tableEntry;
        }
        finally {
            lock.unlock();
        }
    }

    private void checkObFetchPartitionMetaResult(Long lastOdpRefreshTimeMills, ObFetchPartitionMetaRequest request, ObPayload result) {
        if (result == null) {
            TableClientLoggerFactory.RUNTIME.error("client get unexpected NULL result");
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObFetchPartitionMetaResult)) {
            TableClientLoggerFactory.RUNTIME.error("client get unexpected result: " + result.getClass().getName());
            throw new ObTableException("client get unexpected result: " + result.getClass().getName());
        }
        if (lastOdpRefreshTimeMills != null && lastOdpRefreshTimeMills >= ((ObFetchPartitionMetaResult)result).getCreateTime()) {
            throw new ObTableException("client get outdated result from ODP");
        }
    }

    public ObPayload mutationWithFilter(TableQuery tableQuery, Row rowKey, List<ObNewRange> keyRanges, ObTableOperation operation, boolean withResult) throws Exception {
        return this.mutationWithFilter(tableQuery, rowKey, keyRanges, operation, withResult, false, false, false);
    }

    public ObPayload mutationWithFilter(final TableQuery tableQuery, Row rowKey, List<ObNewRange> keyRanges, final ObTableOperation operation, final boolean withResult, final boolean checkAndExecute, final boolean checkExists, final boolean rollbackWhenCheckFailed) throws Exception {
        final long start = System.currentTimeMillis();
        if (tableQuery != null && tableQuery.getObTableQuery().getKeyRanges().isEmpty()) {
            tableQuery.getObTableQuery().addKeyRange(ObNewRange.getWholeRange());
        }
        return this.execute(tableQuery.getTableName(), new OperationExecuteCallback<ObPayload>(rowKey, keyRanges){

            @Override
            public ObPayload execute(ObPair<Long, ObTableParam> obPair) throws Exception {
                long TableTime = System.currentTimeMillis();
                ObTableParam tableParam = obPair.getRight();
                ObTable obTable = tableParam.getObTable();
                ObTableQueryAndMutateRequest request = ObTableClient.this.obTableQueryAndMutate(operation, tableQuery, false);
                request.setTimeout(obTable.getObTableOperationTimeout());
                request.setReturningAffectedEntity(withResult);
                request.setTableId(tableParam.getTableId());
                request.setPartitionId(tableParam.getPartitionId());
                request.getTableQueryAndMutate().setIsCheckAndExecute(checkAndExecute);
                request.getTableQueryAndMutate().setIsCheckNoExists(!checkExists);
                request.getTableQueryAndMutate().setIsRollbackWhenCheckFailed(rollbackWhenCheckFailed);
                ObPayload result = ObTableClient.this.executeWithRetry(obTable, request, tableQuery.getTableName());
                String endpoint = obTable.getIp() + ":" + obTable.getPort();
                MonitorUtil.info(request, ObTableClient.this.database, tableQuery.getTableName(), "QUERY_AND_MUTATE", operation.getOperationType().toString(), endpoint, (ObTableQueryAndMutateResult)result, tableQuery.getObTableQuery(), TableTime - start, System.currentTimeMillis() - TableTime, ObTableClient.this.getslowQueryMonitorThreshold());
                this.checkResult(obTable.getIp(), obTable.getPort(), request, result);
                return result;
            }
        });
    }

    public ObPayload executeWithRetry(ObTable obTable, ObPayload request, String tableName) throws Exception {
        ObPayload result = obTable.execute(request);
        if (result != null && result.getPcode() == 4388) {
            ObTableApiMove moveResponse = (ObTableApiMove)result;
            this.getRouteTableRefresher().addTableIfAbsent(tableName, true);
            this.getRouteTableRefresher().triggerRefreshTable();
            obTable = this.getTable(moveResponse);
            result = obTable.execute(request);
            if (result instanceof ObTableApiMove) {
                ObTableApiMove move = (ObTableApiMove)result;
                logger.warn("The server has not yet completed the master switch, and returned an incorrect leader with an IP address of {}. Rerouting return IP is {}", (Object)moveResponse.getReplica().getServer().ipToString(), (Object)move.getReplica().getServer().ipToString());
                throw new ObTableRoutingWrongException();
            }
        }
        return result;
    }

    public ObTableQueryAndMutateRequest obTableQueryAndUpdate(TableQuery tableQuery, String[] columns, Object[] values) throws Exception {
        if (null == columns || null == values || 0 == columns.length || 0 == values.length) {
            throw new ObTableException("client get unexpected empty columns or values");
        }
        ObTableOperation operation = ObTableOperation.getInstance(ObTableOperationType.UPDATE, new Object[0], columns, values);
        return this.obTableQueryAndMutate(operation, tableQuery, false);
    }

    public ObTableQueryAndMutateRequest obTableQueryAndDelete(TableQuery tableQuery) throws Exception {
        ObTableOperation operation = ObTableOperation.getInstance(ObTableOperationType.DEL, new Object[0], null, null);
        return this.obTableQueryAndMutate(operation, tableQuery, false);
    }

    public ObTableQueryAndMutateRequest obTableQueryAndIncrement(TableQuery tableQuery, String[] columns, Object[] values, boolean withResult) throws Exception {
        if (null == columns || null == values || 0 == columns.length || 0 == values.length) {
            throw new ObTableException("client get unexpected empty columns or values");
        }
        ObTableOperation operation = ObTableOperation.getInstance(ObTableOperationType.INCREMENT, new Object[0], columns, values);
        return this.obTableQueryAndMutate(operation, tableQuery, withResult);
    }

    public ObTableQueryAndMutateRequest obTableQueryAndAppend(TableQuery tableQuery, String[] columns, Object[] values, boolean withResult) throws Exception {
        if (null == columns || null == values || 0 == columns.length || 0 == values.length) {
            throw new ObTableException("client get unexpected empty columns or values");
        }
        ObTableOperation operation = ObTableOperation.getInstance(ObTableOperationType.APPEND, new Object[0], columns, values);
        return this.obTableQueryAndMutate(operation, tableQuery, withResult);
    }

    ObTableQueryAndMutateRequest obTableQueryAndMutate(ObTableOperation operation, TableQuery tableQuery, boolean withResult) throws Exception {
        ObTableQuery obTableQuery = tableQuery.getObTableQuery();
        String tableName = tableQuery.getTableName();
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        ObTableBatchOperation operations = new ObTableBatchOperation();
        operations.addTableOperation(operation);
        ObTableQueryAndMutate queryAndMutate = this.buildObTableQueryAndMutate(obTableQuery, operations);
        ObTableQueryAndMutateRequest request = this.buildObTableQueryAndMutateRequest(queryAndMutate, tableName);
        request.setOptionFlag(ObTableOptionFlag.DEFAULT);
        request.setReturningAffectedEntity(withResult);
        request.setReturningAffectedRows(true);
        return request;
    }

    public ObPayload execute(ObTableAbstractOperationRequest request) throws Exception {
        if (request.getTableName() == null || request.getTableName().isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        if (request instanceof ObTableOperationRequest) {
            ObTableBatchOperation batchOperation = new ObTableBatchOperation();
            batchOperation.addTableOperation(((ObTableOperationRequest)request).getTableOperation());
            ObTableClientBatchOpsImpl batchOps = new ObTableClientBatchOpsImpl(request.getTableName(), batchOperation, this);
            batchOps.setEntityType(request.getEntityType());
            ObTableBatchOperationResult batchOpsResult = new ObClusterTableBatchOps(batchOps).executeInternal();
            return batchOpsResult.getResults().get(0);
        }
        if (request instanceof ObTableQueryRequest) {
            String tableName = request.getTableName();
            ObTableClientQueryImpl tableQuery = new ObTableClientQueryImpl(tableName, ((ObTableQueryRequest)request).getTableQuery(), this);
            tableQuery.setEntityType(request.getEntityType());
            return new ObClusterTableQuery(tableQuery).executeInternal();
        }
        if (request instanceof ObTableQueryAsyncRequest) {
            String tableName = request.getTableName();
            ObTableClientQueryImpl tableQuery = new ObTableClientQueryImpl(tableName, ((ObTableQueryAsyncRequest)request).getObTableQueryRequest().getTableQuery(), this);
            tableQuery.setEntityType(request.getEntityType());
            return new ObClusterTableQuery(tableQuery).asyncExecuteInternal();
        }
        if (request instanceof ObTableBatchOperationRequest) {
            ObTableClientBatchOpsImpl batchOps = new ObTableClientBatchOpsImpl(request.getTableName(), ((ObTableBatchOperationRequest)request).getBatchOperation(), this);
            batchOps.setEntityType(request.getEntityType());
            return new ObClusterTableBatchOps(this.runtimeBatchExecutor, batchOps).executeInternal();
        }
        if (request instanceof ObTableQueryAndMutateRequest) {
            ObTableQueryAndMutate tableQueryAndMutate = ((ObTableQueryAndMutateRequest)request).getTableQueryAndMutate();
            ObTableQuery tableQuery = tableQueryAndMutate.getTableQuery();
            if (tableQuery.getKeyRanges().isEmpty()) {
                tableQuery.addKeyRange(ObNewRange.getWholeRange());
            }
            if (this.isOdpMode()) {
                request.setTimeout(this.getOdpTable().getObTableOperationTimeout());
                return this.getOdpTable().execute(request);
            }
            int maxRetries = this.getRuntimeRetryTimes();
            int tryTimes = 0;
            long startExecute = System.currentTimeMillis();
            boolean needRefreshTableEntry = false;
            HashMap<Long, ObTableParam> partIdMapObTable = new HashMap<Long, ObTableParam>();
            while (true) {
                long currentExecute;
                long costMillis;
                if ((costMillis = (currentExecute = System.currentTimeMillis()) - startExecute) > this.getRuntimeMaxWait()) {
                    logger.error("tablename:{} it has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + this.getRuntimeMaxWait() + "/ms", (Object)request.getTableName());
                    throw new ObTableTimeoutExcetion("it has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + this.getRuntimeMaxWait() + "/ms");
                }
                try {
                    partIdMapObTable.clear();
                    for (ObNewRange rang : tableQuery.getKeyRanges()) {
                        int i;
                        ObRowKey startKey = rang.getStartKey();
                        int startKeySize = startKey.getObjs().size();
                        ObRowKey endKey = rang.getEndKey();
                        int endKeySize = endKey.getObjs().size();
                        Object[] start = new Object[startKeySize];
                        Object[] end = new Object[endKeySize];
                        for (i = 0; i < startKeySize; ++i) {
                            ObObj curStart = startKey.getObj(i);
                            start[i] = curStart.isMinObj() ? curStart : curStart.getValue();
                        }
                        for (i = 0; i < endKeySize; ++i) {
                            ObObj curEnd = endKey.getObj(i);
                            end[i] = curEnd.isMaxObj() ? curEnd : curEnd.getValue();
                        }
                        ObBorderFlag borderFlag = rang.getBorderFlag();
                        List<ObPair<Long, ObTableParam>> pairList = this.getTables(request.getTableName(), tableQuery, start, borderFlag.isInclusiveStart(), end, borderFlag.isInclusiveEnd(), needRefreshTableEntry, this.isTableEntryRefreshIntervalWait());
                        for (ObPair<Long, ObTableParam> pair : pairList) {
                            partIdMapObTable.put(pair.getLeft(), pair.getRight());
                        }
                    }
                    if (partIdMapObTable.size() > 1) {
                        throw new ObTablePartitionConsistentException("query and mutate must be a atomic operation");
                    }
                    Map.Entry entry = partIdMapObTable.entrySet().iterator().next();
                    ObTableParam tableParam = (ObTableParam)entry.getValue();
                    request.setTableId(tableParam.getTableId());
                    request.setPartitionId(tableParam.getPartitionId());
                    request.setTimeout(tableParam.getObTable().getObTableOperationTimeout());
                    ObTable obTable = tableParam.getObTable();
                    return this.executeWithRetry(obTable, request, request.getTableName());
                }
                catch (Exception ex) {
                    ++tryTimes;
                    if (ex instanceof ObTableException && ((ObTableException)ex).isNeedRefreshTableEntry()) {
                        needRefreshTableEntry = true;
                        logger.warn("tablename:{} partition id:{} batch ops refresh table while meet ObTableMasterChangeException, errorCode: {}", new Object[]{request.getTableName(), request.getPartitionId(), ((ObTableException)ex).getErrorCode(), ex});
                        if (this.isRetryOnChangeMasterTimes() && tryTimes <= maxRetries) {
                            logger.warn("tablename:{} partition id:{} batch ops retry while meet ObTableMasterChangeException, errorCode: {} , retry times {}", new Object[]{request.getTableName(), request.getPartitionId(), ((ObTableException)ex).getErrorCode(), tryTimes, ex});
                            if (!(ex instanceof ObTableNeedFetchAllException)) continue;
                            this.getOrRefreshTableEntry(request.getTableName(), needRefreshTableEntry, this.isTableEntryRefreshIntervalWait(), true);
                            continue;
                        }
                        this.calculateContinuousFailure(request.getTableName(), ex.getMessage());
                        throw ex;
                    }
                    this.calculateContinuousFailure(request.getTableName(), ex.getMessage());
                    throw ex;
                }
                break;
            }
        }
        throw new FeatureNotSupportedException("request type " + request.getClass().getSimpleName() + "is not supported. make sure the correct version");
    }

    private ObTableQueryAndMutate buildObTableQueryAndMutate(ObTableQuery obTableQuery, ObTableBatchOperation obTableBatchOperation) {
        ObTableQueryAndMutate queryAndMutate = new ObTableQueryAndMutate();
        queryAndMutate.setTableQuery(obTableQuery);
        queryAndMutate.setMutations(obTableBatchOperation);
        return queryAndMutate;
    }

    private ObTableQueryAndMutateRequest buildObTableQueryAndMutateRequest(ObTableQueryAndMutate queryAndMutate, String targetTableName) {
        ObTableQueryAndMutateRequest request = new ObTableQueryAndMutateRequest();
        request.setTableName(targetTableName);
        request.setTableQueryAndMutate(queryAndMutate);
        request.setEntityType(ObTableEntityType.KV);
        return request;
    }

    @Override
    public CheckAndInsUp checkAndInsUp(String tableName, ObTableFilter filter, InsertOrUpdate insUp, boolean checkExists) {
        return new CheckAndInsUp(this, tableName, filter, insUp, checkExists);
    }

    @Override
    public CheckAndInsUp checkAndInsUp(String tableName, ObTableFilter filter, InsertOrUpdate insUp, boolean checkExists, boolean rollbackWhenCheckFailed) {
        return new CheckAndInsUp(this, tableName, filter, insUp, checkExists, rollbackWhenCheckFailed);
    }

    public void setFullUserName(String fullUserName) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)fullUserName)) {
            TableClientLoggerFactory.RUNTIME.error(String.format("full username is empty, full username=%s", fullUserName));
            throw new IllegalArgumentException(String.format("full username is empty, full username=%s", fullUserName));
        }
        if (!this.odpMode) {
            if (-1 != fullUserName.indexOf(64) || -1 != fullUserName.indexOf(35)) {
                this.parseStandardFullUsername(fullUserName);
            } else {
                this.parseNonStandardFullUsername(fullUserName);
            }
        }
        this.fullUserName = fullUserName;
    }

    public void setSysUserName(String sysUserName) {
        this.sysUA.setUserName(sysUserName);
    }

    public void setSysPassword(String sysPassword) {
        this.sysUA.setPassword(sysPassword);
    }

    public void setEncSysPassword(String encSysPassword) throws Exception {
        this.sysUA.setEncPassword(encSysPassword);
    }

    private void parseStandardFullUsername(String username) {
        int utIndex = -1;
        int tcIndex = -1;
        utIndex = username.indexOf(64);
        tcIndex = username.indexOf(35);
        if (-1 == utIndex || -1 == tcIndex || utIndex >= tcIndex) {
            TableClientLoggerFactory.RUNTIME.error(String.format("invalid full username, username=%s", username));
            throw new IllegalArgumentException(String.format("invalid full username, username=%s (which should be userName@tenantName#clusterName)", username));
        }
        String user = username.substring(0, utIndex);
        String tenant = username.substring(utIndex + 1, tcIndex);
        String cluster = username.substring(tcIndex + 1);
        this.handleFullUsername(user, tenant, cluster, username);
    }

    private void parseNonStandardFullUsername(String username) {
        String separator;
        if (StringUtils.isBlank((CharSequence)usernameSeparators)) {
            TableClientLoggerFactory.RUNTIME.error(String.format("non standard username separators has not been set, full username=%s", username));
            throw new IllegalArgumentException(String.format("non standard username separators has not been set, full username=%s", username));
        }
        String[] separators = usernameSeparators.split(";");
        char separatorChar = '\u0000';
        int ctIndex = -1;
        int tuIndex = -1;
        String[] stringArray = separators;
        int n = stringArray.length;
        for (int i = 0; i < n && (ctIndex = username.indexOf(separatorChar = (separator = stringArray[i]).charAt(0))) == (tuIndex = username.lastIndexOf(separatorChar)); ++i) {
        }
        if (-1 == ctIndex || -1 == tuIndex || ctIndex == tuIndex) {
            TableClientLoggerFactory.RUNTIME.error(String.format("invalid full username, username=%s, userSeparators=%s", username, usernameSeparators));
            throw new IllegalArgumentException(String.format("invalid full username, username=%s, userSeparators=%s", username, usernameSeparators));
        }
        String cluster = username.substring(0, ctIndex);
        String tenant = username.substring(ctIndex + 1, tuIndex);
        String user = username.substring(tuIndex + 1);
        this.handleFullUsername(user, tenant, cluster, username);
    }

    private void handleFullUsername(String user, String tenant, String cluster, String username) {
        if (StringUtils.isBlank((CharSequence)user)) {
            TableClientLoggerFactory.RUNTIME.error(String.format("user has not been set, username=%s", username));
            throw new IllegalArgumentException(String.format("user has not been set, username=%s", username));
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            TableClientLoggerFactory.RUNTIME.error(String.format("tenant has not been set, username=%s", username));
            throw new IllegalArgumentException(String.format("tenant has not been set, username=%s", username));
        }
        if (StringUtils.isBlank((CharSequence)cluster)) {
            TableClientLoggerFactory.RUNTIME.error(String.format("cluster has not been set, username=%s", username));
            throw new IllegalArgumentException(String.format("cluster has not been set, username=%s", username));
        }
        this.setUserName(user);
        this.setTenantName(tenant);
        this.setClusterName(cluster);
    }

    public String getParamURL() {
        return this.paramURL;
    }

    public void setParamURL(String paramURL) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)paramURL)) {
            TableClientLoggerFactory.RUNTIME.error(String.format("zdal url is empty, url=%s", paramURL));
            throw new IllegalArgumentException(String.format("zdal url is empty, url=%s", paramURL));
        }
        int paramIndex = paramURL.indexOf(63);
        if (-1 == paramIndex || paramIndex + 1 == paramURL.length()) {
            TableClientLoggerFactory.RUNTIME.error(String.format("invalid zdal url, parameters are not set. url=%s", paramURL));
            throw new IllegalArgumentException(String.format("invalid zdal url, parameters are not set. url=%s", paramURL));
        }
        String[] params = paramURL.substring(paramIndex + 1).split("&");
        String db = null;
        for (String param : params) {
            String[] kv = param.split("=");
            if (2 != kv.length) {
                TableClientLoggerFactory.RUNTIME.error(String.format("invalid parameter format. url=%s", paramURL));
                throw new IllegalArgumentException(String.format("invalid parameter format. url=%s", paramURL));
            }
            if ("database".equalsIgnoreCase(kv[0])) {
                db = kv[1];
                if (!TableClientLoggerFactory.BOOT.isInfoEnabled()) continue;
                TableClientLoggerFactory.BOOT.info(String.format("will set database=%s", kv[1]));
                continue;
            }
            if ("read_consistency".equalsIgnoreCase(kv[0])) {
                this.readConsistency = ObReadConsistency.getByName(kv[1]);
                if (!TableClientLoggerFactory.BOOT.isInfoEnabled()) continue;
                TableClientLoggerFactory.BOOT.info(String.format("will set %s=%s", "read_consistency", kv[1]));
                continue;
            }
            if (!"ob_route_policy".equalsIgnoreCase(kv[0])) continue;
            this.obRoutePolicy = ObRoutePolicy.getByName(kv[1]);
            if (!TableClientLoggerFactory.BOOT.isInfoEnabled()) continue;
            TableClientLoggerFactory.BOOT.info(String.format("will set %s=%s", "ob_route_policy", kv[1]));
        }
        if (StringUtils.isBlank(db)) {
            throw new IllegalArgumentException(String.format("database is empty in paramURL(configURL). url=%s", paramURL));
        }
        this.setDatabase(db);
        this.paramURL = paramURL;
    }

    public String getFullUserName() {
        return this.fullUserName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean isRetryOnChangeMasterTimes() {
        return this.retryOnChangeMasterTimes;
    }

    public void setRetryOnChangeMasterTimes(boolean retryOnChangeMasterTimes) {
        this.retryOnChangeMasterTimes = retryOnChangeMasterTimes;
    }

    public void addRowKeyElement(String tableName, String[] columns) {
        if (columns == null || columns.length == 0) {
            TableClientLoggerFactory.RUNTIME.error("add row key element error table " + tableName + " column " + Arrays.toString(columns));
            throw new IllegalArgumentException("add row key element error table " + tableName + " column " + Arrays.toString(columns));
        }
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("table name is null");
        }
        LinkedHashMap<String, Integer> rowKeyElement = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < columns.length; ++i) {
            rowKeyElement.put(columns[i], i);
        }
        this.tableRowKeyElement.put(tableName, rowKeyElement);
    }

    public Map<String, Integer> getRowKeyElement(String tableName) {
        return this.tableRowKeyElement.get(tableName);
    }

    public void setRunningMode(RunningMode runningMode) {
        this.runningMode = runningMode;
    }

    public RunningMode getRunningMode() {
        return this.runningMode;
    }

    public ObReadConsistency getReadConsistency() {
        ObReadConsistency readConsistency = ThreadLocalMap.getReadConsistency();
        if (readConsistency == null) {
            readConsistency = this.readConsistency;
        }
        return readConsistency;
    }

    public ObRoutePolicy getObRoutePolicy() {
        return this.obRoutePolicy;
    }

    public ObServerRoute getReadRoute() {
        if (this.odpMode) {
            return null;
        }
        if (this.getReadConsistency().isStrong()) {
            return ObServerRoute.STRONG_READ;
        }
        return new ObServerRoute(ObReadConsistency.WEAK, this.obRoutePolicy, this.serverRoster.getServerLdcLocation().isLdcUsed());
    }

    public ObServerRoute getRoute(boolean readonly) {
        if (readonly) {
            return this.getReadRoute();
        }
        return ObServerRoute.STRONG_READ;
    }

    public void setOdpAddr(String odpAddr) {
        this.odpAddr = odpAddr;
    }

    public void setOdpPort(int odpPort) {
        this.odpPort = odpPort;
    }

    public void setCurrentIDC(String idc) {
        this.currentIDC = idc;
    }

    public String toString() {
        return "ObTableClient {\n serverRoster = " + this.serverRoster.getMembers() + ", \n serverIdc = " + this.serverRoster.getServerLdcLocation() + ", \n tableLocations = " + this.tableLocations + ", \n tableRoster = " + this.tableRoster + ", \n ocpModel = " + this.ocpModel + "\n}\n";
    }

    public ConcurrentHashMap<String, String> getTableGroupInverted() {
        return this.TableGroupInverted;
    }

    public ConcurrentHashMap<String, String> getTableGroupCache() {
        return this.TableGroupCache;
    }

    public void eraseTableGroupFromCache(String tableGroupName) {
        this.TableGroupInverted.remove(this.TableGroupCache.get(tableGroupName));
        this.TableGroupCache.remove(tableGroupName);
        this.TableGroupCacheLocks.remove(tableGroupName);
    }

    public boolean isTableGroupName(String tabName) {
        return !tabName.contains("$");
    }

    public String getPhyTableNameFromTableGroup(ObTableQueryRequest request, String tableName) throws Exception {
        if (!this.odpMode && request.getTableQuery().isHbaseQuery() && this.isTableGroupName(tableName)) {
            tableName = this.tryGetTableNameFromTableGroupCache(tableName, false);
        }
        return tableName;
    }

    public String getPhyTableNameFromTableGroup(ObTableEntityType type, String tableName) throws Exception {
        if (!this.odpMode && type == ObTableEntityType.HKV && this.isTableGroupName(tableName)) {
            tableName = this.tryGetTableNameFromTableGroupCache(tableName, false);
        }
        return tableName;
    }

    public byte[][][] getFirstPartStartKeys(String tableName) throws Exception {
        if (this.runningMode != RunningMode.HBASE && !this.tableRowKeyElement.containsKey(tableName)) {
            throw new IllegalArgumentException("Row key element is empty for " + tableName);
        }
        TableEntry tableEntry = this.getOrRefreshTableEntry(tableName, true, false, false);
        Object firstPartStartKeys = new byte[][][]{};
        if (tableEntry.isPartitionTable()) {
            if (null != tableEntry.getPartitionInfo() && null != tableEntry.getPartitionInfo().getFirstPartDesc()) {
                ObPartFuncType obPartFuncType = tableEntry.getPartitionInfo().getFirstPartDesc().getPartFuncType();
                if (obPartFuncType.isRangePart()) {
                    int i;
                    ObRangePartDesc rangePartDesc = (ObRangePartDesc)tableEntry.getPartitionInfo().getFirstPartDesc();
                    List<List<byte[]>> highBoundVals = rangePartDesc.getHighBoundValues();
                    int startKeysLen = highBoundVals.size();
                    int partKeyLen = highBoundVals.get(0).size();
                    firstPartStartKeys = new byte[startKeysLen][][];
                    firstPartStartKeys[0] = new byte[partKeyLen][];
                    for (i = 0; i < partKeyLen; ++i) {
                        firstPartStartKeys[0][i] = new byte[0];
                    }
                    for (i = 0; i < startKeysLen - 1; ++i) {
                        List<byte[]> innerList = highBoundVals.get(i);
                        firstPartStartKeys[i + 1] = new byte[innerList.size()][];
                        for (int j = 0; j < innerList.size(); ++j) {
                            firstPartStartKeys[i + 1][j] = innerList.get(j);
                        }
                    }
                } else {
                    ObPartDesc partDesc = tableEntry.getPartitionInfo().getFirstPartDesc();
                    int partKeyLen = partDesc.getPartColumns().size();
                    firstPartStartKeys = new byte[1][partKeyLen][];
                    Arrays.fill((Object[])firstPartStartKeys[0], new byte[0]);
                }
            }
        } else {
            firstPartStartKeys = new byte[1][1][];
            Arrays.fill((Object[])firstPartStartKeys[0], new byte[0]);
        }
        return firstPartStartKeys;
    }

    public byte[][][] getFirstPartEndKeys(String tableName) throws Exception {
        if (this.runningMode != RunningMode.HBASE && this.tableRowKeyElement.containsKey(tableName)) {
            throw new IllegalArgumentException("Row key element is empty for " + tableName);
        }
        TableEntry tableEntry = this.getOrRefreshTableEntry(tableName, true, false, false);
        Object firstPartEndKeys = new byte[][][]{};
        if (tableEntry.isPartitionTable()) {
            if (null != tableEntry.getPartitionInfo() && null != tableEntry.getPartitionInfo().getFirstPartDesc()) {
                ObPartFuncType obPartFuncType = tableEntry.getPartitionInfo().getFirstPartDesc().getPartFuncType();
                if (obPartFuncType.isRangePart()) {
                    ObRangePartDesc rangePartDesc = (ObRangePartDesc)tableEntry.getPartitionInfo().getFirstPartDesc();
                    List<List<byte[]>> highBoundVals = rangePartDesc.getHighBoundValues();
                    int endKeysLen = highBoundVals.size();
                    firstPartEndKeys = new byte[endKeysLen][][];
                    for (int i = 0; i < endKeysLen; ++i) {
                        List<byte[]> innerList = highBoundVals.get(i);
                        firstPartEndKeys[i] = new byte[innerList.size()][];
                        for (int j = 0; j < innerList.size(); ++j) {
                            firstPartEndKeys[i][j] = innerList.get(j);
                        }
                    }
                } else {
                    ObPartDesc partDesc = tableEntry.getPartitionInfo().getFirstPartDesc();
                    int partKeyLen = partDesc.getPartColumns().size();
                    firstPartEndKeys = new byte[1][partKeyLen][];
                    Arrays.fill((Object[])firstPartEndKeys[0], new byte[0]);
                }
            }
        } else {
            firstPartEndKeys = new byte[1][1][];
            Arrays.fill((Object[])firstPartEndKeys[0], new byte[0]);
        }
        return firstPartEndKeys;
    }

    public byte[][] getHBaseTableStartKeys(String hbaseTableName) throws Exception {
        if (this.runningMode != RunningMode.HBASE) {
            throw new IllegalArgumentException("getHBaseTableStartKeys only support in HBase mode");
        }
        String tableName = this.tryGetTableNameFromTableGroupCache(hbaseTableName, false);
        byte[][][] firstPartStartKeys = this.getFirstPartStartKeys(tableName);
        byte[][] startKeys = new byte[firstPartStartKeys.length][];
        for (int i = 0; i < firstPartStartKeys.length; ++i) {
            if (firstPartStartKeys[i] == null || firstPartStartKeys[i].length != 1 || firstPartStartKeys[i][0] == null || firstPartStartKeys[i][0].length > 1) {
                throw new IllegalArgumentException("Invalid start keys structure at index " + i + " for table " + hbaseTableName);
            }
            startKeys[i] = firstPartStartKeys[i][0];
        }
        return startKeys;
    }

    public byte[][] getHBaseTableEndKeys(String hbaseTableName) throws Exception {
        if (this.runningMode != RunningMode.HBASE) {
            throw new IllegalArgumentException("getHBaseTableStartKeys only support in HBase mode");
        }
        String tableName = this.tryGetTableNameFromTableGroupCache(hbaseTableName, false);
        byte[][][] firstPartEndKeys = this.getFirstPartEndKeys(tableName);
        byte[][] endKeys = new byte[firstPartEndKeys.length][];
        for (int i = 0; i < firstPartEndKeys.length; ++i) {
            if (firstPartEndKeys[i] == null || firstPartEndKeys[i].length != 1 || firstPartEndKeys[i][0] == null || firstPartEndKeys[i][0].length > 1) {
                throw new IllegalArgumentException("Invalid end keys structure at index " + i + " for table " + hbaseTableName);
            }
            endKeys[i] = firstPartEndKeys[i][0];
        }
        return endKeys;
    }

    public static enum RunningMode {
        NORMAL,
        HBASE;

    }

    private abstract class OperationExecuteCallback<T> {
        private final Row rowKey;
        private final List<ObNewRange> keyRanges;

        OperationExecuteCallback(Row rowKey, List<ObNewRange> keyRanges) {
            this.rowKey = rowKey;
            this.keyRanges = keyRanges;
        }

        void checkResult(String ip, int port, ObPayload request, ObPayload result) {
            if (result == null) {
                TableClientLoggerFactory.RUNTIME.error("client get unexpected NULL result");
                throw new ObTableException("client get unexpected NULL result");
            }
            if (result instanceof ObTableOperationResult) {
                ObTableOperationResult obTableOperationResult = (ObTableOperationResult)result;
                ObTableOperationRequest obTableOperationRequest = (ObTableOperationRequest)request;
                obTableOperationResult.setExecuteHost(ip);
                obTableOperationResult.setExecutePort(port);
                long sequence = obTableOperationResult.getSequence() == 0L ? obTableOperationRequest.getSequence() : obTableOperationResult.getSequence();
                long uniqueId = obTableOperationResult.getUniqueId() == 0L ? obTableOperationRequest.getUniqueId() : obTableOperationResult.getUniqueId();
                ExceptionUtil.throwObTableException(ip, port, sequence, uniqueId, obTableOperationResult.getHeader().getErrno(), obTableOperationResult.getHeader().getErrMsg());
            } else if (!(result instanceof ObTableQueryAndMutateResult)) {
                TableClientLoggerFactory.RUNTIME.error("client get unexpected result: " + result.getClass().getName());
                throw new ObTableException("client get unexpected result: " + result.getClass().getName());
            }
        }

        abstract T execute(ObPair<Long, ObTableParam> var1) throws Exception;

        public Row getRowKey() {
            return this.rowKey;
        }

        public List<ObNewRange> getKeyRanges() {
            return this.keyRanges;
        }
    }

    private abstract class TableExecuteCallback<T> {
        private final Object[] rowKey;

        TableExecuteCallback(Object[] rowKey) {
            this.rowKey = rowKey;
        }

        void checkObTableOperationResult(String ip, int port, ObPayload request, ObPayload result) {
            if (result == null) {
                TableClientLoggerFactory.RUNTIME.error("client get unexpected NULL result");
                throw new ObTableException("client get unexpected NULL result");
            }
            if (!(result instanceof ObTableOperationResult)) {
                TableClientLoggerFactory.RUNTIME.error("client get unexpected result: " + result.getClass().getName());
                throw new ObTableException("client get unexpected result: " + result.getClass().getName());
            }
            ObTableOperationResult obTableOperationResult = (ObTableOperationResult)result;
            ObTableOperationRequest obTableOperationRequest = (ObTableOperationRequest)request;
            obTableOperationResult.setExecuteHost(ip);
            obTableOperationResult.setExecutePort(port);
            long sequence = obTableOperationResult.getSequence() == 0L ? obTableOperationRequest.getSequence() : obTableOperationResult.getSequence();
            long uniqueId = obTableOperationResult.getUniqueId() == 0L ? obTableOperationRequest.getUniqueId() : obTableOperationResult.getUniqueId();
            ExceptionUtil.throwObTableException(ip, port, sequence, uniqueId, obTableOperationResult.getHeader().getErrno(), obTableOperationResult.getHeader().getErrMsg());
        }

        void checkObTableQueryAndMutateResult(String ip, int port, ObPayload result) {
            if (result == null) {
                TableClientLoggerFactory.RUNTIME.error("client get unexpected NULL result");
                throw new ObTableException("client get unexpected NULL result");
            }
            if (!(result instanceof ObTableQueryAndMutateResult)) {
                TableClientLoggerFactory.RUNTIME.error("client get unexpected result: " + result.getClass().getName());
                throw new ObTableException("client get unexpected result: " + result.getClass().getName());
            }
        }

        abstract T execute(ObPair<Long, ObTableParam> var1) throws Exception;

        public Object[] getRowKey() {
            return this.rowKey;
        }
    }
}

