/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.execution;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnection;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadServerException;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementExecutor;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementAsyncPromiseTask;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocol;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadAbortRpc;
import com.alipay.oceanbase.rpc.direct_load.util.ObDirectLoadIntervalUtil;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.table.ObTable;
import java.util.concurrent.TimeUnit;

public class ObDirectLoadStatementAbortTask
extends ObDirectLoadStatementAsyncPromiseTask {
    private final ObDirectLoadConnection connection;
    private final ObDirectLoadProtocol protocol;
    private final ObDirectLoadStatementExecutor executor;
    private static final int STATE_NONE = 0;
    private static final int STATE_SEND_ABORT = 1;
    private static final int STATE_SUCC = 3;
    private static final int STATE_FAIL = 4;
    private int state = 0;
    private ObDirectLoadIntervalUtil intervalUtil = new ObDirectLoadIntervalUtil();

    public ObDirectLoadStatementAbortTask(ObDirectLoadStatement statement, ObDirectLoadStatementExecutor executor) {
        super(statement);
        this.connection = statement.getConnection();
        this.protocol = this.connection.getProtocol();
        this.executor = executor;
    }

    @Override
    public void run() {
        try {
            if (this.state == 0) {
                this.state = 1;
            }
            if (this.state == 1) {
                this.sendAbort();
            }
            if (this.state == 3) {
                this.setSuccess();
            }
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement abort task run failed", e);
            this.state = 4;
            this.setFailure(e);
        }
    }

    private void sendAbort() throws ObDirectLoadException {
        try {
            this.doSendAbort();
            if (this.intervalUtil.reachTimeInterval(10000L)) {
                this.logger.info("statement waiting abort");
            }
            this.schedule(500L, TimeUnit.MILLISECONDS);
        }
        catch (ObDirectLoadException e) {
            int errorCode;
            if (e instanceof ObDirectLoadServerException && (errorCode = ((ObDirectLoadServerException)e).getErrorCode()) == ResultCodes.OB_ENTRY_NOT_EXIST.errorCode) {
                this.logger.info("statement is aborted");
                this.state = 3;
                return;
            }
            throw e;
        }
    }

    private ObDirectLoadAbortRpc doSendAbort() throws ObDirectLoadException {
        ObTable table = this.statement.getObTablePool().getControlObTable();
        long timeoutMillis = this.statement.getTimeoutRemain();
        ObDirectLoadAbortRpc rpc = this.protocol.getAbortRpc(this.executor.getTraceId());
        rpc.setSvrAddr(this.executor.getSvrAddr());
        rpc.setTableId(this.executor.getTableId());
        rpc.setTaskId(this.executor.getTaskId());
        this.logger.debug("statement send abort rpc");
        this.connection.executeWithConnection(rpc, table, timeoutMillis);
        this.logger.debug("statement abort rpc response successful");
        return rpc;
    }
}

