/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.execution;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnection;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadRuntimeInfo;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadExceptionUtil;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadRpcException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadServerException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadServerStatusException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadTimeoutException;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementExecutor;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementAsyncPromiseTask;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocol;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadBeginRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadGetStatusRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObTableLoadClientStatus;
import com.alipay.oceanbase.rpc.direct_load.util.ObDirectLoadIntervalUtil;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.table.ObTable;
import java.util.concurrent.TimeUnit;

public class ObDirectLoadStatementBeginTask
extends ObDirectLoadStatementAsyncPromiseTask {
    private final ObDirectLoadConnection connection;
    private final ObDirectLoadProtocol protocol;
    private final ObDirectLoadStatementExecutor executor;
    private final ObDirectLoadStatementExecutor.BeginProxy proxy;
    private static final int STATE_NONE = 0;
    private static final int STATE_SEND_BEGIN = 1;
    private static final int STATE_WAIT_STATUS_RUNNING = 2;
    private static final int STATE_SUCC = 3;
    private static final int STATE_FAIL = 4;
    private int state = 0;
    private int retryCount = 0;
    private int rebeginCount = 0;
    private ObDirectLoadIntervalUtil intervalUtil = new ObDirectLoadIntervalUtil();
    private ObDirectLoadRuntimeInfo runtimeInfo = new ObDirectLoadRuntimeInfo();

    public ObDirectLoadStatementBeginTask(ObDirectLoadStatement statement, ObDirectLoadStatementExecutor executor) {
        super(statement);
        this.connection = statement.getConnection();
        this.protocol = this.connection.getProtocol();
        this.executor = executor;
        this.proxy = executor.getBeginProxy();
    }

    @Override
    public ObDirectLoadRuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    @Override
    public void run() {
        this.runtimeInfo.incScheduledCount();
        this.runtimeInfo.setLastScheduledTime(System.currentTimeMillis());
        try {
            this.proxy.checkStatus();
            if (this.state == 0) {
                this.state = 1;
            }
            if (this.state == 1) {
                this.sendBegin();
            }
            if (this.state == 2) {
                this.waitStatusRunning();
            }
            if (this.state == 3) {
                this.proxy.setSuccess();
                this.setSuccess();
            }
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement begin task run failed", e);
            this.state = 4;
            this.proxy.setFailure(e);
            this.setFailure(e);
        }
    }

    private static boolean isRetryCode(int errorCode) {
        return errorCode == ResultCodes.OB_ENTRY_NOT_EXIST.errorCode || errorCode == ResultCodes.OB_SIZE_OVERFLOW.errorCode || errorCode == ResultCodes.OB_EAGAIN.errorCode || errorCode == ResultCodes.OB_NOT_MASTER.errorCode || errorCode == ResultCodes.OB_OP_NOT_ALLOW.errorCode || errorCode == ResultCodes.OB_LS_NOT_EXIST.errorCode || errorCode == ResultCodes.OB_TABLET_NOT_EXIST.errorCode || errorCode == ResultCodes.OB_SCHEMA_EAGAIN.errorCode || errorCode == ResultCodes.OB_ERR_PARALLEL_DDL_CONFLICT.errorCode;
    }

    private boolean canRetry(ObDirectLoadException e) {
        boolean bResult = false;
        if (e instanceof ObDirectLoadRpcException) {
            bResult = e instanceof ObDirectLoadTimeoutException;
        } else if (e instanceof ObDirectLoadServerException) {
            int errorCode = ((ObDirectLoadServerException)e).getErrorCode();
            bResult = ObDirectLoadStatementBeginTask.isRetryCode(errorCode);
        } else if (e instanceof ObDirectLoadServerStatusException) {
            int errorCode = ((ObDirectLoadServerStatusException)e).getErrorCode();
            bResult = ObDirectLoadStatementBeginTask.isRetryCode(errorCode);
        }
        return bResult;
    }

    private void sendBegin() throws ObDirectLoadException {
        try {
            ObDirectLoadBeginRpc rpc = null;
            try {
                rpc = this.doSendBeginRpc();
            }
            catch (ObDirectLoadException e) {
                this.logger.warn("statement send begin rpc failed", e);
                throw e;
            }
            ObTableLoadClientStatus status = rpc.getStatus();
            int errorCode = rpc.getErrorCode();
            switch (status) {
                case INITIALIZING: 
                case WAITTING: {
                    this.proxy.setSuccess0(rpc.getSvrAddr(), rpc.getTableId(), rpc.getTaskId());
                    this.state = 2;
                    break;
                }
                case RUNNING: {
                    this.proxy.setSuccess0(rpc.getSvrAddr(), rpc.getTableId(), rpc.getTaskId());
                    this.logger.info("statement server status reach running");
                    this.state = 3;
                    break;
                }
                case ERROR: {
                    this.logger.warn("statement server status is error, errorCode:" + errorCode);
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
                case ABORT: {
                    this.logger.warn("statement server status is abort, errorCode:" + errorCode);
                    if (errorCode == ResultCodes.OB_SUCCESS.errorCode) {
                        errorCode = ResultCodes.OB_CANCELED.errorCode;
                    }
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
                default: {
                    this.logger.warn("statement server status is unexpected, status:" + (Object)((Object)status));
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
            }
        }
        catch (ObDirectLoadException e) {
            if (this.canRetry(e)) {
                ++this.retryCount;
                this.logger.info("statement retry send begin rpc after 1s, retryCount:" + this.retryCount);
                this.schedule(1000L, TimeUnit.MILLISECONDS);
                return;
            }
            throw e;
        }
    }

    private ObDirectLoadBeginRpc doSendBeginRpc() throws ObDirectLoadException {
        ObTable table = this.statement.getObTablePool().getControlObTable();
        long timeoutMillis = this.statement.getTimeoutRemain();
        ObDirectLoadBeginRpc rpc = this.protocol.getBeginRpc(this.statement.getTraceId());
        rpc.setTableName(this.statement.getTableName());
        rpc.setParallel(this.statement.getParallel());
        rpc.setMaxErrorRowCount(this.statement.getMaxErrorRowCount());
        rpc.setDupAction(this.statement.getDupAction());
        rpc.setTimeout(this.statement.getQueryTimeout() * 1000L);
        rpc.setHeartBeatTimeout(this.connection.getHeartBeatTimeout() * 1000L);
        rpc.setLoadMethod(this.statement.getLoadMethod());
        rpc.setColumnNames(this.statement.getColumnNames());
        rpc.setPartitionNames(this.statement.getPartitionNames());
        this.logger.info("statement send begin rpc, arg:" + rpc.getArg());
        this.connection.executeWithConnection(rpc, table, timeoutMillis);
        this.logger.info("statement begin rpc response successful, svrAddr:" + rpc.getSvrAddr() + ", res:" + rpc.getRes());
        return rpc;
    }

    private void waitStatusRunning() throws ObDirectLoadException {
        try {
            ObDirectLoadGetStatusRpc rpc = null;
            try {
                rpc = this.doSendGetStatus();
            }
            catch (ObDirectLoadException e) {
                this.logger.warn("statement send get status rpc failed", e);
                throw e;
            }
            ObTableLoadClientStatus status = rpc.getStatus();
            int errorCode = rpc.getErrorCode();
            switch (status) {
                case INITIALIZING: 
                case WAITTING: {
                    if (this.intervalUtil.reachTimeInterval(10000L)) {
                        this.logger.info("statement waiting server status reach running, status:" + (Object)((Object)status));
                    }
                    this.schedule(500L, TimeUnit.MILLISECONDS);
                    break;
                }
                case RUNNING: {
                    this.logger.info("statement server status reach running");
                    this.state = 3;
                    break;
                }
                case ERROR: {
                    this.logger.warn("statement server status is error, errorCode:" + errorCode);
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
                case ABORT: {
                    this.logger.warn("statement server status is abort, errorCode:" + errorCode);
                    if (errorCode == ResultCodes.OB_SUCCESS.errorCode) {
                        errorCode = ResultCodes.OB_CANCELED.errorCode;
                    }
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
                default: {
                    this.logger.warn("statement server status is unexpected, status:" + (Object)((Object)status));
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
            }
        }
        catch (ObDirectLoadException e) {
            if (e instanceof ObDirectLoadServerStatusException) {
                if (this.canRetry(e)) {
                    ++this.rebeginCount;
                    this.retryCount = 0;
                    this.logger.info("statement retry begin after 1s, rebeginCount:" + this.rebeginCount);
                    this.proxy.clear();
                    this.state = 0;
                    this.schedule(1000L, TimeUnit.MILLISECONDS);
                    return;
                }
                throw e;
            }
            this.schedule(500L, TimeUnit.MILLISECONDS);
        }
    }

    private ObDirectLoadGetStatusRpc doSendGetStatus() throws ObDirectLoadException {
        ObTable table = this.statement.getObTablePool().getControlObTable();
        long timeoutMillis = this.statement.getTimeoutRemain();
        ObDirectLoadGetStatusRpc rpc = this.protocol.getGetStatusRpc(this.executor.getTraceId());
        rpc.setSvrAddr(this.executor.getSvrAddr());
        rpc.setTableId(this.executor.getTableId());
        rpc.setTaskId(this.executor.getTaskId());
        this.logger.debug("statement send get status rpc, arg:" + rpc.getArg());
        this.connection.executeWithConnection(rpc, table, timeoutMillis);
        this.logger.debug("statement get status rpc response successful, res:" + rpc.getRes());
        return rpc;
    }
}

