/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.util.RandomUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;

public class ObHashPartDesc
extends ObPartDesc {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObHashPartDesc.class);
    private List<Long> completeWorks;
    private int partSpace = 0;
    private int partNum = 0;

    public ObHashPartDesc() {
        this.setPartFuncType(ObPartFuncType.HASH);
    }

    public int getPartSpace() {
        return this.partSpace;
    }

    public void setPartSpace(int partSpace) {
        this.partSpace = partSpace;
    }

    @Override
    public int getPartNum() {
        return this.partNum;
    }

    @Override
    public void setPartNum(int partNum) {
        this.partNum = partNum;
        ArrayList<Long> partIds = new ArrayList<Long>();
        for (long i = 0L; i < (long)partNum; ++i) {
            partIds.add(i);
        }
        this.completeWorks = Collections.unmodifiableList(partIds);
    }

    @Override
    public void prepare() {
        super.prepare();
    }

    @Override
    public List<Long> getPartIds(Object startRowObj, boolean startInclusive, Object endRowObj, boolean endInclusive) {
        try {
            if (!(startRowObj instanceof Row) || !(endRowObj instanceof Row)) {
                throw new ObTableException("invalid format of rowObj: " + startRowObj + ", " + endRowObj);
            }
            Row startRow = (Row)startRowObj;
            Row endRow = (Row)endRowObj;
            if (startRow.size() != endRow.size()) {
                throw new IllegalArgumentException("length of start key and end key is not equal");
            }
            if (startRow.size() == 1L && startRow.getValues()[0] instanceof ObObj && ((ObObj)startRow.getValues()[0]).isMinObj() && endRow.size() == 1L && endRow.getValues()[0] instanceof ObObj && ((ObObj)endRow.getValues()[0]).isMaxObj()) {
                return this.completeWorks;
            }
            for (ObColumn curObcolumn : this.partColumns) {
                for (int refIdx = 0; refIdx < curObcolumn.getRefColumnNames().size(); ++refIdx) {
                    Map.Entry<String, Object> entry2;
                    String curObRefColumnName = curObcolumn.getRefColumnNames().get(refIdx);
                    if (startRow.size() <= (long)refIdx) {
                        throw new IllegalArgumentException("rowkey length is " + startRow.size() + ", which is shortest than " + refIdx);
                    }
                    Object startValue = null;
                    for (Map.Entry<String, Object> entry2 : startRow.getMap().entrySet()) {
                        if (!entry2.getKey().equalsIgnoreCase(curObRefColumnName)) continue;
                        startValue = entry2.getValue();
                        break;
                    }
                    if (startValue == null) {
                        throw new IllegalArgumentException("Please include all partition key in start range. Currently missing key: { " + curObRefColumnName + " }");
                    }
                    if (startValue instanceof ObObj && (((ObObj)startValue).isMinObj() || ((ObObj)startValue).isMaxObj())) {
                        return this.completeWorks;
                    }
                    Object endValue = null;
                    entry2 = endRow.getMap().entrySet().iterator();
                    while (entry2.hasNext()) {
                        Map.Entry entry3 = (Map.Entry)entry2.next();
                        if (!((String)entry3.getKey()).equalsIgnoreCase(curObRefColumnName)) continue;
                        endValue = entry3.getValue();
                        break;
                    }
                    if (endValue == null) {
                        throw new IllegalArgumentException("Please include all partition key in end range. Currently missing key: { " + curObRefColumnName + " }");
                    }
                    if (!(endValue instanceof ObObj) || !((ObObj)endValue).isMinObj() && !((ObObj)endValue).isMaxObj()) continue;
                    return this.completeWorks;
                }
            }
            List<Object> startValues = this.evalRowKeyValues(startRow);
            Object startValue = startValues.get(0);
            List<Object> endValues = this.evalRowKeyValues(endRow);
            Object endValue = endValues.get(0);
            Long startLongValue = ObObjType.parseToLongOrNull(startValue);
            Long endLongValue = ObObjType.parseToLongOrNull(endValue);
            if (startLongValue == null || endLongValue == null) {
                throw new NumberFormatException("can not parseToComparable start value [" + startValue + "] or end value [" + endValue + "] to long");
            }
            long startHashValue = startLongValue - (long)(startInclusive ? 0 : -1);
            long endHashValue = endLongValue - (long)(endInclusive ? 0 : 1);
            if (endHashValue - startHashValue + 1L >= (long)this.partNum) {
                return this.completeWorks;
            }
            ArrayList<Long> partIds = new ArrayList<Long>();
            for (long i = startHashValue; i <= endHashValue; ++i) {
                partIds.add(this.innerHash(i));
            }
            return partIds;
        }
        catch (IllegalArgumentException e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00002"), (Throwable)e);
            throw new IllegalArgumentException("ObHashPartDesc get part id come across illegal params", e);
        }
    }

    @Override
    public Long getRandomPartId() {
        return this.partNum > 0 ? Long.valueOf(RandomUtil.getRandomNum(0, this.partNum)) : null;
    }

    @Override
    public Long getPartId(Object ... row) {
        ArrayList<Object> rows = new ArrayList<Object>();
        rows.addAll(Arrays.asList(row));
        return this.getPartId(rows, false);
    }

    @Override
    public Long getPartId(List<Object> rows, boolean consistency) {
        if (rows == null || rows.size() == 0) {
            throw new IllegalArgumentException("invalid row keys :" + rows);
        }
        Long partId = null;
        try {
            for (Object rowObj : rows) {
                if (!(rowObj instanceof Row)) {
                    throw new ObTableException("invalid format of rowObj: " + rowObj);
                }
                Row row = (Row)rowObj;
                List<Object> evalValues = this.evalRowKeyValues(row);
                Object value = evalValues.get(0);
                Long longValue = ObObjType.parseToLongOrNull(value);
                if (longValue == null) {
                    throw new IllegalArgumentException("can not parseToComparable value [" + value + "] to long");
                }
                long currentPartId = this.innerHash(longValue);
                if (partId == null) {
                    partId = currentPartId;
                }
                if (!consistency) break;
                if (partId.equals(currentPartId)) continue;
                throw new ObTablePartitionConsistentException("across partition operation may cause consistent problem " + rows);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("ObHashPartDesc get part id come across illegal params", e);
        }
        return partId;
    }

    private Long innerHash(long hashValue) {
        hashValue = Math.abs(hashValue);
        return (long)(this.partSpace << 28) | hashValue % (long)this.partNum;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("partSpace", this.partSpace).append("partNum", this.partNum).append("partFuncType", (Object)this.getPartFuncType()).append("partExpr", (Object)this.getPartExpr()).toString();
    }
}

