/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.mutation.ColumnValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class Row {
    private Map<String, Object> values;

    public Row() {
        this.values = new LinkedHashMap<String, Object>();
    }

    public Row(Map<String, Object> values) {
        if (null == values) {
            throw new ObTableException("input of Row is null");
        }
        this.values = values;
    }

    public Row(String columnName, Object value) {
        if (null == columnName || columnName.isEmpty()) {
            throw new ObTableException("column name is null");
        }
        this.values = new LinkedHashMap<String, Object>();
        this.values.put(columnName, value);
    }

    public Row(ColumnValue ... columnValues) {
        this.values = new LinkedHashMap<String, Object>();
        for (ColumnValue columnValue : columnValues) {
            if (this.values.containsKey(columnValue.getColumnName())) {
                throw new ObTableException("Duplicate column in row");
            }
            this.values.put(columnValue.getColumnName(), columnValue.getValue());
        }
    }

    public Row add(String columnName, Object value) {
        if (null == columnName || columnName.isEmpty()) {
            throw new ObTableException("column name is null");
        }
        this.values.put(columnName, value);
        return this;
    }

    public Row add(ColumnValue ... columnValues) {
        for (ColumnValue columnValue : columnValues) {
            if (this.values.containsKey(columnValue.getColumnName())) {
                throw new ObTableException("Duplicate column in row");
            }
            this.values.put(columnValue.getColumnName(), columnValue.getValue());
        }
        return this;
    }

    public String[] getColumns() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys.toArray(new String[0]);
    }

    public Object[] getValues() {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            keys.add(entry.getValue());
        }
        return keys.toArray();
    }

    public Map<String, Object> getMap() {
        return this.values;
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public long size() {
        return this.values.size();
    }
}

