/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.packet;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.property.Property;
import com.alipay.oceanbase.rpc.protocol.packet.ObCompressType;
import com.alipay.oceanbase.rpc.protocol.packet.ObRpcCostTime;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObRpcPacketHeader {
    private static final int HEADER_SIZE = 72;
    private static final int ENCODE_SIZE_WITH_COST_TIME = 112;
    private static final int ENCODE_SIZE_WITH_COST_TIME_AND_CLUSTER_ID = 120;
    private static final int ENCODE_SIZE = 128;
    private static final int ENCODE_SIZE_V4 = 184;
    public static final int RESP_FLAG = 32768;
    public static final int STREAM_FLAG = 16384;
    public static final int STREAM_LAST_FLAG = 8192;
    public static final int DISABLE_DEBUGSYNC_FLAG = 4096;
    public static final int CONTEXT_FLAG = 2048;
    public static final int UNNEED_RESPONSE_FLAG = 1024;
    public static final int REQUIRE_REROUTING_FLAG = 512;
    public static final int IS_KV_REQUEST_FALG = 32;
    private int pcode;
    private short hlen = 0;
    private short priority = (short)5;
    private short flag = 0;
    private long checksum;
    private long tenantId = 1L;
    private long prvTenantId = 1L;
    private long sessionId;
    private long traceId0;
    private long traceId1;
    private long timeout = Property.RPC_OPERATION_TIMEOUT.getDefaultLong() * 1000L;
    private long timestamp = System.currentTimeMillis() * 1000L;
    private ObRpcCostTime obRpcCostTime = new ObRpcCostTime();
    private long dstClusterId = -1L;
    private ObCompressType obCompressType = ObCompressType.INVALID_COMPRESSOR;
    private int originalLen = 0;
    private long srcClusterId = -1L;
    private long unisVersion = 0L;
    private int requestLevel = 0;
    private long seqNo = 0L;
    private int groupId = 0;
    private long traceId2;
    private long traceId3;
    private long clusterNameHash;

    public ObRpcPacketHeader() {
        this.flag = (short)39;
    }

    public byte[] encode() {
        byte[] bytes = null;
        if (this.hlen != 0) {
            bytes = new byte[128];
        } else if (ObGlobal.obVsnMajor() >= 4) {
            bytes = new byte[184];
            this.hlen = (short)184;
        } else {
            bytes = new byte[128];
            this.hlen = (short)128;
        }
        int idx = 0;
        System.arraycopy(Serialization.encodeI32(this.pcode), 0, bytes, idx, 4);
        System.arraycopy(Serialization.encodeI8(this.hlen), 0, bytes, idx += 4, 1);
        System.arraycopy(Serialization.encodeI8(this.priority), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI16(this.flag), 0, bytes, ++idx, 2);
        System.arraycopy(Serialization.encodeI64(this.checksum), 0, bytes, idx += 2, 8);
        System.arraycopy(Serialization.encodeI64(this.tenantId), 0, bytes, idx += 8, 8);
        System.arraycopy(Serialization.encodeI64(this.prvTenantId), 0, bytes, idx += 8, 8);
        System.arraycopy(Serialization.encodeI64(this.sessionId), 0, bytes, idx += 8, 8);
        System.arraycopy(Serialization.encodeI64(this.traceId0), 0, bytes, idx += 8, 8);
        System.arraycopy(Serialization.encodeI64(this.traceId1), 0, bytes, idx += 8, 8);
        System.arraycopy(Serialization.encodeI64(this.timeout), 0, bytes, idx += 8, 8);
        System.arraycopy(Serialization.encodeI64(this.timestamp), 0, bytes, idx += 8, 8);
        System.arraycopy(this.obRpcCostTime.encode(), 0, bytes, idx += 8, 40);
        System.arraycopy(Serialization.encodeI64(this.dstClusterId), 0, bytes, idx += 40, 8);
        System.arraycopy(Serialization.encodeI32(this.obCompressType.getCode()), 0, bytes, idx += 8, 4);
        System.arraycopy(Serialization.encodeI32(this.originalLen), 0, bytes, idx += 4, 4);
        if (ObGlobal.obVsnMajor() >= 4 && this.hlen >= 184) {
            System.arraycopy(Serialization.encodeI64(this.srcClusterId), 0, bytes, idx += 4, 8);
            System.arraycopy(Serialization.encodeI64(this.unisVersion), 0, bytes, idx += 8, 8);
            System.arraycopy(Serialization.encodeI32(this.requestLevel), 0, bytes, idx += 8, 4);
            System.arraycopy(Serialization.encodeI64(this.seqNo), 0, bytes, idx += 4, 8);
            System.arraycopy(Serialization.encodeI32(this.groupId), 0, bytes, idx += 8, 4);
            System.arraycopy(Serialization.encodeI64(this.traceId2), 0, bytes, idx += 4, 8);
            System.arraycopy(Serialization.encodeI64(this.traceId3), 0, bytes, idx += 8, 8);
            System.arraycopy(Serialization.encodeI64(this.clusterNameHash), 0, bytes, idx += 8, 8);
        }
        return bytes;
    }

    public Object decode(ByteBuf buf) {
        this.pcode = Serialization.decodeI32(buf);
        this.hlen = Serialization.decodeUI8(buf);
        this.priority = Serialization.decodeUI8(buf);
        this.flag = Serialization.decodeI16(buf);
        this.checksum = Serialization.decodeI64(buf);
        this.tenantId = Serialization.decodeI64(buf);
        this.prvTenantId = Serialization.decodeI64(buf);
        this.sessionId = Serialization.decodeI64(buf);
        this.traceId0 = Serialization.decodeI64(buf);
        this.traceId1 = Serialization.decodeI64(buf);
        this.timeout = Serialization.decodeI64(buf);
        this.timestamp = Serialization.decodeI64(buf);
        if (this.hlen >= 184) {
            this.obRpcCostTime.decode(buf);
            this.dstClusterId = Serialization.decodeI64(buf);
            this.obCompressType = ObCompressType.valueOf(Serialization.decodeI32(buf));
            this.originalLen = Serialization.decodeI32(buf);
            this.srcClusterId = Serialization.decodeI64(buf);
            this.unisVersion = Serialization.decodeI64(buf);
            this.requestLevel = Serialization.decodeI32(buf);
            this.seqNo = Serialization.decodeI64(buf);
            this.groupId = Serialization.decodeI32(buf);
            this.traceId2 = Serialization.decodeI64(buf);
            this.traceId3 = Serialization.decodeI64(buf);
            this.clusterNameHash = Serialization.decodeI64(buf);
            this.ignoreUnresolvedBytes(buf, this.hlen, 184);
        } else if (this.hlen >= 128) {
            this.obRpcCostTime.decode(buf);
            this.dstClusterId = Serialization.decodeI64(buf);
            this.obCompressType = ObCompressType.valueOf(Serialization.decodeI32(buf));
            this.originalLen = Serialization.decodeI32(buf);
            this.ignoreUnresolvedBytes(buf, this.hlen, 128);
        } else if (this.hlen >= 120) {
            this.obRpcCostTime.decode(buf);
            this.dstClusterId = Serialization.decodeI64(buf);
            this.ignoreUnresolvedBytes(buf, this.hlen, 120);
        } else if (this.hlen >= 112) {
            this.obRpcCostTime.decode(buf);
            this.ignoreUnresolvedBytes(buf, this.hlen, 112);
        } else {
            this.ignoreUnresolvedBytes(buf, this.hlen, 72);
        }
        return this;
    }

    public void ignoreUnresolvedBytes(ByteBuf buf, int hlen, int encodeSize) {
        for (int i = 0; i < hlen - encodeSize; ++i) {
            buf.readByte();
        }
    }

    public boolean isResponse() {
        return (this.flag & 0x8000) != 0;
    }

    public boolean isStream() {
        return (this.flag & 0x4000) != 0;
    }

    public boolean isStreamNext() {
        return this.isStream() && (this.flag & 0x2000) == 0;
    }

    public boolean isStreamLast() {
        return this.isStream() && (this.flag & 0x2000) != 0;
    }

    public boolean isRoutingWrong() {
        return (this.flag & 0x200) != 0;
    }

    public void setRoutingWrong() {
        this.flag = (short)(this.flag | 0x200);
    }

    public void setStreamNext() {
        this.flag = (short)(this.flag & 0xFFFFDFFF);
        this.flag = (short)(this.flag | 0x4000);
    }

    public void setStreamLast() {
        this.flag = (short)(this.flag | 0x2000);
        this.flag = (short)(this.flag | 0x4000);
    }

    public void enableRerouting() {
        this.flag = (short)(this.flag | 0x200);
    }

    public void disableRerouting() {
        this.flag = (short)(this.flag & 0xFFFFFDFF);
    }

    public int getPcode() {
        return this.pcode;
    }

    public void setPcode(int pcode) {
        this.pcode = pcode;
    }

    public short getHlen() {
        return this.hlen;
    }

    public void setHlen(byte hlen) {
        this.hlen = hlen;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }

    public short getFlag() {
        return this.flag;
    }

    public void setFlag(short flag) {
        this.flag = flag;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public long getPrvTenantId() {
        return this.prvTenantId;
    }

    public void setPrvTenantId(long prvTenantId) {
        this.prvTenantId = prvTenantId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public long getTraceId0() {
        return this.traceId0;
    }

    public void setTraceId0(long traceId0) {
        this.traceId0 = traceId0;
    }

    public long getTraceId1() {
        return this.traceId1;
    }

    public void setTraceId1(long traceId1) {
        this.traceId1 = traceId1;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public ObRpcCostTime getObRpcCostTime() {
        return this.obRpcCostTime;
    }

    public void setObRpcCostTime(ObRpcCostTime obRpcCostTime) {
        this.obRpcCostTime = obRpcCostTime;
    }

    public long getDstClusterId() {
        return this.dstClusterId;
    }

    public void setDstClusterId(long dstClusterId) {
        this.dstClusterId = dstClusterId;
    }

    public ObCompressType getObCompressType() {
        return this.obCompressType;
    }

    public void setObCompressType(ObCompressType obCompressType) {
        this.obCompressType = obCompressType;
    }

    public int getOriginalLen() {
        return this.originalLen;
    }

    public void setOriginalLen(int originalLen) {
        this.originalLen = originalLen;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }
}

