/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery;

import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableAbstractOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObQueryOperationType;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableQueryAsyncRequest
extends ObTableAbstractOperationRequest {
    private ObTableQueryRequest obTableQueryRequest;
    private long querySessionId;
    private ObQueryOperationType queryType = ObQueryOperationType.QUERY_START;

    @Override
    public int getPcode() {
        return 4358;
    }

    @Override
    public byte[] encode() {
        this.obTableQueryRequest.setCredential(this.credential);
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = (int)this.obTableQueryRequest.getPayloadSize();
        System.arraycopy(this.obTableQueryRequest.encode(), 0, bytes, idx, len);
        idx += len;
        idx = this.encodeQuerySessionId(bytes, idx);
        this.encodeQueryType(bytes, idx);
        return bytes;
    }

    protected int encodeQuerySessionId(byte[] bytes, int idx) {
        int len = Serialization.getNeedBytes(this.querySessionId);
        System.arraycopy(Serialization.encodeVi64(this.querySessionId), 0, bytes, idx, len);
        return idx += len;
    }

    protected int encodeQueryType(byte[] bytes, int idx) {
        System.arraycopy(Serialization.encodeI8(this.queryType.getByteValue()), 0, bytes, idx, 1);
        return ++idx;
    }

    public void setQuerySessionId(long querySessionId) {
        this.querySessionId = querySessionId;
    }

    public ObQueryOperationType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(ObQueryOperationType queryType) {
        this.queryType = queryType;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.obTableQueryRequest = new ObTableQueryRequest();
        this.obTableQueryRequest.decode(buf);
        this.querySessionId = Serialization.decodeVi64(buf);
        this.queryType = ObQueryOperationType.valueOf(buf.readByte());
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return (long)(Serialization.getNeedBytes(this.querySessionId) + 1) + this.obTableQueryRequest.getPayloadSize();
    }

    public ObTableQueryRequest getObTableQueryRequest() {
        return this.obTableQueryRequest;
    }

    public void setObTableQueryRequest(ObTableQueryRequest obTableQueryRequest) {
        this.obTableQueryRequest = obTableQueryRequest;
    }
}

