/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.stream;

import com.alipay.oceanbase.rpc.bolt.transport.ObTableConnection;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.AbstractQueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncResult;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class ObTableClientQueryStreamResult
extends AbstractQueryStreamResult {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableClientQueryStreamResult.class);

    @Override
    protected ObTableQueryResult referToNewPartition(ObPair<Long, ObTableParam> partIdWithObTable) throws Exception {
        ObTableQueryRequest request = new ObTableQueryRequest();
        request.setTableName(this.tableName);
        request.setTableQuery(this.tableQuery);
        request.setPartitionId(partIdWithObTable.getRight().getPartitionId());
        request.setTableId(partIdWithObTable.getRight().getTableId());
        request.setEntityType(this.entityType);
        if (this.operationTimeout > 0L) {
            request.setTimeout(this.operationTimeout);
        } else {
            request.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        request.setConsistencyLevel(this.getReadConsistency().toObTableConsistencyLevel());
        return this.execute(partIdWithObTable, request);
    }

    @Override
    protected ObTableQueryResult execute(ObPair<Long, ObTableParam> partIdWithIndex, ObPayload request) throws Exception {
        AtomicReference<ObTableConnection> connectionRef = new AtomicReference<ObTableConnection>();
        ObTableQueryResult result = (ObTableQueryResult)this.commonExecute(this.client, logger, partIdWithIndex, request, connectionRef);
        this.cacheStreamNext(partIdWithIndex, this.checkObTableQueryResult(result));
        return result;
    }

    @Override
    protected ObTableQueryAsyncResult executeAsync(ObPair<Long, ObTableParam> partIdWithObTable, ObPayload streamRequest) throws Exception {
        throw new IllegalArgumentException("not support this execute");
    }

    @Override
    protected Map<Long, ObPair<Long, ObTableParam>> refreshPartition(ObTableQuery tableQuery, String tableName) throws Exception {
        return this.buildPartitions(this.client, tableQuery, tableName);
    }
}

