/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.checkandmutate.CheckAndInsUp;
import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableNeedFetchAllException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableRetryExhaustedException;
import com.alipay.oceanbase.rpc.exception.ObTableRoutingWrongException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.get.Get;
import com.alipay.oceanbase.rpc.get.result.GetResult;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.TableEntry;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.mutation.Append;
import com.alipay.oceanbase.rpc.mutation.Delete;
import com.alipay.oceanbase.rpc.mutation.Increment;
import com.alipay.oceanbase.rpc.mutation.Insert;
import com.alipay.oceanbase.rpc.mutation.InsertOrUpdate;
import com.alipay.oceanbase.rpc.mutation.Mutation;
import com.alipay.oceanbase.rpc.mutation.Put;
import com.alipay.oceanbase.rpc.mutation.Replace;
import com.alipay.oceanbase.rpc.mutation.Update;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableApiMove;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOpRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.table.AbstractTableBatchOps;
import com.alipay.oceanbase.rpc.table.ConcurrentTask;
import com.alipay.oceanbase.rpc.table.ConcurrentTaskExecutor;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import com.alipay.oceanbase.rpc.threadlocal.ThreadLocalMap;
import com.alipay.oceanbase.rpc.util.MonitorUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ObTableClientLSBatchOpsImpl
extends AbstractTableBatchOps {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableClientLSBatchOpsImpl.class);
    private final ObTableClient obTableClient;
    private ExecutorService executorService;
    private boolean returningAffectedEntity = false;
    private boolean needAllProp = false;
    private List<ObTableSingleOp> batchOperation;

    public ObTableClientLSBatchOpsImpl(String tableName, ObTableClient obTableClient) {
        this.tableName = tableName;
        this.obTableClient = obTableClient;
        this.executorService = obTableClient.getRuntimeBatchExecutor();
        this.batchOperation = new ArrayList<ObTableSingleOp>();
    }

    @Override
    public ObTableBatchOperation getObTableBatchOperation() {
        return null;
    }

    public List<ObTableSingleOp> getSingleOperations() {
        return this.batchOperation;
    }

    @Override
    public void get(Object[] rowkeys, String[] columns) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void update(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void delete(Object[] rowkeys) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void insert(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void replace(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void insertOrUpdate(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void increment(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void append(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void put(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    private void addOperation(ObTableSingleOp singleOp) {
        this.batchOperation.add(singleOp);
    }

    public void addOperation(CheckAndInsUp checkAndInsUp) {
        InsertOrUpdate insUp = checkAndInsUp.getInsUp();
        ObTableSingleOpQuery query = new ObTableSingleOpQuery();
        ObNewRange range = new ObNewRange();
        range.setStartKey(ObRowKey.getInstance(insUp.getRowKeyValues()));
        range.setEndKey(ObRowKey.getInstance(insUp.getRowKeyValues()));
        query.addScanRangeColumns(insUp.getRowKeyNames());
        query.addScanRange(range);
        query.setFilterString(checkAndInsUp.getFilter().toString());
        String[] rowKeyNames = checkAndInsUp.getInsUp().getRowKeyNames().toArray(new String[0]);
        Object[] rowKeyValues = checkAndInsUp.getInsUp().getRowKeyValues().toArray(new Object[0]);
        String[] propertiesNames = checkAndInsUp.getInsUp().getColumns();
        Object[] propertiesValues = checkAndInsUp.getInsUp().getValues();
        ObTableSingleOpEntity entity = ObTableSingleOpEntity.getInstance(rowKeyNames, rowKeyValues, propertiesNames, propertiesValues);
        ObTableSingleOp singleOp = new ObTableSingleOp();
        singleOp.setSingleOpType(ObTableOperationType.CHECK_AND_INSERT_UP);
        singleOp.setIsCheckNoExists(!checkAndInsUp.isCheckExists());
        singleOp.setIsRollbackWhenCheckFailed(checkAndInsUp.isRollbackWhenCheckFailed());
        singleOp.setQuery(query);
        singleOp.addEntity(entity);
        this.addOperation(singleOp);
    }

    public void addOperation(TableQuery query) throws Exception {
        String[] rowKeyNames = query.getRowKey().getColumns();
        if (rowKeyNames == null || rowKeyNames.length == 0) {
            throw new IllegalArgumentException("rowKey is empty in get op");
        }
        Object[] rowKey = query.getRowKey().getValues();
        String[] propertiesNames = query.getSelectColumns().toArray(new String[0]);
        ObTableSingleOpEntity entity = ObTableSingleOpEntity.getInstance(rowKeyNames, rowKey, propertiesNames, null);
        if (propertiesNames.length == 0) {
            this.needAllProp = true;
        }
        ObTableSingleOp singleOp = new ObTableSingleOp();
        if (this.entityType == ObTableEntityType.HKV) {
            ObTableQuery obTableQuery = query.getObTableQuery();
            ObTableSingleOpQuery singleOpQuery = ObTableSingleOpQuery.getInstance(obTableQuery.getIndexName(), obTableQuery.getKeyRanges(), obTableQuery.getSelectColumns(), obTableQuery.getScanOrder(), obTableQuery.isHbaseQuery(), obTableQuery.gethTableFilter(), obTableQuery.getObKVParams(), obTableQuery.getFilterString());
            singleOp.setQuery(singleOpQuery);
            singleOp.setSingleOpType(ObTableOperationType.SCAN);
        } else {
            singleOp.setSingleOpType(ObTableOperationType.GET);
        }
        singleOp.addEntity(entity);
        this.addOperation(singleOp);
    }

    public void addOperation(Mutation mutation) throws Exception {
        String[] rowKeyNames = null;
        Object[] rowKeyValues = null;
        String[] propertiesNames = null;
        Object[] propertiesValues = null;
        ObTableOperationType type = mutation.getOperationType();
        switch (type) {
            case GET: {
                throw new IllegalArgumentException("Invalid type in batch operation, " + (Object)((Object)type));
            }
            case INSERT: {
                ((Insert)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Insert)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Insert)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Insert)mutation).getColumns();
                propertiesValues = ((Insert)mutation).getValues();
                break;
            }
            case DEL: {
                rowKeyNames = ((Delete)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Delete)mutation).getRowKeyValues().toArray(new Object[0]);
                break;
            }
            case UPDATE: {
                ((Update)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Update)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Update)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Update)mutation).getColumns();
                propertiesValues = ((Update)mutation).getValues();
                break;
            }
            case INSERT_OR_UPDATE: {
                ((InsertOrUpdate)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((InsertOrUpdate)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((InsertOrUpdate)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((InsertOrUpdate)mutation).getColumns();
                propertiesValues = ((InsertOrUpdate)mutation).getValues();
                break;
            }
            case REPLACE: {
                ((Replace)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Replace)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Replace)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Replace)mutation).getColumns();
                propertiesValues = ((Replace)mutation).getValues();
                break;
            }
            case INCREMENT: {
                ((Increment)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Increment)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Increment)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Increment)mutation).getColumns();
                propertiesValues = ((Increment)mutation).getValues();
                break;
            }
            case APPEND: {
                ((Append)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Append)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Append)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Append)mutation).getColumns();
                propertiesValues = ((Append)mutation).getValues();
                break;
            }
            case PUT: {
                ((Put)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Put)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Put)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Put)mutation).getColumns();
                propertiesValues = ((Put)mutation).getValues();
                break;
            }
            default: {
                throw new ObTableException("unknown operation type " + (Object)((Object)type));
            }
        }
        ObTableSingleOpEntity entity = ObTableSingleOpEntity.getInstance(rowKeyNames, rowKeyValues, propertiesNames, propertiesValues);
        ObTableSingleOp singleOp = new ObTableSingleOp();
        singleOp.setSingleOpType(type);
        singleOp.addEntity(entity);
        this.addOperation(singleOp);
    }

    public void addOperation(Get get) throws Exception {
        if (get.getRowKey() == null) {
            throw new ObTableException("RowKey is null");
        }
        String[] rowKeyNames = get.getRowKey().getColumns();
        Object[] rowKeyValues = get.getRowKey().getValues();
        String[] propertiesNames = get.getSelectColumns();
        ObTableSingleOpEntity entity = ObTableSingleOpEntity.getInstance(rowKeyNames, rowKeyValues, propertiesNames, null);
        ObTableSingleOp singleOp = new ObTableSingleOp();
        singleOp.setSingleOpType(ObTableOperationType.GET);
        singleOp.addEntity(entity);
        this.addOperation(singleOp);
    }

    @Override
    public List<Object> execute() throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(this.batchOperation.size());
        for (ObTableSingleOpResult result : this.executeInternal()) {
            int errCode = result.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                results.add(result.getAffectedRows());
                continue;
            }
            results.add(ExceptionUtil.convertToObTableException(result.getExecuteHost(), result.getExecutePort(), result.getSequence(), result.getUniqueId(), errCode, result.getHeader().getErrMsg()));
        }
        return results;
    }

    @Override
    public List<Object> executeWithResult() throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(this.batchOperation.size());
        ObTableSingleOpResult[] singleResults = this.executeInternal();
        for (int i = 0; i < singleResults.length; ++i) {
            ObTableSingleOpResult result = singleResults[i];
            ObTableOperationType opType = this.batchOperation.get(i).getSingleOpType();
            int errCode = result.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                if (opType == ObTableOperationType.GET) {
                    results.add(new GetResult(result));
                    continue;
                }
                results.add(new MutationResult(result));
                continue;
            }
            results.add(ExceptionUtil.convertToObTableException(result.getExecuteHost(), result.getExecutePort(), result.getSequence(), result.getUniqueId(), errCode, result.getHeader().getErrMsg()));
        }
        return results;
    }

    private Object[] calculateRowKey(ObTableSingleOp operation) {
        List<ObObj> rowKeyObject = operation.getRowkeyObjs();
        int rowKeySize = rowKeyObject.size();
        Object[] rowKey = new Object[rowKeySize];
        for (int j = 0; j < rowKeySize; ++j) {
            rowKey[j] = rowKeyObject.get(j).getValue();
        }
        return rowKey;
    }

    private List<ObPair<Integer, ObTableSingleOp>> extractOperations(Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> tabletOperationsMap) {
        ArrayList<ObPair<Integer, ObTableSingleOp>> operationsWithIndex = new ArrayList<ObPair<Integer, ObTableSingleOp>>();
        for (ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>> pair : tabletOperationsMap.values()) {
            operationsWithIndex.addAll((Collection<ObPair<Integer, ObTableSingleOp>>)pair.getRight());
        }
        return operationsWithIndex;
    }

    public Map<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> prepareOperations(List<ObPair<Integer, ObTableSingleOp>> operationsWithIndex) throws Exception {
        HashMap<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> lsOperationsMap = new HashMap<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>>();
        if (this.obTableClient.isOdpMode()) {
            HashMap tabletOperationsMap = new HashMap();
            ObPair obTableOperations = new ObPair(new ObTableParam(this.obTableClient.getOdpTable()), new ArrayList());
            for (int i = 0; i < operationsWithIndex.size(); ++i) {
                ((List)obTableOperations.getRight()).add(operationsWithIndex.get(i));
            }
            tabletOperationsMap.put(0L, obTableOperations);
            lsOperationsMap.put(-1L, tabletOperationsMap);
            return lsOperationsMap;
        }
        for (int i = 0; i < operationsWithIndex.size(); ++i) {
            ObTableSingleOp operation = operationsWithIndex.get(i).getRight();
            Object[] rowKey = this.calculateRowKey(operation);
            String real_tableName = this.tableName;
            if (this.entityType == ObTableEntityType.HKV && this.obTableClient.isTableGroupName(this.tableName)) {
                real_tableName = this.obTableClient.tryGetTableNameFromTableGroupCache(this.tableName, false);
            }
            ObPair<Long, ObTableParam> tableObPair = this.obTableClient.getTable(real_tableName, rowKey, false, false, this.obTableClient.getRoute(false));
            long lsId = tableObPair.getRight().getLsId();
            Map tabletOperations = lsOperationsMap.computeIfAbsent(lsId, k -> new HashMap());
            ObPair singleOperations = tabletOperations.computeIfAbsent(tableObPair.getLeft(), k -> new ObPair(tableObPair.getRight(), new ArrayList()));
            ((List)singleOperations.getRight()).add(operationsWithIndex.get(i));
        }
        return lsOperationsMap;
    }

    public Map<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> partitionPrepare() throws Exception {
        List<ObTableSingleOp> operations = this.getSingleOperations();
        LinkedList<ObPair<Integer, ObTableSingleOp>> operationsWithIndex = new LinkedList<ObPair<Integer, ObTableSingleOp>>();
        for (int i = 0; i < operations.size(); ++i) {
            operationsWithIndex.add(new ObPair<Integer, ObTableSingleOp>(i, operations.get(i)));
        }
        return this.prepareOperations(operationsWithIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void partitionExecute(ObTableSingleOpResult[] results, Map.Entry<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> lsOperation) throws Exception {
        ObTableLSOpResult subLSOpResult;
        long lsId = lsOperation.getKey();
        Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> tabletOperationsMap = lsOperation.getValue();
        if (tabletOperationsMap.isEmpty()) {
            logger.warn("the size of tablet operations in ls operation is zero");
            throw new ObTableUnexpectedException("the size of tablet operations in ls operation is zero");
        }
        ObTableLSOpRequest tableLsOpRequest = new ObTableLSOpRequest();
        ObTableLSOperation tableLsOp = new ObTableLSOperation();
        tableLsOp.setLsId(lsId);
        tableLsOp.setReturnOneResult(this.returnOneResult);
        tableLsOp.setNeedAllProp(this.needAllProp);
        tableLsOp.setTableName(this.tableName);
        long tableId = 0L;
        long originPartId = 0L;
        long operationTimeout = 0L;
        ObTable subObTable = null;
        boolean isFirstEntry = true;
        ArrayList<List<ObPair<Integer, ObTableSingleOp>>> lsOperationWithIndexList = new ArrayList<List<ObPair<Integer, ObTableSingleOp>>>();
        for (Map.Entry<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> tabletOperation : tabletOperationsMap.entrySet()) {
            ObTableParam tableParam = tabletOperation.getValue().getLeft();
            long tabletId = tableParam.getPartitionId();
            List<ObPair<Integer, ObTableSingleOp>> tabletOperationWithIndexList = tabletOperation.getValue().getRight();
            lsOperationWithIndexList.add(tabletOperationWithIndexList);
            ArrayList<ObTableSingleOp> singleOps = new ArrayList<ObTableSingleOp>();
            for (ObPair<Integer, ObTableSingleOp> operationWithIndex : tabletOperationWithIndexList) {
                singleOps.add(operationWithIndex.getRight());
            }
            ObTableTabletOp tableTabletOp = new ObTableTabletOp();
            tableTabletOp.setSingleOperations(singleOps);
            tableTabletOp.setTabletId(tabletId);
            tableLsOp.addTabletOperation(tableTabletOp);
            if (!isFirstEntry) continue;
            tableId = tableParam.getTableId();
            originPartId = tableParam.getPartId();
            operationTimeout = tableParam.getObTable().getObTableOperationTimeout();
            subObTable = tableParam.getObTable();
            isFirstEntry = false;
        }
        tableLsOp.prepare();
        tableLsOpRequest.setLsOperation(tableLsOp);
        tableLsOpRequest.setTableId(tableId);
        tableLsOpRequest.setEntityType(this.entityType);
        tableLsOpRequest.setTimeout(operationTimeout);
        boolean needRefreshTableEntry = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        HashSet<String> failedServerList = null;
        ObServerRoute route = null;
        String realTableName = this.obTableClient.getPhyTableNameFromTableGroup(tableLsOpRequest.getEntityType(), this.tableName);
        while (true) {
            this.obTableClient.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > this.obTableClient.getRuntimeMaxWait()) {
                logger.error("table name: {} ls id:{} it has tried " + tryTimes + " times and it has waited " + costMillis + " ms which exceeds runtime max wait timeout " + this.obTableClient.getRuntimeMaxWait() + " ms", (Object)realTableName, (Object)lsId);
                throw new ObTableTimeoutExcetion("it has tried " + tryTimes + " times and it has waited " + costMillis + "ms which exceeds runtime max wait timeout " + this.obTableClient.getRuntimeMaxWait() + "ms");
            }
            ++tryTimes;
            try {
                if (this.obTableClient.isOdpMode()) {
                    subObTable = this.obTableClient.getOdpTable();
                } else if (tryTimes > 1) {
                    if (route == null) {
                        route = this.obTableClient.getRoute(false);
                    }
                    if (failedServerList != null) {
                        route.setBlackList(failedServerList);
                    }
                    TableEntry entry = this.obTableClient.getOrRefreshTableEntry(realTableName, false, false, false);
                    if (ObGlobal.obVsnMajor() >= 4) {
                        this.obTableClient.refreshTableLocationByTabletId(entry, realTableName, this.obTableClient.getTabletIdByPartId(entry, originPartId));
                    } else {
                        this.obTableClient.getOrRefreshTableEntry(realTableName, needRefreshTableEntry, this.obTableClient.isTableEntryRefreshIntervalWait(), false);
                    }
                    subObTable = this.obTableClient.getTableWithPartId(realTableName, originPartId, needRefreshTableEntry, this.obTableClient.isTableEntryRefreshIntervalWait(), false, route).getRight().getObTable();
                }
                ObPayload result = subObTable.execute(tableLsOpRequest);
                if (result != null && result.getPcode() == 4388) {
                    ObTableApiMove moveResponse = (ObTableApiMove)result;
                    this.obTableClient.getRouteTableRefresher().addTableIfAbsent(realTableName, true);
                    this.obTableClient.getRouteTableRefresher().triggerRefreshTable();
                    subObTable = this.obTableClient.getTable(moveResponse);
                    result = subObTable.execute(tableLsOpRequest);
                    if (result instanceof ObTableApiMove) {
                        ObTableApiMove move = (ObTableApiMove)result;
                        logger.warn("The server has not yet completed the master switch, and returned an incorrect leader with an IP address of {}. Rerouting return IP is {}", (Object)moveResponse.getReplica().getServer().ipToString(), (Object)move.getReplica().getServer().ipToString());
                        throw new ObTableRoutingWrongException();
                    }
                }
                subLSOpResult = (ObTableLSOpResult)result;
                this.obTableClient.resetExecuteContinuousFailureCount(realTableName);
            }
            catch (Exception ex) {
                block37: {
                    if (this.obTableClient.isOdpMode()) {
                        logger.warn("meet exception when execute ls batch in odp mode.tablename: {}, errMsg: {}", (Object)realTableName, (Object)ex.getMessage());
                        throw ex;
                    }
                    if (ex instanceof ObTableReplicaNotReadableException) {
                        if (tryTimes - 1 >= this.obTableClient.getRuntimeRetryTimes()) {
                            logger.warn("exhaust retry when replica not readable: {}", (Object)ex.getMessage());
                            throw ex;
                        }
                        logger.warn("tablename:{} ls id:{} retry when replica not readable: {}", new Object[]{realTableName, lsId, ex.getMessage()});
                        if (failedServerList == null) {
                            failedServerList = new HashSet<String>();
                        }
                        failedServerList.add(subObTable.getIp());
                    } else {
                        if (ex instanceof ObTableException && ((ObTableException)ex).isNeedRefreshTableEntry()) {
                            needRefreshTableEntry = true;
                            if (this.obTableClient.isRetryOnChangeMasterTimes() && tryTimes - 1 < this.obTableClient.getRuntimeRetryTimes()) {
                                if (ex instanceof ObTableNeedFetchAllException) {
                                    this.obTableClient.getOrRefreshTableEntry(realTableName, needRefreshTableEntry, this.obTableClient.isTableEntryRefreshIntervalWait(), true);
                                    throw ex;
                                }
                                break block37;
                            } else {
                                String logMessage = String.format("exhaust retry while meet NeedRefresh Exception, table name: %s, ls id: %d, batch ops refresh table, retry times: %d, errorCode: %d", realTableName, lsId, this.obTableClient.getRuntimeRetryTimes(), ((ObTableException)ex).getErrorCode());
                                logger.warn(logMessage, (Throwable)ex);
                                this.obTableClient.calculateContinuousFailure(realTableName, ex.getMessage());
                                throw new ObTableRetryExhaustedException(logMessage, ex);
                            }
                        }
                        this.obTableClient.calculateContinuousFailure(realTableName, ex.getMessage());
                        throw ex;
                    }
                }
                Thread.sleep(this.obTableClient.getRuntimeRetryInterval());
                continue;
            }
            break;
        }
        long endExecute = System.currentTimeMillis();
        if (subLSOpResult == null) {
            String logMessage = String.format("table name: %s ls id: %d check batch operation result error: client get unexpected NULL result", realTableName, lsId);
            TableClientLoggerFactory.RUNTIME.error(logMessage);
            throw new ObTableUnexpectedException(logMessage);
        }
        List<ObTableTabletOpResult> tabletOpResults = subLSOpResult.getResults();
        int affectedRows = 0;
        if (this.returnOneResult) {
            ObTableSingleOpResult singleOpResult;
            if (results[0] == null) {
                results[0] = new ObTableSingleOpResult();
            }
            if ((singleOpResult = tabletOpResults.get(0).getResults().get(0)).getHeader().getErrno() != ResultCodes.OB_SUCCESS.errorCode) {
                results[0].getHeader().setErrno(singleOpResult.getHeader().getErrno());
                results[0].getHeader().setMsg(singleOpResult.getHeader().getMsg());
            }
            results[0].setAffectedRows(results[0].getAffectedRows() + tabletOpResults.get(0).getResults().get(0).getAffectedRows());
        } else {
            for (int i = 0; i < tabletOpResults.size(); ++i) {
                List<ObTableSingleOpResult> singleOpResults = tabletOpResults.get(i).getResults();
                for (int j = 0; j < singleOpResults.size(); affectedRows += singleOpResults.size(), ++j) {
                }
                List singleOperationsWithIndexList = (List)lsOperationWithIndexList.get(i);
                if (singleOpResults.size() < singleOperationsWithIndexList.size()) {
                    if (singleOpResults.size() == 1 && this.entityType == ObTableEntityType.HKV) {
                        ObTableSingleOpResult subObTableSingleOpResult = singleOpResults.get(0);
                        subObTableSingleOpResult.setExecuteHost(subObTable.getIp());
                        subObTableSingleOpResult.setExecutePort(subObTable.getPort());
                        for (ObPair SubOperationWithIndexList : singleOperationsWithIndexList) {
                            results[((Integer)SubOperationWithIndexList.getLeft()).intValue()] = subObTableSingleOpResult;
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("check batch operation result size error: operation size [" + singleOperationsWithIndexList.size() + "] result size [" + singleOpResults.size() + "]");
                }
                if (singleOpResults.size() != singleOperationsWithIndexList.size()) {
                    throw new ObTableUnexpectedException("check batch result error: ls " + lsId + " expect result size " + singleOperationsWithIndexList.size() + " actual result size " + singleOpResults.size() + " for " + i + "th tablet operation");
                }
                for (int j = 0; j < singleOperationsWithIndexList.size(); ++j) {
                    ObTableSingleOpResult subObTableSingleOpResult = singleOpResults.get(j);
                    subObTableSingleOpResult.setExecuteHost(subObTable.getIp());
                    subObTableSingleOpResult.setExecutePort(subObTable.getPort());
                    results[((Integer)((ObPair)singleOperationsWithIndexList.get((int)j)).getLeft()).intValue()] = subObTableSingleOpResult;
                }
            }
        }
        String endpoint = subObTable.getIp() + ":" + subObTable.getPort();
        MonitorUtil.info((ObPayload)tableLsOpRequest, subObTable.getDatabase(), realTableName, "LS_BATCH-Execute-", endpoint, tableLsOp, affectedRows, endExecute - startExecute, this.obTableClient.getslowQueryMonitorThreshold());
    }

    private boolean shouldRetry(Throwable throwable) {
        return throwable instanceof ObTableNeedFetchAllException;
    }

    private void executeWithRetries(ObTableSingleOpResult[] results, Map.Entry<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> entry, int maxRetries) throws Exception {
        int retryCount = 0;
        boolean success = false;
        Map<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> currentPartitions = new HashMap<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>>();
        currentPartitions.put(entry.getKey(), entry.getValue());
        int errCode = ResultCodes.OB_SUCCESS.errorCode;
        String errMsg = null;
        while (retryCount <= maxRetries && !success) {
            boolean allPartitionsSuccess = true;
            for (Map.Entry<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> entry2 : currentPartitions.entrySet()) {
                try {
                    this.partitionExecute(results, entry2);
                }
                catch (Exception e) {
                    if (this.shouldRetry(e)) {
                        ++retryCount;
                        errCode = ((ObTableNeedFetchAllException)e).getErrorCode();
                        errMsg = e.getMessage();
                        List<ObPair<Integer, ObTableSingleOp>> failedOperations = this.extractOperations(entry2.getValue());
                        currentPartitions = this.prepareOperations(failedOperations);
                        allPartitionsSuccess = false;
                        break;
                    }
                    throw e;
                }
            }
            if (!allPartitionsSuccess) continue;
            success = true;
        }
        if (!success) {
            errMsg = "Failed to execute operation after retrying " + maxRetries + " times. Last error Msg:[errCode=" + errCode + "] " + errMsg;
            throw new ObTableUnexpectedException(errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObTableSingleOpResult[] executeInternal() throws Exception {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        long start = System.currentTimeMillis();
        ObTableSingleOpResult[] obTableOperationResults = null;
        obTableOperationResults = this.returnOneResult ? new ObTableSingleOpResult[1] : new ObTableSingleOpResult[this.batchOperation.size()];
        Map<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> lsOperations = this.partitionPrepare();
        long getTableTime = System.currentTimeMillis();
        final Map<Object, Object> context = ThreadLocalMap.getContextMap();
        final int maxRetries = this.obTableClient.getRuntimeRetryTimes();
        if (this.executorService != null && !this.executorService.isShutdown() && lsOperations.size() > 1) {
            final ConcurrentTaskExecutor executor = new ConcurrentTaskExecutor(this.executorService, lsOperations.size());
            for (final Map.Entry<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> entry : lsOperations.entrySet()) {
                final ObTableSingleOpResult[] finalObTableOperationResults = obTableOperationResults;
                executor.execute(new ConcurrentTask(){

                    @Override
                    public void doTask() {
                        try {
                            ThreadLocalMap.transmitContextMap(context);
                            ObTableClientLSBatchOpsImpl.this.executeWithRetries(finalObTableOperationResults, entry, maxRetries);
                        }
                        catch (Exception e) {
                            logger.error(TableClientLoggerFactory.LCD.convert("01-00026"), (Throwable)e);
                            executor.collectExceptions(e);
                        }
                        finally {
                            ThreadLocalMap.reset();
                        }
                    }
                });
            }
            long timeoutTs = this.obTableClient.getRuntimeBatchMaxWait() * 1000L * 1000L + System.nanoTime();
            try {
                while (timeoutTs > System.nanoTime()) {
                    try {
                        executor.waitComplete(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new ObTableUnexpectedException("Batch Concurrent Execute interrupted", e);
                    }
                    if (!executor.getThrowableList().isEmpty()) {
                        throw new ObTableUnexpectedException("Batch Concurrent Execute Error", executor.getThrowableList().get(0));
                    }
                    if (!executor.isComplete()) continue;
                    break;
                }
            }
            finally {
                executor.stop();
            }
            if (!executor.getThrowableList().isEmpty()) {
                throw new ObTableUnexpectedException("Batch Concurrent Execute Error", executor.getThrowableList().get(0));
            }
            if (!executor.isComplete()) {
                throw new ObTableUnexpectedException("Batch Concurrent Execute Error, runtimeBatchMaxWait: " + this.obTableClient.getRuntimeBatchMaxWait() + "ms");
            }
        } else {
            for (Map.Entry<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> entry : lsOperations.entrySet()) {
                this.executeWithRetries(obTableOperationResults, entry, maxRetries);
            }
        }
        if (obTableOperationResults.length <= 0) {
            throw new ObTableUnexpectedException("Ls batch execute returns zero single operation results");
        }
        MonitorUtil.info((ObPayload)obTableOperationResults[0], this.obTableClient.getDatabase(), this.tableName, "LS_BATCH", "", obTableOperationResults.length, getTableTime - start, System.currentTimeMillis() - getTableTime, this.obTableClient.getslowQueryMonitorThreshold());
        return obTableOperationResults;
    }

    @Override
    public void clear() {
        this.batchOperation = new ArrayList<ObTableSingleOp>();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isReturningAffectedEntity() {
        return this.returningAffectedEntity;
    }

    public void setReturningAffectedEntity(boolean returningAffectedEntity) {
        this.returningAffectedEntity = returningAffectedEntity;
    }
}

