/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol;

import com.oceanbase.jdbc.extend.datatype.BINARY_DOUBLE;
import com.oceanbase.jdbc.extend.datatype.BINARY_FLOAT;
import com.oceanbase.jdbc.extend.datatype.ComplexData;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.INTERVALDS;
import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import com.oceanbase.jdbc.extend.datatype.NUMBER;
import com.oceanbase.jdbc.extend.datatype.NUMBER_FLOAT;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPLTZ;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.util.Options;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class RowProtocol {
    public static final int BIT_LAST_FIELD_NOT_NULL = 0;
    public static final int BIT_LAST_FIELD_NULL = 1;
    public static final int BIT_LAST_ZERO_DATE = 2;
    public static final int TINYINT1_IS_BIT = 1;
    public static final int YEAR_IS_DATE_TYPE = 2;
    public static final DateTimeFormatter TEXT_LOCAL_DATE_TIME;
    public static final DateTimeFormatter TEXT_OFFSET_DATE_TIME;
    public static final DateTimeFormatter TEXT_ZONED_DATE_TIME;
    public static final Pattern isIntegerRegex;
    protected static final int NULL_LENGTH = -1;
    private Protocol protocol;
    protected final int maxFieldSize;
    protected final Options options;
    public int lastValueNull;
    public byte[] buf;
    public int pos;
    public int length;
    protected int index;
    public int[] complexEndPos;

    public RowProtocol(int maxFieldSize, Options options) {
        this.maxFieldSize = maxFieldSize;
        this.options = options;
    }

    public void resetRow(byte[] buf) {
        this.buf = buf;
        this.index = -1;
    }

    Charset getCurrentEncoding(ColumnType columnType) {
        switch (columnType) {
            case VARCHAR: 
            case VARCHAR2: 
            case VARSTRING: 
            case NVARCHAR2: 
            case NCHAR: 
            case RAW: 
            case STRING: {
                return Charset.forName(this.options.characterEncoding);
            }
        }
        return StandardCharsets.UTF_8;
    }

    public abstract void setPosition(int var1);

    public int getLengthMaxFieldSize() {
        return this.maxFieldSize != 0 && this.maxFieldSize < this.length ? this.maxFieldSize : this.length;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public abstract String getInternalString(ColumnDefinition var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract int getInternalInt(ColumnDefinition var1) throws SQLException;

    public abstract long getInternalLong(ColumnDefinition var1) throws SQLException;

    public abstract float getInternalFloat(ColumnDefinition var1) throws SQLException;

    public abstract double getInternalDouble(ColumnDefinition var1) throws SQLException;

    public abstract BigDecimal getInternalBigDecimal(ColumnDefinition var1) throws SQLException;

    public abstract Date getInternalDate(ColumnDefinition var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Time getInternalTime(ColumnDefinition var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Timestamp getInternalTimestamp(ColumnDefinition var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Array getInternalArray(ColumnDefinition var1, ComplexDataType var2) throws SQLException;

    public abstract Struct getInternalStruct(ColumnDefinition var1, ComplexDataType var2) throws SQLException;

    public abstract ComplexData getInternalComplexCursor(ColumnDefinition var1, ComplexDataType var2) throws SQLException;

    public String getEncoding() {
        return this.options.characterEncoding;
    }

    public TIMESTAMP getInternalTIMESTAMP(ColumnDefinition columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.TIMESTAMP_NANO) {
            if (this.length < 12) {
                throw new SQLException("timestamp field data length is invalid, expected 12 at least, actual length is " + this.length);
            }
            return this.buildTIMETAMP(this.buf, this.pos, this.length);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as TIMESTAMP");
    }

    public TIMESTAMPTZ getInternalTIMESTAMPTZ(ColumnDefinition columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.TIMESTAMP_TZ) {
            if (this.length < 12) {
                throw new SQLException("timestamp field data length is invalid, expected 12 at least, actual length is " + this.length);
            }
            byte[] returnBytes = new byte[this.length];
            System.arraycopy(this.buf, this.pos, returnBytes, 0, this.length);
            TIMESTAMPTZ timestamptz = new TIMESTAMPTZ(returnBytes);
            timestamptz.setByte(11, returnBytes[11]);
            return timestamptz;
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as TIMESTAMP");
    }

    public TIMESTAMPLTZ getInternalTIMESTAMPLTZ(ColumnDefinition columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.TIMESTAMP_LTZ) {
            if (this.length < 12) {
                throw new SQLException("timestamp field data length is invalid, expected 12 at least, actual length is " + this.length);
            }
            byte[] returnBytes = new byte[this.length];
            System.arraycopy(this.buf, this.pos, returnBytes, 0, this.length);
            return new TIMESTAMPLTZ(returnBytes);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as TIMESTAMP");
    }

    private TIMESTAMP buildTIMETAMP(byte[] bytes, int pos, int length) throws SQLException {
        int index;
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildTimestamp(bytes[pos]));
        sb.append(this.buildTimestamp(bytes[pos + 1]));
        sb.append("-");
        sb.append(this.buildTimestamp(bytes[pos + 2]));
        sb.append("-");
        sb.append(this.buildTimestamp(bytes[pos + 3]));
        sb.append(" ");
        sb.append(this.buildTimestamp(bytes[pos + 4]));
        sb.append(":");
        sb.append(this.buildTimestamp(bytes[pos + 5]));
        sb.append(":");
        sb.append(this.buildTimestamp(bytes[pos + 6]));
        sb.append(".");
        byte[] nanosBytes = new byte[4];
        System.arraycopy(bytes, pos + 7, nanosBytes, 0, 4);
        int nanos = DataTypeUtilities.getNanos(nanosBytes, 0);
        String temp = String.format("%09d", nanos);
        char[] chars = temp.toCharArray();
        for (index = chars.length; index > 1 && chars[index - 1] == '0'; --index) {
        }
        byte scale = bytes[pos + 11];
        if (scale > (temp = temp.substring(0, index)).length()) {
            int x = scale - temp.length();
            StringBuilder strBuf = new StringBuilder();
            for (int i = 0; i < x; ++i) {
                strBuf.append("0");
            }
            temp = temp + strBuf.toString();
        }
        sb.append(temp);
        TIMESTAMP timestamp = new TIMESTAMP(Timestamp.valueOf(sb.toString()));
        timestamp.setByte(11, bytes[pos + 11]);
        return timestamp;
    }

    private String buildTimestamp(byte b) {
        if (b < 10) {
            return "0" + b;
        }
        return "" + b;
    }

    public abstract Object getInternalObject(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract boolean getInternalBoolean(ColumnDefinition var1) throws SQLException;

    public abstract byte getInternalByte(ColumnDefinition var1) throws SQLException;

    public abstract short getInternalShort(ColumnDefinition var1) throws SQLException;

    public abstract String getInternalTimeString(ColumnDefinition var1);

    public abstract BigInteger getInternalBigInteger(ColumnDefinition var1) throws SQLException;

    public abstract ZonedDateTime getInternalZonedDateTime(ColumnDefinition var1, Class var2, TimeZone var3) throws SQLException;

    public abstract OffsetTime getInternalOffsetTime(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract LocalTime getInternalLocalTime(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract LocalDate getInternalLocalDate(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract INTERVALDS getInternalINTERVALDS(ColumnDefinition var1) throws SQLException;

    public abstract INTERVALYM getInternalINTERVALYM(ColumnDefinition var1) throws SQLException;

    public abstract boolean isBinaryEncoded();

    public boolean lastValueWasNull() {
        return (this.lastValueNull & 1) != 0;
    }

    protected String zeroFillingIfNeeded(String value, ColumnDefinition columnDefinition) {
        if (columnDefinition.isZeroFill()) {
            StringBuilder zeroAppendStr = new StringBuilder();
            long zeroToAdd = columnDefinition.getDisplaySize() - value.length();
            while (zeroToAdd-- > 0L) {
                zeroAppendStr.append("0");
            }
            return zeroAppendStr.append(value).toString();
        }
        return value;
    }

    protected int getInternalTinyInt(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int value = this.buf[this.pos];
        if (!columnInfo.isSigned()) {
            value = this.buf[this.pos] & 0xFF;
        }
        return value;
    }

    protected long parseBit() {
        if (this.length == 1) {
            return this.buf[this.pos];
        }
        long val = 0L;
        int ind = 0;
        do {
            val += (long)(this.buf[this.pos + ind] & 0xFF) << 8 * (this.length - ++ind);
        } while (ind < this.length);
        return val;
    }

    protected int getInternalSmallInt(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8);
        if (!columnInfo.isSigned()) {
            return value & 0xFFFF;
        }
        return (short)value;
    }

    protected long getInternalMediumInt(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        long value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
        if (!columnInfo.isSigned()) {
            value &= 0xFFFFFFFFL;
        }
        return value;
    }

    boolean isNUMBERTYPE(ColumnType columnType) {
        return columnType == ColumnType.NUMBER || columnType == ColumnType.FLOAT || columnType == ColumnType.DECIMAL || columnType == ColumnType.BINARY_DOUBLE || columnType == ColumnType.BINARY_FLOAT;
    }

    protected NUMBER zgetNUMBER(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.isNUMBERTYPE(columnInfo.getColumnType())) {
            byte[] b = new byte[this.length];
            System.arraycopy(this.buf, this.pos, b, 0, this.length);
            return new NUMBER(b);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as NUMBER");
    }

    protected NUMBER_FLOAT getNUMBER_FLOAT(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        if (columnInfo.getColumnType() == ColumnType.NUMBER_FLOAT) {
            return new NUMBER_FLOAT(new Float(value).floatValue(), this.buf);
        }
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as NUMBER_FLOAT");
    }

    protected BINARY_DOUBLE getBINARY_DOUBLE(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.BINARY_DOUBLE) {
            return new BINARY_DOUBLE(this.buf[this.pos]);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as BINARY_DOUBLE");
    }

    protected BINARY_FLOAT getBINARY_FLOAT(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.BINARY_FLOAT) {
            return new BINARY_FLOAT(this.buf[this.pos]);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as BINARY_FLOAT");
    }

    protected INTERVALDS getINTERVALDS(ColumnDefinition columnInfo) throws Exception {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.INTERVALDS) {
            return new INTERVALDS(this.buf);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as INTERVALDS");
    }

    protected INTERVALYM getINTERVALYM(ColumnDefinition columnInfo) throws Exception {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.INTERVALYM) {
            return new INTERVALYM(this.buf);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as INTERVALYM");
    }

    protected void rangeCheck(Object className, long minValue, long maxValue, BigDecimal value, ColumnDefinition columnInfo) throws SQLException {
        if (value.compareTo(BigDecimal.valueOf(minValue)) < 0 || value.compareTo(BigDecimal.valueOf(maxValue)) > 0) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    protected void rangeCheck(Object className, long minValue, long maxValue, long value, ColumnDefinition columnInfo) throws SQLException {
        if (value < minValue || value > maxValue) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    protected int extractNanos(String timestring) throws SQLException {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        for (int i = index + 1; i < index + 10; ++i) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char value = timestring.charAt(i);
                if (value < '0' || value > '9') {
                    throw new SQLException("cannot parse sub-second part in timestamp string '" + timestring + "'");
                }
                digit = value - 48;
            }
            nanos = nanos * 10 + digit;
        }
        return nanos;
    }

    public boolean wasNull() {
        return (this.lastValueNull & 1) != 0 || (this.lastValueNull & 2) != 0;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public SelectResultSet sendFechRowViaCursor(long statementid, int fetchSize) {
        return (SelectResultSet)SelectResultSet.createEmptyResultSet();
    }

    static {
        isIntegerRegex = Pattern.compile("^-?\\d+\\.[0-9]+$");
        TEXT_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
        TEXT_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(TEXT_LOCAL_DATE_TIME).appendOffsetId().toFormatter();
        TEXT_ZONED_DATE_TIME = new DateTimeFormatterBuilder().append(TEXT_OFFSET_DATE_TIME).optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    }
}

