/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.io.input;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.io.LruTraceCache;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractPacketInputStream
implements PacketInputStream {
    protected InputStream inputStream;
    protected long threadId;
    protected int mysqlSeqNo;
    protected LruTraceCache traceCache = null;
    protected String serverThreadLog = "";
    protected int maxQuerySizeToLog;
    protected boolean enableNetworkStatistics = false;
    protected long timestampAfterRead = 0L;
    protected static final int REUSABLE_BUFFER_LENGTH = 1024;
    protected static final int MAX_PACKET_SIZE = 0xFFFFFF;
    protected final byte[] reusableArray = new byte[1024];

    @Override
    public abstract Buffer getPacket(boolean var1) throws IOException;

    @Override
    public abstract byte[] getPacketArray(boolean var1) throws IOException;

    protected abstract void readMysqlStream(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void doTrace(int var1, int var2, byte[] var3);

    @Override
    public int getLastPacketSeq() {
        return this.mysqlSeqNo;
    }

    @Override
    public abstract int getCompressLastPacketSeq();

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void setServerThreadId(long serverThreadId, Boolean isMaster) {
        this.serverThreadLog = "conn=" + serverThreadId + (isMaster != null ? "(" + (isMaster != false ? "M" : "S") + ")" : "");
    }

    @Override
    public void setTraceCache(LruTraceCache traceCache) {
        this.traceCache = traceCache;
    }

    @Override
    public void enableNetworkStatistics(boolean flag) {
        this.timestampAfterRead = 0L;
        this.enableNetworkStatistics = flag;
    }

    @Override
    public long getTimestampAfterRead() {
        return this.timestampAfterRead;
    }

    @Override
    public void clearNetworkStatistics() {
        this.timestampAfterRead = 0L;
    }
}

