/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.failover.BlackList.BlackListConfig;
import com.oceanbase.jdbc.internal.failover.FailoverProxy;
import com.oceanbase.jdbc.internal.failover.Listener;
import com.oceanbase.jdbc.internal.failover.utils.HostStateInfo;
import com.oceanbase.jdbc.internal.io.LruTraceCache;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.AbstractQueryProtocol;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.internal.util.pool.GlobalStateInfo;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;

public class MasterProtocol
extends AbstractQueryProtocol
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MasterProtocol.class);

    public MasterProtocol(UrlParser urlParser, GlobalStateInfo globalInfo, ReentrantLock lock, LruTraceCache traceCache) {
        super(urlParser, globalInfo, lock, traceCache);
    }

    private static MasterProtocol getNewProtocol(FailoverProxy proxy, GlobalStateInfo globalInfo, UrlParser urlParser) {
        MasterProtocol newProtocol = new MasterProtocol(urlParser, globalInfo, proxy.lock, proxy.traceCache);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    public static void loop(Listener listener, GlobalStateInfo globalInfo, List<HostAddress> addresses) throws SQLException {
        MasterProtocol.loop(listener, globalInfo, addresses, false);
    }

    public static void loop(Listener listener, GlobalStateInfo globalInfo, List<HostAddress> addresses, boolean fallThrough) throws SQLException {
        LinkedHashSet<HostAddress> connectedHosts = new LinkedHashSet<HostAddress>();
        int attemptedTimes = 0;
        ArrayDeque<HostAddress> loopAddresses = new ArrayDeque<HostAddress>(addresses);
        if (loopAddresses.isEmpty()) {
            MasterProtocol.resetHostList(listener, loopAddresses);
        }
        int maxConnectionTry = listener.getRetryAllDowns();
        Throwable lastQueryException = null;
        while (!loopAddresses.isEmpty() && maxConnectionTry > 0) {
            if (listener.isExplicitClosed()) {
                return;
            }
            MasterProtocol protocol = MasterProtocol.getNewProtocol(listener.getProxy(), globalInfo, listener.getUrlParser());
            --maxConnectionTry;
            try {
                HostAddress host = loopAddresses.pollFirst();
                if (!fallThrough && listener.getBlacklistKeys().contains(host) && ((HostStateInfo)listener.getBlacklist().get(host)).getState() == HostStateInfo.STATE.BLACK) continue;
                if (host == null) {
                    loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                    host = loopAddresses.pollFirst();
                }
                logger.debug("Connect to " + host);
                ++attemptedTimes;
                connectedHosts.add(host);
                protocol.setHostAddress(host);
                protocol.connect();
                if (listener.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                listener.removeFromBlacklist(protocol.getHostAddress());
                listener.removeFromPickedList(protocol.getHostAddress());
                listener.foundActiveMaster(protocol);
                return;
            }
            catch (IOException ioException) {
                long failedTime = System.nanoTime();
                HostAddress host = protocol.getHostAddress();
                if (listener.getBlacklistKeys().contains(host) && ((HostStateInfo)listener.getBlacklist().get(host)).getState() == HostStateInfo.STATE.GREY) {
                    listener.resetHostStateInfo(host);
                    continue;
                }
                BlackListConfig blackListConfig = listener.getCurrentLoadBalanceInfo().getBlackListConfig();
                Properties info = new Properties();
                info.setProperty("failedTime", String.valueOf(failedTime));
                if (blackListConfig.getAppendStrategy().needToAppend(host, info)) {
                    listener.addToBlacklist(host);
                    lastQueryException = ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s. %s", protocol.getHostAddress(), ioException.getMessage()), "08000", ioException);
                    continue;
                }
                listener.addToPickedList(host);
                if (fallThrough) continue;
                loopAddresses.add(host);
            }
            catch (SQLException businessException) {
                throw businessException;
            }
            finally {
                listener.setRetryAllDowns(maxConnectionTry);
            }
        }
        if (lastQueryException != null) {
            throw new SQLException("No active connection found for master : " + lastQueryException.getMessage(), ((SQLException)lastQueryException).getSQLState(), ((SQLException)lastQueryException).getErrorCode(), lastQueryException);
        }
        throw new SQLException("No active connection found for master. \nretryAllDowns remains " + maxConnectionTry + "\nloopAddresses = " + loopAddresses + "\nattempted hosts:" + connectedHosts + "\nattempted times:" + attemptedTimes + "\nblacklist hosts:" + listener.getBlacklist());
    }

    private static void resetHostList(Listener listener, Deque<HostAddress> loopAddresses) {
        ArrayList<HostAddress> servers = new ArrayList<HostAddress>();
        servers.addAll(listener.getUrlParser().getHostAddresses());
        Collections.shuffle(servers);
        loopAddresses.clear();
        loopAddresses.addAll(servers);
    }
}

