/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.CallParameter;
import com.oceanbase.jdbc.CallableParameterMetaData;
import com.oceanbase.jdbc.CallableProcedureStatement;
import com.oceanbase.jdbc.OceanBaseCallableParameterMetaData;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.com.send.parameters.NullParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.com.send.parameters.StringParameter;
import com.oceanbase.jdbc.internal.util.ParsedCallParameters;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.CloneableCallableStatement;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class JDBC4ServerCallableStatement
extends CallableProcedureStatement
implements CloneableCallableStatement {
    private SelectResultSet outputResultSet;
    private final String PARAMETER_NAMESPACE_PREFIX = "@com_mysql_jdbc_outparam_";

    public JDBC4ServerCallableStatement(boolean isObFunction, String query, OceanBaseConnection connection, String procedureName, String database, String arguments, int resultSetType, int resultSetConcurrency, ExceptionFactory exceptionFactory) throws SQLException {
        super(isObFunction, connection, query, resultSetType, resultSetConcurrency, exceptionFactory);
        this.isObFunction = isObFunction;
        this.arguments = arguments;
        this.parameterMetadata = !this.connection.getProtocol().isOracleMode() ? new CallableParameterMetaData(connection, database, procedureName, false) : new OceanBaseCallableParameterMetaData(connection, database, procedureName, isObFunction);
        this.parameterMetadata.readMetadataFromDbIfRequired(this.originalSql, this.arguments, this.isObFunction);
        this.setParamsAccordingToSetArguments();
    }

    public JDBC4ServerCallableStatement(boolean isObFunction, String query, OceanBaseConnection connection, String procedureName, String database, String arguments, int resultSetType, int resultSetConcurrency, ExceptionFactory exceptionFactory, boolean isAnonymousBlock) throws SQLException {
        super(isObFunction, connection, query, resultSetType, resultSetConcurrency, exceptionFactory);
        this.arguments = arguments;
        this.parameterMetadata = new OceanBaseCallableParameterMetaData(connection, database, procedureName, isObFunction);
        this.parameterMetadata.readMetadataFromDbIfRequired(this.originalSql, this.arguments, this.isObFunction);
        this.setParamsAccordingToSetArguments();
    }

    private void setParamsAccordingToSetArguments() throws SQLException {
        if (this.parameterCount == -1) {
            if (this.arguments == null || this.arguments.equals("")) {
                this.parameterCount = 0;
            } else {
                List<ParsedCallParameters> paramList = Utils.argumentsSplit(this.arguments, ",", "'\"", "'\"");
                this.parameterCount = paramList.size();
            }
            if (this.isObFunction) {
                ++this.parameterCount;
            }
        }
        this.params = new ArrayList(this.parameterCount);
        for (int index = 0; index < this.parameterCount; ++index) {
            CallParameter callParameter = new CallParameter();
            CallParameter callParameterFromOBServer = this.parameterMetadata.getPlaceholderParam(index);
            if (null != callParameterFromOBServer) {
                if (!this.protocol.isOracleMode() && callParameterFromOBServer.isOutput()) {
                    callParameter = callParameterFromOBServer;
                } else {
                    callParameter.setName(callParameterFromOBServer.getName());
                    callParameter.setIndex(callParameterFromOBServer.getIndex());
                }
            }
            this.params.add(callParameter);
        }
    }

    @Override
    protected SelectResultSet getOutputResult() throws SQLException {
        if (this.outputResultSet == null) {
            if (this.isObFunction) {
                this.outputResultSet = this.results.getResultSet();
                if (this.outputResultSet != null) {
                    this.outputResultSet.next();
                    return this.outputResultSet;
                }
            }
            if (this.fetchSize != 0) {
                this.results.loadFully(false, this.protocol);
                this.outputResultSet = this.results.getCallableResultSet();
                if (this.outputResultSet != null) {
                    this.outputResultSet.next();
                    return this.outputResultSet;
                }
            }
            throw new SQLException("No output result.");
        }
        return this.outputResultSet;
    }

    @Override
    public JDBC4ServerCallableStatement clone(OceanBaseConnection connection) throws CloneNotSupportedException {
        JDBC4ServerCallableStatement clone = (JDBC4ServerCallableStatement)super.clone(connection);
        clone.outputResultSet = null;
        return clone;
    }

    private void retrieveOutputResult() throws SQLException {
        this.outputResultSet = this.results.getCallableResultSet();
        if (this.outputResultSet != null) {
            this.outputResultSet.next();
            SelectResultSet selectResultSet = this.outputResultSet;
            selectResultSet.row.complexEndPos = selectResultSet.complexEndPos;
            ColumnDefinition[] ci = selectResultSet.getColumnsInformation();
            for (int i = 1; i <= ci.length; ++i) {
                ColumnType columnTypes = ci[i - 1].getColumnType();
                if (columnTypes == ColumnType.COMPLEX || columnTypes == ColumnType.ARRAY || columnTypes == ColumnType.STRUCT) {
                    selectResultSet.getComplex(i);
                    continue;
                }
                if (columnTypes != ColumnType.CURSOR) continue;
                selectResultSet.getComplexCursor(i);
            }
        }
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (this.protocol.isOracleMode() && parameterIndex > this.parameterCount) {
            throw new SQLException("invalid parameter index " + parameterIndex);
        }
        this.getParameter(parameterIndex).setInput(true);
        super.setParameter(parameterIndex, holder);
    }

    private String mangleParameterName(String origParameterName) {
        if (origParameterName == null) {
            return null;
        }
        int offset = 0;
        if (origParameterName.length() > 0 && origParameterName.charAt(0) == '@') {
            offset = 1;
        }
        StringBuilder paramNameBuf = new StringBuilder("@com_mysql_jdbc_outparam_".length() + origParameterName.length());
        paramNameBuf.append("@com_mysql_jdbc_outparam_");
        paramNameBuf.append(origParameterName.substring(offset));
        return paramNameBuf.toString();
    }

    private int setInOutParamsOnServer() throws SQLException {
        String inOutParameterName;
        String paramName;
        int i;
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        this.parameterMetadata.readMetadataFromDbIfRequired(this.originalSql, this.arguments, this.isObFunction);
        this.validAllParameters();
        ArrayList<String> mysqlParamNames = new ArrayList<String>(this.parameterMetadata.allParams.size());
        for (i = 0; i < this.parameterMetadata.allParams.size(); ++i) {
            paramName = this.parameterMetadata.allParams.get(i).getName();
            if (paramName == null) {
                throw new SQLException("param[" + i + "] name is null.");
            }
            inOutParameterName = this.mangleParameterName(paramName);
            mysqlParamNames.add(inOutParameterName);
        }
        for (i = 0; i < this.parameterMetadata.placeholderParams.size(); ++i) {
            paramName = this.parameterMetadata.placeholderParams.get(i).getName();
            if (paramName == null) {
                throw new SQLException("param[" + i + "] name is null.");
            }
            inOutParameterName = this.mangleParameterName(paramName);
            CallParameter inParamInfo = this.parameterMetadata.placeholderParams.get(i);
            if (!inParamInfo.isInput() || !inParamInfo.isOutput()) continue;
            StringBuilder queryBuf = new StringBuilder(4 + inOutParameterName.length() + 1 + 1);
            ParameterHolder holder = (ParameterHolder)this.currentParameterHolder.get(i);
            if (holder == null) continue;
            String holderStr = holder instanceof StringParameter ? ((StringParameter)holder).getFullString() : holder.toString();
            queryBuf.append("SET ");
            queryBuf.append(inOutParameterName);
            queryBuf.append("=");
            if (holderStr == "<null>") {
                queryBuf.append("null");
            } else {
                queryBuf.append(holderStr);
            }
            String query = queryBuf.toString().replaceAll("\\`(\\w+)\\`", "$1");
            this.execute(query);
        }
        if (this.parameterMetadata.outputParamSetParamValueException != null) {
            throw this.parameterMetadata.outputParamSetParamValueException;
        }
        Utils.TrimSQLInfo trimSQLStringInternal = Utils.trimSQLStringInternal(this.originalSql, false, false, false);
        String trimedString = trimSQLStringInternal.getTrimedString();
        int paramCount = trimSQLStringInternal.getParamCount();
        int beginIndex = 0;
        StringBuilder sb = new StringBuilder();
        List<Integer> paramIndexs = trimSQLStringInternal.getParamsIndexs();
        if (paramCount > 0 && paramIndexs.size() > 0) {
            for (int i2 = 0; i2 < paramIndexs.size(); ++i2) {
                int parameterIndex = this.parameterMetadata.placeholderToParameterIndexMap[i2];
                int end = paramIndexs.get(i2);
                String partPre = trimedString.substring(beginIndex, end);
                CallParameter inParamInfo = this.parameterMetadata.allParams.get(parameterIndex);
                sb.append(partPre);
                beginIndex = end + 1;
                if (inParamInfo.isOutput()) {
                    String inOutParameterName2 = (String)mysqlParamNames.get(parameterIndex);
                    inOutParameterName2 = inOutParameterName2.replaceAll("\\`(\\w+)\\`", "$1");
                    sb.append(inOutParameterName2);
                    continue;
                }
                ParameterHolder holder = (ParameterHolder)this.currentParameterHolder.get(i2);
                String holderStr = holder instanceof StringParameter ? ((StringParameter)holder).getFullString() : holder.toString();
                if (holderStr.equals("<null>")) {
                    sb.append("null");
                    continue;
                }
                sb.append(holderStr);
            }
        }
        sb.append(trimedString.substring(beginIndex));
        int r = this.executeUpdate(sb.toString());
        this.outputResultSet = this.results.getCallableResultSet();
        if (this.outputResultSet != null) {
            this.outputResultSet.next();
        }
        if (this.protocol != null) {
            this.protocol.endCallInterface("JDBC4ServerCallableStatement.setInOutParamsOnServer");
        }
        return r;
    }

    @Override
    public boolean execute() throws SQLException {
        ReentrantLock curLock = this.connection.lock;
        curLock.lock();
        try {
            lockLogger.debug("JDBC4ServerCallableStatement.execute locked");
            if (!this.protocol.isOracleMode()) {
                this.checkParameterInMySQLMode();
                this.setInOutParamsOnServer();
                boolean bl = true;
                return bl;
            }
            this.validAllParameters();
            super.execute();
            this.retrieveOutputResult();
            boolean bl = this.results != null && this.results.getResultSet() != null;
            return bl;
        }
        finally {
            curLock.unlock();
            lockLogger.debug("JDBC4ServerCallableStatement.execute unlocked");
        }
    }

    private void validAllParameters() throws SQLException {
        int index;
        int currentOutputMapper;
        if (this.protocol.isOracleMode() && this.params.size() != this.parameterCount) {
            throw new SQLException("The number of parameter names '" + this.params.size() + "' does not match the number of registered parameters in sql '" + this.parameterCount + "'.");
        }
        if (this.protocol.isOracleMode() && this.parameterMetadata.hasEmptyPlaceholderParams()) {
            if (this.outputParameterMapper == null) {
                this.outputParameterMapper = new int[this.params.size()];
            }
            currentOutputMapper = 1;
            for (index = 0; index < this.params.size(); ++index) {
                this.outputParameterMapper[index] = ((CallParameter)this.params.get(index)).isOutput() ? currentOutputMapper++ : -1;
            }
        } else {
            if (this.outputParameterMapper == null) {
                this.outputParameterMapper = new int[this.parameterMetadata.placeholderParams.size()];
            }
            currentOutputMapper = 1;
            for (index = 0; index < this.parameterMetadata.placeholderParams.size(); ++index) {
                this.outputParameterMapper[index] = this.parameterMetadata.getPlaceholderParam(index).isOutput() ? currentOutputMapper++ : -1;
            }
        }
        for (int index2 = 0; index2 < this.params.size(); ++index2) {
            if (((CallParameter)this.params.get(index2)).isInput()) continue;
            if (!this.protocol.isOracleMode() || ((CallParameter)this.params.get(index2)).isOutput()) {
                super.setParameter(index2 + 1, new NullParameter());
                continue;
            }
            throw new SQLException("Missing IN or OUT parameter in index::" + (index2 + 1));
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!this.hasInOutParameters) {
            if (!this.protocol.isOracleMode() && !this.isObFunction) {
                int i;
                int[] retBatchQuery = new int[]{};
                int[] retBatch = new int[]{};
                int querySize = this.parametersList.size();
                retBatch = querySize == 0 ? new int[]{} : this.executeBatchInternal(querySize);
                if (this.batchQueries != null && this.batchQueries.size() > 0) {
                    retBatchQuery = super.executeBatchQuerys();
                }
                int[] ret = new int[retBatch.length + retBatchQuery.length];
                int cur = 0;
                for (i = 0; i < retBatch.length; ++i) {
                    ret[cur++] = retBatch[i];
                }
                for (i = 0; i < retBatchQuery.length; ++i) {
                    ret[cur++] = retBatchQuery[i];
                }
                return ret;
            }
            return super.executeBatch();
        }
        throw new SQLException("executeBatch not permit for procedure with output parameter");
    }

    private int[] executeBatchInternal(int querySize) throws SQLException {
        int[] rows = new int[querySize];
        for (int i = 0; i < querySize; ++i) {
            ParameterHolder[] parameterHolder = (ParameterHolder[])this.parametersList.get(i);
            this.clearParameters();
            for (int j = 0; j < parameterHolder.length; ++j) {
                this.currentParameterHolder.put(j, parameterHolder[j]);
            }
            rows[i] = this.setInOutParamsOnServer();
        }
        return rows;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (!this.hasInOutParameters) {
            if (!this.protocol.isOracleMode() && !this.isObFunction) {
                int i;
                long[] retBatchQuery = new long[]{};
                long[] retBatch = new long[]{};
                int querySize = this.parametersList.size();
                retBatch = querySize == 0 ? new long[]{} : this.executeLargeBatchInternal(querySize);
                if (this.batchQueries != null && this.batchQueries.size() > 0) {
                    retBatchQuery = super.executeLargeBatchQuerys();
                }
                long[] ret = new long[retBatch.length + retBatchQuery.length];
                int cur = 0;
                for (i = 0; i < retBatch.length; ++i) {
                    ret[cur++] = retBatch[i];
                }
                for (i = 0; i < retBatchQuery.length; ++i) {
                    ret[cur++] = retBatchQuery[i];
                }
                return ret;
            }
            return super.executeLargeBatch();
        }
        throw new SQLException("executeBatch not permit for procedure with output parameter");
    }

    private long[] executeLargeBatchInternal(int querySize) throws SQLException {
        long[] rows = new long[querySize];
        for (int i = 0; i < querySize; ++i) {
            ParameterHolder[] parameterHolder = (ParameterHolder[])this.parametersList.get(i);
            this.clearParameters();
            for (int j = 0; j < parameterHolder.length; ++j) {
                this.currentParameterHolder.put(j, parameterHolder[j]);
            }
            rows[i] = this.setInOutParamsOnServer();
        }
        return rows;
    }

    private void checkParameterInMySQLMode() throws SQLException {
        for (CallParameter param : this.params) {
            if (param.isOutput() || param.isInput()) continue;
            throw new SQLException("missing param error");
        }
    }
}

