/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.impl;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.failover.impl.MastersSlavesListener;
import com.oceanbase.jdbc.internal.failover.tools.SearchFilter;
import com.oceanbase.jdbc.internal.protocol.AuroraProtocol;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.ReconnectDuringTransactionException;
import com.oceanbase.jdbc.internal.util.pool.GlobalStateInfo;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuroraListener
extends MastersSlavesListener {
    private static final Logger logger = Logger.getLogger(AuroraListener.class.getName());
    private final Pattern auroraDnsPattern = Pattern.compile("(.+)\\.(cluster-|cluster-ro-)?([a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final HostAddress clusterHostAddress = this.findClusterHostAddress();
    private String clusterDnsSuffix = null;

    public AuroraListener(UrlParser urlParser, GlobalStateInfo globalInfo) throws SQLException {
        super(urlParser, globalInfo);
    }

    private HostAddress findClusterHostAddress() throws SQLException {
        for (HostAddress hostAddress : this.hostAddresses) {
            Matcher matcher = this.auroraDnsPattern.matcher(hostAddress.host);
            if (matcher.find()) {
                if (this.clusterDnsSuffix != null) {
                    if (!this.clusterDnsSuffix.equalsIgnoreCase(matcher.group(3))) {
                        throw new SQLException("Connection string must contain only one aurora cluster. '" + hostAddress.host + "' doesn't correspond to DNS prefix '" + this.clusterDnsSuffix + "'");
                    }
                } else {
                    this.clusterDnsSuffix = matcher.group(3);
                }
                if (matcher.group(2) == null || matcher.group(2).isEmpty()) continue;
                return hostAddress;
            }
            if (this.clusterDnsSuffix != null || !hostAddress.host.contains(".") || Utils.isIPv4(hostAddress.host) || Utils.isIPv6(hostAddress.host)) continue;
            this.clusterDnsSuffix = hostAddress.host.substring(hostAddress.host.indexOf(".") + 1);
        }
        return null;
    }

    public String getClusterDnsSuffix() {
        return this.clusterDnsSuffix;
    }

    public HostAddress getClusterHostAddress() {
        return this.clusterHostAddress;
    }

    @Override
    public void reconnectFailedConnection(SearchFilter initialSearchFilter) throws SQLException {
        SearchFilter searchFilter = initialSearchFilter;
        if (!searchFilter.isInitialConnection() && (this.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlySlave() && !this.isSecondaryHostFail())) {
            return;
        }
        if (!searchFilter.isFailoverLoop()) {
            try {
                this.checkWaitingConnection();
                if (searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlySlave() && !this.isSecondaryHostFail()) {
                    return;
                }
            }
            catch (ReconnectDuringTransactionException e) {
                return;
            }
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.hostAddresses);
        loopAddress.removeAll(this.getBlacklistKeys());
        Collections.shuffle(loopAddress);
        LinkedList<HostAddress> blacklistShuffle = new LinkedList<HostAddress>(this.getBlacklistKeys());
        blacklistShuffle.retainAll(this.hostAddresses);
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
            loopAddress.add(this.masterProtocol.getHostAddress());
        }
        if (!this.isSecondaryHostFail() && this.secondaryProtocol != null) {
            loopAddress.remove(this.secondaryProtocol.getHostAddress());
            loopAddress.add(this.secondaryProtocol.getHostAddress());
        }
        if (this.hostAddresses.size() <= 1) {
            searchFilter = new SearchFilter(true, false);
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            do {
                AuroraProtocol.loop(this, this.globalInfo, loopAddress, searchFilter);
                if (searchFilter.isFailoverLoop()) continue;
                try {
                    this.checkWaitingConnection();
                }
                catch (ReconnectDuringTransactionException reconnectDuringTransactionException) {
                    // empty catch block
                }
            } while (searchFilter.isInitialConnection() && this.masterProtocol == null && (!this.urlParser.getOptions().allowMasterDownConnection || this.secondaryProtocol == null));
        }
        if (this.getCurrentProtocol() != null && !this.getCurrentProtocol().isClosed()) {
            this.retrieveAllEndpointsAndSet(this.getCurrentProtocol());
        }
        if (searchFilter.isInitialConnection() && this.masterProtocol == null && !this.currentReadOnlyAsked) {
            this.currentProtocol = this.secondaryProtocol;
            this.currentReadOnlyAsked = true;
        }
    }

    public void retrieveAllEndpointsAndSet(Protocol protocol) throws SQLException {
        if (this.clusterDnsSuffix != null) {
            List<String> endpoints = this.getCurrentEndpointIdentifiers(protocol);
            this.setUrlParserFromEndpoints(endpoints, protocol.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCurrentEndpointIdentifiers(Protocol protocol) throws SQLException {
        ArrayList<String> endpoints;
        block9: {
            endpoints = new ArrayList<String>();
            try {
                this.proxy.lock.lock();
                try {
                    Results results = new Results();
                    protocol.executeQuery(false, results, "select server_id, session_id from information_schema.replica_host_status where last_update_timestamp > now() - INTERVAL 3 MINUTE");
                    results.commandEnd();
                    SelectResultSet resultSet = results.getResultSet();
                    while (resultSet.next()) {
                        endpoints.add(resultSet.getString(1) + "." + this.clusterDnsSuffix);
                    }
                    Collections.shuffle(endpoints);
                }
                finally {
                    this.proxy.lock.unlock();
                }
            }
            catch (SQLException qe) {
                logger.warning("SQL exception occurred: " + qe.getMessage());
                if (!protocol.getProxy().hasToHandleFailover(qe)) break block9;
                if (this.masterProtocol == null || this.masterProtocol.equals(protocol)) {
                    this.setMasterHostFail();
                } else if (this.secondaryProtocol.equals(protocol)) {
                    this.setSecondaryHostFail();
                }
                this.addToBlacklist(protocol.getHostAddress());
                this.reconnectFailedConnection(new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail()));
            }
        }
        return endpoints;
    }

    private void setUrlParserFromEndpoints(List<String> endpoints, int port) {
        ArrayList<HostAddress> addresses = new ArrayList<HostAddress>();
        for (String endpoint : endpoints) {
            if (endpoint == null) continue;
            addresses.add(new HostAddress(endpoint, port, null));
        }
        if (addresses.isEmpty()) {
            addresses.addAll(this.urlParser.getHostAddresses());
        }
        this.hostAddresses = addresses;
    }

    public HostAddress searchByStartName(Protocol secondaryProtocol, List<HostAddress> loopAddress) {
        if (!this.isSecondaryHostFail()) {
            HostAddress currentWriter;
            block10: {
                int checkWriterAttempts = 3;
                currentWriter = null;
                do {
                    try {
                        currentWriter = this.searchForMasterHostAddress(secondaryProtocol, loopAddress);
                    }
                    catch (SQLException qe) {
                        if (!this.proxy.hasToHandleFailover(qe) || !this.setSecondaryHostFail()) continue;
                        this.addToBlacklist(secondaryProtocol.getHostAddress());
                        return null;
                    }
                } while (currentWriter == null && --checkWriterAttempts > 0);
                if (currentWriter == null && this.getClusterHostAddress() != null) {
                    AuroraProtocol possibleMasterProtocol = AuroraProtocol.getNewProtocol(this.getProxy(), this.globalInfo, this.getUrlParser());
                    possibleMasterProtocol.setHostAddress(this.getClusterHostAddress());
                    try {
                        possibleMasterProtocol.connect();
                        if (possibleMasterProtocol.isMasterConnection()) {
                            possibleMasterProtocol.setMustBeMasterConnection(true);
                            this.foundActiveMaster(possibleMasterProtocol);
                        } else {
                            possibleMasterProtocol.setMustBeMasterConnection(false);
                        }
                    }
                    catch (IOException e) {
                        this.addToBlacklist(possibleMasterProtocol.getHostAddress());
                    }
                    catch (SQLException qe) {
                        if (!this.proxy.hasToHandleFailover(qe)) break block10;
                        this.addToBlacklist(possibleMasterProtocol.getHostAddress());
                    }
                }
            }
            return currentWriter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostAddress searchForMasterHostAddress(Protocol protocol, List<HostAddress> loopAddress) throws SQLException {
        String masterHostName;
        this.proxy.lock.lock();
        try {
            Results results = new Results();
            protocol.executeQuery(false, results, "select server_id from information_schema.replica_host_status where session_id = 'MASTER_SESSION_ID' and last_update_timestamp > now() - INTERVAL 3 MINUTE ORDER BY last_update_timestamp DESC LIMIT 1");
            results.commandEnd();
            SelectResultSet queryResult = results.getResultSet();
            if (!queryResult.isBeforeFirst()) {
                HostAddress hostAddress = null;
                return hostAddress;
            }
            queryResult.next();
            masterHostName = queryResult.getString(1);
        }
        finally {
            this.proxy.lock.unlock();
        }
        if (masterHostName != null) {
            for (HostAddress hostAddress : loopAddress) {
                Matcher matcher = this.auroraDnsPattern.matcher(hostAddress.host);
                if (!hostAddress.host.startsWith(masterHostName) || matcher.find()) continue;
                return hostAddress;
            }
            if (this.clusterDnsSuffix != null || !protocol.getHost().contains(".")) {
                return null;
            }
            this.clusterDnsSuffix = protocol.getHost().substring(protocol.getHost().indexOf(".") + 1);
            HostAddress masterHostAddress = new HostAddress(masterHostName + "." + this.clusterDnsSuffix, protocol.getPort(), null);
            loopAddress.add(masterHostAddress);
            if (!this.hostAddresses.contains(masterHostAddress)) {
                this.hostAddresses.add(masterHostAddress);
            }
            return masterHostAddress;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (!this.isMasterHostFail()) {
            try {
                if (this.masterProtocol != null && !this.masterProtocol.checkIfMaster()) {
                    this.setMasterHostFail();
                    if (this.isSecondaryHostFail()) {
                        this.foundActiveSecondary(this.masterProtocol);
                    }
                    return true;
                }
            }
            catch (SQLException e) {
                block22: {
                    try {
                        this.masterProtocol.ping();
                    }
                    catch (SQLException ee) {
                        this.proxy.lock.lock();
                        try {
                            this.masterProtocol.close();
                        }
                        finally {
                            this.proxy.lock.unlock();
                        }
                        if (!this.setMasterHostFail()) break block22;
                        this.addToBlacklist(this.masterProtocol.getHostAddress());
                    }
                }
                return true;
            }
        }
        if (!this.isSecondaryHostFail()) {
            try {
                if (this.secondaryProtocol != null && this.secondaryProtocol.checkIfMaster()) {
                    this.setSecondaryHostFail();
                    if (this.isMasterHostFail()) {
                        this.foundActiveMaster(this.secondaryProtocol);
                    }
                    return true;
                }
            }
            catch (SQLException e) {
                try {
                    this.secondaryProtocol.ping();
                }
                catch (Exception ee) {
                    this.proxy.lock.lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    if (this.setSecondaryHostFail()) {
                        this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

