/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.io.socket;

import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class OBProxyVCSocket
extends Socket {
    private static final int DEFAULT_SND_BUFFER_LEN = 16384;
    private static final int DEFAULT_RCV_BUFFER_LEN = 16384;
    private static final int VC_SOCK_RD_WITH_TIMEOUT = 1;
    private static final Logger logger = LoggerFactory.getLoggerProxy(OBProxyVCSocket.class);
    private static final String DEFAULT_OBPROXY_LIB_FILE = "/u01/obproxy/lib/libobproxy_so.so";
    private int socketTimeout = 0;
    private long obproxyClientSessionId = -1L;
    private final AtomicBoolean closeLock = new AtomicBoolean();
    private final long fd;
    private InputStream is;
    private OutputStream os;
    private boolean connected;
    private byte[] sendBuff;
    private byte[] recvBuff;
    private int recvBuffDataSpos;
    private int recvBuffDataLen;
    private int sendBuffLen;
    private int recvBuffLen;
    private boolean closed = true;

    public IOException InitProxyVCIOException(String info, Throwable cause) {
        IOException e = new IOException(info);
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    public OBProxyVCSocket(String obproxyConfig, int sendBufferLen, int recvBufferLen) throws IOException {
        logger.debug("OBProxyVCSocket start init with buffer len, obproxyConfig:{} ", (Object)obproxyConfig);
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new IOException("OBProxyVC sockets are not supported on Windows");
        }
        this.recvBuffLen = recvBufferLen != 0 ? recvBufferLen : 16384;
        this.sendBuffLen = sendBufferLen != 0 ? sendBufferLen : 16384;
        try {
            this.sendBuff = new byte[this.sendBuffLen];
            this.recvBuff = new byte[this.recvBuffLen];
            this.recvBuffDataSpos = 0;
            this.recvBuffDataLen = 0;
        }
        catch (Exception e) {
            throw new IOException("OBProxyVCSocket init buffer error", e.getCause());
        }
        this.closeLock.set(false);
        try {
            if (obproxyConfig == null) {
                throw new IOException("OBProxyVCSocket native socket() failed, config is null");
            }
            this.fd = OBProxyVCSocket.socket(obproxyConfig);
            logger.debug("OBProxyVCSocket end init fd:{} ", (Object)this.fd);
            if (this.fd == 0L) {
                logger.debug("OBProxyVCSocket end init error fd:{}", (Object)this.fd);
                throw new IOException("OBProxyVCSocket init socket error with ret:" + this.fd);
            }
        }
        catch (IOException lee) {
            throw this.InitProxyVCIOException("OBProxyVCSocket native socket() failed", lee);
        }
    }

    public OBProxyVCSocket(String obproxyConfig) throws IOException {
        logger.debug("OBProxyVCSocket start init obproxyConfig:{} ", (Object)obproxyConfig);
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new IOException("OBProxyVC sockets are not supported on Windows");
        }
        this.recvBuffLen = 16384;
        this.sendBuffLen = 16384;
        try {
            this.sendBuff = new byte[this.sendBuffLen];
            this.recvBuff = new byte[this.recvBuffLen];
            this.recvBuffDataSpos = 0;
            this.recvBuffDataSpos = 0;
            this.recvBuffDataLen = 0;
        }
        catch (Exception e) {
            throw this.InitProxyVCIOException("OBProxyVCSocket init buffer error", e);
        }
        this.closeLock.set(false);
        try {
            if (obproxyConfig == null) {
                throw new IOException("OBProxyVCSocket native socket() failed, config is null");
            }
            this.fd = OBProxyVCSocket.socket(obproxyConfig);
            if (this.fd < 0L) {
                logger.debug("OBProxyVCSocket end init error ret:{}", (Object)this.fd);
                throw new IOException("OBProxyVCSocket init socket error with ret:" + this.fd);
            }
        }
        catch (IOException lee) {
            throw this.InitProxyVCIOException("OBProxyVCSocket native socket() failed", lee);
        }
        logger.debug("OBProxyVCSocket start init obproxyConfig finish fd:{}", (Object)this.fd);
    }

    private static native long socket(String var0) throws IOException;

    private static native int connect(long var0, int var2, int var3) throws IOException;

    private static native int recv(long var0, byte[] var2, int var3, int var4, int var5) throws IOException;

    private static native int send(long var0, byte[] var2, int var3, int var4, int var5) throws IOException;

    private static native int close(long var0) throws IOException;

    private static native int setClientId(long var0, long var2) throws IOException;

    public void setCsId(long csId) throws IOException {
        this.obproxyClientSessionId = csId;
        try {
            if (this.closed) {
                throw new SocketException("Socket closed");
            }
            OBProxyVCSocket.setClientId(this.fd, csId);
        }
        catch (IOException e) {
            throw this.InitProxyVCIOException("native set_cs_id() failed", e);
        }
    }

    private String formatError(String info) {
        if (info != null) {
            return "ObproxyVCSocket(cs_id:" + this.obproxyClientSessionId + ", fd:" + this.fd + ") native " + info + " function failed";
        }
        return "ObproxyVCSocket(cs_id:" + this.obproxyClientSessionId + ", fd:" + this.fd + ") failed";
    }

    private static String formatError(IOException lee) {
        try {
            return "";
        }
        catch (Throwable t) {
            return lee.getMessage();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() throws IOException {
        if (!this.closeLock.getAndSet(true)) {
            if (this.closed) {
                throw new SocketException("Socket closed");
            }
            try {
                this.closed = true;
                OBProxyVCSocket.close(this.fd);
            }
            catch (IOException lee) {
                throw this.InitProxyVCIOException(this.formatError("close"), lee);
            }
            this.connected = false;
        }
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        logger.debug("OBProxyVCSocket connect:{} ", (Object)this.fd);
        try {
            int ret = OBProxyVCSocket.connect(this.fd, timeout, this.socketTimeout);
            if (ret != 0) {
                this.connected = false;
                logger.warn("fd {} native connect connect ret:{} ", (Object)this.fd, (Object)ret);
                throw new IOException("native connect() method error ret:" + ret);
            }
            this.connected = true;
        }
        catch (IOException lee) {
            this.close();
            throw this.InitProxyVCIOException(this.formatError("connect"), lee);
        }
        this.is = new OBProxyVCSocketInputStream();
        this.os = new OBProxyVCSocketOutputStream();
        this.closed = false;
        logger.debug("OBProxyVCSocket connect end");
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void setTcpNoDelay(boolean b) {
    }

    @Override
    public void setKeepAlive(boolean b) {
    }

    @Override
    public void setReceiveBufferSize(int size) {
    }

    @Override
    public void setSendBufferSize(int size) {
    }

    @Override
    public void setSoLinger(boolean b, int i) {
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    @Override
    public InetAddress getLocalAddress() {
        InetAddress addr = null;
        if (this.connected) {
            addr = InetAddress.getLoopbackAddress();
        }
        return addr;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getPort());
    }

    static {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            System.out.println("load obproxy_so library");
            try {
                System.load(DEFAULT_OBPROXY_LIB_FILE);
            }
            catch (UnsatisfiedLinkError e) {
                System.loadLibrary("obproxy_so");
            }
        }
    }

    class OBProxyVCSocketInputStream
    extends InputStream {
        OBProxyVCSocketInputStream() {
        }

        public int readIntern(byte[] bytesEntry, int off, int len) throws IOException {
            int flag;
            int bytes = 0;
            int size = 0;
            int remainingLength = len;
            int n = flag = OBProxyVCSocket.this.socketTimeout > 0 ? 1 : 0;
            if (remainingLength > OBProxyVCSocket.this.recvBuffDataLen) {
                if (OBProxyVCSocket.this.recvBuffDataLen > 0) {
                    System.arraycopy(OBProxyVCSocket.this.recvBuff, OBProxyVCSocket.this.recvBuffDataSpos, bytesEntry, off, OBProxyVCSocket.this.recvBuffDataLen);
                    off += OBProxyVCSocket.this.recvBuffDataLen;
                    size += OBProxyVCSocket.this.recvBuffDataLen;
                    remainingLength -= OBProxyVCSocket.this.recvBuffDataLen;
                    OBProxyVCSocket.this.recvBuffDataLen = 0;
                }
                int read_len = OBProxyVCSocket.this.recvBuffLen;
                bytes = OBProxyVCSocket.recv(OBProxyVCSocket.this.fd, OBProxyVCSocket.this.recvBuff, 0, read_len, flag);
                if (bytes < 0 || bytes > read_len) {
                    logger.error("read error: return:{}", (Object)bytes);
                    if (bytes != -8) {
                        throw new IOException("cs_id:" + OBProxyVCSocket.this.obproxyClientSessionId + " native recv method error ret:" + bytes);
                    }
                    throw new SocketTimeoutException("socket cs_id:" + OBProxyVCSocket.this.obproxyClientSessionId + " timeout occured");
                }
                OBProxyVCSocket.this.recvBuffDataSpos = 0;
                OBProxyVCSocket.this.recvBuffDataLen = bytes;
            }
            if (remainingLength > 0 && bytes >= 0) {
                int copy_len = OBProxyVCSocket.this.recvBuffDataLen > remainingLength ? remainingLength : OBProxyVCSocket.this.recvBuffDataLen;
                System.arraycopy(OBProxyVCSocket.this.recvBuff, OBProxyVCSocket.this.recvBuffDataSpos, bytesEntry, off, copy_len);
                OBProxyVCSocket.this.recvBuffDataSpos += copy_len;
                OBProxyVCSocket.this.recvBuffDataLen -= copy_len;
                size += copy_len;
            }
            return size;
        }

        @Override
        public int read(byte[] bytesEntry, int off, int len) throws IOException {
            if (OBProxyVCSocket.this.closed) {
                throw new SocketException("Socket closed");
            }
            try {
                if (off > 0) {
                    int size;
                    int bytes = 0;
                    int remainingLength = len;
                    do {
                        if ((size = this.readIntern(bytesEntry, off, remainingLength)) > 0) {
                            off += size;
                            remainingLength -= size;
                            bytes += size;
                            continue;
                        }
                        bytes = size;
                    } while (remainingLength > 0 && size > 0);
                    return bytes;
                }
                return this.readIntern(bytesEntry, 0, len);
            }
            catch (IOException lee) {
                this.close();
                throw OBProxyVCSocket.this.InitProxyVCIOException(OBProxyVCSocket.this.formatError("read"), lee);
            }
        }

        @Override
        public int read() throws IOException {
            byte[] bytes = new byte[1];
            int bytesRead = this.read(bytes);
            if (bytesRead == 0) {
                return -1;
            }
            return bytes[0] & 0xFF;
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }
    }

    class OBProxyVCSocketOutputStream
    extends OutputStream {
        OBProxyVCSocketOutputStream() {
        }

        @Override
        public void write(byte[] bytesEntry, int off, int len) throws IOException {
            if (OBProxyVCSocket.this.closed) {
                throw new SocketException("Socket closed");
            }
            try {
                int bytes;
                if (off > 0) {
                    int remainingLength = len;
                    do {
                        int size = remainingLength < OBProxyVCSocket.this.sendBuffLen ? remainingLength : OBProxyVCSocket.this.sendBuffLen;
                        System.arraycopy(bytesEntry, off, OBProxyVCSocket.this.sendBuff, 0, size);
                        bytes = OBProxyVCSocket.send(OBProxyVCSocket.this.fd, OBProxyVCSocket.this.sendBuff, 0, size, 0);
                        if (bytes < 0) {
                            logger.error("write(cs_id:{}) error: return:{}", (Object)OBProxyVCSocket.this.obproxyClientSessionId, (Object)bytes);
                            throw new IOException("OBProxyVCSocket(cs_id:" + OBProxyVCSocket.this.obproxyClientSessionId + " , fd:" + OBProxyVCSocket.this.fd + " native write error:" + bytes);
                        }
                        logger.debug("write(cs_id:{}) size {}", (Object)OBProxyVCSocket.this.obproxyClientSessionId, (Object)bytes);
                        if (bytes <= 0) continue;
                        off += bytes;
                        remainingLength -= bytes;
                    } while (remainingLength > 0 && bytes > 0);
                    logger.debug("cs_id:{} end write info : len:{}  size:{}", OBProxyVCSocket.this.obproxyClientSessionId, len, bytes);
                } else {
                    bytes = OBProxyVCSocket.send(OBProxyVCSocket.this.fd, bytesEntry, 0, len, 0);
                    if (bytes < 0) {
                        logger.error("write(cs_id:{}) error: return:{}", (Object)OBProxyVCSocket.this.obproxyClientSessionId, (Object)bytes);
                        throw new IOException("OBProxyVCSocket(cs_id:" + OBProxyVCSocket.this.obproxyClientSessionId + " , fd:" + OBProxyVCSocket.this.fd + " native write error:" + bytes);
                    }
                }
                if (bytes != len) {
                    throw new IOException("OBProxyVCSocket(cs_id:" + OBProxyVCSocket.this.obproxyClientSessionId + " , fd:" + OBProxyVCSocket.this.fd + " can't write:" + len + ", but:" + bytes);
                }
            }
            catch (IOException lee) {
                this.close();
                logger.error("OBProxyVCSocket.OBProxyVCSocketOutputStream(cs_id:{}, fd:{}) exception: offset:{} len:{} ", OBProxyVCSocket.this.obproxyClientSessionId, OBProxyVCSocket.this.fd, off, len);
                throw OBProxyVCSocket.this.InitProxyVCIOException(OBProxyVCSocket.this.formatError("write"), lee);
            }
        }

        @Override
        public void write(int value) throws IOException {
            this.write(new byte[]{(byte)value});
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }
    }
}

